<?php
session_start();
ini_set('display_errors', 1);
include('config/config.php');
include('language/eng.php');
$_SESSION['app_folder'] = 'compta';
$_SESSION['fichierjs'] = 'compta';
$_SESSION['function'] = 'compta';
$_SESSION['menu'] = 'compta';
$_SESSION['title'] = "Comptabilité";
include('libraries/shared.php');
include('libraries/' . $_SESSION['function'] . '.php');
include_once('libraries/class_dbcon.php');
include_once('libraries/upload_class.php');
include_once('libraries/system_users.php');
$haccess = new admin_users_model();
$acc = $haccess->UserAccess();
$bdd = HDB::hus();
$module_id =21;
$site_id = $_SESSION['id_hotel'];
//RECUPERATION REGLAGE
$requete = $bdd->prepare("SELECT * FROM resconfig WHERE module_id=:module_id AND site_id=:site_id");
$requete->BindParam(':module_id', $module_id);
$requete->BindParam(':site_id', $site_id);
$requete->execute();
$reglages = $requete->fetchAll(PDO::FETCH_OBJ);
foreach ($reglages as $op) {
    $_SESSION['resconfig_id'] = $op->id;
    $_SESSION['resconfig_nomcomp'] = $op->nomcomp;
    $_SESSION['resconfig_adrcomp'] = $op->adrcomp;
    $_SESSION['resconfig_m_insert'] = $op->m_insert;
    $_SESSION['resconfig_m_affich'] = $op->m_affich;
 
}
//RECUPERATION REGLAGE
InfosCommpta($bdd);
$sous_site_id=$_SESSION['sous_site_id'];
//Création automatique exercice
$annee = date("Y");
AddAutoExercice($annee,$site_id,$bdd);
//Création automatique exercice
$data1=getExerciceEncours($site_id, $bdd);
$data2=getExercicePrec($site_id, $bdd);
$exercice_id = $data1['id_exercice'];
$exercice_idn1 =$data2['id_exercice'];
$dte1 = $data1['debut'];
$dte2 = $data1['fin'];
$dte3 = $data2['debut'];
$dte4 = $data2['fin'];

$solde = soldeTresorerie($site_id, $bdd);
$maffiche = '';
$monnaie_compta2 = $_SESSION['Paie_affiche'];
$monnaie_compta3 = 'USD';
$tot_fournisseur = soldeFournisseur($site_id, $exercice_id, $monnaie_compta3, $bdd);
$tot_client = soldeClient($site_id, $exercice_id, $monnaie_compta3, $bdd);
$ecritures = lastEcriturecompta($site_id, $exercice_id, $monnaie_compta3, $bdd);
$decaissements = lastdecaissement($site_id, $exercice_id, $bdd);
// $dte1 = date('Y-m-01');
// $dte2 = date('Y-m-t');
// $dte3 = date("Y-m-01", strtotime("-1 year"));
// $dte4 = date("Y-m-t", strtotime("-1 year"));
$taux = $_SESSION['tauxop'];
$resultat = GetResultCompta($monnaie_compta3, $dte1, $dte2, $exercice_id, $dte3, $dte4,$exercice_idn1,$sous_site_id,$site_id, $taux, $bdd);
//Compta tresorerie
$nbre_notification = 0;
$statut = "attente";
$requete = $bdd->prepare("SELECT a.mode,a.num_cmd,a.taux, a.fact1,a.id_fact,a.num_fact,a.date_edition,a.monnaie,a.justification,a.id_hotel,a.company_id,a.id_user,a.id_client,a.statut_bon,
                                b.id_client,b.nom_entreprise,SUM(c.prix * c.qte) AS tot_cmd
                                    FROM  t_facture AS a, t_client AS b, lignes_commandes AS c
                                    WHERE a.id_client=b.id_client
                                    AND a.id_fact=c.commande_id 
                                    AND a.type='achat'
                                    AND a.id_hotel=:hotel_id AND a.statut_bon=:statut
                                    GROUP BY a.num_fact");
$requete->BindParam(':hotel_id', $_SESSION['id_hotel']);
$requete->BindParam(':statut', $statut);
$requete->execute();
$operations = $requete->fetchAll(PDO::FETCH_OBJ);
$nbre_notification = count($operations);
$_SESSION['nbre_notification'] = $nbre_notification;
DatasExerciceDefault($_SESSION['idsite'], $bdd);
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Ebutelo </title>
  <!-- Font Awesome Icons -->
  <link rel="stylesheet" href="<?php echo H_THEME; ?>/adminlte310/plugins/fontawesome-free/css/all.min.css">
  <!-- overlayScrollbars -->
  <link rel="stylesheet" href="<?php echo H_THEME; ?>/adminlte310/plugins/overlayScrollbars/css/OverlayScrollbars.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?php echo H_THEME; ?>/adminlte310/dist/css/adminlte.min.css">
</head>

<body class="hold-transition dark-mode sidebar-mini layout-fixed layout-navbar-fixed layout-footer-fixed">
  <div class="wrapper">

    <!-- Preloader -->
    <div class="preloader flex-column justify-content-center align-items-center">
      <img class="animation__wobble" src="<?php echo H_THEME; ?>/adminlte310/dist/img/AdminLTELogo.png" alt="AdminLTELogo" height="60" width="60">
    </div>

    <!-- Navbar -->
    <nav class="main-header navbar navbar-expand navbar-dark">
      <!-- Left navbar links -->
      <ul class="navbar-nav">
        <li class="nav-item">
          <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
        </li>
      </ul>

      <!-- Right navbar links -->
      
      <ul class="navbar-nav ml-auto">
      <?php if ($_SESSION['type_user']==1) { ?>

<!-- <li class="nav-item dropdown">
  <a class="nav-link" data-toggle="dropdown" href="#" style="color:white;">
      <i class="fa fa-th-large fa-fw"></i>
  </a> -->
  <!-- <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
      <span class="dropdown-item dropdown-header">SOUS-SITES</span>
      <div class="dropdown-divider"></div> -->
      <?php
      //  $requete = $bdd->prepare("SELECT * FROM  t_sousresto AS s,site_modules AS m WHERE s.hotel_id=:hotel_id AND s.id_sousresto=m.sous_site_id AND s.statut=1 AND m.module_id=:module_id ORDER BY s.libelle");
      //  $requete->BindParam(':hotel_id', $_SESSION['idsite']);
      //  $requete->BindParam(':module_id', $_SESSION['module_id']);
      // $requete->execute();
      // $pointsdevente = $requete->fetchAll(PDO::FETCH_OBJ);
      // foreach ($pointsdevente as $p) :
      ?>
          <a href="#" class="dropdown-item dropdown-header pointsdevente" id="<?php //echo $p->id_sousresto; ?>" style="font-size:17px;">
              <i class="fa fa-dot-circle-o fa-fw"></i>
              <?php //echo $p->libelle; ?>
          </a>
      <?php
     // endforeach;
      ?>
      
<!--   
  </div> -->
<!-- </li>   -->
<?php } ?>
<li class="dropdown user user-menu" style="margin-top:7px;color:white;">
                                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" style="color:white;">
                                        <i class="fa fa-user fa-fw"></i> 
                                    </a>
                                    <ul class="dropdown-menu">
                                        <!-- User image -->
                                        <li class="user-header" style="height: 200px;">

                                            <img src="<?php echo NO_IMAGE; ?>" class="img-circle" alt="User Image" />
                                            <p>
                                                <?php echo $_SESSION['user']; ?>
                                            </p>
                                            <p>
                                                <big><?php //echo $_SESSION['sous_site_lib']; ?></big>
                                            </p>
                                            
                                        </li>

                                        <!-- Menu Footer-->
                                        <li class="user-footer">
                                            
                                            <div style="text-align:center">
                                                <a href="<?php echo H_LOGIN; ?>" class="btn btn-success btn-flat"><?php echo LANG_LOGOUT2; ?></a>
                                            </div>
                                        </li>
                                    </ul>
                                </li>

       
      </ul>
    </nav>
    <!-- /.navbar -->

    <!-- Main Sidebar Container -->
    <aside class="main-sidebar sidebar-dark-primary elevation-4">
      <!-- Brand Logo -->
      <a href="index3.html" class="brand-link">
        <img src="<?php echo H_THEME; ?>/adminlte310/dist/img/AdminLTELogo.png" alt="AdminLTE Logo" class="brand-image img-circle elevation-3" style="opacity: .8">
        <span class="brand-text font-weight-light">EBUTELO</span>
      </a>

      <!-- Sidebar -->
      <div class="sidebar">
        <!-- Sidebar user panel (optional) -->
        <!--  <div class="user-panel mt-3 pb-3 mb-3 d-flex" style="display:none">
        <div class="image">
          <img src="<?php //echo H_THEME; 
                    ?>/adminlte310/dist/img/user2-160x160.jpg" class="img-circle elevation-2" alt="User Image">
        </div>
        <div class="info">
          <a href="#" class="d-block">Alexander Pierce</a>
        </div>
      </div> -->

        <!-- SidebarSearch Form -->
        <div class="form-inline">
          <div class="input-group" data-widget="sidebar-search">
            <input class="form-control form-control-sidebar" type="search" placeholder="Search" aria-label="Search">
            <div class="input-group-append">
              <button class="btn btn-sidebar">
                <i class="fas fa-search fa-fw"></i>
              </button>
            </div>
          </div>
        </div>

        <!-- Sidebar Menu -->
        <nav class="mt-2">
          <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
            <!-- Add icons to the links using the .nav-icon class
               with font-awesome or any other icon font library -->
            <li class="nav-item menu-open">
              <a href="#" class="nav-link active">
                <i class="nav-icon fas fa-tachometer-alt"></i>
                <p>
                  Tableau de bord
                  <i class="right fas fa-angle-left"></i>
                </p>
              </a>
              <ul class="nav nav-treeview">
                <li class="nav-item">
                  <a href="index2.php?pg=admin&view=module&do=compta" class="nav-link active">
                    <i class="far fa-circle nav-icon"></i>
                    <p>Comptabilité</p>
                  </a>
                </li>
                <?php if ($_SESSION['type_user']==1) { ?>

                <li class="nav-item">
                  <a href="../../REC/tableaudebordRec.php" class="nav-link">
                    <i class="far fa-circle nav-icon"></i>
                    <p>Principal</p>
                  </a>
                </li>
                <?php } ?>

              </ul>
            </li>
            <?php if (in_array('CPTTRESOR', $_SESSION['actions']['code_actions']) || $_SESSION['type_user'] == 1) { ?>

              <li class="nav-item">
                <a href="#" class="nav-link">
                  <i class="nav-icon fas fa-funnel-dollar"></i>
                  <p>
                    Trésorerie
                    <i class="fas fa-angle-left right"></i>
                    <span class="badge badge-info right">4</span>
                  </p>
                </a>
                <ul class="nav nav-treeview">
                  <li class="nav-item">
                    <a href="<?php echo H_ADMIN; ?>&view=tresorerie&do=listencaissement" class="nav-link">
                      <i class="far fa-circle nav-icon"></i>
                      <p>Encaissement</p>
                    </a>
                  </li>
                  <li class="nav-item">
                    <a href="<?php echo H_ADMIN; ?>&view=tresorerie&do=listdecaissement" class="nav-link">
                      <i class="far fa-circle nav-icon"></i>
                      <p>Decaissement</p>
                    </a>
                  </li>
                  <li class="nav-item" style="display:none">
                    <a href="<?php echo H_ADMIN; ?>&view=tresorerie&do=demandepaiement" class="nav-link">
                      <i class="far fa-circle nav-icon"></i>
                      <p>Demande de paiement</p>
                    </a>
                  </li>
                  <li class="nav-item">
                    <a href="<?php echo H_ADMIN; ?>&view=tresorerie&do=synthesecaisse" class="nav-link">
                      <i class="far fa-circle nav-icon"></i>
                      <p>Synthèse Tresorerie</p>
                    </a>
                  </li>
                </ul>
              </li>
            <?php } ?>
            <?php if (in_array('CPTGBDTR', $_SESSION['actions']['code_actions']) || $_SESSION['type_user'] == 1) { ?>

            <li class="nav-item" style="display:none">
              <a href="#" class="nav-link">
                <i class="nav-icon fas fa-money-check"></i>
                <p>
                  Gestion budgétaire
                  <i class="fas fa-angle-left right"></i>
                  <span class="badge badge-info right">3</span>
                </p>
              </a>
              <ul class="nav nav-treeview">
                <li class="nav-item">
                  <a href="<?php echo H_ADMIN; ?>&view=cptprevision&do=viewall" class="nav-link">
                    <i class="far fa-circle nav-icon"></i>
                    <p>Prévision</p>
                  </a>
                </li>
                <li class="nav-item">
                  <a href="#" class="nav-link">
                    <i class="far fa-circle nav-icon"></i>
                    <p>Suivi compte</p>
                  </a>
                </li>
                <li class="nav-item">
                  <a href="<?php echo H_ADMIN; ?>&view=cptprevision&do=realisation" class="nav-link">
                    <i class="far fa-circle nav-icon"></i>
                    <p>Réalisation</p>
                  </a>
                </li>
              </ul>
            </li>
            <?php } ?>
            <?php if (in_array('CPTACCESSCOMPTA', $_SESSION['actions']['code_actions']) || $_SESSION['type_user'] == 1) { ?>

         
            <li class="nav-item">
              <a href="<?php echo H_ADMIN; ?>&view=cptjournal&do=viewall" class="nav-link">
                <i class="nav-icon fas fa-file"></i>
                <p>Journalisation</p>
              </a>
            </li>
            <li class="nav-item">
              <a href="#" class="nav-link">
                <i class="nav-icon fas fa-folder"></i>
                <p>
                  Rapports
                  <i class="fas fa-angle-left right"></i>
                  <span class="badge badge-info right">5</span>
                </p>
              </a>
              <ul class="nav nav-treeview">
                <li class="nav-item">
                  <a href="<?php echo H_ADMIN; ?>&view=cptjournal&do=journal" class="nav-link">
                    <i class="far fa-circle nav-icon"></i>
                    <p>Journal</p>
                  </a>
                </li>
                <li class="nav-item">
                  <a href="<?php echo H_ADMIN; ?>&view=cptjournal&do=grandlivre" class="nav-link">
                    <i class="far fa-circle nav-icon"></i>
                    <p>Grand livre</p>
                  </a>
                </li>
                <li class="nav-item">
                  <a href="<?php echo H_ADMIN; ?>&view=cptjournal&do=balance" class="nav-link">
                    <i class="far fa-circle nav-icon"></i>
                    <p>Balance</p>
                  </a>
                </li>
                <li class="nav-item">
                  <a href="<?php echo H_ADMIN; ?>&view=cptjournal&do=resultat" class="nav-link">
                    <i class="far fa-circle nav-icon"></i>
                    <p>Compte de Resultat</p>
                  </a>
                </li>
                <li class="nav-item">
                  <a href="<?php echo H_ADMIN; ?>&view=cptjournal&do=bilan" class="nav-link">
                    <i class="far fa-circle nav-icon"></i>
                    <p>Bilan</p>
                  </a>
                </li>
              </ul>
            </li>
            <?php } ?>

            <li class="nav-item">
              <a href="#" class="nav-link">
                <i class="nav-icon fas fa-th fa-fw"></i>
                <p>
                  Modules
                  <i class="fas fa-angle-left right"></i>
                  <span class="badge badge-info right"></span>
                </p>
              </a>
              <ul class="nav nav-treeview">
                            <?php if (in_array('VMH', $_SESSION['actions']['code_actions'])) { ?>
                                    <li class="nav-item">
                                        <a href="<?php echo H_ADMIN; ?>&view=module&do=heb2" class="nav-link">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p>Hebergement</p>
                                        </a>
                                    </li>
                                <?php } ?>
                                <?php if (in_array('VHK', $_SESSION['actions']['code_actions'])) { ?>
                                    <li class="nav-item">
                                        <a href="<?php echo H_ADMIN; ?>&view=module&do=hk&mo=hk" class="nav-link" id="hk">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p>Housekeeping</p>
                                        </a>
                                    </li>
                                <?php } ?>
                                <?php if (in_array('VMBUAND', $_SESSION['actions']['code_actions'])) { ?>
                                <li class="nav-item">
                                        <a href="<?php echo H_ADMIN; ?>&view=module&do=buanderie&mo=buanderie" class="nav-link" id="buanderie">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p>Buanderie</p>
                                        </a>
                                 </li>
                                 <?php } ?>
                                 <?php if (in_array('VMEVENTS', $_SESSION['actions']['code_actions'])) { ?>

                                 <li class="nav-item">
                                        <a href="event.php?pg=admin&view=module&do=event" class="nav-link">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p>Evenements</p>
                                        </a>
                                 </li>
                                 <?php } ?>

                                <?php if (in_array('VMR', $_SESSION['actions']['code_actions'])) { ?>
                                    <li class="nav-item">
                                        <a href="../../restaurant2/index.php" class="nav-link">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p>Restaurant</p>
                                        </a>
                                    </li>
                                <?php } ?>
                                <?php if (in_array('VMODCUIS', $_SESSION['actions']['code_actions'])) { ?>
                                    <li class="nav-item">
                                        <a href="../../restaurant2/cuisine.php" class="nav-link">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p>Cuisine</p>
                                        </a>
                                    </li>
                                <?php } ?>
                                <?php if (in_array('VMS', $_SESSION['actions']['code_actions'])) { ?>
                                    <li class="nav-item">
                                        <a href="../../Stock2/index.php" class="nav-link">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p>Stock</p>
                                        </a>
                                    </li>
                                <?php } ?>
                                <?php if (in_array('VMC', $_SESSION['actions']['code_actions'])) { ?>
                                    <li class="nav-item">
                                        <a href="<?php echo H_ADMIN; ?>&view=module&do=compta" class="nav-link">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p>Comptabilité</p>
                                        </a>
                                    </li>
                                <?php } ?>
                                <?php if (in_array('VRH', $_SESSION['actions']['code_actions'])) { ?>

                                <li class="nav-item">
                                    <a href="<?php echo H_ADMIN; ?>&view=module&do=rh&mo=rh" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Ressources humaines</p>
                                    </a>
                                </li>
                                <?php } ?>
                               
                                <?php if (in_array('VMFACT', $_SESSION['actions']['code_actions'])) { ?>

                                    <li class="nav-item">
                                        <a href="<?php echo H_ADMIN; ?>&view=module&do=fact" class="nav-link">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p>Facturation</p>
                                        </a>
                                    </li>
                                <?php } ?>
                              
                              
                                <?php if (in_array('VIMMO', $_SESSION['actions']['code_actions'])) { ?>

                                <li class="nav-item">
                                        <a href="<?php echo H_ADMIN; ?>&view=module&do=immo&mo=immo slctconfmod" class="nav-link" id="immo">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p>Immobilier</p>
                                        </a>
                                </li>
                                <?php } ?>

                               
                              
                              


                            </ul>
            </li>
          </ul>
        </nav>
        <!-- /.sidebar-menu -->
      </div>
      <!-- /.sidebar -->
    </aside>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6">
              <h1 class="m-0">Tableau de bord</h1>
            </div><!-- /.col -->
            <div class="col-sm-6">
              <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="#">Home</a></li>
                <li class="breadcrumb-item active">Dashboard v2</li>
              </ol>
            </div><!-- /.col -->
          </div><!-- /.row -->
        </div><!-- /.container-fluid -->
      </div>
      <!-- /.content-header -->

      <!-- Main content -->
      <section class="content">
        <div class="container-fluid">
          <!-- Info boxes -->
          <div class="row">
            <div class="col-12 col-sm-6 col-md-3">
              <div class="info-box mb-3">
                <span class="info-box-icon bg-info elevation-1">
                  <i class="nav-icon fas fa-dollar-sign"></i>
                </span>
                <div class="info-box-content">
                  <span class="info-box-text">SOLDE USD</span>
                  <span class="info-box-number"> <?php echo  afficheMontant($maffiche, $solde['usd']); ?></span>
                </div>
                <!-- /.info-box-content -->
              </div>
              <!-- /.info-box -->
            </div>
            <!-- /.col -->
            <div class="col-12 col-sm-6 col-md-3">
              <div class="info-box">
                <span class="info-box-icon bg-danger elevation-1">
                  <span class="text-white">CDF</span>
                </span>

                <div class="info-box-content">
                  <span class="info-box-text">SOLDE CDF</span>
                  <span class="info-box-number">
                    <?php echo  afficheMontant($maffiche, $solde['cdf']); ?>

                    <small></small>
                  </span>
                </div>
                <!-- /.info-box-content -->
              </div>
              <!-- /.info-box -->
            </div>
            <!-- /.col -->
            <!-- fix for small devices only -->
            <div class="clearfix hidden-md-up"></div>

            <div class="col-12 col-sm-6 col-md-3">
              <div class="info-box mb-3">
                <span class="info-box-icon bg-success elevation-1">
                  <i class="fas fa-user-friends"></i>
                </span>

                <div class="info-box-content">
                  <span class="info-box-text">FOURNISSEURS</span>
                  <span class="info-box-number"><?php echo  afficheMontant($monnaie_compta3, abs($tot_fournisseur)); ?></span>
                </div>
                <!-- /.info-box-content -->
              </div>
              <!-- /.info-box -->
            </div>
            <!-- /.col -->
            <div class="col-12 col-sm-6 col-md-3">
              <div class="info-box mb-3">
                <span class="info-box-icon bg-warning elevation-1"><i class="fas fa-users"></i></span>

                <div class="info-box-content">
                  <span class="info-box-text">CLIENTS</span>
                  <span class="info-box-number"><?php echo  afficheMontant($monnaie_compta3, abs($tot_client)); ?></span>
                </div>
                <!-- /.info-box-content -->
              </div>
              <!-- /.info-box -->
            </div>
            <!-- /.col -->
          </div>
          <!-- /.row -->

          <div class="row">
            <div class="col-md-12">
              <div class="card">
                <div class="card-header">
                  <h5 class="card-title">Compte résultat</h5>

                  <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                      <i class="fas fa-minus"></i>
                    </button>
                    <div class="btn-group">
                      <button type="button" class="btn btn-tool dropdown-toggle" data-toggle="dropdown">
                        <i class="fas fa-wrench"></i>
                      </button>
                      <div class="dropdown-menu dropdown-menu-right" role="menu">
                        <a href="#" class="dropdown-item">Action</a>
                        <a href="#" class="dropdown-item">Another action</a>
                        <a href="#" class="dropdown-item">Something else here</a>
                        <a class="dropdown-divider"></a>
                        <a href="#" class="dropdown-item">Separated link</a>
                      </div>
                    </div>
                    <button type="button" class="btn btn-tool" data-card-widget="remove">
                      <i class="fas fa-times"></i>
                    </button>
                  </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                  <div class="row">
                    <div class="col-md-12">
                      <p class="text-center">
                        <strong>Ventes</strong>
                      </p>

                      <div class="chart">
                        <!-- Sales Chart Canvas -->
                        <canvas id="sales-chart" height="180" style="height: 180px;"></canvas>
                      </div>
                      <!-- /.chart-responsive -->
                    </div>

                  </div>
                  <!-- /.row -->
                </div>
                <!-- ./card-body -->
                <div class="card-footer">
                  <div class="row">
                    <div class="col-sm-3 col-6">
                      <div class="description-block border-right">

                      </div>
                      <!-- /.description-block -->
                    </div>
                    <!-- /.col -->
                    <div class="col-sm-3 col-6">
                      <div class="description-block border-right">
                        <!-- <span class="description-percentage text-warning"><i class="fas fa-caret-left"></i> </span> -->
                        <h5 class="description-header"><?php echo  afficheMontant($monnaie_compta3, $resultat['chiffreaffairen']); ?></h5>
                        <span class="description-text">CHIFFRE D'AFFAIRES</span>
                      </div>
                      <!-- /.description-block -->
                    </div>
                    <!-- /.col -->
                    <div class="col-sm-3 col-6">
                      <div class="description-block border-right">
                        <!-- <span class="description-percentage text-success"><i class="fas fa-caret-up"></i></span> -->
                        <h5 class="description-header"><?php echo  afficheMontant($monnaie_compta3, $resultat['resultatnetn']); ?></h5>
                        <span class="description-text">RESULTAT NET</span>
                      </div>
                      <!-- /.description-block -->
                    </div>
                    <!-- /.col -->
                    <div class="col-sm-3 col-6">
                      <div class="description-block">

                      </div>
                      <!-- /.description-block -->
                    </div>
                  </div>
                  <!-- /.row -->
                </div>
                <!-- /.card-footer -->
                <!-- /.card-footer -->
              </div>
              <!-- /.card -->
            </div>
            <!-- /.col -->
          </div>
          <!-- /.row -->

          <!-- Main row -->
          <div class="row">
            <!-- Left col -->
            <div class="col-md-8">
              <!-- TABLE: LATEST ORDERS -->
              <div class="card">
                <div class="card-header border-transparent">
                  <h3 class="card-title">Dernières écritures</h3>

                  <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                      <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-tool" data-card-widget="remove">
                      <i class="fas fa-times"></i>
                    </button>
                  </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body p-0">
                  <div class="table-responsive">
                    <table class="table m-0">
                      <thead>
                        <tr>
                          <th>#</th>
                          <th>Numero</th>
                          <th>Description</th>
                          <th>Montant</th>
                        </tr>
                      </thead>
                      <tbody>
                        <?php
                        $n = $ecritures['nbr'][0];
                        if ($n > 0) {
                          $k = 1;
                          for ($i = 0; $i <= $n - 1; $i++) {
                            $numero = $ecritures['numero'][$i];
                            $libelle = $ecritures['libelle'][$i];
                            $montant = $ecritures['montant'][$i];
                            // if ($numero = !"RES00001") {

                        ?>
                            <tr>
                              <td><?php echo $k ?></td>
                              <td><?php echo $numero ?></td>
                              <td><?php echo $libelle ?></td>
                              <td>
                                <div class="sparkbar" data-color="#00a65a" data-height="20"><?php echo  afficheMontant($maffiche, $montant); ?></div>
                              </td>
                            </tr>
                        <?php $k++;
                            //  }
                          }
                        }

                        ?>
                      </tbody>
                    </table>
                  </div>
                  <!-- /.table-responsive -->
                </div>
                <!-- /.card-body -->
                <div class="card-footer clearfix">
                  <!-- <a href="javascript:void(0)" class="btn btn-sm btn-info float-left">Place New Order</a> -->
                  <!-- <a href="javascript:void(0)" class="btn btn-sm btn-secondary float-right">Voir toutes les écritures</a> -->
                </div>
                <!-- /.card-footer -->
              </div>
              <!-- /.card -->
            </div>
            <!-- /.col -->

            <div class="col-md-4">
              <!-- PRODUCT LIST -->
              <div class="card">
                <div class="card-header">
                  <h3 class="card-title">Décaissements</h3>

                  <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse">
                      <i class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-tool" data-card-widget="remove">
                      <i class="fas fa-times"></i>
                    </button>
                  </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body p-0">
                  <table class="table m-0">
                    <thead>
                      <tr>
                        <th>#</th>
                        <th>Numero</th>
                        <th>Description</th>
                        <th>Montant</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php
                      $k = 1;
                      foreach ($decaissements as $rows) {
                        $numero = $rows->reference;
                        $libelle = $rows->libelle;
                        $montant = $rows->credit;
                        $devise = $rows->devise;
                      ?>
                        <tr>
                          <td><?php echo $k ?></td>
                          <td><?php echo $numero ?></td>
                          <td><?php echo $libelle ?></td>
                          <td>
                            <div class="sparkbar" data-color="#00a65a" data-height="20"><?php echo  afficheMontant($devise, $montant); ?></div>
                          </td>
                        </tr>
                      <?php $k++;
                      } ?>
                    </tbody>
                  </table>
                </div>
                <!-- /.card-body -->
                <div class="card-footer text-center">
                  <!-- <a href="javascript:void(0)" class="uppercase">View All Products</a> -->
                </div>
                <!-- /.card-footer -->
              </div>
              <!-- /.card -->
            </div>
            <!-- /.col -->
          </div>
          <!-- /.row -->
        </div>
        <!--/. container-fluid -->
      </section>
      <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

    <!-- Control Sidebar -->
    <aside class="control-sidebar control-sidebar-dark">
      <!-- Control sidebar content goes here -->
    </aside>
    <!-- /.control-sidebar -->

    <!-- Main Footer -->
    <footer class="main-footer">
      <strong>Copyright &copy; 2022 <a href="https://ebutelo.com">ebutelo.com</a>.</strong>
      All rights reserved.
      <div class="float-right d-none d-sm-inline-block">
        <b>Version</b> 3.0
      </div>
    </footer>
  </div>
  <!-- ./wrapper -->

  <!-- REQUIRED SCRIPTS -->
  <!-- jQuery -->
  <script src="<?php echo H_THEME; ?>/adminlte310/plugins/jquery/jquery.min.js"></script>
  <!-- Bootstrap -->
  <script src="<?php echo H_THEME; ?>/adminlte310/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
  <!-- overlayScrollbars -->
  <script src="<?php echo H_THEME; ?>/adminlte310/plugins/overlayScrollbars/js/jquery.overlayScrollbars.min.js"></script>
  <!-- AdminLTE App -->
  <script src="<?php echo H_THEME; ?>/adminlte310/dist/js/adminlte.js"></script>

  <!-- PAGE PLUGINS -->
  <!-- jQuery Mapael -->
  <script src="<?php echo H_THEME; ?>/adminlte310/plugins/jquery-mousewheel/jquery.mousewheel.js"></script>
  <script src="<?php echo H_THEME; ?>/adminlte310/plugins/raphael/raphael.min.js"></script>
  <script src="<?php echo H_THEME; ?>/adminlte310/plugins/jquery-mapael/jquery.mapael.min.js"></script>
  <script src="<?php echo H_THEME; ?>/adminlte310/plugins/jquery-mapael/maps/usa_states.min.js"></script>
  <!-- ChartJS -->
  <script src="<?php echo H_THEME; ?>/adminlte310/plugins/chart.js/Chart.min.js"></script>

  <!-- AdminLTE for demo purposes -->
  <script src="<?php echo H_THEME; ?>/adminlte310/dist/js/demo.js"></script>
  <!-- AdminLTE dashboard demo (This is only for demo purposes) -->
  <!-- <script src="<?php // echo H_THEME; 
                    ?>/adminlte310/dist/js/pages/dashboard2.js"></script> -->
  <!-- <script src="<?php // echo H_THEME; 
                    ?>/dashboard3.js"></script> -->
  <script type="text/javascript">
    $(function() {
      'use strict'
      $.ajax({
        url: 'help.php',
        type: 'GET',
        success: function(data) {
          var ticksStyle = {
            fontColor: '#495057',
            fontStyle: 'bold'
          }

          var mode = 'index'
          var intersect = true

          var $salesChart = $('#sales-chart')
          // eslint-disable-next-line no-unused-vars
          var salesChart = new Chart($salesChart, {
            type: 'bar',
            data: {
              labels: data.mois2,
              datasets: [{
                  backgroundColor: '#007bff',
                  borderColor: '#007bff',
                  data: data.montant2,
                },
                {
                  backgroundColor: '#ced4da',
                  borderColor: '#ced4da',
                  data: data.montant3,
                }
              ]
            },
            options: {
              maintainAspectRatio: false,
              tooltips: {
                mode: mode,
                intersect: intersect
              },
              hover: {
                mode: mode,
                intersect: intersect
              },
              legend: {
                display: false
              },
              scales: {
                yAxes: [{
                  // display: false,
                  gridLines: {
                    display: true,
                    lineWidth: '4px',
                    color: 'rgba(0, 0, 0, .2)',
                    zeroLineColor: 'transparent'
                  },
                  ticks: $.extend({
                    beginAtZero: true,

                    // Include a dollar sign in the ticks
                    callback: function(value) {
                      if (value >= 1000) {
                        value /= 1000
                        value += 'k'
                      }

                      return '$' + value
                    }
                  }, ticksStyle)
                }],
                xAxes: [{
                  display: true,
                  gridLines: {
                    display: false
                  },
                  ticks: ticksStyle
                }]
              }
            }
          })
          console.log(data);
        },
        dataType: 'json'
      });



      var $visitorsChart = $('#visitors-chart')
      // eslint-disable-next-line no-unused-vars
      var visitorsChart = new Chart($visitorsChart, {
        data: {
          labels: ['18th', '20th', '22nd', '24th', '26th', '28th', '30th'],
          datasets: [{
              type: 'line',
              data: [100, 120, 170, 167, 180, 177, 160],
              backgroundColor: 'transparent',
              borderColor: '#007bff',
              pointBorderColor: '#007bff',
              pointBackgroundColor: '#007bff',
              fill: false
              // pointHoverBackgroundColor: '#007bff',
              // pointHoverBorderColor    : '#007bff'
            },
            {
              type: 'line',
              data: [60, 80, 70, 67, 80, 77, 100],
              backgroundColor: 'tansparent',
              borderColor: '#ced4da',
              pointBorderColor: '#ced4da',
              pointBackgroundColor: '#ced4da',
              fill: false
              // pointHoverBackgroundColor: '#ced4da',
              // pointHoverBorderColor    : '#ced4da'
            }
          ]
        },
        options: {
          maintainAspectRatio: false,
          tooltips: {
            mode: mode,
            intersect: intersect
          },
          hover: {
            mode: mode,
            intersect: intersect
          },
          legend: {
            display: false
          },
          scales: {
            yAxes: [{
              // display: false,
              gridLines: {
                display: true,
                lineWidth: '4px',
                color: 'rgba(0, 0, 0, .2)',
                zeroLineColor: 'transparent'
              },
              ticks: $.extend({
                beginAtZero: true,
                suggestedMax: 200
              }, ticksStyle)
            }],
            xAxes: [{
              display: true,
              gridLines: {
                display: false
              },
              ticks: ticksStyle
            }]
          }
        }
      })

    })
    //Basculement dans les differents sous sites
$(".pointsdevente").click(function (e) {
    e.preventDefault();
    var id_sousresto = $(this).attr('id');
    var donnees = '';
    $.ajax({
      url: 'points_de_vente.php?id_sousresto=' + id_sousresto,
      type: 'GET',
      data: donnees,
      success: function (data) {
        window.location.href = 'index2.php?pg=admin&view=module&do=compta';
      }

    });
    return false;
  });
  //    Basculement dans les differents sous sites
  </script>
</body>

</html>