
<?php

/*
 * =======================================================================
 * CLASSNAME:        t_chambre_model
 * DATE CREATED:  	17-11-2017
 * FOR TABLE:  		t_chambre
 * PRODUCED BY:		HEZECOM UltimateSpeed PHP CODE GENERATOR
 * AUTHOR:			Hezecom (http://hezecom.com) info@hezecom.net
 * =======================================================================
 */
if (!defined('VALID_DIR'))
    die('You are not allowed to execute this file directly');

include_once(APP_FOLDER . '/models/classes/class_t_chambre.php');

class t_chambre_model {

    // SELECT ALL
    public function SelectAll($idsite,$sous_site_id) {
        $requete = "SELECT c.id_ch,c.num_ch,k.lib_cat_cha,t.libelle,c.tarif_ch,c.monnaie,c.libre
                    FROM  t_chambre c,categorie_chambre k,appartement t
                     WHERE  k.id_cat_cha=c.categorie 
                     AND t.id=c.appartement
                    AND c.del=0 
                    AND c.libre='oui'
                    AND c.id_hotel=:id
                    AND c.sous_site_id=:sous_site_id
                    ORDER BY c.num_ch ASC";
        $query = HDB::hus()->prepare($requete);
        $query->BindParam(':id',$idsite);
        $query->BindParam(':sous_site_id',$sous_site_id);

        try {
            $query->execute();
            return $query->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            die($e->getMessage());
        }
    }
    public function SelectLocaux($idsite,$sous_site_id) {
        $requete = "SELECT c.id_ch,c.num_ch,c.tarif_ch,c.monnaie,c.statelocal
                    FROM  t_chambre AS c
                     WHERE c.del=0 
                     AND c.libre='oui'
                    AND c.id_hotel=:id
                    AND c.sous_site_id=:sous_site_id
                    ORDER BY c.num_ch ASC";
        $query = HDB::hus()->prepare($requete);
        $query->BindParam(':id',$idsite);
        $query->BindParam(':sous_site_id',$sous_site_id);

        try {
            $query->execute();
            return $query->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            die($e->getMessage());
        }
    }

    //Select Count for Pagination
    public function CountRow() {
        return HDB::hus()->Hcount("t_chambre");
    }

    // SELECT ONE
    public function SelectOne($id) {
        $bind = array(":id" => $id);
        return HDB::hus()->Hone("t_chambre", "id_ch=:id", $bind);
    }

    // QUICK SEARCH
    public function AutoSearch($qstring, $limit, $where) {
        $bind = array(":svalue" => "%$qstring%");
        return HDB::hus()->Hselect("t_chambre", "$where LIKE :svalue LIMIT $limit", $bind);
    }

    // TRUNCATE TABLE
    public function TruncateTable($redirect_to) {
        $sql = HDB::hus()->prepare("TRUNCATE t_chambre");
        $sql->execute();
        send_to($redirect_to);
    }

    // DELETE
    public function Delete($id, $redirect_to) {
        $del=1;
         $sql = "del =:del WHERE id_ch = :id ";
        $data = array(':del'=> $del, ':id' => $id);
        HDB::hus()->Hupdate('t_chambre', $sql, $data);
        send_to($redirect_to);
    }

    // INSERT
    public function Insert($num_ch, $tarif_ch, $monnaie,$categorie,$appartement,$id_hotel,$sous_site_id){
        $values = array(array('num_ch' => $num_ch,'tarif_ch'=>$tarif_ch,'monnaie'=>$monnaie,'libre' =>'oui','categorie'=>$categorie,'appartement'=>$appartement,'id_hotel' => $id_hotel,'sous_site_id'=>$sous_site_id,'module' =>'immobilier'));
        HDB::hus()->Hinsert('t_chambre', $values);
    }

    public function Insertservice($num_ch,$tarif_ch,$monnaie,$id_hotel,$sous_site_id){
        $values = array(array('num_ch' => $num_ch,'libre' =>'non','categorie'=>1,'appartement'=>1,'tarif_ch'=>$tarif_ch,'monnaie'=>$monnaie,'id_hotel' => $id_hotel,'sous_site_id'=>$sous_site_id,'module' =>'immobilier'));
        HDB::hus()->Hinsert('t_chambre', $values);
    }
    // UPDATE 
    public function Update($num_ch,$tarif_ch, $monnaie,$categorie,$appartement,$id) {
        $sql = "  num_ch =:num_ch,appartement =:appartement,tarif_ch =:tarif_ch,monnaie =:monnaie,categorie =:categorie WHERE id_ch = :id ";
        $data = array(':num_ch' => $num_ch, ':tarif_ch' => $tarif_ch, ':monnaie'=>$monnaie, ':appartement'=>$appartement,':categorie' => $categorie,':id'=> $id);
        HDB::hus()->Hupdate('t_chambre', $sql, $data);
    }
    public function Updateservice($num_ch,$tarif_ch,$monnaie,$id) {
        $sql = "  num_ch =:num_ch,tarif_ch =:tarif_ch,monnaie =:monnaie WHERE id_ch = :id ";
        $data = array(':num_ch' => $num_ch, ':tarif_ch'=>$tarif_ch,':monnaie' => $monnaie,':id'=> $id);
        HDB::hus()->Hupdate('t_chambre', $sql, $data);
    }


}

// end class
?>
	
