
<?php

/*
 * =======================================================================
 * FILE NAME:        appartement.php
 * DATE CREATED:  	17-11-2017
 * FOR TABLE:  		appartement
 * PRODUCED BY:		HEZECOM UltimateSpeed PHP CODE GENERATOR
 * AUTHOR:			Hezecom (http://hezecom.com) info@hezecom.net
 * =======================================================================
 */

if (!defined('VALID_DIR'))
    die('You are not allowed to execute this file directly');

include(APP_FOLDER . '/models/objects/appartement.php');

class appartement_controller {

    public $appartement_model;

    public function __construct() {
        $this->appartement_model = new appartement_model();
    }

    public function invoke_appartement() {

        //SELECT ALL //////////////////////////////////	
        if (get('do') == 'viewall') {

            $result = $this->appartement_model->SelectAll($_SESSION['idsite'],$_SESSION['pos_id']);
            include(APP_FOLDER . '/views/admin/appartement/View.php');
        }
        //EXPORT ////////////////////////////////////////////////////	
        if (get('do') == 'export') {
            $result = $this->appartement_model->SelectAll();
            include(APP_FOLDER . '/views/admin/appartement/Export.php');
        }

        //Expeort2
        elseif (get('do') == 'export2') {
            $rows = $this->appartement_model->SelectOne(get('id'));
            include(APP_FOLDER . '/views/admin/appartement/Export2.php');
        }
        //SEARCH SUGGEST ////////////////////////////////////////////////////	
        elseif (get('do') == 'autosearch') {
            $qstring = post('qstring');
            if (strlen($qstring) > 0) {
                $autosearch = $this->appartement_model->AutoSearch(trim($qstring), 10, 'lib_cat_cha');
                echo' <div class=widget><ul class="list-group">';
                foreach ($autosearch as $srow) {
                    echo '<span class="searchheading"><a href="' . H_ADMIN . '&view=appartement&id=' . $srow->id . '&do=details"><li class="list-group-item">' . $srow->lib_cat_cha . '</li></a>
	</span>';
                }
                echo '</ul></div>';
            }
        }


        //ADD //////////////////////////////////////////////////
        elseif (get('do') == 'add') {
            include(APP_FOLDER . '/views/admin/appartement/Add.php');
        }
        
        elseif (get('do') == 'add_detail') {
            include(APP_FOLDER . '/views/admin/appartement/Add_details_ch.php');
        }
        elseif (get('do') == 'add_images') {
            include(APP_FOLDER . '/views/admin/appartement/Add_images.php');
        }

        //ADD PROCESS //////////////////////////////////////////////////
        elseif (get('do') == 'addpro') {
            if ($_POST) {
                //form validation
                if (post('libelle') == '') {
                    json_error('The field libelle cat cha cannot be empty!');
                } elseif (post('adresse') == '') {
                    json_error('The field adresse id cannot be empty!');
                } else {
                   
                    $this->appartement_model->Insert(post('libelle'),post('adresse'), post('hotel_id'),$_SESSION['pos_id']);
                        json_send('' . H_ADMIN . '&view=appartement&do=viewall&msg=add');
                        json_success('Process Completed');
                    
                }
            }
        }
        
        elseif (get('do') == 'addpro_detail') {
            if ($_POST) {
                //form validation
                if (post('icon') == '') {
                    json_error('The field lib cat cha cannot be empty!');
                } elseif (post('designation') == '') {
                    json_error('The field hotel id cannot be empty!');
                } else {
                    
                    $this->appartement_model->InsertDetails(post('icon'),post('designation'), post('hotel_id'));
                    json_send('' . H_ADMIN . '&view=appartement&do=viewall_details&msg=add');
                    json_success('Process Completed');
                    
                }
            }
        }
        
        elseif (get('do') == 'addpro_image') {
            if ($_POST) {
                //form validation
                $slide=1;
                $this->appartement_model->InsertImageSlide(post('description'),post('visible'),$slide, post('hotel_id'));
                json_send('' . H_ADMIN . '&view=appartement&do=viewall_images&msg=add');
                json_success('Process Completed');
            }
        }

        //UPDATE //////////////////////////////////////////////////
        elseif (get('do') == 'update') {
            $rows = $this->appartement_model->SelectOne(get('id'));
            $details = $this->appartement_model->SelectAll_details($_SESSION['idsite']);
            $details_cat = $this->appartement_model->SelectAll_detailsCat(get('id'));
            include(APP_FOLDER . '/views/admin/appartement/Update.php');
        }
        elseif (get('do') == 'update_detail') {
            $rows = $this->appartement_model->SelectOneDetails(get('id_detail'));
            include(APP_FOLDER . '/views/admin/appartement/Update_details.php');
        }
        elseif (get('do') == 'update_img') {
            $rows = $this->appartement_model->SelectOneImage(get('id_img'));
            include(APP_FOLDER . '/views/admin/appartement/Update_images.php');
        }

        //UPDATE PROCESS //////////////////////////////////////////////////
        elseif (get('do') == 'updatepro') {
            if ($_POST) {
                //form validation
               if (post('libelle') == '') {
                    json_error('Veuillez saisir le libelle!');
                }elseif (post('adresse') == '') {
                    json_error("Veuillez saisir l'adresse!");
                }else{
                  
                    $this->appartement_model->Update(post('libelle'), post('hotel_id'), post('adresse'), post('id'));

                    json_send('' . H_ADMIN . '&view=appartement&do=viewall&msg=add');
                    json_success('Process Completed');
                }
            }
        }
        
        elseif (get('do') == 'updateprodetail') {
            if ($_POST) {
                //form validation
               if (post('designation') == '') {
                    json_error('Veuillez entrer une designation!');
                }else{
                    $this->appartement_model->UpdateDetailsCh(post('icon'), post('designation'), post('id_detail'));
                    
                    json_send('' . H_ADMIN . '&view=appartement&do=viewall_details&msg=update');
                    json_success('Process Completed');
                }
            }
        }
        
        elseif (get('do') == 'updateproimage') {
            if ($_POST) {
                //form validation
               if (post('description') == '') {
                    json_error('Veuillez entrer une description!');
                }else{
                    if (!empty($_FILES['image'])) {
                        $this->appartement_model->UpdateImageSlider1(post('description'), post('visible'), post('hotel_id'), post('id_img'));
                    } else {
                        $this->appartement_model->UpdateImageSlider(post('description'), post('visible'), post('hotel_id'), post('id_img'));
                    }
                    
                    json_send('' . H_ADMIN . '&view=appartement&do=viewall_images&msg=update');
                    json_success('Process Completed');
                }
            }
        }

        //DETAILS //////////////////////////////////////////////
        elseif (get('do') == 'details') {
            $rows = $this->appartement_model->SelectOne(get('id'));
            include(APP_FOLDER . '/views/admin/appartement/Details.php');
        }

        //TRUNCATE ///////////////////////////////////////////////
        elseif (get('do') == 'truncate') {
            $this->appartement_model->TruncateTable('' . H_ADMIN . '&view=appartement&do=viewall&msg=truncate');
            include(APP_FOLDER . '/views/admin/appartement/View.php');
        }

        //DELETE /////////////////////////////////////////////////
        elseif (get('do') == 'delete') {
            $dfile = get('dfile');
            if (get('id') and $dfile == '') {
                $del = $this->appartement_model->Delete(get('id'), '' . H_ADMIN . '&view=appartement&do=viewall&msg=delete');
            } elseif (get('id') and $dfile != '' and get('fdel') == '') {
                delete_files(UPLOAD_PATH . get('dfile'));
                delete_files(THUMB_PATH . get('dfile'));
                $del = $this->appartement_model->Delete(get('id'), '' . H_ADMIN . '&view=appartement&do=viewall&msg=delete');
            } elseif (get('id') and $dfile != '' and get('fdel') != '') {
                delete_files(UPLOAD_PATH . get('dfile'));
                delete_files(THUMB_PATH . get('dfile'));
                send_to('' . H_ADMIN . '&view=appartement&id=' . get('id') . '&do=update&msg=delete');
            }
        }
    }

//end invoke
}

//end class
?>
	