<?php
/*
	* =======================================================================
	* FILE NAME:        Add.php
	* DATE CREATED:  	18-04-2019
	* FOR TABLE:  		cptjournal
	* PRODUCED BY:		HEZECOM UltimateSpeed PHP CODE GENERATOR
	* AUTHOR:			Hezecom (http://hezecom.com) info@hezecom.net
	* =======================================================================
	*/
if (!defined('VALID_DIR')) die('You are not allowed to execute this file directly');
?>
<style type="text/css">
    body {
        color: #404E67;
        background: #F5F7FA;
        font-family: 'Open Sans', sans-serif;
    }

    .table-wrapper {
        background: #fff;
        padding: 20px;
        box-shadow: 0 1px 1px rgba(0, 0, 0, .05);
    }

    .table-title {
        padding-bottom: 10px;
        margin: 0 0 10px;
    }

    .table-title h2 {
        margin: 6px 0 0;
        font-size: 22px;
    }

    .table-title .add-new {
        float: right;
        height: 30px;
        font-weight: bold;
        font-size: 12px;
        text-shadow: none;
        min-width: 100px;
        line-height: 13px;
    }

    .table-title .add-new i {
        margin-right: 4px;
    }

    table.table tr th,
    table.table tr td {
        border-color: #e9e9e9;
    }

    table.table th i {
        font-size: 13px;
        margin: 0 5px;
        cursor: pointer;
    }

    table.table th:last-child {
        width: 100px;
    }

    table.table td a {
        cursor: pointer;
        display: inline-block;
        margin: 0 5px;
        min-width: 24px;
    }

    table.table td a.add {
        color: #27C46B;
    }

    table.table td a.edit {
        color: #FFC107;
    }

    table.table td a.delete {
        color: #E34724;
    }

    table.table td i {
        font-size: 19px;
    }

    table.table td a.add i {
        font-size: 24px;
        margin-right: -1px;
        position: relative;
        top: 3px;
    }

    table.table .form-control {
        height: 32px;
        line-height: 32px;
        box-shadow: none;
        border-radius: 2px;
    }

    table.table .form-control.error {
        border-color: #f50000;
    }

    table.table td .add {
        display: none;
    }
    /* Global CSS, you probably don't need that */

.clearfix:after {
    clear: both;
    content: "";
    display: block;
    height: 0;
}



.pull-right {
	float: right;
}

a, a:active {
	color: #333;
	text-decoration: none;
}

a:hover {
	color: #999;
}

/* Breadcrups CSS */

.arrow-steps .step {
	font-size: 13px;
	text-align: center;
	color: #666;
	cursor: default;
	margin: 0 3px;
	padding: 5px 5px 5px 5px;
	min-width: 180px;
	float: left;
	position: relative;
	background-color: #d9e3f7;
	-webkit-user-select: none;
	-moz-user-select: none;
	-ms-user-select: none;
	user-select: none; 
  transition: background-color 0.2s ease;
}

.arrow-steps .step:after,
.arrow-steps .step:before {
	content: " ";
	position: absolute;
	top: 0;
	right: -17px;
	width: 0;
	height: 0;
	border-top: 19px solid transparent;
	border-bottom: 17px solid transparent;
	border-left: 17px solid #d9e3f7;	
	z-index: 2;
  transition: border-color 0.2s ease;
}

.arrow-steps .step:before {
	right: auto;
	left: 0;
	border-left: 17px solid #fff;	
	z-index: 0;
}

.arrow-steps .step:first-child:before {
	border: none;
}

.arrow-steps .step:first-child {
	border-top-left-radius: 4px;
	border-bottom-left-radius: 4px;
}

.arrow-steps .step span {
	position: relative;
}

.arrow-steps .step span:before {
	opacity: 0;
	content: "✔";
	position: absolute;
	top: -2px;
	left: -20px;
}

.arrow-steps .step.done span:before {
	opacity: 1;
	-webkit-transition: opacity 0.3s ease 0.5s;
	-moz-transition: opacity 0.3s ease 0.5s;
	-ms-transition: opacity 0.3s ease 0.5s;
	transition: opacity 0.3s ease 0.5s;
}

.arrow-steps .step.current {
	color: #fff;
	background-color: #23468c;
}

.arrow-steps .step.current:after {
	border-left: 17px solid #23468c;	
}
</style>
<script type="text/javascript">
    $(document).ready(function() {
        $('[data-toggle="tooltip"]').tooltip();
        var actions = $("table td:last-child").html();
        // Append table with add row form on add new button click
        $(".add-new").click(function() {
            //$(this).attr("disabled", "disabled");
            var rowCount = $('#lignesjournal tr').length;
            var index = $("table tbody tr:last-child").index();
            var row = '<tr>' +
                '<td><input type="text" class="form-control" name="libelles[]" id="' + rowCount + '" id2="' + rowCount + '" value=""></td>' +
                '<td><a class="delete" title="Delete" data-toggle="tooltip"><i class="fa fa-trash-o"></i></a></td>' +
                '</tr>';
            $("table").append(row);
            $("table tbody tr").eq(index + 1).find(".add, .edit").toggle();
            $('[data-toggle="tooltip"]').tooltip();
            selectjs();

        });
        // Add row on add button click
        $(document).on("click", ".add", function() {
            var empty = false;
            var input = $(this).parents("tr").find('input[type="text"]');
            input.each(function() {
                if (!$(this).val()) {
                    $(this).addClass("error");
                    empty = true;
                } else {
                    $(this).removeClass("error");
                }
            });
            $(this).parents("tr").find(".error").first().focus();
            if (!empty) {
                input.each(function() {
                    $(this).parent("td").html($(this).val());
                });
                $(this).parents("tr").find(".add, .edit").toggle();
                $(".add-new").removeAttr("disabled");
            }
        });
        // Edit row on edit button click
        $(document).on("click", ".edit", function() {
            $(this).parents("tr").find("td:not(:last-child)").each(function() {
                $(this).html('<input type="text" class="form-control" value="' + $(this).text() + '">');
            });
            $(this).parents("tr").find(".add, .edit").toggle();
            $(".add-new").attr("disabled", "disabled");
        });
        // Delete row on delete button click
        $(document).on("click", ".delete", function() {
            $(this).parents("tr").remove();
            $(".add-new").removeAttr("disabled");
        });
    });


</script>

<form action="<?php echo H_ADMIN_MAIN . '&view=module&do=configuration_checklist_designations_pro'; ?>" method="post" name="hezecomform" id="hezecomform" enctype="multipart/form-data">
    <div class="table-wrapper">
        <div class="table-title">
            <div class="row">
                <div class="col-sm-8">
                    <div class="arrow-steps clearfix">
                    <div class="step"> <span> Housekeeping</span> </div>
                        <div class="step"> <span> Check-list du </span><span><?php echo date('d/m/Y'); ?></span></div>
                        <div class="step"> <span> Nettoyage</span> </div>
                        <div class="step current"> <span><?php echo $ch; ?></span> </div>
                    </div>
                </div>
                <div class="col-sm-4">


                <div class="form-inline">
                            <select id="etats" name="etats" class="form-control" style="width: 200px;">
                            <option value=""></option>
                            <?php
                            foreach ($etats as $rows) {
                            ?>
                                <option value="<?php echo $rows->libelle; ?>" <?php if($rows->libelle==$etat){echo 'selected';} ?>><?php echo $rows->libelle; ?></option>
                            <?php
                            }
                            ?>
                        </select>
                        <button type="submit" class="btn btn-primary btn-flat" id="btnupdatehecklist" name="btnupdatehecklist"><i class="fa fa-save"></i> Enregister</button>

                    </div>
             
                </div>
            </div>
            <div class="output"></div>
        </div>
        <div class="row">
            <div class="col-lg-12 form-group">
                <input type="hidden" id="id_ch" name="id_ch" class="form-control" value="<?php echo $id_ch; ?>">
                <input type="hidden" id="ch" name="ch" class="form-control" value="<?php echo $ch; ?>">

            </div>      
        </div>
        <hr />
        <div class="responsive">
        <table class="table table-bordered" style="width:1000px;margin:auto;">
            <thead>
                <tr>
                    <th>Designations</th>
                    <th>Observations</th>
                    <th>Commentaires</th>

                </tr>
            </thead>
            <tbody id="lignesjournal">
                <?php
                    foreach ($designations as $rows) {
                        $rowCount = $rows->id;
                        $designation= $rows->libelle;
                        $comment='';
                        $observselected='';
                       if(in_array($designation, $_SESSION['checklistrows']['libelle_row'])) {
                        $observselected=$_SESSION['checklistrows']['observation'][$designation];
                        $comment=$_SESSION['checklistrows']['comment'][$designation];

                       }

                ?>

                        <tr>
                            <td>
                            <input type="hidden" class="form-control" name="designations[]" id="<?php echo $rowCount; ?>" value="<?php echo $designation; ?>">
                            <input type="text" class="form-control" name="designview[]" id="designview<?php echo $rowCount; ?>" value="<?php echo $designation; ?>" disabled>

                        </td>
                            <td>
                            <select id="obs<?php echo $rowCount; ?>" name="observations[]" class="form-control choz2">
                            <option value=""></option>

                                <?php
                                foreach ($observations as $rows) {
                                $observation=$rows->libelle;
                                ?>
                                    <option value="<?php echo $observation; ?>" <?php if($observselected==$observation){echo 'selected';} ?> ><?php echo $observation; ?></option>
                                <?php
                                }
                                ?>
                            </select>
                                    
                            </td>
                            <td>
                            <input type="text" class="form-control" name="comments[]" id="comments<?php echo $rowCount; ?>" value="<?php echo $comment; ?>" style="min-width:300px;">

                        </td>

                       
                        </tr>
                <?php
                    }
                ?>
            </tbody>
        </table>
        </div>

    </div>
</form>