<?php
/*
 * =======================================================================
 * FILE NAME:        View.php
 * DATE CREATED:  	17-11-2017
 * FOR TABLE:  		t_chambre
 * PRODUCED BY:		HEZECOM UltimateSpeed PHP CODE GENERATOR
 * AUTHOR:			Hezecom (http://hezecom.com) info@hezecom.net
 * =======================================================================
 */
if (!defined('VALID_DIR'))
    die('You are not allowed to execute this file directly');
?>
<?php AjaxSearchSuggest('' . H_ADMIN_MAIN . '&view=t_chambre&do=autosearch'); ?>

<div class="row">
    <div class="col-xs-12">
        <div class="box">

            <div class="box-header with-border">
                <h3 class="box-title">Chambres</h3>
                <ul class="nav pull-right">
                    <a href="<?php echo H_ADMIN; ?>&view=t_chambre&do=add" class="btn btn-default btn-xs tip" title="<?php echo LANG_TIP_ADD; ?>"><i class="fa fa-plus"></i> <?php echo LANG_ADD; ?></a>
                    <a  class="btn btn-default btn-xs tip" title="Filtrer les chambres" data-toggle="modal" data-target="#modalfiltrerchambre"><i class="fa fa-sort"></i> Filtrer</a>
                    <a href="./main.php?pg=admin&view=impression&do=listchamb" target="_blank" class="btn btn-default btn-xs tip" title="Imprimer la liste" id="factcash">
                        <i class="fa fa-print"></i> Imprimer
                    </a>
                </ul>

            </div><!-- /.box-header -->
            <div class="box-body" id="contentdatafilter">
                <table data-page="false" class="table table-bordered table-hover table-striped t1 t2" data-filter="#filter">
                    <thead>
                        <tr>
                             <th>#</th>
                            <th>Nom</th>
                            <th data-hide="phone,tablet">Tarif</th>
                            <th data-hide="phone,tablet">Categorie</th>
                            <th data-sort-ignore="true"></th>
                        </tr>
                    </thead>
                    <tbody>

                        <?php
                        $i=1;
                          //Mise en session pour impression
                          $titledoc="Liste des chambres";
                          if($horsservice==0){
                              $titledoc="Liste des chambres en service";
                          }elseif($horsservice==1){
                              $titledoc="Liste des chambres hors service";
  
                          }
                          $_SESSION['titledoc']=$titledoc;
                          $_SESSION['chambre'] = array();
                          $_SESSION['chambre']['n'] = array();
                          $_SESSION['chambre']['nom'] = array();
                          $_SESSION['chambre']['tarif'] = array();
                          $_SESSION['chambre']['categorie'] = array();
                        foreach ($result as $rows) {
                            $tarif_ch = montant_equivalent_bdd($rows->monnaie, $_SESSION['Paie_insert'], $_SESSION['Paie_taux'], $rows->tarif_ch);
                            $categorie=GetCategorie($rows->categorie);
                        ?>
                            <?php if ($rows->libre == 'oui') { ?>
                                <tr>
                                   <td><?php echo $i; ?></td>
                                    <td><?php echo $rows->num_ch; ?></td>
                                    <td><?php echo afficheMontant($_SESSION['Paie_insert'], $tarif_ch); ?></td>
                                    <td><?php echo $categorie; ?></td>
                                    <td class="table-actions" style="text-align:center">
                                        <div class="btn-group">
                                            <a href="<?php echo H_ADMIN; ?>&view=t_chambre&id_ch=<?php echo $rows->id_ch; ?>&do=update" class="btn btn-primary btn-xs"><span class="fa fa-edit tip" title="<?php echo LANG_TIP_UPDATE; ?>"></span></a>
                                            <a href="<?php echo H_ADMIN; ?>&view=t_chambre&id_ch=<?php echo $rows->id_ch; ?>&do=delete" class="btn btn-danger btn-xs" data-confirm="<?php echo LANG_DELETE_AUTH; ?>"> <span class="fa fa-times tip" title="<?php echo LANG_TIP_DELETE; ?>"></span></a>
                                            <?php if ($rows->horsservice ==0) { ?>
                                            <a href="<?php echo H_ADMIN; ?>&view=t_chambre&id_ch=<?php echo $rows->id_ch; ?>&do=horsservice&hs=1" class="btn btn-success btn-xs" data-confirm="<?php echo LANG_SERVICE_AUTH; ?>"> <span title="<?php echo LANG_TIP_SERVICE_ON; ?>"><b>ON</b></span></a>
                                            <?php }else{?>
                                            <a href="<?php echo H_ADMIN; ?>&view=t_chambre&id_ch=<?php echo $rows->id_ch; ?>&do=horsservice&hs=0" class="btn btn-success btn-xs" data-confirm="<?php echo LANG_SERVICE_AUTH; ?>"> <span title="<?php echo LANG_TIP_SERVICE_OFF; ?>"><b>OFF</b></span></a>
                                            <?php }?>

                                        </div>
                                    </td>
                                </tr>
                            <?php
                        $i++;
                        array_push($_SESSION['chambre']['n'], $i);
                        array_push($_SESSION['chambre']['nom'],$rows->num_ch);
                        array_push($_SESSION['chambre']['tarif'], afficheMontant($_SESSION['Paie_insert'], $tarif_ch));
                        array_push($_SESSION['chambre']['categorie'],$categorie);
                        } ?>
                        <?php } ?>
                    </tbody>
                </table>
            </div><!-- /.box-body -->
        </div><!-- /.box -->
    </div><!-- /.col -->
</div><!-- /.row -->
 <!-- Modal -->
 <div class="modal fade" id="modalfiltrerchambre" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">

        <form class="form-inline" id="frmfiltrerchambre" name="frmfiltrerchambre">

        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title" id="myModalLabel">Filtrage de chambres</h4>
            </div>
            <div class="modal-body text-center">
            	  <div class="output"></div>
                  <div class="form-group">
                        <select class="form-control" name="horsservice" id="horsservice" style="width:300px;">
                            <option value="2">Toutes les chambres</option>
                            <option value="0">En service</option>
                            <option value="1">Hors service</option>

                        </select>
                    </div>
                   
                   
        </div>
        <div class="modal-footer">
            <div id="msg_popup" class="text-danger text-left col-md-10" style="display:none;">
                <!--<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>-->
                <span id="msg_alert_popup">Veuillez saisir les valeurs correctes dans tous les champs!</span>
            </div>
            <button  class="btn btn-danger pull-right col-md-2"
                id="btnfiltrerchambre"><i class="fa fa-plus-circle fa-fw"></i>&nbsp;Valider
            </button>
            <span class="btn btn-info hidden pull-right" id="loader">
                <i class="fa fa-refresh fa-spin fa-1x"></i> Patientez...
            </span>
        </div>
        </div>
        <!-- /.modal-content -->
        </form>
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->