
<?php

/*
 * =======================================================================
 * FILE NAME:        t_facture.php
 * DATE CREATED:  	17-11-2017
 * FOR TABLE:  		t_facture
 * PRODUCED BY:		HEZECOM UltimateSpeed PHP CODE GENERATOR
 * AUTHOR:			Hezecom (http://hezecom.com) info@hezecom.net
 * =======================================================================
 */

if (!defined('VALID_DIR'))
    die('You are not allowed to execute this file directly');

include(APP_FOLDER . '/models/objects/t_facture.php');
include_once(APP_FOLDER . '/models/objects/t_client.php');
include_once(APP_FOLDER . '/models/objects/facconditionpaie.php');
include_once(APP_FOLDER . '/models/objects/t_hotel.php');
include_once(APP_FOLDER . '/models/objects/stk_produit.php');
include_once(APP_FOLDER . '/models/objects/Panier.php');
include_once(APP_FOLDER . '/models/objects/compteur.php');
include_once(APP_FOLDER . '/models/objects/lignes_commandes.php');
include_once(APP_FOLDER . '/models/objects/t_mode_reglement.php');
include_once(APP_FOLDER . '/models/objects/t_reglement.php');


class t_facture_controller
{

    public $t_facture_model;

    public function __construct()
    {
        $this->t_facture_model = new t_facture_model();
    }

    public function invoke_t_facture()
    {
        $clientobj = new t_client_model();
        $condpaiementobj = new facconditionpaie_model();
        $ot_mode_reglement = new t_mode_reglement_model();
        $siteobj = new t_hotel_model();
        $produitobj = new stk_produit_model();
        $panier = new Panier();
        $compteurobj = new compteur_model();
        $lignes_commandesobj = new lignes_commandes_model();
        $t_reglement_obj = new t_reglement_model();

        $json = array();
        $json['s'] = False;
        $json['message'] = '';
        $json['tva'] = 0;
        $json['ht'] = 0;
        $json['ttc'] = 0;
        $idsite = $_SESSION['idsite'];
        //SELECT ALL //////////////////////////////////	
        if (get('do') == 'viewall') {
            $f = get('f');
            $libellefact = 'Liste des factures';
            if ($f == '0') {
                $libellefact = 'Liste des factures proforma';
            }
            $type = 'evenement';
            $dte1 = date('Y-m-d');
            $dte2 = date('Y-m-d');
            $result = $this->t_facture_model->All($_SESSION['idsite'], $type, $dte1, $dte2);
            $resultannul = $this->t_facture_model->AllAnnul($_SESSION['idsite'], $type, $dte1, $dte2);
            $montantFactures = totalMontantPayeFactureAll();
            $clients = $clientobj->SelectAll($idsite);
            include(APP_FOLDER . '/views/admin/t_facture/View.php');
        }

        if (get('do') == 'recurente') {
            $bdd = HDB::hus();
            $f = get('f');
            $libellefact = 'Liste des factures recurentes';
            $type = 'facturation';
            $dte1 = date('Y-m-d');
            $dte2 = date('Y-m-d');
            //            $a="ppp";
            $result = $this->t_facture_model->AllrecurenteInsert($_SESSION['idsite'], $type, $bdd);
            //            $result = $this->t_facture_model->Allrecurente($_SESSION['idsite'],$type,$dte1,$dte2);
            $montantFactures = totalMontantPayeFactureAllrec($bdd);
            foreach ($result as $rows) {
                $date_recurente = $rows->date_echeance_old;
                $id_hotel = $rows->id_hotel;
                $verif = VerifFactGen($date_recurente, $type, $id_hotel, $bdd);
                if ($verif == 0) {
                    if (date('Y-m-d') == $date_recurente) {
                        //                        $a="pp123p";
                        /* Insertion dans t_facture */
                        $etat = 1;
                        $libcptfact = NUMFACT;
                        $num_cmd = $compteurobj->getnumerotationrec($id_hotel, $libcptfact, $bdd);
                        $num_cmd_format = format_numero($num_cmd);
                        $prefixefact = "FAC/";
                        $numfact = $prefixefact . $num_cmd_format;
                        $id_client = $rows->id_client;
                        $dte_edit = date('Y-m-d');
                        $dte_ech = date('Y-m-d');
                        //Facture recurente
                        $fact_recurente = 1;

                        $nbrejour = $rows->etat_sousresto;
                        //Generation de la date par rapport au nbre de jour
                        $dategeneration = strtotime($date_recurente);
                        $dte_genfact = date('Y-m-d', strtotime('+' . $nbrejour . 'days', $dategeneration));

                        $type = 'facturation';
                        $taux = $rows->taux;
                        $tva = $rows->tva;
                        $monnaie = $rows->monnaie;
                        $mont_ttc = $rows->mont_ttc;
                        $mont_ttc_remise = $rows->mont_ttc_remise;
                        $remise = $majoration = 0;
                        $mont_tva = $rows->mont_tva;
                        $justification = $rows->justification;
                        $company_id = $rows->company_id;
                        $id_user = $rows->id_user;
                        $monttotal_ht = $rows->montant_total;
                        $mode = $rows->montant_total;

                        $this->t_facture_model->InsertFactrecurente($numfact, $type, $etat, $fact_recurente, $nbrejour, $dte_genfact, $dte_edit, $dte_ech, $monttotal_ht, $mont_tva, $mont_ttc, $mont_ttc_remise, $taux, $tva, $monnaie, $remise, $majoration, $justification, $id_hotel, $company_id, $id_user, $id_client, $mode, $bdd);

                        //MAJ NUMEROTATION COMPTEUR
                        $num_cmd += 1;
                        $compteurobj->Update($libcptfact, $num_cmd, $id_hotel);
                        $result = $this->t_facture_model->Allrecurente($_SESSION['idsite'], $type, $dte1, $dte2, $bdd);
                        $montantFactures = totalMontantPayeFactureAllrec($bdd);
                    } else {
                        $result = $this->t_facture_model->Allrecurente($_SESSION['idsite'], $type, $dte1, $dte2, $bdd);
                        $montantFactures = totalMontantPayeFactureAllrec($bdd);
                    }
                }
            }
            include(APP_FOLDER . '/views/admin/t_facture/Recurentes.php');
            //            $json['s'] =TRUE;
            //            echo json_encode($json);

        }

        if (get('do') == 'recurenteaff') {
            $bdd = HDB::hus();
            $f = get('f');
            $libellefact = 'Liste des factures recurentes';
            $type = 'facturation';
            $dte1 = date('Y-m-d');
            $dte2 = date('Y-m-d');
            $result = $this->t_facture_model->Allrecurente($_SESSION['idsite'], $type, $dte1, $dte2,$bdd);
            $montantFactures = totalMontantPayeFactureAll();

            include(APP_FOLDER . '/views/admin/t_facture/Recurentes.php');
        }



        //EXPORT ////////////////////////////////////////////////////	
        if (get('do') == 'export') {
            $result = $this->t_facture_model->SelectAll();
            include(APP_FOLDER . '/views/admin/t_facture/Export.php');
        }
        //Filtrage liste des factures
        elseif (get('do') == 'allbydte') {
            $f = post('f');
            $libellefact = 'Liste des factures';
            if ($f == '0') {
                $libellefact = 'Liste des factures proforma';
            }
            $type = 'evenement';
            $dte1 = dateToformatBdd(post('datedebut'));
            $dte2 = dateToformatBdd(post('datefin'));
            $_SESSION['datedebut_fact'] = post('datedebut');
            $_SESSION['datefin_fact'] = post('datefin');
            
            $client_id = post('client_id_filter');
            $optradio=post('optradio');
            $montantFactures = totalMontantPayeFactureAll();
            if($optradio=='client'){
                $result = $this->t_facture_model->getFactByClient($_SESSION['idsite'], $type, $client_id);
            }else{
                $result = $this->t_facture_model->All($_SESSION['idsite'], $type, $dte1, $dte2);
            }
            include(APP_FOLDER . '/views/admin/t_facture/datalignesfact.php');
        }elseif (get('do') == 'test22') {
            $bdd = HDB::hus();
            $result=getListEventsPlanning($bdd);
            $alldata = array();
            foreach ($result as $rows) {
                $datetime = new DateTime($rows->fin);
                $datetime->modify('+1 day');
                $end=$datetime->format('Y-m-d');
                $title=$rows->name.'('.$rows->description.')';
                $url="index.php?pg=admin&view=t_facture&id_fact=".$rows->facture_id."&do=details&f=1&mode=Cash";
                $row = array("title" =>$title,"start" =>$rows->start,"end" =>$end, 
            "backgroundColor"=>$rows->color,"borderColor" =>$rows->color,"url"=>$url);
            array_push($alldata, $row);
            }
           
            echo json_encode($alldata);
        } 
        elseif (get('do') == 'allbydte5') {
            $f = post('f');
            $libellefact = 'Liste des factures normales';
            if ($f == '0') {
                $libellefact = 'Liste des factures proforma';
            }
            $type = 'facturation';
            $dte1 = dateToformatBdd(post('datedebut'));
            $dte2 = dateToformatBdd(post('datefin'));
            $_SESSION['datedebut_fact'] = post('datedebut');
            $_SESSION['datefin_fact'] = post('datefin');
            $client_id = post('client_id_filter');
            $optradio=post('optradio');
            $montantFactures = totalMontantPayeFactureAll();
            if($optradio=='client'){
                $result = $this->t_facture_model->getFactByClient($_SESSION['idsite'], $type, $client_id);
            }else{
                $result = $this->t_facture_model->All($_SESSION['idsite'], $type, $dte1, $dte2);
            }
            include(APP_FOLDER . '/views/admin/t_facture/datalignesfactall.php');
        } elseif (get('do') == 'allbydte1') {
            $f = post('f');
            $libellefact = 'Liste des factures normales';
            if ($f == '0') {
                $libellefact = 'Liste des factures proforma';
            }
            $type = 'facturation';
            $dte1 = dateToformatBdd(post('datedebut'));
            $dte2 = dateToformatBdd(post('datefin'));
            $_SESSION['datedebut_fact'] = post('datedebut');
            $_SESSION['datefin_fact'] = post('datefin');
            $client_id = post('client_id_filter');
            $optradio=post('optradio');
            $montantFactures = totalMontantPayeFactureAll();
            if($optradio=='client'){
                $result = $this->t_facture_model->getFactByClient($_SESSION['idsite'], $type, $client_id);
            }else{
                $result = $this->t_facture_model->All($_SESSION['idsite'], $type, $dte1, $dte2);
            }
            include(APP_FOLDER . '/views/admin/t_facture/datalignesfactacredit.php');
        } elseif (get('do') == 'allbydte2') {
            $f = post('f');
            $libellefact = 'Liste des factures normales';
            if ($f == '0') {
                $libellefact = 'Liste des factures proforma';
            }
            $type = 'facturation';
            $dte1 = dateToformatBdd(post('datedebut'));
            $dte2 = dateToformatBdd(post('datefin'));
            $_SESSION['datedebut_fact'] = post('datedebut');
            $_SESSION['datefin_fact'] = post('datefin');

            $client_id = post('client_id_filter');
            $optradio=post('optradio');
            $montantFactures = totalMontantPayeFactureAll();
            if($optradio=='client'){
                $result = $this->t_facture_model->getFactByClient($_SESSION['idsite'], $type, $client_id);
            }else{
                $result = $this->t_facture_model->All($_SESSION['idsite'], $type, $dte1, $dte2);
            }
            include(APP_FOLDER . '/views/admin/t_facture/datalignesfactacompte.php');
        } elseif (get('do') == 'allbydte3') {
            $bdd = HDB::hus();
            $f = post('f');
            $libellefact = 'Liste des factures normales';
            if ($f == '0') {
                $libellefact = 'Liste des factures proforma';
            }
            $type = 'facturation';
            $dte1 = dateToformatBdd(post('datedebut'));
            $dte2 = dateToformatBdd(post('datefin'));
            $_SESSION['datedebut_fact'] = post('datedebut');
            $_SESSION['datefin_fact'] = post('datefin');
           
            $client_id = post('client_id_filter');
            $optradio=post('optradio');
            $montantFactures = totalMontantPayeFactureAll();
            if($optradio=='client'){
                $result = $this->t_facture_model->getFactByClient($_SESSION['idsite'], $type, $client_id);
            }else{
                $result = $this->t_facture_model->Allrecurente($_SESSION['idsite'], $type, $dte1, $dte2,$bdd);
            }
            include(APP_FOLDER . '/views/admin/t_facture/datalignesfact_recurente.php');
        }elseif (get('do') == 'allbydte4') {

            $f = post('f');
            $libellefact = 'Liste des factures normales';
            if ($f == '0') {
                $libellefact = 'Liste des factures proforma';
            }

            $type = 'facturation';
            $dte1 = dateToformatBdd(post('datedebut'));
            $dte2 = dateToformatBdd(post('datefin'));
            $_SESSION['datedebut_fact'] = post('datedebut');
            $_SESSION['datefin_fact'] = post('datefin');
            $client_id = post('client_id_filter');
            $optradio=post('optradio');
            $montantFactures = totalMontantPayeFactureAll();
            if($optradio=='client'){
                $result = $this->t_facture_model->getFactByClient($_SESSION['idsite'], $type, $client_id);
            }else{
                $result = $this->t_facture_model->All($_SESSION['idsite'], $type, $dte1, $dte2);
            }
            include(APP_FOLDER . '/views/admin/t_facture/datalignesfact_proformat.php');
        } elseif (get('do') == 'allbydteannul') {

            $f = post('f');
            $libellefact = 'Liste des factures normales';
            if ($f == '0') {
                $libellefact = 'Liste des factures proforma';
            }

            $type = 'facturation';
            $dte1 = dateToformatBdd(post('datedebut'));
            $dte2 = dateToformatBdd(post('datefin'));
            $_SESSION['datedebut_fact'] = post('datedebut');
            $_SESSION['datefin_fact'] = post('datefin');
           
            $client_id = post('client_id_filter');
            $optradio=post('optradio');
            $montantFactures = totalMontantPayeFactureAll();
            if($optradio=='client'){
                $resultannul = $this->t_facture_model->getFactByClientAnnule($_SESSION['idsite'], $type, $client_id);
            }else{
                $resultannul = $this->t_facture_model->AllAnnul($_SESSION['idsite'], $type, $dte1, $dte2);
            }
            include(APP_FOLDER . '/views/admin/t_facture/datalignesfactannulees.php');
        }elseif (get('do') == 'getFactByCl') {
            $f = post('f');
            $libellefact = 'Liste des factures normales';
            if ($f == '0') {
                $libellefact = 'Liste des factures proforma';
            }
            $type = 'facturation';
            $dte1 = dateToformatBdd(post('datedebut'));
            $dte2 = dateToformatBdd(post('datefin'));
            $_SESSION['datedebut_fact'] = post('datedebut');
            $_SESSION['datefin_fact'] = post('datefin');
            $result = $this->t_facture_model->All($_SESSION['idsite'], $type, $dte1, $dte2);
            $montantFactures = totalMontantPayeFactureAll();
            include(APP_FOLDER . '/views/admin/t_facture/datalignesfact.php');
        }
        //Calcul de la date d'echeance
        elseif (get('do') == 'verifcond') {
            $dte_edition = get('dte_edition');
            $nbrjr = get('nbrjr');
            $dte_ech = CalculDateEcheance($dte_edition, $nbrjr);
            $json['message'] = dateAffiche($dte_ech);
            $json['s'] = True;
            echo json_encode($json);
        }
        //Expeort2
        elseif (get('do') == 'export2') {
            $rows = $this->t_facture_model->SelectOne(get('id_fact'));
            include(APP_FOLDER . '/views/admin/t_facture/Export2.php');
        }
        //SEARCH SUGGEST ////////////////////////////////////////////////////	
        elseif (get('do') == 'autosearch') {
            $qstring = post('qstring');
            if (strlen($qstring) > 0) {
                $autosearch = $this->t_facture_model->AutoSearch(trim($qstring), 10, 'num_fact');
                echo ' <div class=widget><ul class="list-group">';
                foreach ($autosearch as $srow) {
                    echo '<span class="searchheading"><a href="' . H_ADMIN . '&view=t_facture&id_fact=' . $srow->id_fact . '&do=details"><li class="list-group-item">' . $srow->num_fact . '</li></a>
	</span>';
                }
                echo '</ul></div>';
            }
        }


        //ADD //////////////////////////////////////////////////
        elseif (get('do') == 'add') {
            $etatfact = get('f');
            if ($etatfact == 1) {
                $typefact = 'normale';
                $libcptfact ='evenement';
            } else {
                $typefact = 'proforma';
                $libcptfact = NUMPROFORMA;
            }
            $bdd = HDB::hus();
            $idsite = $_SESSION['idsite'];
            $sousresto_id =$_SESSION['pos_id'];
            $panier->initialiser();
            $clients = $clientobj->SelectAll($idsite);
            $condpaiements = $condpaiementobj->SelectAll($idsite);
            $result2 = $ot_mode_reglement->SelectAllMode();
            $site = $siteobj->Infos2($idsite);
            $articles = ProdAndServ($sousresto_id, $idsite);
            $num_cmd = $compteurobj->getnumerotation($idsite, $libcptfact);
            $num_cmd_format = format_numero($num_cmd);
            $prefixefact = $_SESSION['prefconge'];
            $numfact = $prefixefact . $num_cmd_format;
          
            $motif=get('event');
            $start=get('start');
            $event_id=get('event_id');
            include(APP_FOLDER . '/views/admin/t_facture/Add.php');
        }elseif (get('do') == 'addbonlivraison') {
            $typefact = 'normale';
            $libcptfact = NUMFACT;
            $idsite = $_SESSION['idsite'];
            $sousresto_id = 123;
            $num_cmd = $compteurobj->getnumerotation($idsite, $libcptfact);
            $num_cmd_format = format_numero($num_cmd);
            $prefixefact = $_SESSION['prefconge'];
            $numfact = $prefixefact . $num_cmd_format;

            $id_fact=get('id');
            $rows = $this->t_facture_model->SelectOne($id_fact);
            $nomcl = $rows->nom_client;
            $societe = $rows->designation;
            $emailcl = $rows->email_client;
            $tel = $rows->telephone_client;
            $adr = $rows->adresse_provenance_client;
            $numfact = $rows->num_fact;
            $mode = $rows->mode;
            $dte_edit = dateAffiche($rows->date_edition);

            $panier->initialiser();
            $result = $this->t_facture_model->lignesAllBySite($id_fact);
            $bdd = HDB::hus();
            $dataliv= getQteLivreProduit($id_fact, $bdd);
            foreach ($result as $rows) {
                $qte=$rows->qte;
                $qte2=$dataliv['qtereste'][$rows->produit_id];
                $select['id'] = $rows->produit_id;
                $select['qte'] = $qte;
                $select['nom'] = $rows->designation;
                $select['prix'] =0;
                $select['monttva']=$qte2;
                $select['repas']=$qte2;
                $panier->ajouterFact($select);
            }
            $nbArticles = count($_SESSION['panier']['id_article']);
            $qtesaisi =0;
           
            include(APP_FOLDER . '/views/admin/t_facture/AddBonLivraison.php');
        }elseif (get('do') == 'majaddbonlivraison') {
            $typefact = 'normale';
            $libcptfact = NUMFACT;
            $idsite = $_SESSION['idsite'];
            $sousresto_id = 123;
            $num_cmd = $compteurobj->getnumerotation($idsite, $libcptfact);
            $num_cmd_format = format_numero($num_cmd);
            $prefixefact = $_SESSION['prefconge'];
            $numfact = $prefixefact . $num_cmd_format;

            $id_fact=get('id');
            $rows = $this->t_facture_model->SelectOne($id_fact);
            $nomcl = $rows->nom_client;
            $societe = $rows->designation;
            $emailcl = $rows->email_client;
            $tel = $rows->telephone_client;
            $adr = $rows->adresse_provenance_client;
            $numfact = $rows->num_fact;
            $mode = $rows->mode;
            $dte_edit = dateAffiche($rows->date_edition);

            $panier->initialiser();
            $result = $this->t_facture_model->lignesAllBySite($id_fact);
            $bdd = HDB::hus();
            $dataliv= getQteLivreProduit($id_fact, $bdd);
            foreach ($result as $rows) {
                $qte=$rows->qte;
                $qte2=$dataliv['qtereste'][$rows->produit_id];
                $select['id'] = $rows->produit_id;
                $select['qte'] = $qte;
                $select['nom'] = $rows->designation;
                $select['prix'] =0;
                $select['monttva']=$qte2;
                $select['repas']=$qte2;
                $panier->ajouterFact($select);
            }
            $nbArticles = count($_SESSION['panier']['id_article']);
            $qtesaisi =0;
           
            include(APP_FOLDER . '/views/admin/t_facture/ligneslivraison.php');
           // echo"bonjour";
        }
        
        elseif (get('do') == 'addpan') {
            // Ajouter produit dans le panier 
            //$depot_id=get('source_id');
            $select['id'] = get('idprod');
            $select['qte'] = get('qte');
            $select['nom'] = trim(get('nameprod'));
            $select['prix'] = arrondir(get('prix'));
            $select['repas']='';

            $tva = get('tva');
            $select['monttva'] = CalculMontTva($select['prix'], $tva);
            //$op=get('op');
            if (IsNombre($select['qte'])) {
                //$qtedispo=GetProdQteDispoByDepot($select['id'],$depot_id);
                //if ($select['qte'] <= $qtedispo){
                //$select['unite'] = get('unite');
                $panier->ajouterFact($select);
                $ttc = $panier->montant_panier();
                $mont_tva = $panier->montant_panier_tva();
                $totmont_prodtva = $panier->total_montantprod_panier_tva();
                $ht = $ttc - $mont_tva;
                $json['tva'] = $panier->montant_panier_tva();
                $json['totprodtva'] = $totmont_prodtva;
                $json['ht'] = $ht;
                $json['ttc'] = $ttc;
                $json['tvaf'] = afficheMontant($_SESSION['Paie_affiche'], $mont_tva);
                $json['htf'] = afficheMontant($_SESSION['Paie_affiche'], $ht);
                $json['ttcf'] = afficheMontant($_SESSION['Paie_affiche'], $ttc);
                $json['s'] = TRUE;
                //}else{
                // $json['message'] = 'La quantité saisie de ce produit dans la source doit être inferieure ou égale à ' . $qtedispo;
                //} 
            } else {
                $json['s'] = FALSE;
                $json['message'] = 'La quantité saisie doit être un nombre positif';
            }
            echo json_encode($json);
        } elseif (get('do') == 'modifqte') {
            //Modification qte produit  panier 
            $select['id'] = get('idprod');
            $select['qte'] = get('qte');
            $panier->modifierQTeArticle($select);
            $nbArticles = count($_SESSION['panier']['id_article']);
            include(APP_FOLDER . '/views/admin/t_facture/lignesfact.php');
        } 
        elseif (get('do') == 'modifqteliv') {
            //Modification qte produit  panier 
            $qtesaisi =intval(get('qte'));
            $idprod = get('idprod');
            $idp = get('idp');
            $reste=get('idp2');
            $qte=$_SESSION['panier']['qte'][$idp];
            if ($qtesaisi <=$reste) {
                $reste2=$reste-$qtesaisi ;
                $_SESSION['panier']['prix'][$idp] = $qtesaisi;
                $_SESSION['panier']['monttva'][$idp] = $reste2;
            }else{
                $reste2=$reste;
                $_SESSION['panier']['prix'][$idp]=0;
                $_SESSION['panier']['monttva'][$idp] = $reste2;
            }
            
            $nbArticles = count($_SESSION['panier']['id_article']);
            include(APP_FOLDER . '/views/admin/t_facture/ligneslivraison.php');
        }elseif (get('do') =='checkQteLivre') {
            $json['s'] = FALSE;
            $qtelibrebool=0;
            $nbArticles = count($_SESSION['panier']['id_article']);
            for ($i = 0; $i <= $nbArticles - 1; $i++) {
                $qtelivre=$_SESSION['panier']['prix'][$i];
                if($qtelivre>0){
                    $qtelibrebool=1;
                    break;
                }
            }
            if($qtelibrebool==0){
                $json['message'] = 'Veuillez insérer les quantités à livrer!';
                $json['s'] = True;
            }
            //echo $qtelibrebool;
            echo json_encode($json);
        } 
        elseif (get('do') == 'modifprix') {
            //Modification prix produit  panier 
            $select['id'] = get('idprod');
            $select['prix'] = arrondir(get('prix'));
            $panier->modifierPrixArticle($select);
            $nbArticles = count($_SESSION['panier']['id_article']);
            include(APP_FOLDER . '/views/admin/t_facture/lignesfact.php');
        } elseif (get('do') == 'modiflib') {
            //Modification lib produit  panier 
            $select['id'] = get('idprod');
            $select['nom'] = get('lib');
            $panier->modifierLibArticle($select);
            $nbArticles = count($_SESSION['panier']['id_article']);
            include(APP_FOLDER . '/views/admin/t_facture/lignesfact.php');
        } elseif (get('do') == 'majtot') {
            //MAJ de totaux de la facture  
            $ttc = $panier->montant_panier();
            $mont_tva = $panier->montant_panier_tva();
            $ht = $ttc - $mont_tva;
            $json['tva'] = $panier->montant_panier_tva();
            $json['ht'] = $ht;
            $json['ttc'] = $ttc;
            $json['tvaf'] = afficheMontant($_SESSION['Paie_affiche'], $mont_tva);
            $json['htf'] = afficheMontant($_SESSION['Paie_affiche'], $ht);
            $json['ttcf'] = afficheMontant($_SESSION['Paie_affiche'], $ttc);
            $json['s'] = TRUE;
            echo json_encode($json);
        } elseif (get('do') == 'majremise') {
            //MAJ de totaux de la facture  
            $remise_mont = get('remise_mont');
            $ttc = $panier->montant_panier() - $remise_mont;
            $mont_tva = $panier->montant_panier_tva();
            $ht = $ttc - $mont_tva + $remise_mont;
            $remise_pour = ($remise_mont * 100) / $ht;
            $json['ttc'] = $ttc;
            $json['remise_pour'] = arrondir($remise_pour);
            $json['remise_mont'] = arrondir($remise_mont);
            $json['ttcf'] = afficheMontant($_SESSION['Paie_affiche'], $ttc);
            $json['s'] = TRUE;
            echo json_encode($json);
        } elseif (get('do') == 'supprodpan') {
            // Supprimer produit dans le panier           
            $select['id'] = get('idprod');
            $panier->delete_articleFact($select);
            $nbArticles = count($_SESSION['panier']['id_article']);
            //            if($nbArticles>=1){
            include(APP_FOLDER . '/views/admin/t_facture/lignesfact.php');
            //            }
        } elseif (get('do') == 'majlistprodstk') {
            // Liste produit stock panier          
            $nbArticles = count($_SESSION['panier']['id_article']);
            if ($nbArticles >= 1) {
                include(APP_FOLDER . '/views/admin/t_facture/lignesfact.php');
            }
        }
        //ENREGISTRER FACTURE FACTURATION //////////////////////////////////////////////////
        elseif (get('do') == 'enregfact') {
            $bdd = HDB::hus();
            $_SESSION['datas_exist'] = 0;
            $_SESSION['montant_total'] = 0;
            $_SESSION['montant_paye'] = 0;
            $_SESSION['montant_a_paye'] = 0;
            if (post('id_client') < 0 || (post('ttc') == 0)) {
                $json['message'] = 'Veuillez completer les informations de la facture svp!';
                $json['s'] = FALSE;
            } else {
                $id_hotel = post('id_hotel');
                //Numerotation facture
                $etat = post('etatfact');
                if ($etat == '0') {
                    $libcptfact = NUMPROFORMA;
                    $fact_recurente = 0;
                } else {
                    $libcptfact = 'evenement';
                    //Facture recurente
                    $fact_recurente = 0;
                }
                $num_cmd = $compteurobj->getnumerotation($id_hotel, $libcptfact);
                $num_cmd_format = format_numero($num_cmd);
                $prefixefact = post('prefixefact');
                $numfact = $prefixefact . $num_cmd_format;
                $id_client = post('id_client');
                $dte_edit = dateToformatBdd(post('dte_edit'));
                $dte_ech = dateToformatBdd(post('dte_ech'));
                //Facture recurente
                //$fact_recurente =post('fact_recurente');
                if ($fact_recurente == 0) {
                    $nbrejour = 0;
                    $dte_genfact = $dte_edit;
                } else {
                    $nbrejour = post('nbrejr');
                    //Generation de la date par rapport au nbre de jour
                    $dategeneration = strtotime($dte_edit);
                    $dte_genfact = date('Y-m-d', strtotime('+' . $nbrejour . 'days', $dategeneration));
                }
                $type = 'evenement';
                $taux = $_SESSION['Paie_taux'];
                $tva = $_SESSION['tva'];
                $monnaie = 'CDF';
                $montant_fact = montant_equivalent_bdd($_SESSION['Paie_affiche'], $monnaie, $taux, post('ttc'));
                $remise = $majoration = 0;
                $mont_tva = montant_equivalent_bdd($_SESSION['Paie_affiche'], $monnaie, $taux, post('tva'));
                $justification = post('description');
                $company_id = $_SESSION['company_id'];
                $id_user = $_SESSION['id_user'];

                $nbArticles = count($_SESSION['panier']['id_article']);
                $totfacttva = $panier->tot_fact_tva();
                $monttotal_ht = montant_equivalent_bdd($_SESSION['Paie_affiche'], $monnaie, $taux, $totfacttva);
                //CAS DE NOUVEAU CLIENT
                $id_res = post('id_res');
                if ($id_client == '0') {
                    $id_res ='';
                    $id_client = $clientobj->InsertFacturation(post('nomclt'), post('nomsct'), post('sexeclt'), post('adr'), post('eml'), post('tel'), post('typeclt'), post('id_hotel'), post('compte2'));
                    $numberincre = $_SESSION['numberincreaccountnumber'];
                    $numberincre += 1;
                    $libelle = "compteclient";
                    setnumerotation($_SESSION['id_hotel'], $libelle, $numberincre, $bdd);
                }
                $res_ch_id = post('res_ch_id');
                $mode = post('modepaiement');
                $compte1 = post('compte1');
                $compte2 = post('compte2');
                $nom_client = post('customer');
                $remise_pour = post('remise_pour');
                $remise_mont = montant_equivalent_bdd($_SESSION['Paie_affiche'], $monnaie, $taux, post('remise_mont2'));
                if($id_res==''){
                $facture_id = $this->t_facture_model->InsertFact2(post('numfact'), $type, $etat, $fact_recurente, $nbrejour, $dte_genfact, $dte_edit, $dte_ech, $monttotal_ht, $mont_tva, $remise_mont, $montant_fact, $taux, $tva, $monnaie, $remise_pour, $majoration, $justification, $id_hotel, $company_id, $id_user, $id_client, $mode, $compte1, $compte2);
                }else{
                    $facture_id = $this->t_facture_model->InsertFact(post('numfact'), $type, $etat, $fact_recurente, $nbrejour, $dte_genfact, $dte_edit, $dte_ech, $monttotal_ht, $mont_tva, $remise_mont, $montant_fact, $taux, $tva, $monnaie, $remise_pour, $majoration, $justification, $id_hotel, $company_id, $id_user, $id_client, $mode, $compte1, $compte2,$id_res,$res_ch_id);

               }

                //INSERT LIGNES FACTURE
                for ($i = 0; $i <= $nbArticles - 1; $i++) {
                    $quantite = $_SESSION['panier']['qte'][$i];
                    $produit_id = $_SESSION['panier']['id_article'][$i];
                    $prix = $_SESSION['panier']['prix'][$i];
                    $mont_tva = $_SESSION['panier']['monttva'][$i];
                    $lib = $_SESSION['panier']['nom'][$i];
                    $lignes_commandesobj->InsertFact($quantite, $prix, $mont_tva, $facture_id, $produit_id, $id_hotel, $lib);
                }
                //MAJ NUMEROTATION COMPTEUR
                $num_cmd += 1;
                $compteurobj->Update($libcptfact, $num_cmd, $id_hotel);
                $panier->initialiser();

                //EVENEMENT
                $description=post('eventcomment');
                $dte=date('Y-m-d');
                $heure=date('H:i:s');
                $event_id=post('id_event');
                insertEvent($description,$dte,$dte_edit,$dte_ech,$heure,$event_id,$facture_id,$id_user,$bdd);


                //COMPTA
                // $module_id = 23;
                // $site_id = $_SESSION['id_hotel'];
                // ConfLinkMod($module_id, $site_id, $bdd);
                // if ($_SESSION['ConfLinkMod_lie'] == 1) {
                //     $mont_ttc = post('ttc');
                //     $tva = $_SESSION['tva'];
                //     $lib_mode = $mode;
                //     $numero = $numfact;
                //     $montantusd = $mont_ttc;
                //     $montantcdf = 0;
                //     $montantsaisi = $mont_ttc;
                //     $m_affiche = $_SESSION['Paie_affiche'];
                //     $taux_op = $taux;
                //     $account = $compte1 . $compte2;
                //     CreateAcountForCustomer($compte1, $compte2, $account, $nom_client, $site_id, $bdd);
                //     $reference = $numero;
                //     $montantusd = $montantusd;
                //     $montantcdf = $montantcdf;
                //     $montantsaisi = $montantsaisi;
                //     $devise = $m_affiche;
                //     $tauxop = $taux_op;
                //     $libelle = '';
                //     $beneficiaire = $nom_client;
                //     $site_id = $_SESSION['id_hotel'];
                //     $user_id = $_SESSION['id_user'];
                //     $ttc = $mont_ttc;
                //     $type_rendu = 'oui';
                //     $dte = date('Y-m-d');
                //     $dtetime = date('Y-m-d H:i:s');
                //     $mont_tva = ($ttc * $tva) / 100;
                //     $ht = $ttc - $mont_tva;
                //     //echo "lib_mode  " . $lib_mode;
                //     // echo "ttc  " . $ttc;
                //     // echo "montantusd  " . $montantusd;
                //     // echo "montantcdf  " . $montantcdf;
                //     // echo "devise  " . $devise;

                //     if ($lib_mode == 'Cash') {
                //         COMPTA_VENTE_CASH_RESTO($type_rendu, $reference, $dte, $dtetime, $montantusd, $montantcdf, $montantsaisi, $ht, $tva, $ttc, $devise, $tauxop, $libelle, $beneficiaire, $site_id, $user_id, $bdd);
                //     } elseif ($lib_mode == 'Credit') {
                //         COMPTA_VENTE_CREDIT_RESTO($type_rendu, $reference, $dte, $dtetime, $montantusd, $montantcdf, $montantsaisi, $ht, $tva, $ttc, $devise, $tauxop, $libelle, $beneficiaire, $site_id, $user_id, $bdd);
                //         if ($montantusd > 0 || $montantcdf > 0) {
                //             COMPTA_PAIE_RESTO($reference, $montantusd, $montantcdf, $montantsaisi, $devise, $tauxop, $libelle, $beneficiaire, $site_id, $user_id, $bdd, $ttc);
                //         }
                //     }
                //     // elseif ($lib_mode == 'Don') {
                //     //ici on mettra la fonction compta pour le mode Don  
                //     // }

                // }

                //COMPTA
                $json['facture_id'] = $facture_id;
                $json['mode_paie'] = $mode;
                $json['message'] = "Cette facture vient d'être enregistrée avec succès!";
                $json['s'] = TRUE;
            }
            echo json_encode($json);
        } elseif (get('do') == 'enregbonlivraison') {
            $bdd = HDB::hus();
            $json1 = array();
            $json1['s'] = False;
            $json1['message'] = '';
            $libcptfact="BONLIV";
            $id_hotel = post('id_hotel');
            $user_id = $_SESSION['id_user'];
            $commande_id=post('facture_id');
            $num_cmd = $compteurobj->getnumerotation($id_hotel, $libcptfact);
            $num_cmd_format = format_numero($num_cmd);
            $prefixefact = post('prefixefact');
            $numfact = $libcptfact . $num_cmd_format;
            $dte_edit = dateToformatBdd(post('dte_edit'));
            $dte_h=date('Y-m-d H:i:s');
            $nbArticles = count($_SESSION['panier']['id_article']);
            //INSERTION BON
            $requete = $bdd->prepare("INSERT INTO bons(numero,dte,dte_h,commande_id,user_id,site_id)
                                        VALUES(:numero,:dte,:dte_h,:commande_id,:user_id,:site_id)");
                                        $requete->BindParam(':numero', $numfact);
                                        $requete->BindParam(':dte', $dte_edit);
                                        $requete->BindParam(':dte_h',$dte_h);
                                        $requete->BindParam(':commande_id',$commande_id);
                                        $requete->BindParam(':user_id', $user_id);
                                        $requete->BindParam(':site_id',$id_hotel);
                                        $requete->execute();
                                        $bon_id = $bdd->lastInsertId();
            //INSERT LIGNES BONS
            for ($i = 0; $i <= $nbArticles - 1; $i++) {
                $produit_id = $_SESSION['panier']['id_article'][$i];
                $qte = $_SESSION['panier']['qte'][$i];
                $qtelivre = $_SESSION['panier']['prix'][$i];
                $qtereste = $_SESSION['panier']['monttva'][$i];
                $qi=$qtereste+$qtelivre;
                if($qtelivre>0){
                    $requete = $bdd->prepare("INSERT INTO lignesbons(qi,qte,qs,produit_id,bon_id)
                    VALUES(:qi,:qte,:qs,:produit_id,:bon_id)");
                    $requete->BindParam(':qi',$qi);
                    $requete->BindParam(':qte',$qtelivre);
                    $requete->BindParam(':qs',$qtereste);
                    $requete->BindParam(':produit_id',$produit_id);
                    $requete->BindParam(':bon_id',$bon_id);
                    $requete->execute();
                }
                /* $requete = $bdd->prepare("UPDATE lignes_commandes SET qte2=qte2+:qte2 WHERE commande_id=:commande_id AND produit_id=:produit_id");
                $requete->BindParam(':qte2',$qtelivre);
                $requete->BindParam(':commande_id',$commande_id);
                $requete->BindParam(':produit_id',$produit_id);
                $requete->execute(); */
            }
            //MAJ NUMEROTATION COMPTEUR
            $num_cmd += 1;
            $compteurobj->Update($libcptfact, $num_cmd, $id_hotel);
            $panier->initialiser();
            $json1['bon_id'] = $bon_id;
            $json1['facture_id'] = $commande_id;
            $json1['s'] = TRUE;
            echo json_encode($json1);
        }
         elseif (get('do') == 'updatefact') {
            $bdd = HDB::hus();
            $_SESSION['datas_exist'] = 0;
            $_SESSION['montant_total'] = 0;
            $_SESSION['montant_paye'] = 0;
            $_SESSION['montant_a_paye'] = 0;
            if (post('id_client') < 0 || (post('ttc') == 0)) {
                $json['message'] = 'Veuillez completer les informations de la facture svp!';
                $json['s'] = FALSE;
            } else {
                $id_hotel = post('id_hotel');
                //Numerotation facture
                $etat = post('etatfact');
                if ($etat == '0') {
                    $libcptfact = NUMPROFORMA;
                    $fact_recurente = 0;
                } else {
                    $libcptfact = NUMFACT;
                    //Facture recurente
                    $fact_recurente = 0;
                }

                $id_fact = post('facture_id');
                $id_client = post('id_client');
                $dte_edit = dateToformatBdd(post('dte_edit'));
                $dte_ech = dateToformatBdd(post('dte_ech'));
                //Facture recurente
                if ($fact_recurente == 0) {
                    $nbrejour = 0;
                    $dte_genfact = $dte_edit;
                } else {
                    $nbrejour = post('nbrejr');
                    //Generation de la date par rapport au nbre de jour
                    $dategeneration = strtotime($dte_edit);
                    $dte_genfact = date(
                        'Y-m-d',
                        strtotime('+' . $nbrejour . 'days', $dategeneration)
                    );
                }
                $type = 'facturation';
                $taux = $_SESSION['Paie_taux'];
                $tva = $_SESSION['tva'];
                $monnaie = 'CDF';
                $montant_fact = montant_equivalent_bdd($_SESSION['Paie_affiche'], $monnaie, $taux, post('ttc'));
                $remise = $majoration = 0;
                $mont_tva = montant_equivalent_bdd($_SESSION['Paie_affiche'], $monnaie, $taux, post('tva'));
                $justification = post('description');
                $company_id = $_SESSION['company_id'];
                $id_user = $_SESSION['id_user'];
                $nbArticles = count($_SESSION['panier']['id_article']);
                $totfacttva = $panier->tot_fact_tva();
                $monttotal_ht = montant_equivalent_bdd($_SESSION['Paie_affiche'], $monnaie, $taux, $totfacttva);
                //CAS DE NOUVEAU CLIENT
                if ($id_client == '0') {
                    $id_client = $clientobj->InsertFacturation(post('nomclt'), post('nomsct'), post('sexeclt'), post('adr'), post('eml'), post('tel'), post('typeclt'), post('id_hotel'), post('compte2'));
                    $numberincre = $_SESSION['numberincreaccountnumber'];
                    $numberincre += 1;
                    $libelle = "compteclient";
                    setnumerotation($_SESSION['id_hotel'], $libelle, $numberincre, $bdd);
                }
                $mode = post('modepaiement');
                $compte1 = post('compte1');
                $compte2 = post('compte2');
                $nom_client = post('customer');
                $remise_pour = post('remise_pour');
                $remise_mont = montant_equivalent_bdd($_SESSION['Paie_affiche'], $monnaie, $taux, post('remise_mont2'));
                // $facture_id = $this->t_facture_model->InsertFact(post('numfact'), $type, $etat, $fact_recurente, $nbrejour, $dte_genfact, $dte_edit, $dte_ech, $monttotal_ht, $mont_tva, $remise_mont, $montant_fact, $taux, $tva, $monnaie, $remise_pour, $majoration, $justification, $id_hotel, $company_id, $id_user, $id_client, $mode, $compte1, $compte2);
                // echo "type " . $type . "<br>";
                // echo "etat " . $etat . "<br>";
                // echo "fact_recurente " . $fact_recurente . "<br>";
                // echo "dte_genfact " . $dte_genfact . "<br>";
                // echo "dte_edit " . $dte_edit . "<br>";
                // echo "dte_ech " . $dte_ech . "<br>";
                // echo "monttotal_ht " . $monttotal_ht . "<br>";
                // echo "mont_tva " . $mont_tva . "<br>";
                // echo "remise_mont " . $remise_mont . "<br>";
                // echo "montant_fact " . $montant_fact . "<br>";
                // echo "taux " . $taux . "<br>";
                // echo "tva " . $tva . "<br>";
                // echo "monnaie " . $monnaie . "<br>";
                // echo "remise_pour " . $remise_pour . "<br>";
                // echo "majoration " . $majoration . "<br>";
                // echo "justification " . $justification . "<br>";
                // echo "id_user " . $id_user . "<br>";
                // echo "id_client " . $id_client . "<br>";
                // echo "mode " . $mode . "<br>";
                // echo "compte1 " . $compte1 . "<br>";
                // echo "compte2 " . $compte2 . "<br>";
                // echo "id_fact " . $id_fact . "<br>";
                UpdateFact($etat, $dte_genfact, $dte_edit, $dte_ech, $monttotal_ht, $mont_tva, $remise_mont, $montant_fact, $taux, $tva, $monnaie, $remise_pour, $majoration, $justification, $id_user, $id_client, $mode, $compte1, $compte2, $id_fact, $bdd);
                //Suppression avant insertion
                $t_reglement_obj->DeleteAllLgnRglm($id_fact);
                $lignes_commandesobj->DeleteAllLgnCmd($id_fact);
                //INSERT LIGNES FACTURE
                for ($i = 0; $i <= $nbArticles - 1; $i++) {
                    $quantite = $_SESSION['panier']['qte'][$i];
                    $produit_id = $_SESSION['panier']['id_article'][$i];
                    $prix = $_SESSION['panier']['prix'][$i];
                    $mont_tva = $_SESSION['panier']['monttva'][$i];
                    $lib = $_SESSION['panier']['nom'][$i];
                    $lignes_commandesobj->InsertFact($quantite, $prix, $mont_tva, $id_fact, $produit_id, $id_hotel, $lib);
                }
                //MAJ NUMEROTATION COMPTEUR
                $panier->initialiser();
                $json['facture_id'] = $id_fact;
                $json['mode_paie'] = $mode;
                $json['message'] = "Cette facture vient d'être modifiée avec succès!";
                $json['s'] = TRUE;
            }
            echo json_encode($json);
        }
        //ADD PROCESS //////////////////////////////////////////////////
        elseif (get('do') == 'addpro') {
            if ($_POST) {
                //form validation
                if (post('num_fact') == '') {
                    json_error('The field num fact cannot be empty!');
                } elseif (post('type') == '') {
                    json_error('The field type cannot be empty!');
                } elseif (post('i_souscription') == '') {
                    json_error('The field i souscription cannot be empty!');
                } elseif (post('etat') == '') {
                    json_error('The field etat cannot be empty!');
                } elseif (post('etat_cmd') == '') {
                    json_error('The field etat cmd cannot be empty!');
                } elseif (post('date_echeance_old') == '') {
                    json_error('The field date echeance old cannot be empty!');
                } elseif (post('date_edition') == '') {
                    json_error('The field date edition cannot be empty!');
                } elseif (post('dte_blocage') == '') {
                    json_error('The field dte blocage cannot be empty!');
                } elseif (post('date_echeance') == '') {
                    json_error('The field date echeance cannot be empty!');
                } elseif (post('date_desactivation') == '') {
                    json_error('The field date desactivation cannot be empty!');
                } elseif (post('montant_total') == '') {
                    json_error('The field montant total cannot be empty!');
                } elseif (post('mont_tva') == '') {
                    json_error('The field mont tva cannot be empty!');
                } elseif (post('mont_ttc') == '') {
                    json_error('The field mont ttc cannot be empty!');
                } elseif (post('mont_ttc_remise') == '') {
                    json_error('The field mont ttc remise cannot be empty!');
                } elseif (post('taux') == '') {
                    json_error('The field taux cannot be empty!');
                } elseif (post('taux_prix') == '') {
                    json_error('The field taux prix cannot be empty!');
                } elseif (post('tva') == '') {
                    json_error('The field tva cannot be empty!');
                } elseif (post('monnaie') == '') {
                    json_error('The field monnaie cannot be empty!');
                } elseif (post('remise') == '') {
                    json_error('The field remise cannot be empty!');
                } elseif (post('majoration') == '') {
                    json_error('The field majoration cannot be empty!');
                } elseif (post('justification') == '') {
                    json_error('The field justification cannot be empty!');
                } elseif (post('id_res') == '') {
                    json_error('The field id res cannot be empty!');
                } elseif (post('res_ch_id') == '') {
                    json_error('The field res ch id cannot be empty!');
                } elseif (post('modulecompagny') == '') {
                    json_error('The field modulecompagny cannot be empty!');
                } elseif (post('id_hotel') == '') {
                    json_error('The field id hotel cannot be empty!');
                } elseif (post('company_id') == '') {
                    json_error('The field company id cannot be empty!');
                } elseif (post('id_user') == '') {
                    json_error('The field id user cannot be empty!');
                } elseif (post('id_client') == '') {
                    json_error('The field id client cannot be empty!');
                } elseif (post('fact1') == '') {
                    json_error('The field fact1 cannot be empty!');
                } else {
                    $this->t_facture_model->Insert(post('num_fact'), post('type'), post('i_souscription'), post('etat'), post('etat_cmd'), post('date_echeance_old'), post('date_edition'), post('dte_blocage'), post('date_echeance'), post('date_desactivation'), post('montant_total'), post('mont_tva'), post('mont_ttc'), post('mont_ttc_remise'), post('taux'), post('taux_prix'), post('tva'), post('monnaie'), post('remise'), post('majoration'), post('justification'), post('id_res'), post('res_ch_id'), post('modulecompagny'), post('id_hotel'), post('company_id'), post('id_user'), post('id_client'), post('fact1'));
                    json_send('' . H_ADMIN . '&view=t_facture&do=viewall&msg=add');
                    json_success('Process Completed');
                }
            }
        }

        //UPDATE //////////////////////////////////////////////////
        elseif (get('do') == 'update') {
            $idsite = $_SESSION['idsite'];
            $sousresto_id = 123;
            $id_fact = get('id_fact');
            $rows = $this->t_facture_model->SelectOne($id_fact);
            $etatfact = $rows->etat;
            $id_client = $rows->id_client;
            $nomcl = $rows->nom_client;
            $societe = $rows->designation;
            $emailcl = $rows->email_client;
            $tel = $rows->telephone_client;
            $adr = $rows->adresse_provenance_client;
            $numfact = $rows->num_fact;
            $mode = $rows->mode;
            $dte_edit = dateAffiche($rows->date_edition);
            $etatfact = $rows->etat;
            $annul = $rows->etat_cmd;
            $compte2 = $rows->compte2;

            if ($etatfact == '1') {
                $typefact = 'normale';
            } else {
                $typefact = 'proforma';
            }
            $dte_ech = dateAffiche($rows->date_echeance);
            $justification = $rows->justification;
            $ht = $rows->montant_total;
            $monttvax = $rows->mont_tva;
            $ttc = $rows->mont_ttc_remise;
            $remise = $rows->remise;
            $montremise = $rows->mont_ttc;
            $monnaie_fact = $rows->monnaie;
            $taux = getTauxFacture2($monnaie_fact, $_SESSION['Paie_taux'], $rows->taux);
            $ht = montant_equivalent_bdd($monnaie_fact, $_SESSION['Paie_affiche'], $taux, $ht);
            $monttvax = montant_equivalent_bdd($monnaie_fact, $_SESSION['Paie_affiche'], $taux, $monttvax);
            $ttc = montant_equivalent_bdd($monnaie_fact, $_SESSION['Paie_affiche'], $taux, $ttc);
            $montremise = montant_equivalent_bdd($monnaie_fact, $_SESSION['Paie_affiche'], $taux, $montremise);
            $panier->initialiser();
            $site = $siteobj->Infos2($idsite);
            $logo = $site->logo;
            $mail = $site->mail;
            $phone = $site->phone;
            $adrcomp = $site->adrcomp;
            $nomcomp = $site->nomcomp;
            $idnat = $site->idnat;
            $rccm = $site->rccm;
            $result = $this->t_facture_model->lignesAllBySite($id_fact);
            foreach ($result as $rows) {
                $select['id'] = $rows->produit_id;
                $select['qte'] = $rows->qte;
                $select['nom'] = $rows->designation;
                $select['prix'] = arrondir($rows->prix);
                $select['monttva'] = $rows->mont_tva;
                $panier->ajouterFact($select);
            }
            $nbArticles = count($_SESSION['panier']['id_article']);
            if ($etatfact == 1) {
                $typefact = 'normale';
                $libcptfact = NUMFACT;
            } else {
                $typefact = 'proforma';
                $libcptfact = NUMPROFORMA;
            }

            $clients = $clientobj->SelectAll($idsite);
            $condpaiements = $condpaiementobj->SelectAll($idsite);
            $result2 = $ot_mode_reglement->SelectAllMode();
            $site = $siteobj->Infos2($idsite);
            $articles = ProdAndServ($sousresto_id, $idsite);
            $prefixefact = $_SESSION['prefconge'];
            include(APP_FOLDER . '/views/admin/t_facture/Update.php');
        }

        //UPDATE PROCESS //////////////////////////////////////////////////
        elseif (get('do') == 'updatepro') {
            if ($_POST) {
                //form validation
                if (post('id_fact') == '') {
                    json_error('The field id_fact cannot be empty!');
                } elseif (post('num_fact') == '') {
                    json_error('The field num fact cannot be empty!');
                } elseif (post('type') == '') {
                    json_error('The field type cannot be empty!');
                } elseif (post('i_souscription') == '') {
                    json_error('The field i souscription cannot be empty!');
                } elseif (post('etat') == '') {
                    json_error('The field etat cannot be empty!');
                } elseif (post('etat_cmd') == '') {
                    json_error('The field etat cmd cannot be empty!');
                } elseif (post('date_echeance_old') == '') {
                    json_error('The field date echeance old cannot be empty!');
                } elseif (post('date_edition') == '') {
                    json_error('The field date edition cannot be empty!');
                } elseif (post('dte_blocage') == '') {
                    json_error('The field dte blocage cannot be empty!');
                } elseif (post('date_echeance') == '') {
                    json_error('The field date echeance cannot be empty!');
                } elseif (post('date_desactivation') == '') {
                    json_error('The field date desactivation cannot be empty!');
                } elseif (post('montant_total') == '') {
                    json_error('The field montant total cannot be empty!');
                } elseif (post('mont_tva') == '') {
                    json_error('The field mont tva cannot be empty!');
                } elseif (post('mont_ttc') == '') {
                    json_error('The field mont ttc cannot be empty!');
                } elseif (post('mont_ttc_remise') == '') {
                    json_error('The field mont ttc remise cannot be empty!');
                } elseif (post('taux') == '') {
                    json_error('The field taux cannot be empty!');
                } elseif (post('taux_prix') == '') {
                    json_error('The field taux prix cannot be empty!');
                } elseif (post('tva') == '') {
                    json_error('The field tva cannot be empty!');
                } elseif (post('monnaie') == '') {
                    json_error('The field monnaie cannot be empty!');
                } elseif (post('remise') == '') {
                    json_error('The field remise cannot be empty!');
                } elseif (post('majoration') == '') {
                    json_error('The field majoration cannot be empty!');
                } elseif (post('justification') == '') {
                    json_error('The field justification cannot be empty!');
                } elseif (post('id_res') == '') {
                    json_error('The field id res cannot be empty!');
                } elseif (post('res_ch_id') == '') {
                    json_error('The field res ch id cannot be empty!');
                } elseif (post('modulecompagny') == '') {
                    json_error('The field modulecompagny cannot be empty!');
                } elseif (post('id_hotel') == '') {
                    json_error('The field id hotel cannot be empty!');
                } elseif (post('company_id') == '') {
                    json_error('The field company id cannot be empty!');
                } elseif (post('id_user') == '') {
                    json_error('The field id user cannot be empty!');
                } elseif (post('id_client') == '') {
                    json_error('The field id client cannot be empty!');
                } elseif (post('fact1') == '') {
                    json_error('The field fact1 cannot be empty!');
                } else {
                    $this->t_facture_model->Update(post('num_fact'), post('type'), post('i_souscription'), post('etat'), post('etat_cmd'), post('date_echeance_old'), post('date_edition'), post('dte_blocage'), post('date_echeance'), post('date_desactivation'), post('montant_total'), post('mont_tva'), post('mont_ttc'), post('mont_ttc_remise'), post('taux'), post('taux_prix'), post('tva'), post('monnaie'), post('remise'), post('majoration'), post('justification'), post('id_res'), post('res_ch_id'), post('modulecompagny'), post('id_hotel'), post('company_id'), post('id_user'), post('id_client'), post('fact1'), post('id_fact'));
                    json_send('' . H_ADMIN . '&view=t_facture&id_fact=' . post('id_fact') . '&do=details&msg=update');
                    json_success('Process Completed');
                }
            }
        }

        //DETAILS //////////////////////////////////////////////
        elseif (get('do') == 'details') {
            $idsite = $_SESSION['idsite'];
            $id_fact = get('id_fact');
            $modepaie = get('mode');

            if (isset($_GET['msg'])) {
                $msg = 1;
            } else {
                $msg = 0;
            }

            $rows = $this->t_facture_model->SelectOne($id_fact);

            $nomcl = $rows->nom_client;
            $societe = $rows->designation;
            $emailcl = $rows->email_client;
            $tel = $rows->telephone_client;
            $adr = $rows->adresse_provenance_client;
            $numfact = $rows->num_fact;
            $mode = $rows->mode;
            $dte_edit = dateAffiche($rows->date_edition);
            $dte_hr_fac = $rows->datsyn;
            $etatfact = $rows->etat;
            $annul = $rows->etat_cmd;
            if ($etatfact == '1') {
                $typefact = 'normale';
            } else {
                $typefact = 'proforma';
            }
            $dte_ech = dateAffiche($rows->date_echeance);
            $justification = $rows->justification;
            $ht = $rows->montant_total;
            $monttvax = $rows->mont_tva;
            $ttc = $rows->mont_ttc_remise;
            $remise = $rows->remise;
            $montremise = $rows->mont_ttc;
            $monnaie_fact = $rows->monnaie;
            $taux = getTauxFacture2($monnaie_fact, $_SESSION['Paie_taux'], $rows->taux);
            $ht = montant_equivalent_bdd($monnaie_fact, $_SESSION['Paie_affiche'], $taux, $ht);
            $monttvax = montant_equivalent_bdd($monnaie_fact, $_SESSION['Paie_affiche'], $taux, $monttvax);
            $ttc = montant_equivalent_bdd($monnaie_fact, $_SESSION['Paie_affiche'], $taux, $ttc);
            $montremise = montant_equivalent_bdd($monnaie_fact, $_SESSION['Paie_affiche'], $taux, $montremise);
            $panier->initialiser();
            $site = $siteobj->Infos2($idsite);
            $logo = $site->logo;
            $mail = $site->mail;
            $phone = $site->phone;
            $adrcomp = $site->adrcomp;
            $nomcomp = $site->nomcomp;
            $idnat = $site->idnat;
            $rccm = $site->rccm;
            $result = $this->t_facture_model->lignesAllBySite($id_fact);
            $bdd = HDB::hus();
            $dataliv= getQteLivreProduit($id_fact, $bdd);
            foreach ($result as $rows) {
                $select['id'] = $rows->produit_id;
                $qte2=$dataliv['qtereste'][$rows->produit_id];
                $select['qte'] = $rows->qte;
                $select['nom'] = $rows->designation;
                $select['prix'] = $rows->prix;
                $select['monttva'] = $rows->mont_tva;
                $select['repas']=$qte2;
                $panier->ajouterFact($select);
            }
            $nbArticles = count($_SESSION['panier']['id_article']);


            $dte = date('Y-m-d');
            $sql = "SELECT a.id_fact,a.num_fact,b.id_regl,b.numero,b.dte,c.montant,c.montantusd,c.montantcdf,c.taux,d.id_mode_regl,d.lib,e.id_client,e.nom_client
         FROM t_facture AS a, t_reglement AS b, paiement AS c,t_mode_reglement AS d, t_client AS e
         WHERE  a.id_fact=b.id_fact
               AND b.id_regl=c.regl_id
               AND c.id_mode_regl=d.id_mode_regl
               AND e.id_client=a.id_client
               AND a.type='facturation'
              AND a.id_fact=:id_fact
               AND a.id_hotel=:id_hotel
               ORDER BY e.nom_client,a.num_fact,b.numero ASC";
            $requete = HDB::hus()->prepare($sql);
            $requete->BindParam(':id_fact', $id_fact);
            $requete->BindParam(':id_hotel', $_SESSION['idsite']);
            $requete->execute();
            $resultpaie = $requete->fetchAll(PDO::FETCH_OBJ);
            $cash1 = 0;
            $credit1 = 0;
            $acompte1 = 0;
            foreach ($resultpaie as $rows) {
                $montant = montant_equivalent_bdd(getsymbole_local(), $_SESSION['Paie_affiche'], $rows->taux, $rows->montant);
                if ($rows->lib == 'Cash') {
                    $cash1 += $montant;
                } else if ($rows->lib == 'Credit') {
                    $credit1 += $montant;
                } else {
                    $acompte1 += $montant;
                }
            }
            $mont_paie = arrondir($cash1 + $credit1 + $acompte1); 
            $bdd = HDB::hus();
            $mont_paie2 =GetTotalPayeFacture($id_fact,$bdd);
            $solde=$ttc-$mont_paie2;

            //Liste des livraisons
            $dataliv= getQteLivreProduit($id_fact,$bdd);

            include(APP_FOLDER . '/views/admin/t_facture/Details.php');
        }elseif (get('do') == 'fichelivraison') {
           $id_fact= get('id_fact');
           $rows = $this->t_facture_model->SelectOne($id_fact);

           $nomcl = $rows->nom_client;
           $numfact = $rows->num_fact;
           $dte_edit = dateAffiche($rows->date_edition);
           $mode = $rows->mode;
           $bdd = HDB::hus();
           $bons= getListBons($id_fact, $bdd);
          
           include(APP_FOLDER . '/views/admin/t_facture/Fiche_livraison.php');
        }elseif (get('do') == 'deletebonlivraison') {
            $bdd = HDB::hus();
            $id_fact= get('id_fact');
            $bon_id=get('bon_id');
            //Delete bon livraison
            bonLivraisonDelete($bon_id, $bdd);
            $bons= getListBons($id_fact, $bdd);
           
            include(APP_FOLDER . '/views/admin/t_facture/fichelivraisondata.php');
         }
        //TRUNCATE ///////////////////////////////////////////////
        elseif (get('do') == 'truncate') {
            $this->t_facture_model->TruncateTable('' . H_ADMIN . '&view=t_facture&do=viewall&msg=truncate');
            include(APP_FOLDER . '/views/admin/t_facture/View.php');
        }

        //DELETE /////////////////////////////////////////////////
        elseif (get('do') == 'delete') {
            $bdd = HDB::hus();
            $hotel_id = $_SESSION['idsite'];
            $id_fact = get('id_fact');
            AnnulFacture($id_fact, $bdd);
            //COMPTA
            $module_id = 23;
            ConfLinkMod($module_id, $hotel_id, $bdd);
            if ($_SESSION['ConfLinkMod_lie'] == 1) {
                $type = "";
                $facture = InfosCommmande($id_fact, $type, $bdd);
                $nom_client = $facture->nom_client;
                $num_fact = $facture->num_fact;
                $id_client = $facture->id_client;
                $type_client = $facture->typecl;
                $compte1 = $facture->compte1;
                $compte2 = $facture->compte2;
                $mont_ttc = $facture->mont_ttc;
                $num_fact = $facture->num_fact;
                $taux_fact = $facture->taux;
                $monnaie_fact = $facture->monnaie;
                $libmodefact = $facture->mode;
                if (empty($nom_client)) {
                    $nom_client = $facture->designation;
                }
                $tva = $facture->tva;
                $ttc = $facture->mont_ttc;
                $mont_tva = ($ttc * $tva) / 100;
                $ht = $ttc - $mont_tva;
                $account = $compte1 . $compte2;
                CreateAcountForCustomer($compte1, $compte2, $account, $nom_client, $hotel_id, $bdd);
                $reference = $num_fact;
                $tauxop = $taux_fact;
                $libelle = "";
                $beneficiaire = $nom_client;
                $user_id = $_SESSION['id_user'];
                $devise = $monnaie_fact;
                $dte = date('Y-m-d');
                $dtetime = date('Y-m-d H:i:s');
                COMPTA_ANNULATION_FAC_RESTO($id_fact, $libmodefact, $reference, $dte, $dtetime, $ht, $tva, $ttc, $devise, $tauxop, $libelle, $beneficiaire, $hotel_id, $user_id, $bdd);
            }

            //COMPTA

            send_to('' . H_ADMIN . '&view=t_facture&id_fact=' . get('id_fact') . '&do=details');
        } elseif (get('do') == 'exonerertva') {
            $panier->Exonerer_tva();
            $nbArticles = count($_SESSION['panier']['id_article']);
            include(APP_FOLDER . '/views/admin/t_facture/lignesfact.php');
        } elseif (get('do') == 'appliktva') {
            $panier->Appliquer_tva();
            $nbArticles = count($_SESSION['panier']['id_article']);
            include(APP_FOLDER . '/views/admin/t_facture/lignesfact.php');
        } elseif (get('do') == 'sendmail') {
            include './libraries/mpdf60/mpdf.php';
            include './libraries/PHPMailer/class.phpmailer.php';
            $idsite = $_SESSION['idsite'];
            $id_fact = get('id_fact');
            $rows = $this->t_facture_model->SelectOne($id_fact);
            $nomcl = $rows->nom_client;
            $societe = $rows->designation;
            $emailcl = $rows->email_client;
            $tel = $rows->telephone_client;
            $adr = $rows->adresse_provenance_client;
            $numfact = $rows->num_fact;
            $dte_edit = dateAffiche($rows->date_edition);
            $etatfact = $rows->etat;
            if ($etatfact == '1') {
                $typefact = 'normale';
            } else {
                $typefact = 'proforma';
            }

            $dte_ech = dateAffiche($rows->date_echeance);
            $justification = $rows->justification;
            $ht = $rows->montant_total;
            $monttvax = $rows->mont_tva;
            $ttc = $rows->mont_ttc_remise;
            $monnaie_fact = $rows->monnaie;
            //$taux=getTauxFacture2($monnaie_fact,$_SESSION['Paie_taux'],$rows->taux);
            $taux = 1600;
            $ht = montant_equivalent_bdd($monnaie_fact, $_SESSION['Paie_affiche'], $taux, $ht);
            $monttvax = montant_equivalent_bdd($monnaie_fact, $_SESSION['Paie_affiche'], $taux, $monttvax);
            $ttc = montant_equivalent_bdd($monnaie_fact, $_SESSION['Paie_affiche'], $taux, $ttc);
            $panier->initialiser();
            $site = $siteobj->Infos2($idsite);
            $logo = $site->logo;
            $mail = $site->mail;
            $phone = $site->phone;
            $adrcomp = $site->adrcomp;
            $nomcomp = $site->nomcomp;
            $idnat = $site->idnat;
            $rccm = $site->rccm;
            $result = $this->t_facture_model->lignesAllBySite($id_fact);
            foreach ($result as $rows) {
                $select['id'] = $rows->produit_id;
                $select['qte'] = $rows->qte;
                $select['nom'] = $rows->designation;
                $select['prix'] = $rows->prix;
                $select['monttva'] = $rows->mont_tva;
                $panier->ajouterFact($select);
            }
            $nbArticles = count($_SESSION['panier']['id_article']);
            include(APP_FOLDER . '/views/admin/impression/facturation_fact.php');
            $body = ob_get_clean();
            $body = iconv("UTF-8", "UTF-8//IGNORE", $body);
            $mpdf = new mPDF('c', 'A4', '', '', 7, 7, 8, 5, 0, 0);
            $mpdf->SetDisplayMode('fullpage');
            $mpdf->WriteHTML($body);
            $fichier = $mpdf->Output("Facture.pdf", "S");
            $mailobj = new PHPMailer();
            $bool = EmailSendFichier($_SESSION['nomexp'], $_SESSION['mailexp'], $nomcl, $emailcl, $_SESSION['sujetmail'], $_SESSION['msgmail'], $fichier, $mailobj);
            if ($bool) {
                $json['message'] = "Cette facture vient d'être envoyée avec succès!";
                //echo'ok';
            } else {
                $json['message'] = "Cette facture n'est pas envoyée!";
                //echo'no';
            }
            $json['s'] = TRUE;
            echo json_encode($json);
        } elseif (get('do') == 'ProcGenAccount') {
            $bdd = HDB::hus();
            $libelle = 'compteclient';
            $numberincre = getnumerotation($_SESSION['id_hotel'], $libelle, $bdd);
            $accountnumber = str_pad($numberincre, 4, "0", STR_PAD_LEFT);
            $_SESSION['numberincreaccountnumber'] = $numberincre;
            $_SESSION['accountnumber'] = $accountnumber;
            echo $accountnumber;
        }
    }

    //end invoke
}

//end class
?>
	