<?php
    session_start();
    //Fusion horaire
    date_default_timezone_set('Africa/Kinshasa');
    include('../bdd/connexion.php');
    include '../FUNCTION/stock.php';
?>
<!DOCTYPE html>
<html lang="fr">

    <?php
    include('head.php');
    ?>

    <body>
        <div id="wrapper">
            <!-- Navigation -->
            <nav class="navbar navbar-default navbar-static-top" role="navigation" style="margin-bottom: 0">
                <div class="navbar-header">
                    <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
                        <span class="sr-only">Toggle navigation</span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                    </button>
                    <a class="navbar-brand" href="index.php"><img src="images/logoKB1.png"/></a>
                </div>
                <!-- /.navbar-header -->

                <?php include('navigation.php'); ?> 
                <?php include('menu.php'); ?>
                <?php 
                $fiche_id=$_GET['fiche_id'];
                $fiche_num=$_GET['fiche_num'];
                $fiche_dte=$_GET['fiche_dte'];
                $user=$_GET['user'];
                $beneficiere=$_GET['beneficiere'];
                $emplacement=$_GET['emplacement'];
                $requete = $bdd->prepare("SELECT  * FROM stk_produit AS prod, stk__mouvement AS m,t_motif_sortie AS s WHERE prod.idprod=m.produit_id AND m.motif_sortie_id=s.id_motif_sortie AND m.type='sortie' AND m.fiche_id=:fiche_id ORDER BY prod.designation ASC");
                $requete->BindParam(':fiche_id', $fiche_id);
                $requete->execute();
                $mouvements = $requete->fetchAll(PDO::FETCH_OBJ);
                ?>
            </nav>
            <!-- /.navbar-top-links -->

            <div id="page-wrapper">
                <div class="row">
                    <div class="col-lg-12">
                        <h3 class="page-header">Sortie / transfert</h3>
                    </div>
                    <!-- /.col-lg-12 -->
                </div>
                <!-- /.row -->
                <div class="row">
                    <div class="col-lg-12">
                        <div id="msg_grp" class="alert alert-danger alert-dismissable" style="display:none;">
                            <!--<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>-->
                            <span id="msg_alert_grp">L'enrégistrement s'est effectué avec succès!</span>
                        </div>
                        <div class="panel panel-default">
                            <div class="panel-heading">
                                <h4>
                                Détails
                                <div class="btn-group  btn-group-sm pull-right">
                                    <a href="approvisionnement_view.php?operation=sortie" class="btn btn-danger" title="Liste"><i class="fa fa-bars"></i> Liste</a>
                                    <a href="impression/bon_sortie.php" target="_blank" class="btn btn-primary btn-sm" title="Imprimer bon"><i class="fa fa-print"></i> Imprimer</a>
                                </div>
                                <div class="pull-right">
                                    
                                </div>
                                </h4>
                            </div>
                            <!-- /.panel-heading -->
                            <div class="panel-body">
                                <!-- title row -->
                                <div class="row">
                                  <div class="col-xs-12">
                                    <h3 class="page-header">
                                      <i class="fa fa-file-text"></i> Bon de sortie n°: <?php echo $fiche_num; ?>
                                      <small class="pull-right">Date: <?php echo $fiche_dte; ?></small>
                                    </h3>
                                  </div>
                                  <!-- /.col -->
                                </div>
                                <!-- info row -->
                                <div class="row invoice-info">
                                  <div class="col-sm-4 invoice-col">
                                    Béneficière :
                                    <address>
                                      <strong><?php echo $beneficiere?></strong><br>
                                    </address>
                                  </div>
                                  <!-- /.col -->
                                  <div class="col-sm-4 invoice-col">
                                    Utilisateur :
                                    <address>
                                      <strong><?php echo $user?></strong><br>
                                    </address>
                                  </div>
                                  <div class="col-sm-4 invoice-col">
                                    Emplacement :
                                    <address>
                                      <strong><?php echo $emplacement?></strong><br>
                                    </address>
                                  </div>
                                  <!-- /.col -->
                                </div>
                                <!-- /.row -->
                                <!-- Table row -->
                                <div class="row">
                                  <div class="col-xs-12 table-responsive">
                                    <table class="table table-striped">
                                      <thead>
                                      <tr>
                                        <th>N°</th>
                                        <th>Product</th>
                                        <th>Quantité</th>
                                        <th>Unité</th>
                                        <th>Motif</th>
                                      </tr>
                                      </thead>
                                      <tbody>
                                          <?php
                                              //Mise en session pour impression
                                                $_SESSION['fiche'] = array();
                                                $_SESSION['fiche']['produit_id'] = array();
                                                $_SESSION['fiche']['designation'] = array();
                                                $_SESSION['fiche']['qte_env'] = array();
                                                $_SESSION['fiche']['qte_recue'] = array();
                                                $_SESSION['fiche']['ecart'] = array();
                                                $_SESSION['fiche']['unite'] = array();
                                                $_SESSION['fiche']['obs'] = array();

                                               //Fin mise en session
                                             $i=1;
                                             $benef="";
                                             $statut=1;
                                             sessionInfoBon($fiche_num, $fiche_dte,$user, $beneficiere, $statut);
                                             $_SESSION['DepotSource']=$emplacement;
                                             foreach($mouvements as $so):
                                               $qte=0;
                                               $motif="";
                                                if($so->qte_sortie>0){

                                                $qte=$so->qte_sortie;
                                                $motif=$so->libelle;

                                                }elseif($so->qte_declasse>0){

                                                $qte=$so->qte_declasse;
                                                $motif="Perte";

                                                }elseif($so->qte_avarie>0){

                                                $qte=$so->qte_avarie;
                                                $motif="Avarie/Expire";

                                                  
                                                }elseif($so->qte_casse>0){
                                                
                                                $qte=$so->qte_casse;
                                                $motif="Casse";

                                                
                                                }elseif($so->qte_regul>0){

                                                  $qte=$so->qte_regul;
                                                  $motif="Regularisation";

                                                }
                                                
                                                
                                                 //Mise en session pour impression
                                               sessionDetailsBon($so->produit_id, $so->designation,$qte,0, 0, $so->unite,$motif);
                                                //Fin mise en session
                                                
                                                ?>
                                                <tr class="odd gradeX">
                                                    <td><?php echo $i ?></td>
                                                    <td><?php echo $so->designation?></td>
                                                    <td>
                                                        <?php echo $qte; ?>
                                                    </td>
                                                    <td><?php echo $so->unite?></td>
                                                    <td><?php echo $motif?></td>

                                                </tr>
                                                <?php 
                                                 $i++;
                                                 endforeach;
                                                 ?>
                                      </tbody>
                                    </table>
                                  </div>
                                  <!-- /.col -->
                                </div>
                                <!-- /.row -->
                                <br>
                            </div>
                            <!-- /.panel-body -->
                        </div>
                        <!-- /.panel -->
                    </div>
                    <!-- /.col-lg-12 -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /#page-wrapper -->

        </div>
        <!-- /#wrapper -->
        <!-- /.modal -->
        <?php include('footer.php'); ?>

    </body>

</html>
