<?php
ini_set('max_execution_time', 300); //300 seconds = 5 minutes
ini_set('memory_limit', '1024M');
ini_set("pcre.backtrack_limit", "5000000");
require_once '../../vendor/autoload.php';
include '../bdd/connexion.php';
include_once '../../FUNCTION/hebergement.php';
include_once '../../FUNCTION/stock.php';
session_start();
$company_id = $_SESSION['company_id'];
$depot_id = $_SESSION['depot_id'];
$deps = [0, 121];

// requette pour la selection infos site
$requete_idhotel = $bdd->prepare("SELECT * FROM  t_hotel WHERE id_hotel=:id_hotel");
$requete_idhotel->BindParam(':id_hotel', $_SESSION['id_hotel']);
$requete_idhotel->execute();
while ($donnees = $requete_idhotel->fetch()) {
    $province_hotel = $donnees['province_hotel'];
    $ville_hotel = $donnees['ville_hotel'];
    $nom_c = @$donnees['nom_hotel '];
    $adresse_c = $donnees['adresse_hotel'];
    $ville = $donnees['ville_hotel'];
    $logo = $donnees['image'];
    $idnat = $donnees['idnat'];
    $rccm = $donnees['rccm'];
    $num_impot = $donnees['num_impot'];
    $telephone = $donnees['phone'];
    $email_compagny = $donnees['mail'];
    $compte_bancaire = $donnees['cb'];
}
/* Fin de la Recuperation des coordonnées de l'sites */
ob_start();
?>
<style>
    * {
        margin: 0;
        padding: 0;
        font-family: helvetica;
        font-size: 10pt;
        color: #000;
    }

    #titre {
        margin-bottom: 5px;
    }

    #table {
        width: 100%;
        border-left: 0.5px solid #000;
        border-top: 0.5px solid #000;
        border-spacing: 0;
        border-collapse: collapse;
        font-family: helvetica;

    }

    #table th {
        background: #eee;
        border: 0.5px solid #000;
        height: 10px;
        padding: 1mm;
        text-transform: uppercase;
        /*font-weight:bold;*/
    }

    #table td {
        border-right: 0.5px solid #000;
        border-bottom: 0.5px solid #000;
        padding: 1mm;
    }

    .page {
        height: 297mm;
        width: 210mm;
        page-break-after: always;
    }

    #entete {
        text-align: center;
        text-transform: uppercase;
        padding-top: 35px;
        padding-bottom: 15px;
        font-family: helvetica;
    }

    #entete1 {
        margin-top: 55px;
        margin-right: 70px;
    }
</style>
<div id="content">
    <div id="entete1" align="right">
        <span>Kinshasa, </span><?php echo 'le ' . date('d/m/Y'); ?>
    </div>
    <div id="entete">
        <h3><u>FICHE DE STOCK<?php echo ' DU ' . dateAffiche($_SESSION['fiche_dte1']) . ' AU ' . dateAffiche($_SESSION['fiche_dte2']); ?></u></h3><br>
        <span>(Depot:<?php echo $_SESSION['libelle_depot'] ?>)</span>
    </div>
    <table width="444" border="1" align="center" id="table">
        <thead>
            <tr>
                <th>N°</th>
                <th>DESIGNATION</th>
                <th>I</th>
                <th>ENTREE</th>
                <th>SORTIE</th>
                <th>PERTE</th>
                <th>AVARIE</th>
                <th>CASSE</th>
                <th>REGULARISATION</th>
                <th>SOLDE</th>
                <th>PAU</th>
                <?php if (!in_array($depot_id, $deps)) { ?>
                    <th>PVU</th>
                <?php } ?>
                <th>V. ACHAT</th>
                <?php if (!in_array($depot_id, $deps)) { ?>
                    <th>V. VENTE</th>
                    <th>MARGE</th>
                <?php } ?>
            </tr>
        </thead>
        <tbody>
            <?php
            $i = 1;
            $tva = 0;
            $tvv = 0;
            $tmarge = 0;
            foreach ($_SESSION['articles'] as $art) {
                $q0 = 0;
                $qin = 0;
                $qout = 0;
                $qte_perte = 0;
                $qte_avarie = 0;
                $qte_casse = 0;
                $qte_regul = 0;
                $qsolde = 0;
                $idprod = $art->idprod;
                $des = $art->produit;
                if (isset($_SESSION['fs']['q0'][$idprod])) {
                    $q0 = $_SESSION['fs']['q0'][$idprod];
                } else {
                    $_SESSION['fs']['q0'][$idprod] = $q0;
                }
                if (isset($_SESSION['fs']['qin'][$idprod])) {
                    $qin = $_SESSION['fs']['qin'][$idprod];
                } else {
                    $_SESSION['fs']['qin'][$idprod] = $qin;
                }
                if (isset($_SESSION['fs']['qout'][$idprod])) {
                    $qout = $_SESSION['fs']['qout'][$idprod];
                } else {
                    $_SESSION['fs']['qout'][$idprod] = $qout;
                }


                if (isset($_SESSION['fs']['qperte'][$idprod])) {
                    $qte_perte = $_SESSION['fs']['qperte'][$idprod];
                } else {
                    $_SESSION['fs']['qperte'][$idprod] = $qte_perte;
                }

                if (isset($_SESSION['fs']['qavarie'][$idprod])) {
                    $qte_avarie = $_SESSION['fs']['qavarie'][$idprod];
                } else {
                    $_SESSION['fs']['qavarie'][$idprod] = $qte_avarie;
                }
                if (isset($_SESSION['fs']['qcasse'][$idprod])) {
                    $qte_casse = $_SESSION['fs']['qcasse'][$idprod];
                } else {
                    $_SESSION['fs']['qcasse'][$idprod] = $qte_casse;
                }
                if (isset($_SESSION['fs']['qregul'][$idprod])) {
                    $qte_regul = $_SESSION['fs']['qregul'][$idprod];
                } else {
                    $_SESSION['fs']['qregul'][$idprod] = $qte_regul;
                }



                $qsolde = ($q0 + $qin) - ($qout + $qte_perte+$qte_avarie+$qte_casse+$qte_regul);
                $pa = @$_SESSION['fs']['pa'][$idprod];
                $pv = @$_SESSION['fs']['pv'][$idprod];
                $va = @$_SESSION['fs']['va'][$idprod];
                $vv = @$_SESSION['fs']['vv'][$idprod];
                $marge = @$_SESSION['fs']['m'][$idprod];
            ?>
                <tr class="odd gradeX">
                    <td><?php echo $i ?></td>
                    <td><?php echo $des ?></td>
                    <td><?php echo round($q0, 2) ?></td>
                    <td><?php echo round($qin, 2) ?></td>
                    <td><?php echo round($qout, 2) ?></td>

                    <td><?php echo round($qte_perte, 2) ?></td>
                    <td><?php echo round($qte_avarie, 2) ?></td>
                    <td><?php echo round($qte_casse, 2) ?></td>
                    <td><?php echo round($qte_regul, 2) ?></td>


                    <td><?php echo round($qsolde, 2) ?></td>
                    <td><?php echo afficheMontantstk2('', $pa) ?></td>
                    <?php if (!in_array($depot_id, $deps)) { ?>
                        <td><?php echo afficheMontantstk2('', $pv) ?></td>
                    <?php } ?>
                    <td><?php echo  afficheMontantstk2('', $va) ?></td>
                    <?php if (!in_array($depot_id, $deps)) { ?>
                        <td><?php echo afficheMontantstk2('', $vv) ?></td>
                        <td><?php echo afficheMontantstk2('', $marge) ?></td>
                    <?php } ?>
                </tr>
            <?php
                $i++;
                $tva += $va;
                $tvv += $vv;
                $tmarge += $marge;
            };
            ?>
        </tbody>
        <tfoot>
            <tr>
                <?php if (!in_array($depot_id, $deps)) { ?>
                    <th colspan='9'>TOTAL(USD)</th>
                <?php } else { ?>
                    <th colspan='8'>TOTAL(USD)</th>
                <?php } ?>
                <th><?php echo afficheMontantstk2('', $tva) ?></th>
                <?php if (!in_array($depot_id, $deps)) { ?>
                    <th><?php echo  afficheMontantstk2('', $tvv) ?></th>
                    <th><?php echo  afficheMontantstk2('', $tmarge) ?></th>
            </tr>
        <?php } ?>
        </tfoot>
    </table>
</div>


<?php

$body = ob_get_clean();
$body = iconv("UTF-8", "UTF-8//IGNORE", $body);
//Entete et pied de page
include './entete_pied_page.php';
$mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
$mpdf->SetDisplayMode('fullpage');
$mpdf->SetHTMLHeader($header);
$mpdf->SetHTMLFooter($footer);
$mpdf->WriteHTML($body);
$mpdf->Output("Fiche de stock.pdf", "I");
