<?php
// Initialisation de la session
session_start();
include('../../../../bdd/connexion.php');
$months = array(
    '',
    'January',
    'February',
    'March',
    'April',
    'May',
    'June',
    'July ',
    'August',
    'September',
    'October',
    'November',
    'December',
);

$data = array();
$data['indiceMoisEncours'] = array();
$data['indiceMoisPrec'] = array();
$data['mois'] = array();
$data['encours'] = array();
$data['totMoisEncours'] = 0;
$data['totMoisPrec'] = 0;
$data['prec'] = array();
$anneEncours = date("Y");
$anneprec = date("Y", strtotime("-1 year"));
$numMois = date('n');

//Annnee en cours
$requete = $bdd->prepare("SELECT YEAR(a.dte) AS annee,MONTH(a.dte) AS nummois ,MONTHNAME(a.dte) AS mois,SUM(a.montant/b.taux) AS ca
FROM factchambre a,t_facture AS b
WHERE a.site_id=:hotel_id
AND a.facture_id=b.id_fact 
AND b.etat_cmd=0
AND b.chiffre_aff =1
AND YEAR(a.dte)=YEAR(CURRENT_DATE())
GROUP BY annee,mois");
$requete->BindParam(':hotel_id', $_SESSION['id_hotel']);
$requete->execute();
$result = $requete->fetchAll(PDO::FETCH_OBJ);
foreach ($result as $r) {
    $mont = round($r->ca, 2);
    $mois = $r->mois;
    $nummois = $r->nummois;

    $diffMonth = (int)$nummois - 1;
    $libMonth = $months[$diffMonth];

    if (!in_array($diffMonth, $data['indiceMoisEncours']) && $diffMonth > 0) {
        array_push($data['mois'], $libMonth);
        array_push($data['encours'], 0);
    }
    array_push($data['mois'], $months[$nummois]);
    array_push($data['encours'], $mont);
    if ($numMois == $r->nummois) {
        $data['totMoisEncours'] = $mont;
    } elseif ($numMois - 1 == $r->nummois) {
        $data['totMoisPrec'] = $mont;
    }
    array_push($data['indiceMoisEncours'], $nummois);
}


//Annnee precedente

$requete = $bdd->prepare("SELECT YEAR(a.dte) AS annee,MONTH(a.dte) AS nummois ,MONTHNAME(a.dte) AS mois,SUM(a.montant/b.taux) AS ca
FROM factchambre a,t_facture AS b
WHERE a.site_id=:hotel_id
AND a.facture_id=b.id_fact 
AND b.etat_cmd=0
AND YEAR(a.dte)=YEAR(CURRENT_DATE())-1
GROUP BY annee,mois");
$requete->BindParam(':hotel_id', $_SESSION['id_hotel']);
$requete->execute();
$result = $requete->fetchAll(PDO::FETCH_OBJ);
if (count($result) == 0) {
    $nbre = count($months);
    for ($i = 1; $i <= 12; $i++) {
        array_push($data['prec'], 0);
    }
} else {

    foreach ($result as $r) {
        $mont = round($r->ca, 2);
        $mois = $r->mois;
        $nummois = $r->nummois;

        $diffMonth = (int)$nummois - 1;
        $libMonth = $months[$diffMonth];

        if (!in_array($diffMonth, $data['indiceMoisPrec']) && $diffMonth > 0) {
            array_push($data['prec'], 0);
        }
        array_push($data['prec'], $mont);

        $data['totMoisPrec'] += $mont;
        array_push($data['indiceMoisPrec'], $nummois);
    }
}

echo json_encode($data);
