<?php
// Initialisation de la session
session_start();
include('../../../../bdd/connexion.php');
$data = array();
$data['mois'] = array();
$data['encours'] = array();
$data['totMoisEncours'] = 0;
$data['totMoisPrec'] = 0;
$data['prec'] = array();
$data['totCouvertMoisPrec'] = 0;
$data['totCouvertMoisEncours'] = 0;
$data['couvertencours'] = array();
$data['couvertprec'] = array();
$data['message'] = 'reseration ok';
$data['test'] = array();
$anneEncours = date("Y");
$anneprec = date("Y", strtotime("-1 year"));
$numMois = date('n');

$requete = $bdd->prepare("SELECT MONTH(a.date_edition) AS nummois,MONTHNAME(a.date_edition) AS mois,a.taux_prix,a.monnaie,a.mode,a.mont_ttc_remise,c.idprod,c.code, c.designation,c.repas,c.nourriture,
SUM(b.qte) AS qte, b.prix AS pu, b.dte_h,a.mode AS lib,SUM((b.qte*(b.prix-(b.prix*a.mont_ttc_remise/100)))/a.taux_prix) AS mont2,SUM(b.qte*b.prix)/a.taux_prix AS mont,
SUM(b.qteoffert) AS qteoffert,SUM(b.qteoffert*b.prix2) AS montof
FROM lignes_commandes AS b, stk_produit AS c, t_facture AS a
WHERE b.produit_id= c.idprod AND a.id_fact=b.commande_id 
AND a.id_hotel  =:hotel_id 
AND a.etat_cmd=0 
AND a.type='restaurant'
AND a.mode IN ('Cash','Credit')
AND YEAR(a.date_edition)=:annee
GROUP BY MONTH(a.date_edition)");
$requete->BindParam(':hotel_id', $_SESSION['id_hotel']);
$requete->BindParam(':annee', $anneEncours);
$requete->execute();
$result = $requete->fetchAll(PDO::FETCH_OBJ);
$data['test'] = $result;

foreach ($result as $r) {
    $mont = round($r->mont, 2);
    array_push($data['mois'], $r->mois);
    array_push($data['encours'], $mont);

    if ($numMois == $r->nummois) {
        $data['totMoisEncours'] = $mont;
    } elseif ($numMois - 1 == $r->nummois) {
        $data['totMoisPrec'] = $mont;
    }
}

// Data vente annee precedente
$requete = $bdd->prepare("SELECT MONTH(a.date_edition) AS nummois,MONTHNAME(a.date_edition) AS mois,a.taux_prix,a.monnaie,a.mode,a.mont_ttc_remise,c.idprod,c.code, c.designation,c.repas,c.nourriture,
SUM(b.qte) AS qte, b.prix AS pu, b.dte_h,a.mode AS lib,SUM((b.qte*(b.prix-(b.prix*a.mont_ttc_remise/100)))/a.taux_prix) AS mont2,SUM(b.qte*b.prix)/a.taux_prix AS mont,
SUM(b.qteoffert) AS qteoffert,SUM(b.qteoffert*b.prix2) AS montof
FROM lignes_commandes AS b, stk_produit AS c, t_facture AS a
WHERE b.produit_id= c.idprod AND a.id_fact=b.commande_id 
AND a.id_hotel  =:hotel_id 
AND a.etat_cmd  =0 
AND a.type='restaurant'
AND a.mode IN ('Cash','Credit')
AND YEAR(a.date_edition)=:annee
GROUP BY MONTH(a.date_edition)");
$requete->BindParam(':hotel_id', $_SESSION['id_hotel']);
$requete->BindParam(':annee', $anneprec);

$requete->execute();
$result = $requete->fetchAll(PDO::FETCH_OBJ);

$dx = array();
foreach ($result as $r) {
    $mont = round($r->mont, 2);
    $dx[$r->mois] = $mont;
}

$nbre = count($data['mois']);
for ($i = 0; $i <= $nbre - 1; $i++) {
    $mois = $data['mois'][$i];
    if (isset($dx[$mois])) {
        array_push($data['prec'], $data['mois']);
    } else {
        array_push($data['prec'], 0);
    }
}

//Nombre des couverts annee en cours
$requete = $bdd->prepare("SELECT MONTH(a.date_edition) AS nummois, MONTHNAME(a.date_edition) AS mois,
                        SUM(a.nbrcouvert) AS nbrcouvert
                        FROM  t_facture AS a
                        WHERE a.id_hotel=:hotel_id
                        AND a.etat_cmd  =0 
                        AND a.mode IS NOT NULL
                        AND YEAR(a.date_edition)=:annee
                        GROUP BY MONTH(a.date_edition)
                        ORDER BY a.date_edition");
$requete->BindParam(':hotel_id', $_SESSION['id_hotel']);
$requete->BindParam(':annee', $anneEncours);
$requete->execute();
$result = $requete->fetchAll(PDO::FETCH_OBJ);

$couvertEncours = array();
foreach ($result as $r) {
    $couvertEncours[$r->mois] = $r->nbrcouvert;
}
for ($i = 0; $i <= $nbre - 1; $i++) {
    $mois = $data['mois'][$i];
    if (isset($couvertEncours[$mois])) {
        array_push($data['couvertencours'], $couvertEncours[$mois]);
        $data['totCouvertMoisEncours'] = $couvertEncours[$mois];
    } else {
        array_push($data['couvertencours'], 0);
    }

    if ($numMois - 1 == $r->nummois) {
        $data['totCouvertMoisPrec'] += $couvertEncours[$mois];
    }
}
//Nombre des couverts annee precedente
$requete = $bdd->prepare("SELECT MONTH(a.date_edition) AS nummois, MONTHNAME(a.date_edition) AS mois,
                        SUM(a.nbrcouvert) AS nbrcouvert
                        FROM  t_facture AS a
                        WHERE a.id_hotel=:hotel_id
                        AND a.mode IS NOT NULL
                        AND a.etat_cmd  =0 
                        AND YEAR(a.date_edition)=:annee
                        GROUP BY MONTH(a.date_edition)
                        ORDER BY a.date_edition");
$requete->BindParam(':hotel_id', $_SESSION['id_hotel']);
$requete->BindParam(':annee', $anneprec);
$requete->execute();
$result = $requete->fetchAll(PDO::FETCH_OBJ);

$couvertPrec = array();
foreach ($result as $r) {
    $couvertPrec[$r->mois] = $r->nbrcouvert;
}

for ($i = 0; $i <= $nbre - 1; $i++) {
    $mois = $data['mois'][$i];
    if (isset($couvertPrec[$mois])) {
        array_push($data['couvertprec'], $couvertPrec[$mois]);
    } else {
        array_push($data['couvertprec'], 0);
    }
}
echo json_encode($data);
