<?php
// Initialisation de la session
?>

<div class="container-fluid">
    <div class="row">

        <div class="col-12 col-sm-6 col-md-3">
            <div class="info-box mb-3">
                <span class="info-box-icon bg-info elevation-1">
                    <i class="fas fa-dollar-sign"></i>
                </span>

                <div class="info-box-content">
                    <a href="#">
                        <span class="info-box-text text-dark">
                            Chiffre d'affaire du jour
                        </span>
                        <span class="info-box-number text-dark">
                            <?php echo afficheMontant($maffiche, $totChiffreAffaireheb); ?>
                        </span>
                    </a>
                </div>
                <!-- /.info-box-content -->
            </div>
            <!-- /.info-box -->
        </div>

        <!-- /.col -->
        <div class="col-12 col-sm-6 col-md-3">
            <div class="info-box mb-3">
                <span class="info-box-icon bg-danger elevation-1">
                    <i class="fas fa-chart-bar"></i>
                </span>

                <div class="info-box-content">
                    <a href="#">
                        <span class="info-box-text text-dark">Taux d'occupation(TO)</span>
                        <span class="info-box-number text-dark"><?php echo $txOccup; ?>%</span>
                    </a>
                </div>
                <!-- /.info-box-content -->
            </div>
            <!-- /.info-box -->
        </div>
        <!-- /.col -->
        <div class="col-12 col-sm-6 col-md-3">
            <div class="info-box mb-3">
                <span class="info-box-icon bg-success elevation-1">
                    <i class="fas fa-donate"></i>
                </span>

                <div class="info-box-content">
                    <a href="#">
                        <span class="info-box-text text-dark" data-toggle="tooltip" title="Prix Moyen Chambre">PMC</span>
                        <span class="info-box-number text-dark"><?php echo afficheMontant($maffiche, $pmc); ?></span>
                    </a>
                </div>
                <!-- /.info-box-content -->
            </div>
            <!-- /.info-box -->
        </div>
        <div class="col-12 col-sm-6 col-md-3">
            <div class="info-box mb-3">
                <span class="info-box-icon bg-warning elevation-1">
                    <i class="fas fa-tag"></i></span>

                <div class="info-box-content">
                    <a href="#">
                        <span class="info-box-text text-dark" data-toggle="tooltip" title="Revenu par chambre disponible">REVPAR</span>
                        <span class="info-box-number text-dark"><?php echo afficheMontant($maffiche, $revpar); ?></span>
                    </a>
                </div>
                <!-- /.info-box-content -->
            </div>
            <!-- /.info-box -->
        </div>
    </div>
    <!-- /.row -->
    <div class="row">
        <!-- /.col-md-6 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header border-0">
                    <div class="d-flex justify-content-between">
                        <h3 class="card-title">Chiffre d'affaire mensuelle</h3>
                    </div>
                </div>
                <div class="card-body">
                    <div class="d-flex">
                        <p class="d-flex flex-column">
                            <span class="text-bold text-lg" id='totMoisEncours'></span>
                        </p>
                        <p class="ml-auto d-flex flex-column text-right">
                            <span class="text-success">
                                <i class="fas fa-arrow-up"></i>
                                <span class="text-bold text-lg" id='totMoisPrec'></span>
                            </span>
                            <span class="text-muted">Mois précédent</span>
                        </p>
                    </div>
                    <!-- /.d-flex -->

                    <div class="position-relative mb-4">
                        <canvas id="sales-chart-heb" height="200"></canvas>
                    </div>

                    <div class="d-flex flex-row justify-content-end">
                        <span class="mr-2">
                            <i class="fas fa-square text-primary"></i> Cette année
                        </span>

                        <span>
                            <i class="fas fa-square text-gray"></i> Année précédente
                        </span>
                    </div>
                </div>
            </div>
            <!-- /.card -->

        </div>
        <!-- /.col-md-6 -->
        <div class="col-lg-6" style="display:none">
            <div class="card">
                <div class="card-header border-0">
                    <h3 class="card-title">TOP 5 chambres</h3>
                    <!--  <div class="card-tools">
                  <a href="#" class="btn btn-tool btn-sm">
                    <i class="fas fa-download"></i>
                  </a>
                  <a href="#" class="btn btn-tool btn-sm">
                    <i class="fas fa-bars"></i>
                  </a>
                </div> -->
                </div>
                <div class="card-body table-responsive p-0">
                    <table class="table table-striped table-valign-middle">
                        <thead>
                            <tr>
                                <th>Désignation</th>
                                <th>Montant</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($roomsTop as $r) { ?>
                                <tr>
                                    <td>
                                        <?php echo $r->num_ch; ?>
                                    </td>
                                    <td> <?php echo afficheMontant($maffiche, $r->montant); ?></td>
                                </tr>
                            <?php  } ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <!-- /.card -->


        </div>
    </div>
    <!-- /.row -->
</div>