﻿<?php
//post
function post1($var)
{
    if (isset($_POST[$var]))
        return $_POST[$var];
}

//get
function get1($var)
{
    if (isset($_GET[$var]))
        return $_GET[$var];
}
function infosPos($id, $default, $bdd)
{
    //    $default=0 signifie pos par defaut
    if ($default != 0) {
        $requete = $bdd->prepare("SELECT *FROM t_sousresto AS a WHERE a.id_sousresto=:id_sousresto");
        $requete->BindParam(':id_sousresto', $id);
    } else {
        $requete = $bdd->prepare("SELECT *FROM t_sousresto AS a WHERE a.hotel_id=:id_hotel AND a.etat=1 AND a.statut=1");
        $requete->BindParam(':id_hotel', $_SESSION['id_hotel']);
    }
    $requete->execute();
    $st = $requete->fetch(PDO::FETCH_OBJ);
    $id_sous_resto = $st->id_sousresto;
    $libelle_resto = $st->libelle;
    $depot_id = $st->depot_id;
    $_SESSION['id_sousresto'] = $id_sous_resto;
    $_SESSION['libelle_resto'] = $libelle_resto;
    $_SESSION['taux_resto'] = $st->taux;
    $_SESSION['depot_id'] = $depot_id;
    $_SESSION['mention'] = $st->mentionlegale;
    $_SESSION['remise'] = $st->remise;
    return $st;
}
function ListPosResto($id, $bdd)
{
    $module_id=22;
    $requete = $bdd->prepare("SELECT * FROM  t_sousresto AS s,site_modules AS m WHERE s.hotel_id=:hotel_id AND s.id_sousresto=m.sous_site_id AND s.statut=1 AND m.module_id=:module_id ORDER BY s.libelle");
    $requete->BindParam(':hotel_id', $id);
    $requete->BindParam(':module_id', $module_id);
    $requete->execute();
    $st = $requete->fetchAll(PDO::FETCH_OBJ);
    return $st;
}
function ListSousSite($id, $bdd)
{
    $module_id=22;
    $requete = $bdd->prepare("SELECT * FROM  t_sousresto AS s,site_modules AS m WHERE s.hotel_id=:hotel_id AND s.id_sousresto=m.sous_site_id AND s.statut=1 AND m.module_id=:module_id ORDER BY s.libelle");
    $requete->BindParam(':hotel_id', $id);
    $requete->BindParam(':module_id', $module_id);
    $requete->execute();
    $st = $requete->fetchAll(PDO::FETCH_OBJ);
    return $st;
}
function ListPOSRestoOne($id, $bdd)
{
    $requete = $bdd->prepare("SELECT *FROM t_sousresto AS a WHERE a.id_sousresto=:id_sousresto AND a.etat=1 ORDER BY a.libelle");
    $requete->BindParam(':id_sousresto', $id);
    $requete->execute();
    $st = $requete->fetchAll(PDO::FETCH_OBJ);
    return $st;
}
function InfosCommmande($id, $type, $bdd)
{
    $req = "
        SELECT a.*,
        c.nom_client,c.adresse_provenance_client,c.email_client,c.telephone_client,c.designation,c.type AS typecl,c.sexe_client,d.nom_user,d.prenom_user
            FROM t_facture a,t_client c,t_utilisateur AS d
             WHERE a.id_client=c.id_client
                   AND a.id_user=d.id_user AND a.id_fact=:id";
    $requete = $bdd->prepare($req);
    $requete->BindParam(':id', $id);
    $requete->execute();
    $result = $requete->fetch(PDO::FETCH_OBJ);
    return $result;
}
function LignesCommmande($id, $bdd)
{
    $requete = $bdd->prepare("SELECT  p.idprod,l.qte,l.prix,p.designation,p.monnaie,p.repas,l.accomp
                                    FROM  lignes_commandes AS l,stk_produit As p 
                                    WHERE l.produit_id=p.idprod AND l.commande_id=:cmd_id ORDER BY p.designation ");
    $requete->BindParam(':cmd_id', $id);
    $requete->execute();
    $result = $requete->fetchAll(PDO::FETCH_OBJ);
    return $result;
}
function AllCommmandes($id, $type, $dte1, $dte2, $bdd)
{
    //Retourne toutes les commandes du sous-resto
    if ($id > 0) {

        $req = "
        SELECT a.*,
        c.nom_client,c.designation,c.type,c.adresse_provenance_client,c.email_client,c.telephone_client,c.sexe_client,d.nom_user,d.prenom_user
            FROM t_facture a,t_client c,t_utilisateur AS d
             WHERE a.id_client=c.id_client
                   AND a.id_user=d.id_user 
                   AND a.id_sousresto=:id
                   AND a.type=:type
                   AND a.date_edition BETWEEN :dte1 AND :dte2
                   ";
        $requete = $bdd->prepare($req);
        $requete->BindParam(':id', $id);
        $requete->BindParam(':type', $type);
        $requete->BindParam(':dte1', $dte1);
        $requete->BindParam(':dte2', $dte2);
        $requete->execute();
        $result = $requete->fetchAll(PDO::FETCH_OBJ);
        return $result;
    } else {
        $req = "
        SELECT a.*,
        c.nom_client,c.designation,c.type,c.adresse_provenance_client,c.email_client,c.telephone_client,c.sexe_client,d.nom_user,d.prenom_user
            FROM t_facture a,t_client c,t_utilisateur AS d
             WHERE a.id_client=c.id_client
                   AND a.id_user=d.id_user 
                   AND a.type=:type
                   AND a.date_edition BETWEEN :dte1 AND :dte2
                   ";
        $requete = $bdd->prepare($req);
        $requete->BindParam(':type', $type);
        $requete->BindParam(':dte1', $dte1);
        $requete->BindParam(':dte2', $dte2);
        $requete->execute();
        $result = $requete->fetchAll(PDO::FETCH_OBJ);
        return $result;
    }
}
function AllCommmandesBYuser($id, $type, $dte1, $dte2, $bdd)
{
    //Retourne toutes les commandes du sous-resto
    $req = "
        SELECT a.*,
        c.nom_client,c.designation,c.type,c.adresse_provenance_client,c.email_client,c.telephone_client,c.sexe_client,d.nom_user,d.prenom_user
            FROM t_facture a,t_client c,t_utilisateur AS d
             WHERE a.id_client=c.id_client
                   AND a.id_user=d.id_user 
                   AND a.id_sousresto=:id
                   AND a.id_user=:id_user
                   AND a.type=:type
                   AND a.date_edition BETWEEN :dte1 AND :dte2
                   ";
    $requete = $bdd->prepare($req);
    $requete->BindParam(':id', $id);
    $requete->BindParam(':id_user', $_SESSION['id_user']);
    $requete->BindParam(':type', $type);
    $requete->BindParam(':dte1', $dte1);
    $requete->BindParam(':dte2', $dte2);
    $requete->execute();
    $result = $requete->fetchAll(PDO::FETCH_OBJ);
    return $result;
}
function TotPayeCommande($id, $bdd)
{
    //Retourne toutes les commandes du sous-resto
    $requete = $bdd->prepare("SELECT SUM(c.montantusd*c.taux-c.rendu_usd*c.taux+c.montantcdf-c.rendu_cdf) AS montantpaye
                                FROM t_facture AS a, t_reglement AS b, paiement AS c
                                WHERE a.id_fact=b.id_fact AND b.id_regl=c.regl_id
                                 AND c.id_mode_regl IN(1,2)
                                AND a.id_fact=:id  
                                GROUP BY a.id_fact");
    $requete->BindParam(':id', $id);
    $requete->execute();
    $result = $requete->fetchAll(PDO::FETCH_OBJ);
    $montantpaye = 0;
    foreach ($result as $r) {
        $montantpaye = $r->montantpaye;
    }
    return $montantpaye;
}
function TotPayeCommande2($id, $bdd)
{
    //Retourne montant payé saisi et rendu
    $select['paye'] = 0;
    $select['rendu'] = 0;
    $requete = $bdd->prepare("SELECT SUM(c.montantusd*c.taux+c.montantcdf) AS montantpaye,SUM(c.rendu_usd*c.taux+c.rendu_cdf) AS rendu
                                FROM t_facture AS a, t_reglement AS b, paiement AS c
                                WHERE a.id_fact=b.id_fact AND b.id_regl=c.regl_id
                                AND a.id_fact=:id  
                                AND c.annuler=0
                                GROUP BY a.id_fact");
    $requete->BindParam(':id', $id);
    $requete->execute();
    $result = $requete->fetchAll(PDO::FETCH_OBJ);
    $montantpaye = 0;
    foreach ($result as $r) {
        $select['paye'] = $r->montantpaye;
        $select['rendu'] = $r->rendu;
    }
    return $select;
}
function ListMode($bdd)
{
    $requete = $bdd->prepare("SELECT * FROM  t_mode_reglement ORDER BY lib");
    $requete->execute();
    $result = $requete->fetchAll(PDO::FETCH_OBJ);
    return $result;
}

function VerifInsertFDCJrs($id_sousresto, $dtejrs, $bdd)
{
    $id = 0;
    $nblgn = 0;
    $requete = $bdd->prepare("SELECT id FROM fondscaisse WHERE sousresto_id=:id_sousresto AND dte=:dte");
    $requete->BindParam(':id_sousresto', $id_sousresto);
    $requete->BindParam(':dte', $dtejrs);
    $requete->execute();
    $nblgn = $requete->rowCount();
    if ($nblgn > 0) {
        $st = $requete->fetch(PDO::FETCH_OBJ);
        $id = $st->id;
    }
    return $id;
}
function ReimprimerPOS($id_fact, $bdd)
{

    $tva_fact = 0;
    $tauxfct = 1;
    $remise_fact = 0;
    $_SESSION['panier1'] = array();
    $_SESSION['panier1']['id_article'] = array();
    $_SESSION['panier1']['nom'] = array();
    $_SESSION['panier1']['qte'] = array();
    $_SESSION['panier1']['prix'] = array();
    $_SESSION['panier1']['repas'] = array();
    $_SESSION['panier1']['id_client'] = 0;
    $_SESSION['panier1']['remise'] = 0;
    $_SESSION['panier1']['mont_tva'] = 0;
    $_SESSION['panier1']['mont_ttc'] = 0;
    $_SESSION['panier1']['mont_ttc_remise'] = 0;
    $_SESSION['panier1']['verrouille'] = false;
    $_SESSION['panier1']['description'] = array();
    $_SESSION['panier1']['mont_impot'] = 0;

    $idcmd = $id_fact;
    $remise_fact = 0;
    $requete = $bdd->prepare("SELECT f.id_sousresto,f.res_ch_id, f.impot,f.etat_cmd,f.usercancel,f.id_fact,f.etat,f.montant_total,f.mont_tva,f.mont_ttc,f.date_edition,f.dte_time,f.mode,f.mont_ttc_remise,f.taux,f.tva,f.id_fact,f.num_fact,f.remise,
                                f.id_res,c.designation,c.id_client,c.nom_client,c.designation,c.type,d.nom_user,d.prenom_user,f.nbrcouvert,f.nomcaisse
                                FROM  t_client AS c,t_facture AS f,t_utilisateur AS d
                                 WHERE f.id_client=c.id_client AND f.id_user=d.id_user 
                                       AND f.id_fact=:cmd_id");
    $requete->BindParam(':cmd_id', $idcmd);
    $requete->execute();
    $reservation_attente = $requete->fetchAll(PDO::FETCH_OBJ);
    $mont_remise=0;
    foreach ($reservation_attente as $ra) {
        $id_sousresto = $ra->id_sousresto;
        $id = $ra->id_res;
        $id_fact = $ra->id_fact;
        $remise_fact = $ra->mont_ttc_remise;
        $mont_remise = $ra->remise;
        $tva_fact = $ra->tva;
        $impot = $ra->impot;
        $mont_tva = $ra->mont_tva;
        $mont_ttc = $ra->mont_ttc;
        $id_cl = $ra->id_client;
        $cmd_num = $ra->num_fact;
        $tbl = $ra->designation;
        $cl = $ra->nom_client;
        $res_ch_id=$ra->res_ch_id;
        $tauxfct = $ra->taux;
        $_SESSION['tauxfct'] = $ra->taux;
        $_SESSION['nbrcouvert'] = $ra->nbrcouvert;
        $_SESSION['mode_fact'] = $ra->mode;
        $_SESSION['date_edition'] = $ra->date_edition;
        //      $_SESSION['date_edition2'] = $ra->dte_time;
        $_SESSION['date_edition2'] = $ra->date_edition;
        $_SESSION['nomserveur'] = $ra->nom_user;
        $_SESSION['nom_caissier'] = $ra->nomcaisse;
        $_SESSION['PosName'] =GetLibPos($id_sousresto, $bdd);
        $typ = $ra->type;
        if ($typ == 'client' || $typ == 'serveur') {
            if(!is_null($res_ch_id)){
                $requete = $bdd->prepare("SELECT b.num_ch,a.idreserv FROM t_reserve_chambre AS a,t_chambre  AS b
                WHERE a.idchambre=b.id_ch AND a.id=:id");
                $requete->BindParam(':id',$res_ch_id);
                $requete->execute();
                $chambre = $requete->fetch(PDO::FETCH_OBJ);
                $cl=$chambre->num_ch;
            }
            $cl_tbl = $cl;
        } else if ($typ == 'table') {
            $cl_tbl = $tbl;
        } else {
            $cl_tbl = 'Occasionnel';
        }
        $_SESSION['num_commande'] = $ra->num_fact;
        $_SESSION['nom_client'] = $cl_tbl;
        $_SESSION['usercancel'] = $ra->usercancel;
        $_SESSION['etat_cmd'] = $ra->etat_cmd;
        $_SESSION['etat']=$ra->etat;
        $requete = $bdd->prepare("SELECT  p.idprod,p.designation,p.monnaie,p.repas,l.qte,l.qte2,l.qteoffert,l.prix,l.impr,l.accomp
                                    FROM  lignes_commandes AS l,stk_produit As p 
                                    WHERE l.produit_id=p.idprod AND l.commande_id=:cmd_id");
        $requete->BindParam(':cmd_id', $id_fact);
        $requete->execute();
        $reservation_l_attente = $requete->fetchAll(PDO::FETCH_OBJ);
        foreach ($reservation_l_attente as $r) {
            $qte = $r->qte;
            if (round($r->qte) == 0) {
                $qte = $r->qteoffert;
            }
            $prix = $r->prix;
            $idprod = $r->idprod;
            $designation = $r->designation;
            // if ($r->accomp != '') {
            //     $designation = $r->designation . ' avec ' . $r->accomp;
            // }
            $repas = $r->repas;
            $description = $r->accomp;

            array_push($_SESSION['panier1']['id_article'], $idprod);
            array_push($_SESSION['panier1']['nom'], $designation);
            array_push($_SESSION['panier1']['qte'], $qte);
            array_push($_SESSION['panier1']['prix'], $prix);
            array_push($_SESSION['panier1']['repas'], $repas);
            array_push($_SESSION['panier1']['description'], $description);
        }
        $mont_ht = 0;
        $nb_articles = count($_SESSION['panier1']['id_article']);
        for ($i = 0; $i < $nb_articles; $i++) {
            $mont_ht += $_SESSION['panier1']['qte'][$i] * $_SESSION['panier1']['prix'][$i];
        }
        if($mont_tva==0){
            $tva_fact=0; 
        }
        $total1 = $mont_ht;
        $remise_fact =  $mont_remise*100/$mont_ht ;
        $total = total($total1, $tva_fact, $remise_fact);
        $mont_tva = tva($total, $tva_fact, $remise_fact);
        $mont_impot=fpt_impot($total, $impot);
        $mont_rmz = remise($total1, $tva_fact, $remise_fact);
        $mont_ht = ht($total, $tva_fact, $impot);

        $ttc = ttc($mont_ht, $mont_tva, $mont_impot);
        $ttc2 =  montant_equivalent_bdd('CDF', 'USD', $tauxfct, $ttc);
        $_SESSION['panier1']['mont_tva'] = $mont_tva;
        $_SESSION['panier1']['mont_impot'] = $mont_impot;

        $_SESSION['panier1']['mont_ttc'] = $mont_ht - $mont_rmz;
        $_SESSION['panier1']['mont_remise'] = $mont_rmz;
        $_SESSION['panier1']['mont_ht'] = $mont_ht;
        $_SESSION['panier1']['mont_ttc_remise'] = $ttc;
        $_SESSION['panier1']['netapayer'] = $ttc - $mont_rmz;
        $_SESSION['panier1']['tvafact'] = $tva_fact;
        $_SESSION['panier1']['remise_fact'] = $remise_fact;
        $_SESSION['ttc2'] = $ttc2;
    }
}
function GetQteProdEnAttente($bdd)
{
    //Recuperer les quantités produits mise en attente
    $dte = date('Y-m-d');
    $_SESSION['attente'] = array();
    $_SESSION['attente']['qte'] = array();
    $_SESSION['attente']['idprod'] = array();
    $requete = $bdd->prepare("SELECT  l.produit_id,SUM(l.qte) AS qte,l.repas 
                                    FROM t_facture AS a, lignes_commandes AS l
                                    WHERE a.id_fact=l.commande_id AND a.etat_cmd='1'
                                     AND a.id_sousresto=:id_sousresto
                                     AND a.date_edition=:date_edition
                                      GROUP BY l.produit_id");
    $requete->BindParam(':id_sousresto', $_SESSION['id_sousresto']);
    $requete->BindParam(':date_edition', $dte);
    $requete->execute();
    $result = $requete->fetchAll(PDO::FETCH_OBJ);
    foreach ($result as $p) {
        $idprod = $p->produit_id;
        $quantite = $p->qte;
        $repas = $p->repas;
        if ($repas == 1) {
            $produits_plat = listeProduitIngredient($idprod, $_SESSION['id_hotel'], $bdd);
            foreach ($produits_plat as $p) {
                $idpr = $p->produit_id;
                $qte = $p->quantite;
                if (!in_array($idpr, $_SESSION['attente']['idprod'])) {
                    array_push($_SESSION['attente']['idprod'], $idpr);
                    $_SESSION['attente']['qte'][$idpr] = $quantite * $qte;
                } else {
                    $_SESSION['attente']['qte'][$idpr] += $quantite * $qte;
                }
            }
        } else {
            if (!in_array($idprod, $_SESSION['attente']['idprod'])) {
                array_push($_SESSION['attente']['idprod'], $idprod);
                $_SESSION['attente']['qte'][$idprod] = $quantite;
            } else {
                $_SESSION['attente']['qte'][$idprod] += $quantite;
            }
        }
    }
}
function QteAttenteProd($idprod)
{
    $quantite = 0;
    if (in_array($idprod, $_SESSION['attente']['idprod'])) {
        $quantite = $_SESSION['attente']['qte'][$idprod];
    }
    return $quantite;
}
function InitializePrintFacture()
{
    //cash
    $_SESSION['facture'] = array();
    $_SESSION['facture']['id'] = array();
    $_SESSION['facture']['num'] = array();
    $_SESSION['facture']['client'] = array();
    $_SESSION['facture']['vendeur'] = array();
    $_SESSION['facture']['date'] = array();
    $_SESSION['facture']['mode'] = array();
    $_SESSION['facture']['mont_paye'] = array();
    $_SESSION['facture']['mont_tot'] = array();
    //credit
    $_SESSION['facture1'] = array();
    $_SESSION['facture1']['id'] = array();
    $_SESSION['facture1']['num'] = array();
    $_SESSION['facture1']['client'] = array();
    $_SESSION['facture1']['vendeur'] = array();
    $_SESSION['facture1']['date'] = array();
    $_SESSION['facture1']['mode'] = array();
    $_SESSION['facture1']['mont_paye'] = array();
    $_SESSION['facture1']['mont_tot'] = array();
    //don
    $_SESSION['facture2'] = array();
    $_SESSION['facture2']['id'] = array();
    $_SESSION['facture2']['num'] = array();
    $_SESSION['facture2']['client'] = array();
    $_SESSION['facture2']['vendeur'] = array();
    $_SESSION['facture2']['date'] = array();
    $_SESSION['facture2']['mode'] = array();
    $_SESSION['facture2']['mont_paye'] = array();
    $_SESSION['facture2']['mont_tot'] = array();
    //annnulee
    $_SESSION['facture3'] = array();
    $_SESSION['facture3']['id'] = array();
    $_SESSION['facture3']['num'] = array();
    $_SESSION['facture3']['client'] = array();
    $_SESSION['facture3']['vendeur'] = array();
    $_SESSION['facture3']['date'] = array();
    $_SESSION['facture3']['mode'] = array();
    $_SESSION['facture3']['mont_paye'] = array();
    $_SESSION['facture3']['mont_tot'] = array();
    //fusion
    $_SESSION['facture4'] = array();
    $_SESSION['facture4']['id'] = array();
    $_SESSION['facture4']['num'] = array();
    $_SESSION['facture4']['creeepar'] = array();
    $_SESSION['facture4']['date'] = array();
    $_SESSION['facture4']['mont_tot'] = array();

    //proforma
    $_SESSION['facture55'] = array();
    $_SESSION['facture55']['id'] = array();
    $_SESSION['facture55']['num'] = array();
    $_SESSION['facture55']['client'] = array();
    $_SESSION['facture55']['vendeur'] = array();
    $_SESSION['facture55']['date'] = array();
    $_SESSION['facture55']['mont_tot'] = array();
}
function sessionPrintFacture($facture_id, $num_fact, $client, $vendeur, $date, $mode, $mont_paye, $mont_tot)
{
    array_push($_SESSION['facture']['id'], $facture_id);
    array_push($_SESSION['facture']['num'], $num_fact);
    array_push($_SESSION['facture']['client'], $client);
    array_push($_SESSION['facture']['vendeur'], $vendeur);
    array_push($_SESSION['facture']['date'], $date);
    array_push($_SESSION['facture']['mode'], $mode);
    array_push($_SESSION['facture']['mont_paye'], $mont_paye);
    array_push($_SESSION['facture']['mont_tot'], $mont_tot);
}

function sessionPrintFactureCredit($facture_id, $num_fact, $client, $vendeur, $date, $mode, $mont_paye, $mont_tot)
{
    array_push($_SESSION['facture1']['id'], $facture_id);
    array_push($_SESSION['facture1']['num'], $num_fact);
    array_push($_SESSION['facture1']['client'], $client);
    array_push($_SESSION['facture1']['vendeur'], $vendeur);
    array_push($_SESSION['facture1']['date'], $date);
    array_push($_SESSION['facture1']['mode'], $mode);
    array_push($_SESSION['facture1']['mont_paye'], $mont_paye);
    array_push($_SESSION['facture1']['mont_tot'], $mont_tot);
}

function sessionPrintFactureDon($facture_id, $num_fact, $client, $vendeur, $date, $mode, $mont_paye, $mont_tot)
{
    array_push($_SESSION['facture2']['id'], $facture_id);
    array_push($_SESSION['facture2']['num'], $num_fact);
    array_push($_SESSION['facture2']['client'], $client);
    array_push($_SESSION['facture2']['vendeur'], $vendeur);
    array_push($_SESSION['facture2']['date'], $date);
    array_push($_SESSION['facture2']['mode'], $mode);
    array_push($_SESSION['facture2']['mont_paye'], $mont_paye);
    array_push($_SESSION['facture2']['mont_tot'], $mont_tot);
}
function sessionPrintProforma($facture_id, $num_fact, $client, $vendeur, $date, $mode, $mont_paye, $mont_tot)
{
    array_push($_SESSION['facture55']['id'], $facture_id);
    array_push($_SESSION['facture55']['num'], $num_fact);
    array_push($_SESSION['facture55']['client'], $client);
    array_push($_SESSION['facture55']['vendeur'], $vendeur);
    array_push($_SESSION['facture55']['date'], $date);
    array_push($_SESSION['facture55']['mont_tot'], $mont_tot);
}
function sessionPrintFactureAnnulee($facture_id, $num_fact, $client, $vendeur, $date, $mode, $mont_paye, $mont_tot)
{
    array_push($_SESSION['facture3']['id'], $facture_id);
    array_push($_SESSION['facture3']['num'], $num_fact);
    array_push($_SESSION['facture3']['client'], $client);
    array_push($_SESSION['facture3']['vendeur'], $vendeur);
    array_push($_SESSION['facture3']['date'], $date);
    array_push($_SESSION['facture3']['mode'], $mode);
    array_push($_SESSION['facture3']['mont_paye'], $mont_paye);
    array_push($_SESSION['facture3']['mont_tot'], $mont_tot);
}
function sessionPrintFactureFusion($facture_id, $num_fact, $creepar, $date, $mont_tot)
{
    array_push($_SESSION['facture4']['id'], $facture_id);
    array_push($_SESSION['facture4']['num'], $num_fact);
    array_push($_SESSION['facture4']['creeepar'], $creepar);
    array_push($_SESSION['facture4']['date'], $date);
    array_push($_SESSION['facture4']['mont_tot'], $mont_tot);
}
function GetCaffOfDayResto($bdd)
{
    $hr_1 = '00:00:00';
    $hr_2 = '05:00:00';
    $hr_operation = date('H:i:s');
    $dte = date('Y-m-d');
    if ($hr_operation >= $hr_1 && $hr_operation <= $hr_2) {
        $dte = ReduiceDaysToDate($dte, 1);
    }
    $select['usd'] = 0;
    $select['cdf'] = 0;
    $fc_usd = $fc_cdf = 0;
    $id_user = $_SESSION['id_user'];
    if ($_SESSION['type_user'] == 1) {

        // REPORT
        $rfond_cdf = 0;
        $rfond_usd = 0;

        $requete = $bdd->prepare("SELECT cdf ,usd  FROM  reportcaisse WHERE hotel_id=:id_hotel
                                     ORDER BY id DESC LIMIT 1");
        $requete->BindParam(':id_hotel', $_SESSION['id_hotel']);
        $requete->execute();
        $result = $requete->fetchAll(PDO::FETCH_OBJ);

        foreach ($result as $r) {
            $rfond_cdf = $r->cdf;
            $rfond_usd = $r->usd;
        }

        $requete = $bdd->prepare("SELECT SUM(a.usd) AS usd,SUM(a.cdf) AS cdf
                                FROM fondscaisse AS a
                                WHERE a.hotel_id=:hotel_id
                                ");
        $requete->BindParam(':hotel_id', $_SESSION['id_hotel']);
        $requete->execute();
        $fc = $requete->fetch(PDO::FETCH_OBJ);
        $fc_usd = $fc->usd + $rfond_usd;
        $fc_cdf = $fc->cdf + $rfond_cdf;

        $requete = $bdd->prepare("SELECT SUM(c.montantusd-c.rendu_usd) AS usd,SUM(c.montantcdf-c.rendu_cdf) AS cdf
                                FROM t_facture AS a, t_reglement AS b, paiement AS c
                                WHERE a.id_fact=b.id_fact AND b.id_regl=c.regl_id
                                AND c.id_mode_regl IN(2)
                                AND c.site_id=:site_id");
        $requete->BindParam(':site_id', $_SESSION['id_hotel']);
        $requete->execute();
        $result = $requete->fetchAll(PDO::FETCH_OBJ);
        foreach ($result as $r) {
            $select['usd'] = $r->usd;
            $select['cdf'] = $r->cdf;
        }
    } else {
        // REPORT
        $rfond_cdf = 0;
        $rfond_usd = 0;

        $requete = $bdd->prepare("SELECT cdf ,usd  FROM  reportcaisse WHERE hotel_id=:id_hotel  AND user_id=:id_user
                                     ORDER BY id DESC LIMIT 1");
        $requete->BindParam(':id_hotel', $_SESSION['id_hotel']);
        $requete->BindParam(':id_user', $id_user);
        $requete->execute();
        $result = $requete->fetchAll(PDO::FETCH_OBJ);

        foreach ($result as $r) {
            $rfond_cdf = $r->cdf;
            $rfond_usd = $r->usd;
        }
        $requete = $bdd->prepare("SELECT SUM(a.usd) AS usd,SUM(a.cdf) AS cdf
                                FROM fondscaisse AS a
                                WHERE a.sousresto_id=:id_sousresto
                                AND a.user_id=:id_user
                                AND a.dte=:dte");
        $requete->BindParam(':id_sousresto', $_SESSION['id_sousresto']);
        $requete->BindParam(':id_user', $id_user);
        $requete->BindParam(':dte', $dte);
        $requete->execute();
        $fc = $requete->fetch(PDO::FETCH_OBJ);
        $fc_usd = $fc->usd +  $rfond_usd;
        $fc_cdf = $fc->cdf +  $rfond_cdf;
        $requete = $bdd->prepare("SELECT SUM(c.montantusd-c.rendu_usd) AS usd,SUM(c.montantcdf-c.rendu_cdf) AS cdf
                                FROM t_facture AS a, t_reglement AS b, paiement AS c
                                WHERE a.id_fact=b.id_fact AND b.id_regl=c.regl_id
                                AND c.id_mode_regl IN(2)
                                AND c.id_sousresto=:id_sousresto
                                AND b.id_user=:id_user
                                AND b.dte=:dte
                                GROUP BY c.id_sousresto");
        $requete->BindParam(':id_sousresto', $_SESSION['id_sousresto']);
        $requete->BindParam(':id_user', $id_user);
        $requete->BindParam(':dte', $dte);
        $requete->execute();
        $result = $requete->fetchAll(PDO::FETCH_OBJ);
        foreach ($result as $r) {
            $select['usd'] = $r->usd;
            $select['cdf'] = $r->cdf;
        }
    }

    $select['usd'] += $fc_usd;
    $select['cdf'] += $fc_cdf;
    return $select;
}
function DetailsVente($id_sousresto, $date_bd1, $date_bd2, $bdd)
{
    $requete = $bdd->prepare("SELECT a.taux_prix,a.monnaie,a.mode,a.mont_ttc_remise,c.idprod,c.code, c.designation,
                                SUM(b.qte) AS qte, b.prix AS pu, b.dte_h,a.mode AS lib,SUM(b.qte*b.prix) AS mont,
                                SUM(b.qteoffert) AS qteoffert,SUM(b.qteoffert*b.prix2) AS montof
        FROM lignes_commandes AS b, stk_produit AS c, t_facture AS a
        WHERE b.produit_id= c.idprod AND a.id_fact=b.commande_id 
        AND a.date_edition  BETWEEN :date_bd1 AND :date_bd2
        AND a.id_sousresto =:id_sousresto 
        AND a.mode IS NOT NULL
        GROUP BY c.idprod, a.mode  
        ORDER BY c.designation");
    $requete->BindParam(':date_bd1', $date_bd1);
    $requete->BindParam(':date_bd2', $date_bd2);
    $requete->BindParam(':id_sousresto', $_SESSION['id_sousresto']);
    $requete->execute();
    $articles3 = $requete->fetchAll(PDO::FETCH_OBJ);
    return $articles3;
}
function DetailsVenteByUser($id_sousresto, $date_bd1, $date_bd2, $bdd)
{
    $requete = $bdd->prepare("SELECT a.taux_prix,a.monnaie,a.mode,a.mont_ttc_remise,c.idprod,c.code, c.designation,
                                SUM(b.qte) AS qte, b.prix AS pu, b.dte_h,a.mode AS lib,SUM(b.qte*b.prix) AS mont,
                                SUM(b.qteoffert) AS qteoffert,SUM(b.qteoffert*b.prix2) AS montof
        FROM lignes_commandes AS b, stk_produit AS c, t_facture AS a
        WHERE b.produit_id= c.idprod AND a.id_fact=b.commande_id 
        AND a.date_edition  BETWEEN :date_bd1 AND :date_bd2
        AND a.id_sousresto =:id_sousresto 
        AND a.id_user =:id_user
        AND a.mode IS NOT NULL
        GROUP BY c.idprod, a.mode  
        ORDER BY c.designation");
    $requete->BindParam(':date_bd1', $date_bd1);
    $requete->BindParam(':date_bd2', $date_bd2);
    $requete->BindParam(':id_sousresto', $_SESSION['id_sousresto']);
    $requete->BindParam(':id_user', $_SESSION['id_user']);
    $requete->execute();
    $articles3 = $requete->fetchAll(PDO::FETCH_OBJ);
    return $articles3;
}
function TotVerser($id_user, $id_sousresto, $dte, $bdd)
{
    //Retourne montant payé saisi et rendu
    $select['usd'] = 0;
    $select['cdf'] = 0;
    $requete = $bdd->prepare("SELECT a.date_vers,a.user_vers,SUM(a.montant_vers) AS mont_cdf,SUM(a.montantusd) AS mont_usd,a.date_vers
        FROM t_versement AS a
        WHERE a.user_vers=:id_user 
             AND a.date_vers=:dte 
             AND a.id_sousresto=:id_sousresto
        GROUP BY a.user_vers,a.date_vers");
    $requete->BindParam(':dte', $dte);
    $requete->BindParam(':id_user', $id_user);
    $requete->BindParam(':id_sousresto', $id_sousresto);
    $requete->execute();
    $result = $requete->fetchAll(PDO::FETCH_OBJ);
    foreach ($result as $r) {
        $select['usd'] = $r->mont_usd;
        $select['cdf'] = $r->mont_cdf;
    }
    return $select;
}
function TotSolde($id_user, $id_sousresto, $dte, $bdd)
{
    //Retourne montant payé saisi et rendu
    $select['percu_cdf'] = 0;
    $select['percu_usd'] = 0;
    $select['rendu_usd'] = 0;
    $select['rendu_cdf'] = 0;
    $requete = $bdd->prepare("SELECT SUM(b.montantcdf) AS percu_cdf,SUM(b.montantusd) AS percu_usd,b.id_sousresto,
       SUM(b.rendu_cdf) AS rendu_cdf,SUM(b.rendu_usd) AS rendu_usd,a.dte AS date_vers,a.id_user AS user_vers,d.nom_user,d.prenom_user
        FROM t_reglement AS a,paiement AS b,t_utilisateur AS d
        WHERE a.id_regl=b.regl_id 
             AND a.id_user=d.id_user
         AND b.id_sousresto=:id_sousresto 
             AND b.id_mode_regl IN(2)
             AND a.dte BETWEEN :dte AND :dte 
        GROUP BY a.id_user,a.dte");
    $requete->BindParam(':dte', $dte);
    $requete->BindParam(':id_user', $id_user);
    $requete->BindParam(':id_sousresto', $id_sousresto);
    $requete->execute();
    $result = $requete->fetchAll(PDO::FETCH_OBJ);
    foreach ($result as $r) {
        $select['percu_cdf'] = $r->percu_cdf;
        $select['percu_usd'] = $r->percu_usd;
        $select['rendu_usd'] = $r->rendu_usd;
        $select['rendu_cdf'] = $r->rendu_cdf;
    }
    return $select;
}
function FamillesPlat($bdd)
{
    $plat = 1;
    $requete = $bdd->prepare("SELECT * FROM  stk_famille AS f WHERE f.hotel_id=:hotel_id AND f.plat=:plat AND f.pseudo_supp=0 ORDER BY designation ");

    $requete->BindParam(':hotel_id', $_SESSION['id_hotel']);
    $requete->BindParam(':plat', $plat);
    $requete->execute();
    $familles = $requete->fetchAll(PDO::FETCH_OBJ);
    return $familles;
}
function SousFamillesPlat($bdd)
{
    $plat = 1;
    $requete = $bdd->prepare("SELECT * FROM  stk_famille AS f,stk_sous_famille sf"
        . " WHERE f.idfamille= sf.famille AND f.hotel_id=:hotel_id AND f.plat=:plat AND sf.pseudo_supp=0 ORDER BY sf.des");
    $requete->BindParam(':hotel_id', $_SESSION['id_hotel']);
    $requete->BindParam(':plat', $plat);
    $requete->execute();
    $sous_familles = $requete->fetchAll(PDO::FETCH_OBJ);
    return $sous_familles;
}
function ListePlat($bdd)
{
    $requete = $bdd->prepare("SELECT prod.idprod,prod.code,prod.designation AS produit,prod.pa,prod.pv,prod.qte_initial,prod.qte_min,prod.unite,s_fam.des,fam.designation
    FROM stk_produit AS prod,stk_sous_famille AS s_fam ,stk_famille AS fam
    WHERE  prod.famille_id=s_fam.id_s_fam  
    AND prod.hotel_id=:hotel_id 
    AND fam.plat=1 
    AND s_fam.famille=fam.idfamille 
    AND prod.pseudo_supp=0 ORDER BY prod.designation");
    $requete->BindParam(':hotel_id', $_SESSION['id_hotel']);
    $requete->execute();
    $produits = $requete->fetchAll(PDO::FETCH_OBJ);
    return $produits;
}
function ListePlat2($bdd, $fich_sfamid)
{
    $requete = $bdd->prepare("SELECT prod.idprod,prod.code,prod.designation AS produit,prod.pa,prod.pv,prod.qte_initial,prod.qte_min,prod.unite,prod.monnaie,s_fam.des,fam.designation,p.id_prix,p.prix_vente 
    FROM stk_produit AS prod,stk_sous_famille AS s_fam ,stk_famille AS fam, t_prix_produit AS p 
    WHERE  prod.famille_id=s_fam.id_s_fam AND prod.idprod=p.produit_id AND s_fam.id_s_fam=:fich_sfamid
    AND p.sousresto_id=:sousresto_id AND prod.hotel_id=:hotel_id AND fam.plat=1 AND s_fam.famille=fam.idfamille AND prod.pseudo_supp=0 ORDER BY prod.designation");
    $requete->BindParam(':sousresto_id', $_SESSION['id_sousresto']);
    $requete->BindParam(':hotel_id', $_SESSION['id_hotel']);
    $requete->BindParam(':fich_sfamid', $fich_sfamid);
    $requete->execute();
    $produits = $requete->fetchAll(PDO::FETCH_OBJ);
    return $produits;
}
function AfficheNom($nom)
{
    return substr(ucfirst($nom), 0, 10);
}
function AfficheNom2($nom)
{
    return substr(ucfirst($nom), 0, 17);
}
function AllCommmandesCredit($id, $type, $dte1, $dte2, $bdd)
{
    if ($id > 0) {
        //Retourne toutes les commandes par sous-resto
        $mode = 'Credit';
        $req = "
        SELECT a.*,c.type AS type_client,
        c.nom_client,c.designation,c.adresse_provenance_client,c.email_client,c.telephone_client,c.sexe_client,d.nom_user,d.prenom_user
            FROM t_facture a,t_client c,t_utilisateur AS d
             WHERE a.id_client=c.id_client
                   AND a.id_user=d.id_user 
                   AND a.id_sousresto=:id
                   AND a.type=:type
                   AND a.mode=:mode
                   AND a.date_edition BETWEEN :dte1 AND :dte2
                   ";
        $requete = $bdd->prepare($req);
        $requete->BindParam(':id', $id);
        $requete->BindParam(':type', $type);
        $requete->BindParam(':mode', $mode);
        $requete->BindParam(':dte1', $dte1);
        $requete->BindParam(':dte2', $dte2);
        $requete->execute();
        $result = $requete->fetchAll(PDO::FETCH_OBJ);
        return $result;
    } else {
        //Retourne toutes les commandes de sous-restos

        $mode = 'Credit';
        $req = "
        SELECT a.*,c.type AS type_client,
        c.nom_client,c.designation,c.adresse_provenance_client,c.email_client,c.telephone_client,c.sexe_client,d.nom_user,d.prenom_user
            FROM t_facture a,t_client c,t_utilisateur AS d
             WHERE a.id_client=c.id_client
                   AND a.id_user=d.id_user 
                   AND a.type=:type
                   AND a.mode=:mode
                   AND a.date_edition BETWEEN :dte1 AND :dte2
                   ";
        $requete = $bdd->prepare($req);
        $requete->BindParam(':type', $type);
        $requete->BindParam(':mode', $mode);
        $requete->BindParam(':dte1', $dte1);
        $requete->BindParam(':dte2', $dte2);
        $requete->execute();
        $result = $requete->fetchAll(PDO::FETCH_OBJ);
        return $result;
    }
}
function HistoPaiementByFact($id, $bdd)
{
    //Retourne toutes les commandes du sous-resto
    $req = "SELECT re.id_regl,re.numero,re.dte,re.date_regl,re.id_user,pa.montantusd,pa.montantcdf,pa.rendu_usd,pa.rendu_cdf,pa.taux,mo.lib,us.nom_user,us.prenom_user
        FROM t_reglement AS re,paiement AS pa,t_mode_reglement AS mo,t_utilisateur AS us
        WHERE re.id_regl=pa.regl_id 
       AND  mo.id_mode_regl=pa.id_mode_regl 
       AND  re.id_user=us.id_user
       AND re.id_fact=:id
       AND pa.annuler=0
       AND mo.id_mode_regl IN(2,4,5,6,7)
       ";
    $requete = $bdd->prepare($req);
    $requete->BindParam(':id', $id);
    $requete->execute();
    $result = $requete->fetchAll(PDO::FETCH_OBJ);
    return $result;
}
function DetailsRecu($id, $bdd)
{
    //Retourne toutes les commandes du sous-resto
    $req = "SELECT pa.id_sousresto,re.id_regl,re.id_fact,re.numero,re.dte,re.date_regl,re.id_user,pa.montantusd,pa.montantcdf,pa.rendu_usd,pa.rendu_cdf,pa.taux,mo.lib,us.nom_user,us.prenom_user
        FROM t_reglement AS re,paiement AS pa,t_mode_reglement AS mo,t_utilisateur AS us
        WHERE re.id_regl=pa.regl_id 
       AND  mo.id_mode_regl=pa.id_mode_regl 
       AND  re.id_user=us.id_user
       AND re.id_regl=:id
       AND mo.id_mode_regl IN(1,2,4,5,6,7)
       ";
    $requete = $bdd->prepare($req);
    $requete->BindParam(':id', $id);
    $requete->execute();
    $result = $requete->fetch(PDO::FETCH_OBJ);
    return $result;
}
function DetailsVenteAll($date_bd1, $date_bd2, $bdd)
{
    $requete = $bdd->prepare("SELECT a.taux_prix,a.monnaie,a.mode,c.idprod,c.code, c.designation,SUM(b.qte) AS qte, b.prix AS pu, b.dte_h,a.mode AS lib,SUM(b.prix*b.qte) AS pt,SUM(c.pa*b.qte) AS pa,c.repas
        FROM lignes_commandes AS b, stk_produit AS c, t_facture AS a
        WHERE b.produit_id= c.idprod AND a.id_fact=b.commande_id 
        AND a.date_edition  BETWEEN :date_bd1 AND :date_bd2
        AND a.id_hotel =:id_hotel 
        GROUP BY c.idprod, a.mode 
        ORDER BY c.designation");
    $requete->BindParam(':date_bd1', $date_bd1);
    $requete->BindParam(':date_bd2', $date_bd2);
    $requete->BindParam(':id_hotel', $_SESSION['id_hotel']);
    $requete->execute();
    $articles3 = $requete->fetchAll(PDO::FETCH_OBJ);
    return $articles3;
}
function insertSessionVente($numero, $bdd)
{
    $statut = 1;
    $date_ouverture = date('Y-m-d');
    $date_fermeture = date('Y-m-d');
    $dte_heure_ouvert = date('Y-m-d H:i:s');
    $dte_heure_ferm = date('Y-m-d H:i:s');
    $requete = $bdd->prepare("INSERT INTO t_session(numero,date_ouverture,date_fermeture,statut,dte_heure_ouvert,
                                                    dte_heure_ferm,user_id,souresto_id,hotel_id)
                VALUES(:numero,:date_ouverture,:date_fermeture,:statut,:dte_heure_ouvert,:dte_heure_ferm,:user_id,:souresto_id,:hotel_id)");
    $requete->BindParam(':date_ouverture', $date_ouverture);
    $requete->BindParam(':date_fermeture', $date_fermeture);
    $requete->BindParam(':statut', $statut);
    $requete->BindParam(':dte_heure_ouvert', $dte_heure_ouvert);
    $requete->BindParam(':dte_heure_ferm', $dte_heure_ferm);
    $requete->BindParam(':user_id', $_SESSION['id_user']);
    $requete->BindParam(':souresto_id', $_SESSION['id_sousresto']);
    $requete->BindParam(':hotel_id', $_SESSION['id_hotel']);
    $requete->execute();
}
function selectIdVenteSession($bdd)
{
    $numero = 0;
    $requete = $bdd->prepare("SELECT idsession FROM t_session WHERE statut=1");
    //    $requete->BindParam(':statut',$id);
    $requete->execute();
    $operations = $requete->fetchAll(PDO::FETCH_OBJ);
    foreach ($operations as $op) :
        $numero = $op->idsession;
    endforeach;
    return $numero;
}
function CloturerVenteSession($idsession, $bdd)
{
    $date_fermeture = date('Y-m-d');
    $dte_heure_ferm = date('Y-m-d H:i:s');
    $statut = 0;
    $requete = $bdd->prepare("UPDATE t_session SET statut=:statut,date_fermeture=:date_fermeture,dte_heure_ferm=:dte_heure_ferm WHERE idsession=:idsession");
    $requete->BindParam(':statut', $statut);
    $requete->BindParam(':date_fermeture', $date_fermeture);
    $requete->BindParam(':dte_heure_ferm', $dte_heure_ferm);
    $requete->BindParam(':idsession', $idsession);
    $requete->execute();
}
function ReduiceDaysToDate($dte, $nbrejr)
{
    $addjr = '-' . $nbrejr . 'days';
    $date_collect = date("Y-m-d", strtotime($dte . $addjr));
    $new_date_collect = $date_collect;
    return $new_date_collect;
}
function ReimprimerBC($id_fact, $bdd)
{
    $tva_fact = 0;
    $tauxfct = 1;
    $remise_fact = 0;
    $_SESSION['dessert'] = 0;
    $_SESSION['entree'] = 0;
    $_SESSION['plats'] = 0;
    $_SESSION['panier'] = array();
    $_SESSION['panier']['id_article'] = array();
    $_SESSION['panier']['nom'] = array();
    $_SESSION['panier']['qte'] = array();
    $_SESSION['panier']['prix'] = array();
    $_SESSION['panier']['repas'] = array();
    $_SESSION['panier']['genre'] = array();
    $_SESSION['panier']['id_client'] = 0;
    $_SESSION['panier']['remise'] = 0;
    $_SESSION['panier']['mont_tva'] = 0;
    $_SESSION['panier']['mont_ttc'] = 0;
    $_SESSION['panier']['mont_ttc_remise'] = 0;
    $_SESSION['panier']['verrouille'] = false;
    $idcmd = $id_fact;
    $requete = $bdd->prepare("SELECT f.id_fact, f.montant_total,f.mont_tva,f.mont_ttc,f.date_edition,f.dte_time,f.mode,f.mont_ttc_remise,f.taux,f.tva,f.id_fact,f.num_fact,
                                f.id_res,c.designation,c.id_client,c.nom_client,c.designation,c.type,d.nom_user,d.prenom_user
                                FROM  t_client AS c,t_facture AS f,t_utilisateur AS d
                                 WHERE f.id_client=c.id_client AND f.id_user=d.id_user 
                                       AND f.id_fact=:cmd_id");
    $requete->BindParam(':cmd_id', $idcmd);
    $requete->execute();
    $reservation_attente = $requete->fetchAll(PDO::FETCH_OBJ);
    foreach ($reservation_attente as $ra) {
        $id = $ra->id_res;
        $id_fact = $ra->id_fact;
        $remise_fact = $ra->mont_ttc_remise;
        $mont_remise = $ra->tva;
        $tva_fact = $ra->tva;
        $mont_tva = $ra->mont_tva;
        $mont_ttc = $ra->mont_ttc;
        $id_cl = $ra->id_client;
        $cmd_num = $ra->num_reserv;
        $tbl = $ra->designation;
        $cl = $ra->nom_client;
        $tauxfct = $ra->taux;
        $_SESSION['mode_fact'] = $ra->mode;
        $_SESSION['nom_user'] = $ra->nom_user;
        $_SESSION['date_edition'] = $ra->date_edition;
        //        $_SESSION['date_edition2'] = $ra->dte_time;
        $_SESSION['date_edition2'] = $ra->dte_time;
        $typ = $ra->type;
        if ($typ == 'client' || $typ == 'serveur') {
            $cl_tbl = $cl;
        } else if ($typ == 'table') {
            $cl_tbl = $tbl;
        } else {
            $cl_tbl = 'Occasionnel';
        }
        $_SESSION['num_commande'] = $ra->num_fact;
        $_SESSION['nom_client'] = $cl_tbl;
        $requete = $bdd->prepare("SELECT  p.idprod,p.designation,p.monnaie,p.repas,ss.genre,l.*
                                    FROM  lignes_commandes AS l,stk_produit As p,stk_sous_famille AS ss
                                    WHERE l.produit_id=p.idprod AND p.famille_id=ss.id_s_fam AND l.commande_id=:cmd_id");
        $requete->BindParam(':cmd_id', $id_fact);
        $requete->execute();
        $reservation_l_attente = $requete->fetchAll(PDO::FETCH_OBJ);
        foreach ($reservation_l_attente as $r) {
            $qte = $r->qte;
            if (round($r->qte) == 0) {
                $qte = $r->qteoffert;
            }
            $prix = $r->prix;
            $idprod = $r->idprod;
            $designation = $r->designation;
            if ($r->accomp != '') {
                $designation = $r->designation . ' avec ' . $r->accomp;
            }
            $repas = $r->repas;
            $genre = $r->genre;

            array_push($_SESSION['panier']['id_article'], $idprod);
            array_push($_SESSION['panier']['nom'], $designation);
            array_push($_SESSION['panier']['qte'], $qte);
            array_push($_SESSION['panier']['prix'], $prix);
            array_push($_SESSION['panier']['repas'], $repas);
            array_push($_SESSION['panier']['genre'], $genre);
            if ($genre == 2) {
                $_SESSION['dessert'] = 1;
            } elseif ($genre == 1) {
                $_SESSION['entree'] = 1;
            } elseif ($genre == 0) {
                $_SESSION['plats'] = 1;
            }
        }
        $mont_ht = 0;
        $nb_articles = count($_SESSION['panier']['id_article']);
        for ($i = 0; $i < $nb_articles; $i++) {
            $mont_ht += $_SESSION['panier']['qte'][$i] * $_SESSION['panier']['prix'][$i];
        }
        $total1 = $mont_ht;
        $total = total($total1, $tva_fact, $remise_fact);
        $mont_tva = tva($total, $tva_fact, $remise_fact);
        $mont_rmz = remise($total1, $tva_fact, $remise_fact);
        $mont_ht = ht($total, $tva_fact, $remise_fact);

        $ttc = ttc($mont_ht, $mont_tva, $mont_rmz);
        $ttc2 =  montant_equivalent_bdd('CDF', 'USD', $tauxfct, $ttc);
        $_SESSION['panier']['mont_tva'] = $mont_tva;
        $_SESSION['panier']['mont_ttc'] = $mont_ht - $mont_rmz;
        $_SESSION['panier']['mont_remise'] = $mont_rmz;
        $_SESSION['panier']['mont_ht'] = $mont_ht;
        $_SESSION['panier']['mont_ttc_remise'] = $ttc;
        $_SESSION['ttc2'] = $ttc2;

        //DETAILS PLATS
        $_SESSION['platdetail'] = array();
        $_SESSION['platdetail']['accomp_id'] = array();
        $_SESSION['platdetail']['accomp_nom'] = array();
        $_SESSION['platdetail']['cpt'] = array();
        $_SESSION['platdetail']['cpt2'] = array();
        $_SESSION['platdetail']['cuisson_id'] = array();
        $_SESSION['platdetail']['cuisson_nom'] = array();
        $_SESSION['platdetail']['idprod'] = array();
        $_SESSION['platdetail']['sauce_id'] = array();
        $_SESSION['platdetail']['sauce_nom'] = array();
        $_SESSION['platdetail']['sel_id'] = array();
        $_SESSION['platdetail']['sel_nom'] = array();
        $_SESSION['platdetail']['keyprods'] = array();
    }
}
function RenduRetour($usd_saisi, $cdf_saisi, $totrendu, $taux)
{
    $data = array();
    $data['r_usd'] = 0;
    $data['r_cdf'] = 0;
    $totrdpe = 0;
    $totrddc = 0;
    if ($usd_saisi > $cdf_saisi) {
        $totrendu_usd = $totrendu / $taux;
        $totrdpe = floor($totrendu_usd);
        $totrddc = $totrendu_usd - $totrdpe;
        $a = $totrdpe % 5;
        $x1 = $totrdpe / 5;
        $y = floor($x1);
        if ($y >= 1) {
            $r_usd = 5 * $y;
            $r_cdf = $totrddc * $taux + $a * $taux;
        } else {
            $r_usd = 0;
            $r_cdf = $totrendu;
        }
    } else {
        $r_usd = 0;
        $r_cdf = $totrendu;
    }
    $data['r_usd'] = $r_usd;
    $data['r_cdf'] = $r_cdf;
    return $data;
}
function AddLibelleDepense($code, $designation, $site_id, $bdd)
{
    $psedo = 0;
    $code = '';
    try {
        $requete = $bdd->prepare("INSERT INTO dep_libelles(code,designation,site_id) VALUES(:code,:designation,:site_id)");
        $requete->BindParam(':code', $code);
        $requete->BindParam(':designation', $designation);
        $requete->BindParam(':site_id', $site_id);
        $requete->execute();
    } catch (Exception $exc) {
        echo $exc->getTraceAsString();
    }
}
function SelectLibelleDepense($site_id, $bdd)
{
    $requete = $bdd->prepare("SELECT * FROM dep_libelles AS a WHERE a.site_id=:site_id AND a.psedo=0 ORDER BY a.designation");
    $requete->BindParam(':site_id', $site_id);
    $requete->execute();
    $st = $requete->fetchAll(PDO::FETCH_OBJ);
    return $st;
}
function AddDepense($numero, $dte_dep, $motif, $usd, $cdf, $taux, $user_id, $libelle_id, $service, $sousresto_id, $site_id, $bdd)
{
    try {
        $requete = $bdd->prepare("INSERT INTO depenses (numero,dte_dep,motif,usd,cdf,taux,service,user_id,libelle_id,sousresto_id,site_id) VALUES(:numero,:dte_dep,:motif,:usd,:cdf,:taux,:service,:user_id,:libelle_id,:sousresto_id,:site_id)");
        $requete->BindParam(':numero', $numero);
        $requete->BindParam(':dte_dep', $dte_dep);
        $requete->BindParam(':motif', $motif);
        $requete->BindParam(':usd', $usd);
        $requete->BindParam(':cdf', $cdf);
        $requete->BindParam(':taux', $taux);
        $requete->BindParam(':service', $service);
        $requete->BindParam(':user_id', $user_id);
        $requete->BindParam(':libelle_id', $libelle_id);
        $requete->BindParam(':sousresto_id', $sousresto_id);
        $requete->BindParam(':site_id', $site_id);
        $requete->execute();
        $depense_id = $bdd->lastInsertId();
        return $depense_id;
    } catch (Exception $exc) {
        echo $exc->getTraceAsString();
    }
}

function SelectDepense($site_id, $dte1, $dte2, $bdd)
{
    $requete = $bdd->prepare("SELECT * FROM depenses AS a, dep_libelles AS b, t_utilisateur AS c
                                WHERE a.libelle_id=b.id AND a.user_id=c.id_user
                                AND a.site_id=:site_id AND a.psedo=0 
                                AND a.dte_dep BETWEEN :dte1 AND :dte2
                                ORDER BY a.dte_dep");
    $requete->BindParam(':site_id', $site_id);
    $requete->BindParam(':dte1', $dte1);
    $requete->BindParam(':dte2', $dte2);
    $requete->execute();
    $st = $requete->fetchAll(PDO::FETCH_OBJ);
    return $st;
}
function SelectDepenseID($id, $bdd)
{
    $requete = $bdd->prepare("SELECT * FROM depenses AS a,dep_libelles AS b WHERE a.libelle_id=b.id AND a.id=:id");
    $requete->BindParam(':id', $id);
    $requete->execute();
    $st = $requete->fetch(PDO::FETCH_OBJ);
    return $st;
}

function SelectDetailsPlats($bdd)
{
    $requete = $bdd->prepare("SELECT * FROM  detailsplats WHERE hotel_id=:hotel_id ORDER BY nom");
    $requete->BindParam(':hotel_id', $_SESSION['id_hotel']);
    $requete->execute();
    $st = $requete->fetchAll(PDO::FETCH_OBJ);
    return $st;
}

function SelectDetailsPlats_ID($produit_id, $bdd)
{
    $requete = $bdd->prepare("SELECT * FROM  detailsplats AS b,platspreparations AS c WHERE b.id=c.detplat_id AND c.produit_id=:produit_id");
    $requete->BindParam(':produit_id', $produit_id);
    $requete->execute();
    $st = $requete->fetchAll(PDO::FETCH_OBJ);
    return $st;
}
function supprimer_detailsplat($cpt1)
{

    if (array_key_exists($cpt1, $_SESSION['platdetail']['cpt2'])) {
        $keyprod_sup = $_SESSION['platdetail']['cpt2'][$cpt1];
        unset($_SESSION['platdetail']['idprod'][$keyprod_sup]);
        unset($_SESSION['platdetail']['keyprods'][$keyprod_sup]);
    }
}

function SelectCouverts($dte1, $dte2, $site_id, $bdd)
{
    $requete = $bdd->prepare("SELECT f.id_fact, f.num_fact,f.nbrcouvert,f.date_edition,c.designation,c.id_client
                              FROM  t_facture AS f,t_client AS c
                              WHERE f.id_client=c.id_client 
                              AND f.type='restaurant' 
                              AND f.etat_cmd!=3 
                              AND f.date_edition BETWEEN :dte1 AND :dte2
                              AND f.id_hotel=:site_id");
    $requete->BindParam(':dte1', $dte1);
    $requete->BindParam(':dte2', $dte2);
    $requete->BindParam(':site_id', $site_id);
    $requete->execute();
    $st = $requete->fetchAll(PDO::FETCH_OBJ);
    return $st;
}

function ReimprimerBC2old($id_fact, $impr, $bdd)
{
    $tva_fact = 0;
    $tauxfct = 1;
    $remise_fact = 0;
    $_SESSION['dessert'] = 0;
    $_SESSION['entree'] = 0;
    $_SESSION['plats'] = 0;
    $_SESSION['panier'] = array();
    $_SESSION['panier']['id_article'] = array();
    $_SESSION['panier']['nom'] = array();
    $_SESSION['panier']['qte'] = array();
    $_SESSION['panier']['prix'] = array();
    $_SESSION['panier']['repas'] = array();
    $_SESSION['panier']['genre'] = array();
    $_SESSION['panier']['pa'] = array();
    $_SESSION['panier']['description'] = array();
    $_SESSION['panier']['id_client'] = 0;
    $_SESSION['panier']['remise'] = 0;
    $_SESSION['panier']['mont_tva'] = 0;
    $_SESSION['panier']['mont_ttc'] = 0;
    $_SESSION['panier']['mont_ttc_remise'] = 0;
    $_SESSION['panier']['verrouille'] = false;
    //Regroupement
    $_SESSION['group_prod'] = array();
    $_SESSION['group_prod']['id_article'] = array();
    $_SESSION['group_prod']['nom'] = array();
    $_SESSION['group_prod']['qte'] = array();
    $_SESSION['group_prod']['accomps'] = array();
    $_SESSION['group_prod']['des_plt'] = array();
    $_SESSION['group_prod']['repas'] = array();
    $_SESSION['group_prod']['genre'] = array();

    $_SESSION['group_accomp'] = array();
    $_SESSION['group_accomp']['nom_accomp'] = array();
    $_SESSION['group_accomp']['qte_accomp'] = array();

    //Regroupement
    $idcmd = $id_fact;
    $requete = $bdd->prepare("SELECT f.etat_cmd,f.usercancel,f.note_cmd,f.id_fact, f.montant_total,f.mont_tva,f.mont_ttc,f.date_edition,f.dte_time,f.mode,f.mont_ttc_remise,f.taux,f.tva,f.id_fact,f.num_fact,
                                f.id_res,c.designation,c.id_client,c.nom_client,c.designation,c.type,d.nom_user,d.prenom_user,f.nbrcouvert AS nbrcouvertfac,f.preparer,f.etat_cmd
                                FROM  t_client AS c,t_facture AS f,t_utilisateur AS d
                                 WHERE f.id_client=c.id_client AND f.id_user=d.id_user 
                                       AND f.id_fact=:cmd_id");
    $requete->BindParam(':cmd_id', $idcmd);
    $requete->execute();
    $reservation_attente = $requete->fetchAll(PDO::FETCH_OBJ);
    foreach ($reservation_attente as $ra) {
        $_SESSION['nbrcouvert'] = $ra->nbrcouvertfac;
        $id = $ra->id_res;
        $id_fact = $ra->id_fact;
        $remise_fact = $ra->mont_ttc_remise;
        $mont_remise = $ra->tva;
        $tva_fact = $ra->tva;
        $mont_tva = $ra->mont_tva;
        $mont_ttc = $ra->mont_ttc;
        $id_cl = $ra->id_client;
        // $cmd_num = $ra->num_reserv;
        $tbl = $ra->designation;
        $cl = $ra->nom_client;
        $tauxfct = $ra->taux;
        $_SESSION['mode_fact'] = $ra->mode;
        $_SESSION['nom_user'] = $ra->nom_user;
        $_SESSION['date_edition'] = $ra->date_edition;
        //        $_SESSION['date_edition2'] = $ra->dte_time;
        $_SESSION['date_edition2'] = $ra->dte_time;
        $typ = $ra->type;
        if ($typ == 'client' || $typ == 'serveur') {
            $cl_tbl = $cl;
        } else if ($typ == 'table') {
            $cl_tbl = $tbl;
        } else {
            $cl_tbl = 'Occasionnel';
        }
        $_SESSION['num_commande'] = $ra->num_fact;
        $_SESSION['nom_client'] = $cl_tbl;
        $_SESSION['id_client'] = $id_cl;
        $statut = 'En cours';
        if ($ra->preparer == 1) {
            $statut = 'Preparé';
        }
        if ($ra->etat_cmd == 3) {
            $statut = 'Annulé';
        }
        $_SESSION['preparer'] = $ra->preparer;
        $_SESSION['etat_cmd'] = $ra->etat_cmd;
        $_SESSION['statut_cmd'] = $statut;
        $note_cmd = $ra->note_cmd;
        $_SESSION['note_cmd'] = $note_cmd;
        $_SESSION['usercancel'] = $ra->usercancel;
        $_SESSION['etat_cmd'] = $ra->etat_cmd;
        $$accompgns = "";
        $requete = $bdd->prepare("SELECT  p.idprod,p.designation,p.monnaie,p.repas,ss.genre,l.*
                                    FROM  lignes_commandes AS l,stk_produit As p,stk_sous_famille AS ss
                                    WHERE l.produit_id=p.idprod AND p.famille_id=ss.id_s_fam 
                                     AND l.commande_id=:cmd_id AND l.impr=:impr");
        $requete->BindParam(':cmd_id', $id_fact);
        $requete->BindParam(':impr', $impr);
        $requete->execute();
        $reservation_l_attente = $requete->fetchAll(PDO::FETCH_OBJ);
        foreach ($reservation_l_attente as $r) {
            $qte = $r->qte;
            $lignecmd_id = $r->id;
            if (round($r->qte) == 0) {
                $qte = $r->qteoffert;
            }
            $prix = $r->prix;
            $idprod = $r->idprod;
            $designation = $r->designation;

            $repas = $r->repas;
            $genre = $r->genre;
            $impr = $r->impr;
            if ($impr == 1) {
                if ($r->qte2 != 0) {
                    $qte = $r->qte2;
                }
            }
            $des_plt = $r->accomp;
            $pa = $r->pa;
            array_push($_SESSION['panier']['id_article'], $idprod);
            array_push($_SESSION['panier']['nom'], $designation);
            array_push($_SESSION['panier']['qte'], $qte);
            array_push($_SESSION['panier']['prix'], $prix);
            array_push($_SESSION['panier']['repas'], $repas);
            array_push($_SESSION['panier']['genre'], $genre);
            array_push($_SESSION['panier']['pa'], $pa);
            array_push($_SESSION['panier']['description'], $des_plt);
            if ($genre == 2) {
                $_SESSION['dessert'] = 1;
            } elseif ($genre == 1) {
                $_SESSION['entree'] = 1;
            } elseif ($genre == 0) {
                $_SESSION['plats'] = 1;
                $accompgns = $r->accomp;
                //Regroupement des produits
                if (!in_array($idprod, $_SESSION['group_prod']['id_article'])) {
                    array_push($_SESSION['group_prod']['id_article'], $idprod);
                    $_SESSION['group_prod']['nom'][$idprod] = $designation;
                    $_SESSION['group_prod']['repas'][$idprod] = $repas;
                    $_SESSION['group_prod']['genre'][$idprod] = $genre;
                    $_SESSION['group_prod']['qte'][$idprod] = $qte;
                    $_SESSION['group_prod']['accomps'][$idprod] = $accompgns;
                } else {
                    $qteold = $_SESSION['group_prod']['qte'][$idprod];
                    $_SESSION['group_prod']['qte'][$idprod] = $qteold + $qte;
                    $_SESSION['group_prod']['accomps'][$idprod] = $_SESSION['group_prod']['accomps'][$idprod]  . ',' . $accompgns;
                }
            }
        }
        //Regroupement des accompagnements
        $nbrprod = count($_SESSION['group_prod']['id_article']);
        for ($i = 0; $i <= $nbrprod - 1; $i++) {
            $idprod = $_SESSION['group_prod']['id_article'][$i];
            $accompgns = $_SESSION['group_prod']['accomps'][$idprod];
            $t_accomps = explode(',', $accompgns);
            $nbraccomp = count($t_accomps);
            for ($j = 0; $j <= $nbraccomp - 1; $j++) {
                $nom_accomp = trim($t_accomps[$j]);
                $nom_accomp = strstr($nom_accomp, '(', true);
                if (!in_array($nom_accomp, $_SESSION['group_accomp']['nom_accomp'])) {
                    array_push($_SESSION['group_accomp']['nom_accomp'], $nom_accomp);
                    $_SESSION['group_accomp']['qte_accomp'][$nom_accomp] = 1;
                } else {
                    $_SESSION['group_accomp']['qte_accomp'][$nom_accomp] += 1;
                }
            }
            $Z = count($_SESSION['group_accomp']['nom_accomp']);
            $ch = "";
            for ($s = 0; $s <= $Z - 1; $s++) {
                $n = $_SESSION['group_accomp']['nom_accomp'][$s];
                $q = $_SESSION['group_accomp']['qte_accomp'][$n];
                if ($q > 0 && $n != "") {
                    $ch = $ch . $q . ' ' . $n . ',';
                }
            }
            $_SESSION['group_prod']['des_plt'][$idprod] = $ch;
            $_SESSION['group_accomp'] = array();
            $_SESSION['group_accomp']['nom_accomp'] = array();
            $_SESSION['group_accomp']['qte_accomp'] = array();
        }
        //Regroupement des accompagnements

        $mont_ht = 0;
        $nb_articles = count($_SESSION['panier']['id_article']);
        for ($i = 0; $i < $nb_articles; $i++) {
            $mont_ht += $_SESSION['panier']['qte'][$i] * $_SESSION['panier']['prix'][$i];
        }
        $total1 = $mont_ht;
        $total = total($total1, $tva_fact, $remise_fact);
        //        $mont_tva=tva($total,$tva_fact,$remise_fact);
        $mont_rmz = remise($total1, $tva_fact, $remise_fact);
        $mont_ht = ht($total, $tva_fact, $remise_fact);

        $ttc = ttc($mont_ht, $mont_tva, $mont_rmz);
        $ttc2 =  montant_equivalent_bdd('CDF', 'USD', $tauxfct, $ttc);
        $_SESSION['panier']['mont_tva'] = $mont_tva;
        $_SESSION['panier']['mont_ttc'] = $mont_ht - $mont_rmz;
        $_SESSION['panier']['mont_remise'] = $mont_rmz;
        $_SESSION['panier']['mont_ht'] = $mont_ht;
        $_SESSION['panier']['mont_ttc_remise'] = $ttc;
        $_SESSION['ttc2'] = $ttc2;
    }
}
function ReimprimerBC2($id_fact, $impr, $bdd)
{
    $tva_fact = 0;
    $tauxfct = 1;
    $remise_fact = 0;
    $_SESSION['dessert'] = 0;
    $_SESSION['entree'] = 0;
    $_SESSION['plats'] = 0;
    $_SESSION['panier'] = array();
    $_SESSION['panier']['id_article'] = array();
    $_SESSION['panier']['nom'] = array();
    $_SESSION['panier']['qte'] = array();
    $_SESSION['panier']['prix'] = array();
    $_SESSION['panier']['repas'] = array();
    $_SESSION['panier']['genre'] = array();
    $_SESSION['panier']['description'] = array();
    $_SESSION['panier']['id_client'] = 0;
    $_SESSION['panier']['remise'] = 0;
    $_SESSION['panier']['mont_tva'] = 0;
    $_SESSION['panier']['mont_ttc'] = 0;
    $_SESSION['panier']['mont_ttc_remise'] = 0;
    $_SESSION['panier']['verrouille'] = false;
    $idcmd = $id_fact;
    $requete = $bdd->prepare("SELECT f.note_cmd,f.id_fact, f.montant_total,f.mont_tva,f.mont_ttc,f.date_edition,f.dte_time,f.mode,f.mont_ttc_remise,f.taux,f.tva,f.id_fact,f.num_fact,
                                f.id_res,c.designation,c.id_client,c.nom_client,c.designation,c.type,d.nom_user,d.prenom_user
                                FROM  t_client AS c,t_facture AS f,t_utilisateur AS d
                                 WHERE f.id_client=c.id_client AND f.id_user=d.id_user 
                                       AND f.id_fact=:cmd_id");
    $requete->BindParam(':cmd_id', $idcmd);
    $requete->execute();
    $reservation_attente = $requete->fetchAll(PDO::FETCH_OBJ);
    foreach ($reservation_attente as $ra) {
        $id = $ra->id_res;
        // $id_fact = $ra->id_fact;
        $remise_fact = $ra->mont_ttc_remise;
        $mont_remise = $ra->tva;
        $tva_fact = $ra->tva;
        $mont_tva = $ra->mont_tva;
        $mont_ttc = $ra->mont_ttc;
        $id_cl = $ra->id_client;
        $cmd_num = $ra->num_reserv;
        $tbl = $ra->designation;
        $cl = $ra->nom_client;
        $tauxfct = $ra->taux;
        $_SESSION['mode_fact'] = $ra->mode;
        $_SESSION['nom_user'] = $ra->nom_user;
        $_SESSION['date_edition'] = $ra->date_edition;
        $_SESSION['libelle_resto']=
        //        $_SESSION['date_edition2'] = $ra->dte_time;
        $_SESSION['date_edition2'] = $ra->dte_time;
        $typ = $ra->type;
        if ($typ == 'client' || $typ == 'serveur') {
            $cl_tbl = $cl;
        } else if ($typ == 'table') {
            $cl_tbl = $tbl;
        } else {
            $cl_tbl = 'Occasionnel';
        }
        $_SESSION['num_commande'] = $ra->num_fact;
        $_SESSION['NoteCmdBar'] = $ra->note_cmd;
        $_SESSION['nom_client'] = $cl_tbl;
        $requete = $bdd->prepare("SELECT  p.idprod,p.designation,p.monnaie,p.repas,ss.genre,SUM(l.qte) AS qte,SUM(l.qte2) AS qte2,SUM(l.qteoffert) AS qteoffert,l.prix,l.impr,GROUP_CONCAT(l.accomp) AS accomp
        FROM  lignes_commandes AS l,stk_produit As p,stk_sous_famille AS ss
        WHERE l.produit_id=p.idprod AND p.famille_id=ss.id_s_fam 
        AND l.commande_id=:cmd_id AND l.impr=:impr
        GROUP BY p.idprod");
        $requete->BindParam(':cmd_id', $id_fact);
        $requete->BindParam(':impr', $impr);
        $requete->execute();
        $reservation_l_attente = $requete->fetchAll(PDO::FETCH_OBJ);
        foreach ($reservation_l_attente as $r) {
            $qte = $r->qte;
            $impr = $r->impr;
            if ($impr == 1) {
                if ($r->qte2 != 0) {
                    $qte = $r->qte2;
                }
            }

            if (round($r->qte) == 0) {
                $qte = $r->qteoffert;
            }
            $prix = $r->prix;
            $idprod = $r->idprod;
            $designation = $r->designation;
            $description = $r->accomp;
            $repas = $r->repas;
            $genre = $r->genre;

            array_push($_SESSION['panier']['id_article'], $idprod);
            array_push($_SESSION['panier']['nom'], $designation);
            array_push($_SESSION['panier']['qte'], $qte);
            array_push($_SESSION['panier']['prix'], $prix);
            array_push($_SESSION['panier']['repas'], $repas);
            array_push($_SESSION['panier']['genre'], $genre);
            array_push($_SESSION['panier']['description'], $description);
            if ($genre == 2) {
                $_SESSION['dessert'] = 1;
            } elseif ($genre == 1) {
                $_SESSION['entree'] = 1;
            } elseif ($genre == 0) {
                $_SESSION['plats'] = 1;
            }
        }
        $mont_ht = 0;
        $nb_articles = count($_SESSION['panier']['id_article']);
        for ($i = 0; $i < $nb_articles; $i++) {
            $mont_ht += $_SESSION['panier']['qte'][$i] * $_SESSION['panier']['prix'][$i];
        }
        $total1 = $mont_ht;
        $total = total($total1, $tva_fact, $remise_fact);
        $mont_tva = tva($total, $tva_fact, $remise_fact);
        $mont_rmz = remise($total1, $tva_fact, $remise_fact);
        $mont_ht = ht($total, $tva_fact, $remise_fact);

        $ttc = ttc($mont_ht, $mont_tva, $mont_rmz);
        $ttc2 =  montant_equivalent_bdd('CDF', 'USD', $tauxfct, $ttc);
        $_SESSION['panier']['mont_tva'] = $mont_tva;
        $_SESSION['panier']['mont_ttc'] = $mont_ht - $mont_rmz;
        $_SESSION['panier']['mont_remise'] = $mont_rmz;
        $_SESSION['panier']['mont_ht'] = $mont_ht;
        $_SESSION['panier']['mont_ttc_remise'] = $ttc;
        $_SESSION['ttc2'] = $ttc2;
    }
}

function ReimprimerBonCuisine($id_fact, $bdd)
{
    $tva_fact = 0;
    $tauxfct = 1;
    $remise_fact = 0;
    $_SESSION['dessert'] = 0;
    $_SESSION['entree'] = 0;
    $_SESSION['plats'] = 0;
    $_SESSION['panier'] = array();
    $_SESSION['panier']['id_article'] = array();
    $_SESSION['panier']['nom'] = array();
    $_SESSION['panier']['qte'] = array();
    $_SESSION['panier']['prix'] = array();
    $_SESSION['panier']['repas'] = array();
    $_SESSION['panier']['genre'] = array();
    $_SESSION['panier']['pa'] = array();
    $_SESSION['panier']['description'] = array();
    $_SESSION['panier']['id_client'] = 0;
    $_SESSION['panier']['remise'] = 0;
    $_SESSION['panier']['mont_tva'] = 0;
    $_SESSION['panier']['mont_ttc'] = 0;
    $_SESSION['panier']['mont_ttc_remise'] = 0;
    $_SESSION['panier']['verrouille'] = false;
    $idcmd = $id_fact;
    $requete = $bdd->prepare("SELECT f.usercancel,f.note_cmd,f.id_fact, f.montant_total,f.mont_tva,f.mont_ttc,f.date_edition,f.dte_time,f.mode,f.mont_ttc_remise,f.taux,f.tva,f.id_fact,f.num_fact,
                                f.id_res,c.designation,c.id_client,c.nom_client,c.designation,c.type,d.nom_user,d.prenom_user,f.nbrcouvert AS nbrcouvertfac,f.preparer,f.etat_cmd
                                FROM  t_client AS c,t_facture AS f,t_utilisateur AS d
                                 WHERE f.id_client=c.id_client AND f.id_user=d.id_user 
                                       AND f.id_fact=:cmd_id");
    $requete->BindParam(':cmd_id', $idcmd);
    $requete->execute();
    $reservation_attente = $requete->fetchAll(PDO::FETCH_OBJ);
    foreach ($reservation_attente as $ra) {
        $_SESSION['nbrcouvert'] = $ra->nbrcouvertfac;
        $id = $ra->id_res;
        $id_fact = $ra->id_fact;
        $remise_fact = $ra->mont_ttc_remise;
        $mont_remise = $ra->tva;
        $tva_fact = $ra->tva;
        $mont_tva = $ra->mont_tva;
        $mont_ttc = $ra->mont_ttc;
        $id_cl = $ra->id_client;
        // $cmd_num = $ra->num_reserv;
        $tbl = $ra->designation;
        $cl = $ra->nom_client;
        $tauxfct = $ra->taux;
        $_SESSION['mode_fact'] = $ra->mode;
        $_SESSION['nom_user'] = $ra->nom_user;
        $_SESSION['date_edition'] = $ra->date_edition;
        //        $_SESSION['date_edition2'] = $ra->dte_time;
        $_SESSION['date_edition2'] = $ra->dte_time;
        $typ = $ra->type;
        if ($typ == 'client' || $typ == 'serveur') {
            $cl_tbl = $cl;
        } else if ($typ == 'table') {
            $cl_tbl = $tbl;
        } else {
            $cl_tbl = 'Occasionnel';
        }
        $_SESSION['num_commande'] = $ra->num_fact;
        $_SESSION['nom_client'] = $cl_tbl;
        $_SESSION['id_client'] = $id_cl;
        $statut = 'En cours';
        if ($ra->preparer == 1) {
            $statut = 'Preparé';
        }
        if ($ra->etat_cmd == 3) {
            $statut = 'Annulé';
        }
        $_SESSION['preparer'] = $ra->preparer;
        $_SESSION['etat_cmd'] = $ra->etat_cmd;
        $_SESSION['statut_cmd'] = $statut;
        $note_cmd = $ra->note_cmd;
        $_SESSION['note_cmd'] = $note_cmd;
        $_SESSION['usercancel'] = $ra->usercancel;
        $requete = $bdd->prepare("SELECT  p.idprod,p.designation,p.monnaie,p.repas,ss.genre,l.*
                                    FROM  lignes_commandes AS l,stk_produit As p,stk_sous_famille AS ss
                                    WHERE l.produit_id=p.idprod AND p.famille_id=ss.id_s_fam 
                                     AND l.commande_id=:cmd_id");
        $requete->BindParam(':cmd_id', $id_fact);
        $requete->execute();
        $reservation_l_attente = $requete->fetchAll(PDO::FETCH_OBJ);
        foreach ($reservation_l_attente as $r) {
            $qte = $r->qte;
            $lignecmd_id = $r->id;
            if (round($r->qte) == 0) {
                $qte = $r->qteoffert;
            }
            $prix = $r->prix;
            $idprod = $r->idprod;
            $designation = $r->designation;

            $repas = $r->repas;
            $genre = $r->genre;
            $impr = $r->impr;
            if ($impr == 1) {
                if ($r->qte2 != 0) {
                    $qte = $r->qte2;
                }
            }
            $des_plt = $r->accomp;
            $pa = $r->pa;

            array_push($_SESSION['panier']['id_article'], $idprod);
            array_push($_SESSION['panier']['nom'], $designation);
            array_push($_SESSION['panier']['qte'], $qte);
            array_push($_SESSION['panier']['prix'], $prix);
            array_push($_SESSION['panier']['repas'], $repas);
            array_push($_SESSION['panier']['genre'], $genre);
            array_push($_SESSION['panier']['pa'], $pa);
            array_push($_SESSION['panier']['description'], $des_plt);
            if ($genre == 2) {
                $_SESSION['dessert'] = 1;
            } elseif ($genre == 1) {
                $_SESSION['entree'] = 1;
            } elseif ($genre == 0) {
                $_SESSION['plats'] = 1;
            }
        }
        $mont_ht = 0;
        $nb_articles = count($_SESSION['panier']['id_article']);
        for ($i = 0; $i < $nb_articles; $i++) {
            $mont_ht += $_SESSION['panier']['qte'][$i] * $_SESSION['panier']['prix'][$i];
        }
        $total1 = $mont_ht;
        $total = total($total1, $tva_fact, $remise_fact);
        //        $mont_tva=tva($total,$tva_fact,$remise_fact);
        $mont_rmz = remise($total1, $tva_fact, $remise_fact);
        $mont_ht = ht($total, $tva_fact, $remise_fact);

        $ttc = ttc($mont_ht, $mont_tva, $mont_rmz);
        $ttc2 =  montant_equivalent_bdd('CDF', 'USD', $tauxfct, $ttc);
        $_SESSION['panier']['mont_tva'] = $mont_tva;
        $_SESSION['panier']['mont_ttc'] = $mont_ht - $mont_rmz;
        $_SESSION['panier']['mont_remise'] = $mont_rmz;
        $_SESSION['panier']['mont_ht'] = $mont_ht;
        $_SESSION['panier']['mont_ttc_remise'] = $ttc;
        $_SESSION['ttc2'] = $ttc2;
    }
}

function listaccompagnements2($bdd)
{
    $id = 32;
    $requete = $bdd->prepare("SELECT * FROM stk_produit AS a WHERE a.pseudo_supp=0 AND a.famille_id=:id ORDER BY  a.designation");
    $requete->BindParam(':id', $id);
    $requete->execute();
    $st = $requete->fetchAll(PDO::FETCH_OBJ);
    return $st;
}

function SelectSOFT($bdd)
{
    //$id = 47;
    $requete = $bdd->prepare("SELECT * FROM stk_produit AS a WHERE a.pseudo_supp=0 AND a.famille_id IN (21,12) ORDER BY  a.designation");
    // $requete->BindParam(':id', $id);
    $requete->execute();
    $st = $requete->fetchAll(PDO::FETCH_OBJ);
    return $st;
}
function SelectSOFTBTL($bdd)
{
    //$id = 47;
    $requete = $bdd->prepare("SELECT * FROM stk_produit AS a WHERE a.pseudo_supp=0 AND a.famille_id IN (47,12) ORDER BY  a.designation");
    // $requete->BindParam(':id', $id);
    $requete->execute();
    $st = $requete->fetchAll(PDO::FETCH_OBJ);
    return $st;
}
function SelectLegumes($bdd)
{
    $id = 31;
    $requete = $bdd->prepare("SELECT * FROM stk_produit AS a WHERE a.pseudo_supp=0 AND a.famille_id=:id ORDER BY  a.designation");
    $requete->BindParam(':id', $id);
    $requete->execute();
    $st = $requete->fetchAll(PDO::FETCH_OBJ);
    return $st;
}
function SelectBouteilles($bdd)
{
    $data = array();
    $id = 20;
    $requete = $bdd->prepare("SELECT * FROM stk_produit AS a WHERE a.pseudo_supp=0 AND a.famille_id=:id ORDER BY  a.designation");
    $requete->BindParam(':id', $id);
    $requete->execute();
    $st = $requete->fetchAll(PDO::FETCH_OBJ);
    foreach ($st as $r) {
        $idprod = $r->idprod;
        array_push($data, $idprod);
    }
    return $data;
}

function ListAccompagnementsUPDT($plat_id, $hotel_id, $bdd)
{
    $requete = $bdd->prepare("SELECT * FROM t_accompagnement WHERE plat_id=:plat_id AND hotel_id=:hotel_id");
    $requete->BindParam(':plat_id', $plat_id);
    $requete->BindParam(':hotel_id', $hotel_id);
    $requete->execute();
    $result = $requete->fetchAll(PDO::FETCH_OBJ);
    return $result;
}
function EnregAccompBoisson($site_id, $idprod, $accboissonvalues, $idtab, $bdd)
{
    $nb = 0;
    $bool = 0;
    $requete = $bdd->prepare("SELECT COUNT(*) AS nb_lg FROM accompagnment_boisson_values WHERE idboisson=:idboisson  AND site_id=:site_id AND idtab=:idtab");
    /* monnaie Mis pour les besoins de la cause */
    $requete->BindParam(':idboisson', $idprod);
    $requete->BindParam(':site_id', $site_id);
    $requete->BindParam(':idtab', $idtab);
    $requete->execute();
    $operations = $requete->fetchAll(PDO::FETCH_OBJ);
    foreach ($operations as $op) :
        $nb = $op->nb_lg;
    endforeach;
    if ($nb > 0) $bool = 1;

    if ($bool == 0) {
        $requete = $bdd->prepare("INSERT INTO accompagnment_boisson_values (idboisson,chainevalue,site_id,idtab)
                VALUES(:idboisson,:chainevalue,:site_id,:idtab)");
        $requete->BindParam(':idboisson', $idprod);
        $requete->BindParam(':chainevalue', $accboissonvalues);
        $requete->BindParam(':site_id', $site_id);
        $requete->BindParam(':idtab', $idtab);
        $requete->execute();
    } elseif ($bool == 1) {
        $requete = $bdd->prepare("UPDATE accompagnment_boisson_values SET chainevalue=:chainevalue WHERE idboisson=:idboisson AND site_id=:site_id AND idtab=:idtab");
        $requete->BindParam(':chainevalue', $accboissonvalues);
        $requete->BindParam(':idboisson', $idprod);
        $requete->BindParam(':site_id', $site_id);
        $requete->BindParam(':idtab', $idtab);

        $requete->execute();
    }
}
function AffichAccompBoisson($site_id, $idprod, $idtab, $bdd)
{
    $accboissonvalues = "";
    $requete = $bdd->prepare("SELECT chainevalue FROM accompagnment_boisson_values WHERE idboisson=:idboisson  AND site_id=:site_id AND idtab=:idtab");
    $requete->BindParam(':idboisson', $idprod);
    $requete->BindParam(':site_id', $site_id);
    $requete->BindParam(':idtab', $idtab);
    $requete->execute();
    $operations = $requete->fetchAll(PDO::FETCH_OBJ);
    foreach ($operations as $op) :
        $accboissonvalues = $op->chainevalue;
    endforeach;
    return $accboissonvalues;
}

function BonAnnulation($id_fact, $impr, $bdd)
{
    $tva_fact = 0;
    $tauxfct = 1;
    $remise_fact = 0;
    $_SESSION['dessert'] = 0;
    $_SESSION['entree'] = 0;
    $_SESSION['plats'] = 0;
    $_SESSION['panier'] = array();
    $_SESSION['panier']['id_article'] = array();
    $_SESSION['panier']['nom'] = array();
    $_SESSION['panier']['qte'] = array();
    $_SESSION['panier']['prix'] = array();
    $_SESSION['panier']['repas'] = array();
    $_SESSION['panier']['genre'] = array();
    $_SESSION['panier']['pa'] = array();
    $_SESSION['panier']['description'] = array();
    $_SESSION['panier']['id_client'] = 0;
    $_SESSION['panier']['remise'] = 0;
    $_SESSION['panier']['mont_tva'] = 0;
    $_SESSION['panier']['mont_ttc'] = 0;
    $_SESSION['panier']['mont_ttc_remise'] = 0;
    $_SESSION['panier']['verrouille'] = false;
    $idcmd = $id_fact;
    $requete = $bdd->prepare("SELECT f.usercancel,f.id_fact, f.montant_total,f.mont_tva,f.mont_ttc,f.date_edition,f.dte_time,f.mode,f.mont_ttc_remise,f.taux,f.tva,f.id_fact,f.num_fact,
                                f.id_res,c.designation,c.id_client,c.nom_client,c.designation,c.type,d.nom_user,d.prenom_user,c.nbrcouvert
                                FROM  t_client AS c,t_facture AS f,t_utilisateur AS d
                                 WHERE f.id_client=c.id_client AND f.id_user=d.id_user 
                                       AND f.id_fact=:cmd_id");
    $requete->BindParam(':cmd_id', $idcmd);
    $requete->execute();
    $reservation_attente = $requete->fetchAll(PDO::FETCH_OBJ);
    foreach ($reservation_attente as $ra) {
        $_SESSION['nbrcouvert'] = $ra->nbrcouvert;
        $id = $ra->id_res;
        $id_fact = $ra->id_fact;
        $remise_fact = $ra->mont_ttc_remise;
        $mont_remise = $ra->tva;
        $tva_fact = $ra->tva;
        $mont_tva = $ra->mont_tva;
        $mont_ttc = $ra->mont_ttc;
        $id_cl = $ra->id_client;
        $cmd_num = @$ra->num_reserv;
        $tbl = $ra->designation;
        $cl = $ra->nom_client;
        $tauxfct = $ra->taux;
        $_SESSION['mode_fact'] = $ra->mode;
        $_SESSION['nom_user'] = $ra->nom_user;
        $_SESSION['date_edition'] = $ra->date_edition;
        //        $_SESSION['date_edition2'] = $ra->dte_time;
        $_SESSION['date_edition2'] = $ra->dte_time;
        $typ = $ra->type;
        if ($typ == 'client' || $typ == 'serveur') {
            $cl_tbl = $cl;
        } else if ($typ == 'table') {
            $cl_tbl = $tbl;
        } else {
            $cl_tbl = 'Occasionnel';
        }
        $_SESSION['num_commande'] = $ra->num_fact;
        $_SESSION['nom_client'] = $cl_tbl;
        $_SESSION['usercancel'] = $ra->usercancel;
        $requete = $bdd->prepare("SELECT  p.idprod,p.designation,p.monnaie,p.repas,ss.genre,l.*
                                    FROM  lignes_commandes AS l,stk_produit As p,stk_sous_famille AS ss
                                    WHERE l.produit_id=p.idprod AND p.famille_id=ss.id_s_fam 
                                     AND l.commande_id=:cmd_id");
        $requete->BindParam(':cmd_id', $id_fact);
        $requete->execute();
        $reservation_l_attente = $requete->fetchAll(PDO::FETCH_OBJ);
        foreach ($reservation_l_attente as $r) {
            $qte = $r->qte;
            $lignecmd_id = $r->id;
            if (round($r->qte) == 0) {
                $qte = $r->qteoffert;
            }
            $prix = $r->prix;
            $idprod = $r->idprod;
            $designation = $r->designation;

            $repas = $r->repas;
            $genre = $r->genre;
            $impr = $r->impr;
            if ($impr == 1) {
                if ($r->qte2 != 0) {
                    $qte = $r->qte2;
                }
            }
            $des_plt = $r->accomp;
            $pa = $r->pa;
            array_push($_SESSION['panier']['id_article'], $idprod);
            array_push($_SESSION['panier']['nom'], $designation);
            array_push($_SESSION['panier']['qte'], $qte);
            array_push($_SESSION['panier']['prix'], $prix);
            array_push($_SESSION['panier']['repas'], $repas);
            array_push($_SESSION['panier']['genre'], $genre);
            array_push($_SESSION['panier']['pa'], $pa);
            array_push($_SESSION['panier']['description'], $des_plt);
            if ($genre == 2) {
                $_SESSION['dessert'] = 1;
            } elseif ($genre == 1) {
                $_SESSION['entree'] = 1;
            } elseif ($genre == 0) {
                $_SESSION['plats'] = 1;
            }
        }
        $mont_ht = 0;
        $nb_articles = count($_SESSION['panier']['id_article']);
        for ($i = 0; $i < $nb_articles; $i++) {
            $mont_ht += $_SESSION['panier']['qte'][$i] * $_SESSION['panier']['prix'][$i];
        }
        $total1 = $mont_ht;
        $total = total($total1, $tva_fact, $remise_fact);
        //        $mont_tva=tva($total,$tva_fact,$remise_fact);
        $mont_rmz = remise($total1, $tva_fact, $remise_fact);
        $mont_ht = ht($total, $tva_fact, $remise_fact);

        $ttc = ttc($mont_ht, $mont_tva, $mont_rmz);
        $ttc2 =  montant_equivalent_bdd('CDF', 'USD', $tauxfct, $ttc);
        $_SESSION['panier']['mont_tva'] = $mont_tva;
        $_SESSION['panier']['mont_ttc'] = $mont_ht - $mont_rmz;
        $_SESSION['panier']['mont_remise'] = $mont_rmz;
        $_SESSION['panier']['mont_ht'] = $mont_ht;
        $_SESSION['panier']['mont_ttc_remise'] = $ttc;
        $_SESSION['ttc2'] = $ttc2;
    }
}

function ReimprimerPOS2($id_fact, $bdd)
{
    $tva_fact = 0;
    $tauxfct = 1;
    $remise_fact = 0;
    $_SESSION['panier1'] = array();
    $_SESSION['panier1']['id_article'] = array();
    $_SESSION['panier1']['nom'] = array();
    $_SESSION['panier1']['qte'] = array();
    $_SESSION['panier1']['prix'] = array();
    $_SESSION['panier1']['repas'] = array();
    $_SESSION['panier1']['id_client'] = 0;
    $_SESSION['panier1']['remise'] = 0;
    $_SESSION['panier1']['mont_tva'] = 0;
    $_SESSION['panier1']['mont_ttc'] = 0;
    $_SESSION['panier1']['mont_ttc_remise'] = 0;
    $_SESSION['panier1']['verrouille'] = false;
    $idcmd = $id_fact;
    $requete = $bdd->prepare("SELECT f.id_fact, f.montant_total,f.mont_tva,f.mont_ttc,f.date_edition,f.dte_time,f.mode,f.mont_ttc_remise,f.taux,f.tva,f.id_fact,f.num_fact,
                                f.id_res,c.designation,c.id_client,c.nom_client,c.designation,c.type,d.nom_user,d.prenom_user,f.nbrcouvert,f.nomcaisse
                                FROM  t_client AS c,t_facture AS f,t_utilisateur AS d
                                 WHERE f.id_client=c.id_client AND f.id_user=d.id_user 
                                       AND c.user_attente=d.id_user
                                       AND f.id_fact=:cmd_id");
    $requete->BindParam(':cmd_id', $idcmd);
    $requete->execute();
    $reservation_attente = $requete->fetchAll(PDO::FETCH_OBJ);
    foreach ($reservation_attente as $ra) {
        $id = $ra->id_res;
        $id_fact = $ra->id_fact;
        $remise_fact = $ra->mont_ttc_remise;
        $mont_remise = $ra->tva;
        $tva_fact = $ra->tva;
        $mont_tva = $ra->mont_tva;
        $mont_ttc = $ra->mont_ttc;
        $id_cl = $ra->id_client;
        //  $cmd_num = $ra->num_reserv;
        $tbl = $ra->designation;
        $cl = $ra->nom_client;
        $tauxfct = $ra->taux;
        $_SESSION['tauxfct'] = $ra->taux;
        $_SESSION['nbrcouvert'] = $ra->nbrcouvert;
        $_SESSION['mode_fact'] = $ra->mode;
        $_SESSION['date_edition'] = $ra->date_edition;
        //      $_SESSION['date_edition2'] = $ra->dte_time;
        $_SESSION['date_edition2'] = $ra->date_edition;
        $_SESSION['nomserveur'] = $ra->nom_user;
        $typ = $ra->type;
        if ($typ == 'client' || $typ == 'serveur') {
            $cl_tbl = $cl;
        } else if ($typ == 'table') {
            $cl_tbl = $tbl;
        } else {
            $cl_tbl = 'Occasionnel';
        }
        $_SESSION['num_commande'] = $ra->num_fact;
        $_SESSION['nom_client'] = $cl_tbl;
        $requete = $bdd->prepare("SELECT  p.idprod,p.designation,p.monnaie,p.repas,l.*
                                    FROM  lignes_commandes AS l,stk_produit As p 
                                    WHERE l.produit_id=p.idprod AND l.commande_id=:cmd_id");
        $requete->BindParam(':cmd_id', $id_fact);
        $requete->execute();
        $reservation_l_attente = $requete->fetchAll(PDO::FETCH_OBJ);
        foreach ($reservation_l_attente as $r) {
            $qte = $r->qte;
            if (round($r->qte) == 0) {
                $qte = $r->qteoffert;
            }
            $prix = $r->prix;
            $idprod = $r->idprod;
            $designation = $r->designation;
            if ($r->accomp != '') {
                $designation = $r->designation . ' avec ' . $r->accomp;
            }
            $repas = $r->repas;

            array_push($_SESSION['panier1']['id_article'], $idprod);
            array_push($_SESSION['panier1']['nom'], $designation);
            array_push($_SESSION['panier1']['qte'], $qte);
            array_push($_SESSION['panier1']['prix'], $prix);
            array_push($_SESSION['panier1']['repas'], $repas);
        }
        $mont_ht = 0;
        $nb_articles = count($_SESSION['panier1']['id_article']);
        for ($i = 0; $i < $nb_articles; $i++) {
            $mont_ht += $_SESSION['panier1']['qte'][$i] * $_SESSION['panier1']['prix'][$i];
        }
        $total1 = $mont_ht;
        $total = total($total1, $tva_fact, $remise_fact);
        //        $mont_tva=tva($total,$tva_fact,$remise_fact);
        $mont_rmz = remise($total1, $tva_fact, $remise_fact);
        $mont_ht = ht($total, $tva_fact, $remise_fact);

        $ttc = ttc($mont_ht, $mont_tva, $mont_rmz);
        $ttc2 =  montant_equivalent_bdd('CDF', 'USD', $tauxfct, $ttc);
        $_SESSION['panier1']['mont_tva'] = $mont_tva;
        $_SESSION['panier1']['mont_ttc'] = $mont_ht - $mont_rmz;
        $_SESSION['panier1']['mont_remise'] = $mont_rmz;
        $_SESSION['panier1']['mont_ht'] = $mont_ht;
        $_SESSION['panier1']['mont_ttc_remise'] = $ttc;
        $_SESSION['ttc2'] = $ttc2;
    }
}
function DetailsVenteTout($date_bd1, $date_bd2,$serveur_id, $bdd)
{
    $idsite = $_SESSION['id_hotel'];
    $q1="SELECT a.id_sousresto,e.familletype_id,b.prixremise,a.taux_prix,a.monnaie,a.mode,a.mont_ttc_remise,c.idprod,c.code, c.designation,c.repas,c.nourriture,
    SUM(b.qte) AS qte, b.prixremise AS pu, b.dte_h,a.mode AS lib,SUM(((b.qte*b.prix)-((b.qte*b.prix*a.mont_ttc_remise)/100))/a.taux_prix) AS mont,
    SUM(b.qteoffert) AS qteoffert,SUM(b.qteoffert*b.prix2) AS montof
    FROM lignes_commandes AS b, stk_produit AS c, t_facture AS a,
    stk_sous_famille AS d,stk_famille AS e,stk_familletype AS f
    WHERE a.id_fact=b.commande_id 
    AND b.produit_id= c.idprod
    AND c.famille_id=d.id_s_fam
    AND d.famille=e.idfamille
    AND e.familletype_id=f.id
    AND a.mode IS NOT NULL
    AND a.date_edition  BETWEEN :date_bd1 AND :date_bd2
    AND a.id_hotel  =:id_hotel";
    $q3=" GROUP BY c.idprod, b.prixremise, a.mode  
    ORDER BY c.nourriture,c.designation";
    $q2="";
    if($serveur_id!=0){
        $q2=" AND a.id_user=:id_user";
    }
    $q=$q1.$q2.$q3;
    $requete = $bdd->prepare($q);
    $requete->BindParam(':date_bd1', $date_bd1);
    $requete->BindParam(':date_bd2', $date_bd2);
    $requete->BindParam(':id_hotel', $idsite);
    if($serveur_id!=0){
        $requete->BindParam(':id_user', $serveur_id);
    }
    $requete->execute();
    $articles3 = $requete->fetchAll(PDO::FETCH_OBJ);
    return $articles3;
}
function DetailsVentePos($date_bd1, $date_bd2, $pos_id,$serveur_id, $bdd)
{
    $idsite = $_SESSION['id_hotel'];
    $q1="SELECT a.id_sousresto,e.familletype_id,b.prixremise,a.taux_prix,a.monnaie,a.mode,a.mont_ttc_remise,c.idprod,c.code, c.designation,c.repas,c.nourriture,
    SUM(b.qte) AS qte, b.prixremise AS pu, b.dte_h,a.mode AS lib,SUM(((b.qte*b.prix)-((b.qte*b.prix*a.mont_ttc_remise)/100))/a.taux_prix) AS mont,
    SUM(b.qteoffert) AS qteoffert,SUM(b.qteoffert*b.prix2) AS montof
    FROM lignes_commandes AS b, stk_produit AS c, t_facture AS a,
    stk_sous_famille AS d,stk_famille AS e,stk_familletype AS f
    WHERE a.id_fact=b.commande_id 
    AND b.produit_id= c.idprod
    AND c.famille_id=d.id_s_fam
    AND d.famille=e.idfamille
    AND e.familletype_id=f.id
    AND a.mode IS NOT NULL
    AND a.date_edition  BETWEEN :date_bd1 AND :date_bd2
    AND a.id_hotel =:id_hotel 
    AND a.id_sousresto =:id_sousresto";
    $q2="";
    if($serveur_id!=0){
        $q2=" AND a.id_user=:id_user";
    }
    $q3=" GROUP BY c.idprod, b.prixremise, a.mode  
    ORDER BY c.nourriture,c.designation";
    $q=$q1.$q2.$q3;
    $requete = $bdd->prepare($q);
    $requete->BindParam(':date_bd1', $date_bd1);
    $requete->BindParam(':date_bd2', $date_bd2);
    $requete->BindParam(':id_hotel', $idsite);
    $requete->BindParam(':id_sousresto', $pos_id);
    if($serveur_id!=0){
    $requete->BindParam(':id_user', $serveur_id);
    }
    $requete->execute();
    $articles3 = $requete->fetchAll(PDO::FETCH_OBJ);
    return $articles3;
}
function NombreCouvert($date_bd1, $date_bd2,$serveur_id,$pos_id, $bdd)
{
    $idsite = $_SESSION['id_hotel'];
    $nbrcouvert = 0;
    $q1="SELECT SUM(a.nbrcouvert) AS nbrcouvert
    FROM  t_facture AS a
    WHERE a.date_edition  BETWEEN :date_bd1 AND :date_bd2
    AND a.id_hotel  =:id_hotel 
    AND a.etat_cmd NOT IN('1','3')";
    $q2="";
    if($serveur_id!=0){
        $q2=" AND a.id_user=:id_user";
    }
    $q3="";
    if($pos_id!=0){
        $q3=" AND a.id_sousresto  =:id_sousresto";
    }
    $q=$q1.$q2.$q3;
    $requete = $bdd->prepare($q);
    $requete->BindParam(':date_bd1', $date_bd1);
    $requete->BindParam(':date_bd2', $date_bd2);
    $requete->BindParam(':id_hotel', $idsite);
    if($serveur_id!=0){
        $requete->BindParam(':id_user', $serveur_id);
        }
    if($pos_id!=0){
    $requete->BindParam(':id_sousresto', $pos_id);
    }
    $requete->execute();
    $articles3 = $requete->fetchAll(PDO::FETCH_OBJ);
    foreach ($articles3 as $sr) {
        $nbrcouvert = $sr->nbrcouvert;
    }
    return $nbrcouvert;
}

function NombreCouvertPos($date_bd1, $date_bd2, $pos_id, $bdd)
{
    $idsite = $_SESSION['id_hotel'];
    $nbrcouvert = 0;
    $q1="";
    $requete = $bdd->prepare("SELECT SUM(a.nbrcouvert) AS nbrcouvert
        FROM  t_facture AS a
        WHERE a.date_edition  BETWEEN :date_bd1 AND :date_bd2
        AND a.id_hotel  =:id_hotel 
        AND a.id_sousresto  =:id_sousresto 
        AND a.etat_cmd NOT IN('1','3')
        ");
    $requete->BindParam(':date_bd1', $date_bd1);
    $requete->BindParam(':date_bd2', $date_bd2);
    $requete->BindParam(':id_hotel', $idsite);
    $requete->BindParam(':id_sousresto', $pos_id);
    $requete->execute();
    $articles3 = $requete->fetchAll(PDO::FETCH_OBJ);
    foreach ($articles3 as $sr) {
        $nbrcouvert = $sr->nbrcouvert;
    }
    return $nbrcouvert;
}
function SelectVolalles($bdd)
{
    $id = 34;
    $d = array();
    $requete = $bdd->prepare("SELECT * FROM stk_produit AS a WHERE a.pseudo_supp=0 AND a.famille_id=:id ORDER BY  a.designation");
    $requete->BindParam(':id', $id);
    $requete->execute();
    $volailles = $requete->fetchAll(PDO::FETCH_OBJ);
    foreach ($volailles as $sr) {
        $idprod = $sr->idprod;
        array_push($d, $idprod);
    }
    return $d;
}

function CheckAllCmdCustomer($id, $bdd)
{
    $req = "
        SELECT a.*,c.id_client,
        c.nom_client,c.designation,c.type,c.adresse_provenance_client,c.email_client,c.telephone_client,c.sexe_client
            FROM t_facture a,t_client c
             WHERE a.id_client=c.id_client
                   AND a.id_client=:id_client
                   AND a.etat_cmd=1
                   ";
    $requete = $bdd->prepare($req);
    $requete->BindParam(':id_client', $id);
    $requete->execute();
    $bool = 0;
    $nblgn = $requete->rowCount();
    if ($nblgn > 0) {
        $bool = 1;
    }

    return $bool;
}
function InfosUser($id_user, $bdd)
{
    $datas = array();
    $datas['nom_user'] = 0;
    $datas['prenom_user'] = 0;
    $requete = $bdd->prepare("SELECT * FROM  t_utilisateur WHERE id_user=:id_user");
    $requete->BindParam(':id_user', $id_user);
    $requete->execute();
    $result = $requete->fetchAll(PDO::FETCH_OBJ);
    foreach ($result as $r) {
        $datas['nom_user'] = $r->nom_user;
        $datas['prenom_user'] = $r->prenom_user;
    }
    return $datas;
}
function DetailsVenteServeur($date_bd1, $date_bd2, $serveur_id, $bdd)
{
    $idsite = $_SESSION['id_hotel'];
    $requete = $bdd->prepare("SELECT e.familletype_id,b.prixremise,a.taux_prix,a.monnaie,a.mode,a.mont_ttc_remise,c.idprod,c.code, c.designation,c.repas,c.nourriture,
    SUM(b.qte) AS qte, b.prixremise AS pu, b.dte_h,a.mode AS lib,SUM((b.qte*b.prixremise)/a.taux_prix) AS mont,
    SUM(b.qteoffert) AS qteoffert,SUM(b.qteoffert*b.prix2) AS montof
FROM lignes_commandes AS b, stk_produit AS c, t_facture AS a,
stk_sous_famille AS d,stk_famille AS e,stk_familletype AS f
WHERE a.id_fact=b.commande_id 
AND b.produit_id= c.idprod
AND c.famille_id=d.id_s_fam
AND d.famille=e.idfamille
AND e.familletype_id=f.id
AND a.mode IS NOT NULL
AND a.date_edition  BETWEEN :date_bd1 AND :date_bd2
AND a.id_hotel  =:id_hotel
AND a.id_user  =:id_user 
GROUP BY c.idprod, b.prixremise, a.mode  
ORDER BY c.nourriture,c.designation");
    $requete->BindParam(':date_bd1', $date_bd1);
    $requete->BindParam(':date_bd2', $date_bd2);
    $requete->BindParam(':id_hotel', $idsite);
    $requete->BindParam(':id_user', $serveur_id);
    $requete->execute();
    $articles3 = $requete->fetchAll(PDO::FETCH_OBJ);
    return $articles3;
}
function NombreCouvertServeur($date_bd1, $date_bd2, $serveur_id, $bdd)
{
    $idsite = $_SESSION['id_hotel'];
    $nbrcouvert = 0;
    $requete = $bdd->prepare("SELECT SUM(a.nbrcouvert) AS nbrcouvert
        FROM  t_facture AS a
        WHERE a.date_edition  BETWEEN :date_bd1 AND :date_bd2
        AND a.id_hotel  =:id_hotel 
        AND a.id_user  =:id_user 
        AND a.etat_cmd NOT IN('1','3')
        ");
    $requete->BindParam(':date_bd1', $date_bd1);
    $requete->BindParam(':date_bd2', $date_bd2);
    $requete->BindParam(':id_hotel', $idsite);
    $requete->BindParam(':id_user', $serveur_id);
    $requete->execute();
    $articles3 = $requete->fetchAll(PDO::FETCH_OBJ);
    foreach ($articles3 as $sr) {
        $nbrcouvert = $sr->nbrcouvert;
    }
    return $nbrcouvert;
}
function CheckDetailsProduit($idprod, $bdd)
{

    $requete = $bdd->prepare("SELECT * FROM  stk_produit WHERE idprod=:idprod");
    $requete->BindParam(':idprod', $idprod);
    $requete->execute();
    $result = $requete->fetch(PDO::FETCH_OBJ);
    return $result;
}
function SelectBIERE($bdd)
{
    // $id =14;
    $requete = $bdd->prepare("SELECT * FROM stk_produit AS a WHERE a.pseudo_supp=0 AND a.famille_id IN(289,12) ORDER BY  a.designation");
    //  $requete->BindParam(':id', $id);
    $requete->execute();
    $st = $requete->fetchAll(PDO::FETCH_OBJ);
    return $st;
}
function SelectSucres($bdd)
{
    // $id =14;
    $requete = $bdd->prepare("SELECT * FROM stk_produit AS a WHERE a.pseudo_supp=0 AND a.famille_id IN(286,12) ORDER BY  a.designation");
    //  $requete->BindParam(':id', $id);
    $requete->execute();
    $st = $requete->fetchAll(PDO::FETCH_OBJ);
    return $st;
}


function ReinitialiserPanier()
{
    $_SESSION['panier'] = array();
    $_SESSION['panier']['cpt'] = array();
    $_SESSION['panier']['id_article'] = array();
    $_SESSION['panier']['nom'] = array();
    $_SESSION['panier']['qte'] = array();
    $_SESSION['panier']['qteoffert'] = array();
    $_SESSION['panier']['pa'] = array();
    $_SESSION['panier']['description'] = array();
    $_SESSION['panier']['prix'] = array();
    $_SESSION['panier']['prix2'] = array();
    $_SESSION['panier']['repas'] = array();
    $_SESSION['panier']['offre'] = array();
    $_SESSION['panier']['genre'] = array();
    $_SESSION['panier']['id_client'] = 0;
    $_SESSION['panier']['remise'] = 0;
    $_SESSION['panier']['mont_tva'] = 0;
    $_SESSION['panier']['mont_ttc'] = 0;
    $_SESSION['panier']['mont_ttc_remise'] = 0;
    $_SESSION['panier']['verrouille'] = false;
    $_SESSION['cptpanier'] = 0;
    $_SESSION['panier']['qi'] = array();
    $_SESSION['panier']['qlimit'] = array();
}

function insertMonitoringCommande($agent, $qte, $produit_id, $description, $facture_id, $suppr, $prix, $monnaie, $repas, $bdd)
{
    $dte_time = date('Y-m-d H:i:s');
    $heure = date('H:i:s');
    $requete = $bdd->prepare("INSERT INTO suivifactures(dte_time,heure,agent,qte,produit_id,facture_id,suppr,description,prix,monnaie,repas)
                VALUES(:dte_time,:heure,:agent,:qte,:produit_id,:facture_id,:suppr,:description,:prix,:monnaie,:repas)");
    $requete->BindParam(':dte_time', $dte_time);
    $requete->BindParam(':heure', $heure);
    $requete->BindParam(':agent', $agent);
    $requete->BindParam(':qte', $qte);
    $requete->BindParam(':produit_id', $produit_id);
    $requete->BindParam(':facture_id', $facture_id);
    $requete->BindParam(':suppr', $suppr);
    $requete->BindParam(':description', $description);
    $requete->BindParam(':prix', $prix);
    $requete->BindParam(':monnaie', $monnaie);
    $requete->BindParam(':repas', $repas);
    $requete->execute();
}
function insertMonitoringCommande2($agent, $qte, $produit_id, $description, $facture_id, $suppr, $prix, $monnaie, $repas, $admin, $site_id, $bdd)
{
    $dte_time = date('Y-m-d H:i:s');
    $dte = date('Y-m-d');
    $heure = date('H:i:s');
    $requete = $bdd->prepare("INSERT INTO suivifactures(dte_time,heure,agent,qte,produit_id,facture_id,suppr,description,prix,monnaie,dte,repas,admin,site_id)
                VALUES(:dte_time,:heure,:agent,:qte,:produit_id,:facture_id,:suppr,:description,:prix,:monnaie,:dte,:repas,:admin,:site_id)");
    $requete->BindParam(':dte_time', $dte_time);
    $requete->BindParam(':heure', $heure);
    $requete->BindParam(':agent', $agent);
    $requete->BindParam(':qte', $qte);
    $requete->BindParam(':produit_id', $produit_id);
    $requete->BindParam(':facture_id', $facture_id);
    $requete->BindParam(':suppr', $suppr);
    $requete->BindParam(':description', $description);
    $requete->BindParam(':prix', $prix);
    $requete->BindParam(':monnaie', $monnaie);
    $requete->BindParam(':dte', $dte);
    $requete->BindParam(':repas', $repas);
    $requete->BindParam(':admin', $admin);
    $requete->BindParam(':site_id', $site_id);
    $requete->execute();
}

function SelectProduitsMonitoringGroupes($facture_id, $bdd)
{
    $requete = $bdd->prepare("SELECT a.produit_id,SUM(a.qte) AS qte,b.designation FROM suivifactures AS a, stk_produit AS b 
                            WHERE a.produit_id=b.idprod AND  a.facture_id=:facture_id GROUP BY a.produit_id ORDER BY a.heure,b.designation");
    $requete->BindParam(':facture_id', $facture_id);
    $requete->execute();
    $st = $requete->fetchAll(PDO::FETCH_OBJ);
    return $st;
}
function SelectProduitsMonitoringDetails($facture_id, $bdd)
{
    $requete = $bdd->prepare("SELECT a.*,b.designation FROM suivifactures AS a, stk_produit AS b 
                            WHERE a.produit_id=b.idprod AND a.facture_id=:facture_id ORDER BY a.heure");
    $requete->BindParam(':facture_id', $facture_id);
    $requete->execute();
    $st = $requete->fetchAll(PDO::FETCH_OBJ);
    return $st;
}
//Confinement
function AllCommmandesFusion($id, $type, $dte1, $dte2, $bdd)
{
    if ($id > 0) {

        //Retourne toutes les commandes du sous-resto
        $req = "
        SELECT a.*,d.*,c.designation AS tab2,a.justification AS idtab1
            FROM t_facture AS a,t_client AS c,t_utilisateur AS d
             WHERE a.id_client=c.id_client
                   AND a.id_user=d.id_user 
                   AND a.id_sousresto=:id
                   AND a.fusion=1
                   AND a.type=:type
                   AND a.date_edition BETWEEN :dte1 AND :dte2
                   ";
        $requete = $bdd->prepare($req);
        $requete->BindParam(':id', $id);
        $requete->BindParam(':type', $type);
        $requete->BindParam(':dte1', $dte1);
        $requete->BindParam(':dte2', $dte2);
        $requete->execute();
        $result = $requete->fetchAll(PDO::FETCH_OBJ);
        return $result;
    } else {
        $req = "
        SELECT a.*,d.*,c.designation AS tab2,a.justification AS idtab1
            FROM t_facture AS a,t_client AS c,t_utilisateur AS d
             WHERE  a.id_client=c.id_client
                   AND a.id_user=d.id_user 
                   AND a.fusion=1
                   AND a.type=:type
                   AND a.date_edition BETWEEN :dte1 AND :dte2
                   ";
        $requete = $bdd->prepare($req);
        $requete->BindParam(':type', $type);
        $requete->BindParam(':dte1', $dte1);
        $requete->BindParam(':dte2', $dte2);
        $requete->execute();
        $result = $requete->fetchAll(PDO::FETCH_OBJ);
        return $result;
    }
}
function ExtraitDEcompte($idclient, $date_bd1, $date_bd2, $bdd)
{
    $data = array();
    $data['id'] = array();
    $data['date'] = array();
    $data['numfact'] = array();
    $data['numrecu'] = array();
    $data['debitusd'] = array();
    $data['creditusd'] = array();
    $data['debitcdf'] = array();
    $data['creditcdf'] = array();
    $data['taux'] = array();
    $m_affiche = getsymbole_local();
    $requete = $bdd->prepare("SELECT * FROM t_facture AS a, t_client AS b 
                                WHERE a.id_client=b.id_client
                                     AND b.id_client=:idcl
                                     AND a.type='restaurant'
                                     AND a.etat_cmd=0
                                     AND a.date_edition BETWEEN :date_bd1 AND :date_bd2");
    $requete->BindParam(':idcl', $idclient);
    $requete->BindParam(':date_bd1', $date_bd1);
    $requete->BindParam(':date_bd2', $date_bd2);
    $requete->execute();
    $factures = $requete->fetchAll(PDO::FETCH_OBJ);

    foreach ($factures as $fct) {
        $debitusd = 0;
        $debitcdf = 0;
        $numfact = $fct->num_fact;
        $id_fact = $fct->id_fact;
        $taux = $fct->taux;
        $monnaie = $fct->monnaie;
        $date_edition = $fct->date_edition;
        $totalfact = $fct->mont_ttc;
        if ($monnaie == 'CDF') {
            $debitcdf = $totalfact;
        } else {
            $debitusd = $totalfact;
        }
        $requete = $bdd->prepare("SELECT * FROM t_reglement AS c, paiement AS d WHERE c.id_regl=d.regl_id AND c.id_fact=:id_fact ORDER BY c.dte");
        $requete->BindParam(':id_fact', $id_fact);
        $requete->execute();
        $paiements = $requete->fetchAll(PDO::FETCH_OBJ);

        $nbre = count($paiements);
        if ($nbre > 0) {
            foreach ($paiements as $p) {
                $creditusd = 0;
                $creditcdf = 0;
                $numrecu = $p->numero;
                $montantusd = $p->montantusd;
                $montantcdf = $p->montantcdf;
                $creditcdf = $montantcdf;
                $creditusd = $montantusd;
                $taux = $p->taux;
                array_push($data['id'], $id_fact);
                array_push($data['date'], $date_edition);
                if (!in_array($numfact, $data['numfact'])) {
                    array_push($data['numfact'], $numfact);
                } else {
                    array_push($data['numfact'], $numfact);
                    $debitcdf = 0;
                    $debitusd = 0;
                }
                array_push($data['numrecu'], $numrecu);
                array_push($data['debitcdf'], $debitcdf);
                array_push($data['creditcdf'], $creditcdf);
                array_push($data['debitusd'], $debitusd);
                array_push($data['creditusd'], $creditusd);
                array_push($data['taux'], $taux);
            }
        } else {
            array_push($data['id'], $id_fact);
            array_push($data['date'], $date_edition);
            array_push($data['numfact'], $numfact);
            array_push($data['numrecu'], '');
            array_push($data['debitcdf'], $debitcdf);
            array_push($data['creditcdf'], 0);
            array_push($data['debitusd'], $debitusd);
            array_push($data['creditusd'], 0);
            array_push($data['taux'], 1);
        }
    }

    return  $data;
}

function FusionIDs($id_tbl, $bdd)
{
    $data = array();
    $data['ids'] = array();
    $requete = $bdd->prepare("SELECT * FROM  fusion_tables WHERE id_tbl=:id_tbl");
    $requete->BindParam(':id_tbl', $id_tbl);
    $requete->execute();
    $operations = $requete->fetchAll(PDO::FETCH_OBJ);
    foreach ($operations as $op) {
        $id_tbl_fus = $op->id_tbl_fus;
        array_push($data['ids'], $id_tbl_fus);
    }
    return  $data;
}
function ReturnFusionID($id_fact, $bdd)
{
    $requete = $bdd->prepare("SELECT * FROM  fusion_factures WHERE id_fact =:id_fact ");
    $requete->BindParam(':id_fact', $id_fact);
    $requete->execute();
    $operations = $requete->fetchAll(PDO::FETCH_OBJ);
    $id_fact_fus = 0;
    foreach ($operations as $op) {
        $id_fact_fus = $op->id_fact_fus;
    }
    return  $id_fact_fus;
}
//Confinement

function PaiementCreance($dte1, $dte2,$serveur_id, $bdd)
{
    $total = 0;
    $idsite = $_SESSION['id_hotel'];
    $q1="SELECT f.id_fact,f.taux,b.montantcdf,b.montantusd,b.rendu_cdf,b.rendu_usd
    FROM t_facture AS f,t_reglement AS fa,paiement AS b
    WHERE f.id_fact=fa.id_fact 
        AND fa.id_regl=b.regl_id
        AND f.type='restaurant'
        AND f.mode='Credit'
        AND b.motif='restaurant'
        AND fa.dte BETWEEN :dte1 AND :dte2
        AND  b.site_id=:id_hotel";
    $q2="";
    if($serveur_id!=0){
        $q2=" AND f.id_user=:id_user";
    }
    $q=$q1.$q2;
    $requete = $bdd->prepare($q);
    $requete->BindParam(':id_hotel', $idsite);
    $requete->BindParam(':dte1', $dte1);
    $requete->BindParam(':dte2', $dte2);
    if($serveur_id!=0){
        $requete->BindParam(':id_user', $serveur_id);
    }
    $requete->execute();
    $result = $requete->fetchAll(PDO::FETCH_OBJ);
    foreach ($result as $r) {
        $taux = $r->taux;
        $montantusd = $r->montantusd;
        $rendu_usd = $r->rendu_usd;
        $montantcdf = $r->montantcdf / $taux;
        $rendu_cdf = $r->rendu_cdf / $taux;
        $val = ($montantusd - $rendu_usd) + ($montantcdf - $rendu_cdf);
        if ($val < 0) {
            $val = 0;
        }
        $total += $val;
    }



    return $total;
}
function PaiementCreancePos($dte1, $dte2, $pos_id,$serveur_id, $bdd)
{
    $total = 0;
    $idsite = $_SESSION['id_hotel'];
    $q1="SELECT f.id_fact,f.taux,b.montantcdf,b.montantusd,b.rendu_cdf,b.rendu_usd
    FROM t_facture AS f,t_reglement AS fa,paiement AS b
    WHERE f.id_fact=fa.id_fact 
        AND fa.id_regl=b.regl_id
        AND f.type='restaurant'
        AND f.mode='Credit'
        AND b.motif='restaurant'
        AND fa.dte BETWEEN :dte1 AND :dte2
        AND  b.site_id=:id_hotel
        AND  f.id_sousresto=:id_sousresto";
    $q2="";
    if($serveur_id!=0){
        $q2=" AND f.id_user=:id_user";
    }
    $q=$q1.$q2;
    $requete = $bdd->prepare($q);
    $requete->BindParam(':id_hotel', $idsite);
    $requete->BindParam(':dte1', $dte1);
    $requete->BindParam(':dte2', $dte2);
    $requete->BindParam(':id_sousresto', $pos_id);
    if($serveur_id!=0){
    $requete->BindParam(':id_user', $serveur_id);
    }
    $requete->execute();
    $result = $requete->fetchAll(PDO::FETCH_OBJ);
    foreach ($result as $r) {
        $taux = $r->taux;
        $montantusd = $r->montantusd;
        $rendu_usd = $r->rendu_usd;
        $montantcdf = $r->montantcdf / $taux;
        $rendu_cdf = $r->rendu_cdf / $taux;
        $val = ($montantusd - $rendu_usd) + ($montantcdf - $rendu_cdf);
        if ($val < 0) {
            $val = 0;
        }
        $total += $val;
    }



    return $total;
}

function SelectVinMaison($bdd)
{
    // $id =14;
    $requete = $bdd->prepare("SELECT * FROM stk_produit AS a WHERE a.pseudo_supp=0 AND a.repas!=3 AND a.famille_id IN(10,11) ORDER BY  a.designation");
    //  $requete->BindParam(':id', $id);
    $requete->execute();
    $st = $requete->fetchAll(PDO::FETCH_OBJ);
    return $st;
}
function getProdLierMesurette($idprod, $bdd)
{

    $requete = $bdd->prepare("SELECT * FROM  t_ingredient WHERE plat_id=:idprod");
    $requete->BindParam(':idprod', $idprod);
    $requete->execute();
    $result = $requete->fetch(PDO::FETCH_OBJ);
    return $result;
}

function ReimprimerBC_Reprint_Lines($id_fact, $impr, $bdd)
{
    $tva_fact = 0;
    $tauxfct = 1;
    $remise_fact = 0;
    $_SESSION['dessert'] = 0;
    $_SESSION['entree'] = 0;
    $_SESSION['plats'] = 0;
    $_SESSION['panier'] = array();
    $_SESSION['panier']['id_article'] = array();
    $_SESSION['panier']['nom'] = array();
    $_SESSION['panier']['qte'] = array();
    $_SESSION['panier']['prix'] = array();
    $_SESSION['panier']['repas'] = array();
    $_SESSION['panier']['genre'] = array();
    $_SESSION['panier']['pa'] = array();
    $_SESSION['panier']['description'] = array();
    $_SESSION['panier']['id_client'] = 0;
    $_SESSION['panier']['remise'] = 0;
    $_SESSION['panier']['mont_tva'] = 0;
    $_SESSION['panier']['mont_ttc'] = 0;
    $_SESSION['panier']['mont_ttc_remise'] = 0;
    $_SESSION['panier']['verrouille'] = false;
    //Regroupement
    $_SESSION['group_prod'] = array();
    $_SESSION['group_prod']['id_article'] = array();
    $_SESSION['group_prod']['nom'] = array();
    $_SESSION['group_prod']['qte'] = array();
    $_SESSION['group_prod']['accomps'] = array();
    $_SESSION['group_prod']['des_plt'] = array();
    $_SESSION['group_prod']['repas'] = array();
    $_SESSION['group_prod']['genre'] = array();
    $_SESSION['group_accomp'] = array();
    $_SESSION['group_accomp']['nom_accomp'] = array();
    $_SESSION['group_accomp']['qte_accomp'] = array();
    //Regroupement
    $idcmd = $id_fact;
    $requete = $bdd->prepare("SELECT f.note_cmd,f.id_fact, f.montant_total,f.mont_tva,f.mont_ttc,f.date_edition,f.dte_time,f.mode,f.mont_ttc_remise,f.taux,f.tva,f.id_fact,f.num_fact,
                                f.id_res,c.designation,c.id_client,c.nom_client,c.designation,c.type,d.nom_user,d.prenom_user,f.nbrcouvert AS nbrcouvertfac,f.preparer,f.etat_cmd
                                FROM  t_client AS c,t_facture AS f,t_utilisateur AS d
                                 WHERE f.id_client=c.id_client AND f.id_user=d.id_user 
                                       AND f.id_fact=:cmd_id");
    $requete->BindParam(':cmd_id', $idcmd);
    $requete->execute();
    $reservation_attente = $requete->fetchAll(PDO::FETCH_OBJ);
    foreach ($reservation_attente as $ra) {
        $_SESSION['nbrcouvert'] = $ra->nbrcouvertfac;
        $id = $ra->id_res;
        $id_fact = $ra->id_fact;
        $remise_fact = $ra->mont_ttc_remise;
        $mont_remise = $ra->tva;
        $tva_fact = $ra->tva;
        $mont_tva = $ra->mont_tva;
        $mont_ttc = $ra->mont_ttc;
        $id_cl = $ra->id_client;
        // $cmd_num = $ra->num_reserv;
        $tbl = $ra->designation;
        $cl = $ra->nom_client;
        $tauxfct = $ra->taux;
        $_SESSION['mode_fact'] = $ra->mode;
        $_SESSION['nom_user'] = $ra->nom_user;
        $_SESSION['date_edition'] = $ra->date_edition;
        //        $_SESSION['date_edition2'] = $ra->dte_time;
        $_SESSION['date_edition2'] = $ra->dte_time;
        $typ = $ra->type;
        if ($typ == 'client' || $typ == 'serveur') {
            $cl_tbl = $cl;
        } else if ($typ == 'table') {
            $cl_tbl = $tbl;
        } else {
            $cl_tbl = 'Occasionnel';
        }
        $_SESSION['num_commande'] = $ra->num_fact;
        $_SESSION['nom_client'] = $cl_tbl;
        $_SESSION['id_client'] = $id_cl;
        $statut = 'En cours';
        if ($ra->preparer == 1) {
            $statut = 'Preparé';
        }
        if ($ra->etat_cmd == 3) {
            $statut = 'Annulé';
        }
        $_SESSION['statut_cmd'] = $statut;
        $note_cmd = $ra->note_cmd;
        $_SESSION['note_cmd'] = $note_cmd;
        $requete = $bdd->prepare("SELECT  l.id AS idlgcmd,p.idprod,p.designation,p.monnaie,p.repas,ss.genre,l.*
                                    FROM  lignes_commandes AS l,stk_produit As p,stk_sous_famille AS ss
                                    WHERE l.produit_id=p.idprod AND p.famille_id=ss.id_s_fam 
                                     AND l.commande_id=:cmd_id");
        $requete->BindParam(':cmd_id', $id_fact);
        $requete->execute();
        $reservation_l_attente = $requete->fetchAll(PDO::FETCH_OBJ);
        foreach ($reservation_l_attente as $r) {
            $idlgcmd = $r->idlgcmd;
            if (in_array($idlgcmd, $_SESSION['ProduitsSelectiones']['id_produit'])) {
                $idprod = $r->idprod;
                $qte = $r->qte;
                $prix = $r->prix;
                $designation = $r->designation;
                $repas = $r->repas;
                $genre = $r->genre;
                $des_plt = $r->accomp;
                $qte_modif = $_SESSION['ProduitsSelectiones']['qte_modif'][$idlgcmd];
                if ($qte_modif <= $qte) {
                    $qte = $qte_modif;
                }
                array_push($_SESSION['panier']['id_article'], $idprod);
                array_push($_SESSION['panier']['nom'], $designation);
                array_push($_SESSION['panier']['qte'], $qte);
                array_push($_SESSION['panier']['prix'], $prix);
                array_push($_SESSION['panier']['repas'], $repas);
                array_push($_SESSION['panier']['genre'], $genre);
                array_push($_SESSION['panier']['pa'], $idlgcmd);
                array_push($_SESSION['panier']['description'], $des_plt);
                if ($genre == 2) {
                    $_SESSION['dessert'] = 1;
                } elseif ($genre == 1) {
                    $_SESSION['entree'] = 1;
                } elseif ($genre == 0) {
                    $_SESSION['plats'] = 1;
                    $accompgns = $r->accomp;
                    //Regroupement des produits
                    if (!in_array($idprod, $_SESSION['group_prod']['id_article'])) {
                        array_push($_SESSION['group_prod']['id_article'], $idprod);
                        $_SESSION['group_prod']['nom'][$idprod] = $designation;
                        $_SESSION['group_prod']['repas'][$idprod] = $repas;
                        $_SESSION['group_prod']['genre'][$idprod] = $genre;
                        $_SESSION['group_prod']['qte'][$idprod] = $qte;
                        $_SESSION['group_prod']['accomps'][$idprod] = $accompgns;
                    } else {
                        $qteold = $_SESSION['group_prod']['qte'][$idprod];
                        $_SESSION['group_prod']['qte'][$idprod] = $qteold + $qte;
                        $_SESSION['group_prod']['accomps'][$idprod] = $_SESSION['group_prod']['accomps'][$idprod]  . ',' . $accompgns;
                    }
                }
            }
        }
        //Regroupement des accompagnements
        $nbrprod = count($_SESSION['group_prod']['id_article']);
        for ($i = 0; $i <= $nbrprod - 1; $i++) {
            $idprod = $_SESSION['group_prod']['id_article'][$i];
            $accompgns = $_SESSION['group_prod']['accomps'][$idprod];
            $t_accomps = explode(',', $accompgns);
            $nbraccomp = count($t_accomps);
            for ($j = 0; $j <= $nbraccomp - 1; $j++) {
                $nom_accomp = trim($t_accomps[$j]);
                $nom_accomp = strstr($nom_accomp, '(', true);
                if (!in_array($nom_accomp, $_SESSION['group_accomp']['nom_accomp'])) {
                    array_push($_SESSION['group_accomp']['nom_accomp'], $nom_accomp);
                    $_SESSION['group_accomp']['qte_accomp'][$nom_accomp] = 1;
                } else {
                    $_SESSION['group_accomp']['qte_accomp'][$nom_accomp] += 1;
                }
            }
            $Z = count($_SESSION['group_accomp']['nom_accomp']);
            $ch = "";
            for ($s = 0; $s <= $Z - 1; $s++) {
                $n = $_SESSION['group_accomp']['nom_accomp'][$s];
                $q = $_SESSION['group_accomp']['qte_accomp'][$n];
                if ($q > 0 && $n != "") {
                    $ch = $ch . $q . ' ' . $n . ',';
                }
            }
            $_SESSION['group_prod']['des_plt'][$idprod] = $ch;
            $_SESSION['group_accomp'] = array();
            $_SESSION['group_accomp']['nom_accomp'] = array();
            $_SESSION['group_accomp']['qte_accomp'] = array();
        }
        //Regroupement des accompagnements
        $mont_ht = 0;
        $nb_articles = count($_SESSION['panier']['id_article']);
        for ($i = 0; $i < $nb_articles; $i++) {
            $idlgcmd = $_SESSION['panier']['pa'][$i];
            if (in_array($idlgcmd, $_SESSION['ProduitsSelectiones']['id_produit'])) {

                $mont_ht += $_SESSION['panier']['qte'][$i] * $_SESSION['panier']['prix'][$i];
            }
        }
        $total1 = $mont_ht;
        $total = total($total1, $tva_fact, $remise_fact);
        //        $mont_tva=tva($total,$tva_fact,$remise_fact);
        $mont_rmz = remise($total1, $tva_fact, $remise_fact);
        $mont_ht = ht($total, $tva_fact, $remise_fact);

        $ttc = ttc($mont_ht, $mont_tva, $mont_rmz);
        $ttc2 =  montant_equivalent_bdd('CDF', 'USD', $tauxfct, $ttc);
        $_SESSION['panier']['mont_tva'] = $mont_tva;
        $_SESSION['panier']['mont_ttc'] = $mont_ht - $mont_rmz;
        $_SESSION['panier']['mont_remise'] = $mont_rmz;
        $_SESSION['panier']['mont_ht'] = $mont_ht;
        $_SESSION['panier']['mont_ttc_remise'] = $ttc;
        $_SESSION['ttc2'] = $ttc2;
    }
}
function ReimprimerBC_Reprint_All($id_fact, $impr, $bdd)
{
    $tva_fact = 0;
    $tauxfct = 1;
    $remise_fact = 0;
    $_SESSION['dessert'] = 0;
    $_SESSION['entree'] = 0;
    $_SESSION['plats'] = 0;
    $_SESSION['panier'] = array();
    $_SESSION['panier']['id_article'] = array();
    $_SESSION['panier']['nom'] = array();
    $_SESSION['panier']['qte'] = array();
    $_SESSION['panier']['prix'] = array();
    $_SESSION['panier']['repas'] = array();
    $_SESSION['panier']['genre'] = array();
    $_SESSION['panier']['description'] = array();
    $_SESSION['panier']['id_client'] = 0;
    $_SESSION['panier']['remise'] = 0;
    $_SESSION['panier']['mont_tva'] = 0;
    $_SESSION['panier']['mont_ttc'] = 0;
    $_SESSION['panier']['mont_ttc_remise'] = 0;
    $_SESSION['panier']['verrouille'] = false;
    $idcmd = $id_fact;
    $requete = $bdd->prepare("SELECT f.id_fact, f.montant_total,f.mont_tva,f.mont_ttc,f.date_edition,f.dte_time,f.mode,f.mont_ttc_remise,f.taux,f.tva,f.id_fact,f.num_fact,
                                f.id_res,c.designation,c.id_client,c.nom_client,c.designation,c.type,d.nom_user,d.prenom_user
                                FROM  t_client AS c,t_facture AS f,t_utilisateur AS d
                                 WHERE f.id_client=c.id_client AND f.id_user=d.id_user 
                                       AND f.id_fact=:cmd_id");
    $requete->BindParam(':cmd_id', $idcmd);
    $requete->execute();
    $reservation_attente = $requete->fetchAll(PDO::FETCH_OBJ);
    foreach ($reservation_attente as $ra) {
        $id = $ra->id_res;
        // $id_fact = $ra->id_fact;
        $remise_fact = $ra->mont_ttc_remise;
        $mont_remise = $ra->tva;
        $tva_fact = $ra->tva;
        $mont_tva = $ra->mont_tva;
        $mont_ttc = $ra->mont_ttc;
        $id_cl = $ra->id_client;
        $cmd_num = $ra->num_reserv;
        $tbl = $ra->designation;
        $cl = $ra->nom_client;
        $tauxfct = $ra->taux;
        $_SESSION['mode_fact'] = $ra->mode;
        $_SESSION['nom_user'] = $ra->nom_user;
        $_SESSION['date_edition'] = $ra->date_edition;
        //        $_SESSION['date_edition2'] = $ra->dte_time;
        $_SESSION['date_edition2'] = $ra->dte_time;
        $typ = $ra->type;
        if ($typ == 'client' || $typ == 'serveur') {
            $cl_tbl = $cl;
        } else if ($typ == 'table') {
            $cl_tbl = $tbl;
        } else {
            $cl_tbl = 'Occasionnel';
        }
        $_SESSION['num_commande'] = $ra->num_fact;
        $_SESSION['nom_client'] = $cl_tbl;
        $requete = $bdd->prepare("SELECT  p.idprod,p.designation,p.monnaie,p.repas,ss.genre,SUM(l.qte) AS qte,SUM(l.qte2) AS qte2,SUM(l.qteoffert) AS qteoffert,l.prix,l.impr,GROUP_CONCAT(l.accomp) AS accomp
        FROM  lignes_commandes AS l,stk_produit As p,stk_sous_famille AS ss
        WHERE l.produit_id=p.idprod AND p.famille_id=ss.id_s_fam 
        AND l.commande_id=:cmd_id AND l.impr=:impr
        GROUP BY p.idprod");
        $requete->BindParam(':cmd_id', $id_fact);
        $requete->BindParam(':impr', $impr);
        $requete->execute();
        $reservation_l_attente = $requete->fetchAll(PDO::FETCH_OBJ);
        foreach ($reservation_l_attente as $r) {
            $qte = $r->qte;
            $impr = $r->impr;
            if ($impr == 1) {
                if ($r->qte2 != 0) {
                    $qte = $r->qte2;
                }
            }

            if (round($r->qte) == 0) {
                $qte = $r->qteoffert;
            }
            $prix = $r->prix;
            $idprod = $r->idprod;
            $designation = $r->designation;
            $description = $r->accomp;
            $repas = $r->repas;
            $genre = $r->genre;

            array_push($_SESSION['panier']['id_article'], $idprod);
            array_push($_SESSION['panier']['nom'], $designation);
            array_push($_SESSION['panier']['qte'], $qte);
            array_push($_SESSION['panier']['prix'], $prix);
            array_push($_SESSION['panier']['repas'], $repas);
            array_push($_SESSION['panier']['genre'], $genre);
            array_push($_SESSION['panier']['description'], $description);
            if ($genre == 2) {
                $_SESSION['dessert'] = 1;
            } elseif ($genre == 1) {
                $_SESSION['entree'] = 1;
            } elseif ($genre == 0) {
                $_SESSION['plats'] = 1;
            }
        }
        $mont_ht = 0;
        $nb_articles = count($_SESSION['panier']['id_article']);
        for ($i = 0; $i < $nb_articles; $i++) {
            $mont_ht += $_SESSION['panier']['qte'][$i] * $_SESSION['panier']['prix'][$i];
        }
        $total1 = $mont_ht;
        $total = total($total1, $tva_fact, $remise_fact);
        $mont_tva = tva($total, $tva_fact, $remise_fact);
        $mont_rmz = remise($total1, $tva_fact, $remise_fact);
        $mont_ht = ht($total, $tva_fact, $remise_fact);

        $ttc = ttc($mont_ht, $mont_tva, $mont_rmz);
        $ttc2 =  montant_equivalent_bdd('CDF', 'USD', $tauxfct, $ttc);
        $_SESSION['panier']['mont_tva'] = $mont_tva;
        $_SESSION['panier']['mont_ttc'] = $mont_ht - $mont_rmz;
        $_SESSION['panier']['mont_remise'] = $mont_rmz;
        $_SESSION['panier']['mont_ht'] = $mont_ht;
        $_SESSION['panier']['mont_ttc_remise'] = $ttc;
        $_SESSION['ttc2'] = $ttc2;
    }
}

function ExtraitDEcompteAll($date_bd1, $date_bd2, $bdd)
{
    $data = array();
    $data['id'] = array();
    $data['client'] = array();
    $data['debit'] = array();
    $data['credit'] = array();
    $requete = $bdd->prepare("SELECT b.id_client,b.nom_client 
                                FROM t_facture AS a, t_client AS b 
                                WHERE a.id_client=b.id_client
                                AND a.type='restaurant'
                                AND a.etat_cmd=0
                                AND b.type='client'
                                GROUP BY b.id_client
                                ORDER BY b.nom_client ASC");
    $requete->execute();
    $clients = $requete->fetchAll(PDO::FETCH_OBJ);
    foreach ($clients as $cli) {
        $idclient = $cli->id_client;
        $nom_client = $cli->nom_client;
        $debit = 0;
        $credit = 0;
        $requete = $bdd->prepare("SELECT * FROM t_facture AS a, t_client AS b 
                                WHERE a.id_client=b.id_client
                                     AND b.id_client=:idcl
                                     AND a.type='restaurant'
                                     AND a.etat_cmd=0
                                     AND a.date_edition BETWEEN :date_bd1 AND :date_bd2");
        $requete->BindParam(':idcl', $idclient);
        $requete->BindParam(':date_bd1', $date_bd1);
        $requete->BindParam(':date_bd2', $date_bd2);
        $requete->execute();
        $factures = $requete->fetchAll(PDO::FETCH_OBJ);
        foreach ($factures as $fct) {
            $id_fact = $fct->id_fact;
            $taux = $fct->taux;
            $monnaie = $fct->monnaie;
            $totalfact = $fct->mont_ttc;
            if ($monnaie == 'CDF') {
                $debit += montant_equivalent_bdd(getsymbole_local(), getsymbole_devise(), $taux, $totalfact);
            } else {
                $debit += $totalfact;
            }
            $requete = $bdd->prepare("SELECT * FROM t_reglement AS c, paiement AS d WHERE c.id_regl=d.regl_id AND c.id_fact=:id_fact ORDER BY c.dte");
            $requete->BindParam(':id_fact', $id_fact);
            $requete->execute();
            $paiements = $requete->fetchAll(PDO::FETCH_OBJ);
            $nbre = count($paiements);
            if ($nbre > 0) {
                foreach ($paiements as $p) {
                    $montantusd = $p->montantusd;
                    $montantcdf = $p->montantcdf;
                    $taux = $p->taux;
                    $credit += $montantusd + montant_equivalent_bdd(getsymbole_local(), getsymbole_devise(), $taux, $montantcdf);
                }
            }
        }
        if ($debit > 0) {
            array_push($data['id'], $idclient);
            array_push($data['client'], $nom_client);
            array_push($data['debit'], $debit);
            array_push($data['credit'], $credit);
        }
    }
    return  $data;
}

function AllCommmandesCustom($type, $dte1, $dte2, $idclient, $bdd)
{
    //Retourne toutes les commandes du sous-resto
    $req = "
        SELECT a.*,
        c.nom_client,c.designation,c.type,c.adresse_provenance_client,c.email_client,c.telephone_client,c.sexe_client,d.nom_user,d.prenom_user
            FROM t_facture a,t_client c,t_utilisateur AS d
             WHERE a.id_client=c.id_client
                   AND a.id_user=d.id_user 
                   AND a.type=:type
                   AND a.date_edition BETWEEN :dte1 AND :dte2
                   AND c.id_client=:id_client
                   ";
    $requete = $bdd->prepare($req);
    $requete->BindParam(':type', $type);
    $requete->BindParam(':dte1', $dte1);
    $requete->BindParam(':dte2', $dte2);
    $requete->BindParam(':id_client', $idclient);
    $requete->execute();
    $result = $requete->fetchAll(PDO::FETCH_OBJ);
    return $result;
}
function AllCommmandesCreditCustom($type, $dte1, $dte2, $idclient, $bdd)
{
    //Retourne toutes les commandes du sous-resto
    $mode = 'Credit';
    $req = "
        SELECT a.*,c.type AS type_client,
        c.nom_client,c.designation,c.adresse_provenance_client,c.email_client,c.telephone_client,c.sexe_client,d.nom_user,d.prenom_user
            FROM t_facture a,t_client c,t_utilisateur AS d
             WHERE a.id_client=c.id_client
                   AND a.id_user=d.id_user 
                   AND a.type=:type
                   AND a.mode=:mode
                   AND a.date_edition BETWEEN :dte1 AND :dte2
                   AND c.id_client=:id_client
                   ";
    $requete = $bdd->prepare($req);
    $requete->BindParam(':type', $type);
    $requete->BindParam(':mode', $mode);
    $requete->BindParam(':dte1', $dte1);
    $requete->BindParam(':dte2', $dte2);
    $requete->BindParam(':id_client', $idclient);
    $requete->execute();
    $result = $requete->fetchAll(PDO::FETCH_OBJ);
    return $result;
}

/* function venteGroupByFamille($id_hotel,$maffiche,$dte1,$dte2, $bdd)
{

    $data2 = array();
    $data2['id'] = array();
    $data2['des'] = array();
    $data2['cash'] = array();
    $data2['credit'] = array();
    $data2['don'] = array();
    if($maffiche=='USD'){
        $req = "SELECT  f.id,f.nom,a.taux_prix,a.monnaie,a.mont_ttc_remise
                SUM(b.qte) AS qte,SUM(b.qteoffert) AS qteoffert,
                SUM(b.qte*b.prix) AS mont,SUM(b.qteoffert*b.prix2) AS montof,a.mode
                FROM t_facture AS a,lignes_commandes AS b,stk_produit AS c,
                stk_sous_famille AS d,stk_famille AS e,stk_familletype AS f
                WHERE a.id_fact=b.commande_id
                AND b.produit_id= c.idprod
                AND c.famille_id=d.id_s_fam
                AND d.famille=e.idfamille
                AND a.mode IS NOT NULL
                AND a.id_hotel  =:id_hotel 
                AND a.date_edition  BETWEEN :dte1 AND :dte2
                AND e.affichage=1
                AND e.familletype_id=f.id
                GROUP BY f.id,a.mode";
    }else¨{
        
    }
    $requete = $bdd->prepare($req);
    $requete->BindParam(':id_hotel', $id_hotel);
    $requete->BindParam(':dte1', $dte1);
    $requete->BindParam(':dte2', $dte2);
    $requete->execute();

    $result = $requete->fetchAll(PDO::FETCH_OBJ);
    
    foreach ($result as $r) {
        if (!in_array($r->id, $data2['id'])) {
            array_push($data2['id'],$r->id);
            array_push($data2['des'] ,$r->nom);
        }
        if ($r->mode == 'Cash') {
            $data2['cash'][$r->id] = $r->mont;
        }
        if ($r->mode == 'Credit') {
            $data2['credit'][$r->id] = $r->mont;
        }
        if ($r->mode == 'Don') {
            $data2['don'][$r->id] = $r->mont;
        }
    }

    

    
} */

function GetMarges($id_hotel, $dte1, $dte2,$serveur_id,$bdd)
{
    $q1="SELECT c.idprod,c.designation,b.pa,b.prix,b.prixremise,a.taux_prix,a.monnaie,a.mont_ttc_remise,
    SUM(b.qte) AS qte, SUM((b.qte*b.pa)/a.taux_prix) AS valpa,
    SUM((b.qte*b.prixremise-b.qte*b.prixremise*a.mont_ttc_remise/100)/a.taux_prix) AS valpv,a.mode
FROM t_facture AS a,lignes_commandes AS b,stk_produit AS c,
         stk_sous_famille AS d,stk_famille AS e
 WHERE a.id_fact=b.commande_id
            AND b.produit_id= c.idprod
             AND c.famille_id=d.id_s_fam
             AND d.famille=e.idfamille
             AND a.id_hotel=:id_hotel
             AND a.mode IN('Cash','Credit')
             AND e.affichage=1
             AND a.date_edition  BETWEEN :date_bd1 AND :date_bd2";
    $q3=" GROUP BY  c.idprod,b.prixremise";
    $q2="";
    if($serveur_id!=0){
        $q2=" AND a.id_user=:id_user";
    }
    $q=$q1.$q2.$q3;
    $requete = $bdd->prepare($q);
    $requete->BindParam(':id_hotel', $id_hotel);
    $requete->BindParam(':date_bd1', $dte1);
    $requete->BindParam(':date_bd2', $dte2);
    if($serveur_id!=0){
        $requete->BindParam(':id_user', $serveur_id);
    }
    $requete->execute();
    return $requete->fetchAll(PDO::FETCH_OBJ);
}
function GetMargesSousSite($pos_id, $id_hotel, $dte1, $dte2,$serveur_id, $bdd)
{
    $q1="SELECT c.idprod,c.designation,b.pa,b.prix,b.prixremise,a.taux_prix,a.monnaie,a.mont_ttc_remise,
    SUM(b.qte) AS qte, SUM((b.qte*b.pa)/a.taux_prix) AS valpa,
    SUM((b.qte*b.prixremise-b.qte*b.prixremise*a.mont_ttc_remise/100)/a.taux_prix) AS valpv,a.mode
FROM t_facture AS a,lignes_commandes AS b,stk_produit AS c,
         stk_sous_famille AS d,stk_famille AS e
 WHERE a.id_fact=b.commande_id
            AND b.produit_id= c.idprod
             AND c.famille_id=d.id_s_fam
             AND d.famille=e.idfamille
             AND a.id_hotel=:id_hotel
             AND a.id_sousresto=:id_sousresto
             AND a.mode IN('Cash','Credit')
             AND e.affichage=1
             AND a.date_edition  BETWEEN :date_bd1 AND :date_bd2";
    $q3=" GROUP BY  c.idprod,b.prixremise";
    $q2="";
    if($serveur_id!=0){
        $q2=" AND a.id_user=:id_user";
    }
    $q=$q1.$q2.$q3;
    $requete = $bdd->prepare($q);
    $requete->BindParam(':id_hotel', $id_hotel);
    $requete->BindParam(':id_sousresto', $pos_id);
    $requete->BindParam(':date_bd1', $dte1);
    $requete->BindParam(':date_bd2', $dte2);
    if($serveur_id!=0){
        $requete->BindParam(':id_user', $serveur_id);
    }
    $requete->execute();
    return $requete->fetchAll(PDO::FETCH_OBJ);
}
function GetDeletes($site_id, $dte1, $dte2, $bdd)
{
    $requete = $bdd->prepare("SELECT * FROM suivifactures AS a, stk_produit AS b,t_facture AS c
                                WHERE a.produit_id=b.idprod AND a.facture_id=c.id_fact
                                AND a.site_id=:site_id AND a.suppr=1 
                                AND a.dte BETWEEN :dte1 AND :dte2
                                ORDER BY a.dte");
    $requete->BindParam(':site_id', $site_id);
    $requete->BindParam(':dte1', $dte1);
    $requete->BindParam(':dte2', $dte2);
    $requete->execute();
    $st = $requete->fetchAll(PDO::FETCH_OBJ);
    return $st;
}
function UserName($bdd, $id_user)
{
    $requete = $bdd->prepare("SELECT nom_user FROM t_utilisateur WHERE id_user=:id_user ");
    $requete->BindParam(':id_user', $id_user);
    $requete->execute();
    $st = $requete->fetch(PDO::FETCH_OBJ);
    return $st->nom_user;
}
function GetQteProdEnAttenteById($idprod, $bdd)
{
    $quantite = 0;
    $dte = date('Y-m-d');
    $requete = $bdd->prepare("SELECT  l.produit_id,SUM(l.qte) AS qte,l.repas 
                                    FROM t_facture AS a, lignes_commandes AS l
                                    WHERE a.id_fact=l.commande_id AND a.etat_cmd='1' 
                                    AND l.produit_id=:produit_id
                                    AND a.id_sousresto=:id_sousresto
                                    AND a.date_edition=:date_edition");
    $requete->BindParam(':produit_id', $idprod);
    $requete->BindParam(':id_sousresto',$_SESSION['id_sousresto']);
    $requete->BindParam(':date_edition', $dte);
    $requete->execute();
    $result = $requete->fetchAll(PDO::FETCH_OBJ);
    foreach ($result as $p) {
        $quantite = $p->qte;
    }

    return $quantite;
}

function DetailsVenteTout2($date_bd1, $date_bd2,$serveur_id, $bdd)
{
    $idsite = $_SESSION['id_hotel'];
    $q1="SELECT e.familletype_id,b.prixremise,a.taux_prix,a.monnaie,a.mode,a.mont_ttc_remise,c.idprod,c.code, c.designation,c.repas,c.nourriture,
    SUM(b.qte) AS qte, b.prixremise AS pu, b.dte_h,a.mode AS lib,SUM(((b.qte*b.prix)-((b.qte*b.prix*a.mont_ttc_remise)/100))/a.taux_prix) AS mont,
    SUM(b.qteoffert) AS qteoffert,SUM(b.qteoffert*b.prix2) AS montof
    FROM lignes_commandes AS b, stk_produit AS c, t_facture AS a,
    stk_sous_famille AS d,stk_famille AS e,stk_familletype AS f
    WHERE a.id_fact=b.commande_id 
    AND b.produit_id= c.idprod
    AND c.famille_id=d.id_s_fam
    AND d.famille=e.idfamille
    AND e.familletype_id=f.id
    AND a.mode IS NOT NULL
    AND a.date_edition  BETWEEN :date_bd1 AND :date_bd2
    AND a.id_hotel=:id_hotel";
    $q3=" GROUP BY c.idprod  
    ORDER BY c.nourriture,c.designation";
    $q2="";
    if($serveur_id!=0){
        $q2=" AND a.id_user=:id_user";
    }
    $q=$q1.$q2.$q3;
    $requete = $bdd->prepare($q);
    $requete->BindParam(':date_bd1', $date_bd1);
    $requete->BindParam(':date_bd2', $date_bd2);
    $requete->BindParam(':id_hotel', $idsite);
    if($serveur_id!=0){
        $requete->BindParam(':id_user', $serveur_id);
    }
    $requete->execute();
    $articles3 = $requete->fetchAll(PDO::FETCH_OBJ);
    return $articles3;
}

function DetailsVenteTout2Pos($date_bd1, $date_bd2, $pos_id,$serveur_id, $bdd)
{
    $idsite = $_SESSION['id_hotel'];
    $q1="SELECT e.familletype_id,b.prixremise,a.taux_prix,a.monnaie,a.mode,a.mont_ttc_remise,c.idprod,c.code, c.designation,c.repas,c.nourriture,
    SUM(b.qte) AS qte, b.prixremise AS pu, b.dte_h,a.mode AS lib,SUM(((b.qte*b.prix)-((b.qte*b.prix*a.mont_ttc_remise)/100))/a.taux_prix) AS mont,
    SUM(b.qteoffert) AS qteoffert,SUM(b.qteoffert*b.prix2) AS montof
    FROM lignes_commandes AS b, stk_produit AS c, t_facture AS a,
    stk_sous_famille AS d,stk_famille AS e,stk_familletype AS f
    WHERE a.id_fact=b.commande_id 
    AND b.produit_id= c.idprod
    AND c.famille_id=d.id_s_fam
    AND d.famille=e.idfamille
    AND e.familletype_id=f.id
    AND a.mode IS NOT NULL
    AND a.date_edition  BETWEEN :date_bd1 AND :date_bd2
    AND a.id_hotel=:id_hotel 
    AND a.id_sousresto=:id_sousresto";
    $q3=" GROUP BY c.idprod  
    ORDER BY c.nourriture,c.designation";
    $q2="";
    if($serveur_id!=0){
        $q2=" AND a.id_user=:id_user";
    }
    $q=$q1.$q2.$q3;
    $requete = $bdd->prepare($q);
    $requete->BindParam(':date_bd1', $date_bd1);
    $requete->BindParam(':date_bd2', $date_bd2);
    $requete->BindParam(':id_hotel', $idsite);
    $requete->BindParam(':id_sousresto', $pos_id);
    if($serveur_id!=0){
        $requete->BindParam(':id_user', $serveur_id);
    }
    $requete->execute();
    $articles3 = $requete->fetchAll(PDO::FETCH_OBJ);
    return $articles3;
}


function VenteGlobalCredit($date_bd1, $date_bd2,$serveur_id, $bdd)
{
    $idsite = $_SESSION['id_hotel'];
    $q1="SELECT e.familletype_id,b.prixremise,a.taux_prix,a.monnaie,a.mode,a.mont_ttc_remise,c.idprod,c.code, c.designation,c.repas,c.nourriture,
    SUM(b.qte) AS qte, b.prixremise AS pu, b.dte_h,a.mode AS lib,SUM(((b.qte*b.prix)-((b.qte*b.prix*a.mont_ttc_remise)/100))/a.taux_prix) AS mont,
    SUM(b.qteoffert) AS qteoffert,SUM(b.qteoffert*b.prix2) AS montof
    FROM lignes_commandes AS b, stk_produit AS c, t_facture AS a,
    stk_sous_famille AS d,stk_famille AS e,stk_familletype AS f
    WHERE a.id_fact=b.commande_id 
    AND b.produit_id= c.idprod
    AND c.famille_id=d.id_s_fam
    AND d.famille=e.idfamille
    AND e.familletype_id=f.id
    AND a.mode='Credit'
    AND a.date_edition  BETWEEN :date_bd1 AND :date_bd2
    AND a.id_hotel=:id_hotel";
    $q3=" ORDER BY c.nourriture,c.designation";
    $q2="";
    if($serveur_id!=0){
        $q2=" AND a.id_user=:id_user";
    }
    $q=$q1.$q2.$q3;
    $requete = $bdd->prepare($q);
    $requete->BindParam(':date_bd1', $date_bd1);
    $requete->BindParam(':date_bd2', $date_bd2);
    $requete->BindParam(':id_hotel', $idsite);
    if($serveur_id!=0){
        $requete->BindParam(':id_user', $serveur_id);
    }
    $requete->execute();
    $articles3 = $requete->fetch(PDO::FETCH_OBJ);
    return $articles3->mont;
}
function VenteGlobalCreditPos($date_bd1, $date_bd2, $pos_id,$serveur_id, $bdd)
{
    $idsite = $_SESSION['id_hotel'];
    $q1="SELECT e.familletype_id,b.prixremise,a.taux_prix,a.monnaie,a.mode,a.mont_ttc_remise,c.idprod,c.code, c.designation,c.repas,c.nourriture,
    SUM(b.qte) AS qte, b.prixremise AS pu, b.dte_h,a.mode AS lib,SUM(((b.qte*b.prix)-((b.qte*b.prix*a.mont_ttc_remise)/100))/a.taux_prix) AS mont,
    SUM(b.qteoffert) AS qteoffert,SUM(b.qteoffert*b.prix2) AS montof
    FROM lignes_commandes AS b, stk_produit AS c, t_facture AS a,
    stk_sous_famille AS d,stk_famille AS e,stk_familletype AS f
    WHERE a.id_fact=b.commande_id 
    AND b.produit_id= c.idprod
    AND c.famille_id=d.id_s_fam
    AND d.famille=e.idfamille
    AND e.familletype_id=f.id
    AND a.mode='Credit'
    AND a.date_edition  BETWEEN :date_bd1 AND :date_bd2
    AND a.id_hotel=:id_hotel 
    AND a.id_sousresto=:id_sousresto";
    $q3=" ORDER BY c.nourriture,c.designation";
    $q2="";
    if($serveur_id!=0){
        $q2=" AND a.id_user=:id_user";
    }
    $q=$q1.$q2.$q3;
    $requete = $bdd->prepare($q);
    $requete->BindParam(':date_bd1', $date_bd1);
    $requete->BindParam(':date_bd2', $date_bd2);
    $requete->BindParam(':id_hotel', $idsite);
    $requete->BindParam(':id_sousresto', $pos_id);
    if($serveur_id!=0){
        $requete->BindParam(':id_user', $serveur_id);
    }
    $requete->execute();
    $articles3 = $requete->fetch(PDO::FETCH_OBJ);
    return $articles3->mont;
}

function GetTTCFac($id_fact, $bdd)
{
    $requete = $bdd->prepare("SELECT a.mont_ttc FROM t_facture AS a WHERE a.id_fact=:id_fact");
    $requete->BindParam(':id_fact', $id_fact);
    $requete->execute();
    $st = $requete->fetch(PDO::FETCH_OBJ);
    return $st->mont_ttc;
}
function GetNameTab($id_tab, $bdd)
{
    $requete = $bdd->prepare("SELECT a.designation FROM t_client AS a WHERE a.id_client=:id_tab");
    $requete->BindParam(':id_tab', $id_tab);
    $requete->execute();
    $st = $requete->fetch(PDO::FETCH_OBJ);
    return $st->designation;
}
function GetPrixProd($produit_id, $sousresto_id, $bdd)
{
    $requete = $bdd->prepare("SELECT p.prix_vente
    FROM t_prix_produit AS p
    WHERE p.produit_id=:produit_id AND p.sousresto_id=:sousresto_id");
    $requete->BindParam(':produit_id', $produit_id);
    $requete->BindParam(':sousresto_id', $sousresto_id);
    $requete->execute();
    $st = $requete->fetch(PDO::FETCH_OBJ);
    return $st->prix_vente;
}
function getFirstAndLastDateOfCurrentMonth()
{
    $mois = date('m');
    $annee = date('Y');
    $data = array();
    $data['startDate'] = date("Y-m-d", mktime(0, 0, 0, $mois, 1, $annee));
    $data['endDate'] = date("Y-m-d", mktime(0, 0, 0, $mois + 1, 0, $annee));

    return  $data;
}
function getTopTables($datedebut, $datefin, $monnaieAffichage, $id, $bdd)
{
    if ($monnaieAffichage == 'USD') {
        $req = "SELECT a.id_client,a.designation,c.libelle AS sousresto,SUM(b.mont_ttc) AS montant
        FROM t_client AS a,t_facture AS b,t_sousresto AS c
        WHERE a.id_client=b.id_client 
        AND a.id_sousresto=c.id_sousresto
        AND a.id_hotel=:id_hotel 
        AND b.date_edition BETWEEN :dte1 AND :dte2 
        AND a.type='table'
        AND b.etat_cmd=0
        GROUP BY a.id_client 
        ORDER BY montant DESC LIMIT 5";
        $requete = $bdd->prepare($req);
        $requete->BindParam(':id_hotel', $id);
        $requete->BindParam(':dte1', $datedebut);
        $requete->BindParam(':dte2', $datefin);
        $requete->execute();
        $result = $requete->fetchAll(PDO::FETCH_OBJ);
    } else {
        $req = "SELECT a.id_client,a.designation,c.libelle AS sousresto,SUM(b.mont_ttc*b.taux) AS montant
        FROM t_client AS a,t_facture AS b,t_sousresto AS c
        WHERE a.id_client=b.id_client 
        AND a.id_sousresto=c.id_sousresto
        AND a.id_hotel=:id_hotel 
        AND b.date_edition BETWEEN :dte1 AND :dte2 
        AND a.type='table'
        AND b.etat_cmd=0
        GROUP BY a.id_client 
        ORDER BY montant DESC LIMIT 5";
        $requete = $bdd->prepare($req);
        $requete->BindParam(':id_hotel', $id);
        $requete->BindParam(':dte1', $datedebut);
        $requete->BindParam(':dte2', $datefin);
        $requete->execute();
        $result = $requete->fetchAll(PDO::FETCH_OBJ);
    }

    return $result;
}
function getTopTables2($datedebut, $datefin, $monnaieAffichage, $id, $bdd)
{
    if ($monnaieAffichage == 'USD') {
        $req = "SELECT a.id_client,a.designation,c.libelle AS sousresto,SUM(b.mont_ttc) AS montant
        FROM t_client AS a,t_facture AS b,t_sousresto AS c
        WHERE a.id_client=b.id_client 
        AND a.id_sousresto=c.id_sousresto
        AND a.id_hotel=:id_hotel 
        AND b.date_edition BETWEEN :dte1 AND :dte2 
        AND a.type='table'
        AND b.etat_cmd=0
        GROUP BY a.id_client 
        ORDER BY montant DESC";
        $requete = $bdd->prepare($req);
        $requete->BindParam(':id_hotel', $id);
        $requete->BindParam(':dte1', $datedebut);
        $requete->BindParam(':dte2', $datefin);
        $requete->execute();
        $result = $requete->fetchAll(PDO::FETCH_OBJ);
    } else {
        $req = "SELECT a.id_client,a.designation,c.libelle AS sousresto,SUM(b.mont_ttc*b.taux) AS montant
        FROM t_client AS a,t_facture AS b,t_sousresto AS c
        WHERE a.id_client=b.id_client 
        AND a.id_sousresto=c.id_sousresto
        AND a.id_hotel=:id_hotel 
        AND b.date_edition BETWEEN :dte1 AND :dte2 
        AND a.type='table'
        AND b.etat_cmd=0
        GROUP BY a.id_client 
        ORDER BY montant DESC";
        $requete = $bdd->prepare($req);
        $requete->BindParam(':id_hotel', $id);
        $requete->BindParam(':dte1', $datedebut);
        $requete->BindParam(':dte2', $datefin);
        $requete->execute();
        $result = $requete->fetchAll(PDO::FETCH_OBJ);
    }

    return $result;
}
function LogRestaurant($date, $heure, $utilisateur, $evenement, $description, $module, $bdd)
{
    try {
        $requete = $bdd->prepare("INSERT INTO logapp(date,heure,utilisateur,evenement,description,module)
         VALUES(:date,:heure,:utilisateur,:evenement,:description,:module)");
        $requete->BindParam(':date', $date);
        $requete->BindParam(':heure', $heure);
        $requete->BindParam(':utilisateur', $utilisateur);
        $requete->BindParam(':evenement', $evenement);
        $requete->BindParam(':description', $description);
        $requete->BindParam(':module', $module);
        $requete->execute();
    } catch (Exception $exc) {
        echo $exc->getTraceAsString();
    }
}
function listedesoffres($dte1, $dte2, $id_sousresto, $bdd)
{

    if ($id_sousresto == 0) {
        $id_sousresto = $_SESSION['id_hotel'];
        $req = "SELECT  a.taux_prix,a.id_fact, a.num_fact, a.date_edition,d.nom_user,d.prenom_user,b.designation AS nomtable,e.designation,c.prix2,c.qte
        FROM t_facture AS a, t_client AS b,lignes_commandes AS c, t_utilisateur AS d, stk_produit AS e
        WHERE a.id_client=b.id_client AND a.id_fact=c.commande_id
            AND c.user_id=d.id_user AND c.produit_id=e.idprod 
            AND a.date_edition BETWEEN :dte1 AND :dte2
            AND c.prix=0
            AND a.etat_cmd<>3
            AND a.id_hotel=:id_sousresto
            ORDER BY a.num_fact DESC";
    } else {
        $req = "SELECT  a.taux_prix,a.id_fact, a.num_fact, a.date_edition,d.nom_user,d.prenom_user,b.designation AS nomtable,e.designation,c.prix2,c.qte
        FROM t_facture AS a, t_client AS b,lignes_commandes AS c, t_utilisateur AS d, stk_produit AS e
        WHERE a.id_client=b.id_client AND a.id_fact=c.commande_id
            AND c.user_id=d.id_user AND c.produit_id=e.idprod 
            AND a.date_edition BETWEEN :dte1 AND :dte2
            AND c.prix=0
            AND a.etat_cmd<>3
            AND a.id_sousresto=:id_sousresto
            ORDER BY a.num_fact DESC";
    }
    $requete = $bdd->prepare($req);
    $requete->BindParam(':id_sousresto', $id_sousresto);
    $requete->BindParam(':dte1', $dte1);
    $requete->BindParam(':dte2', $dte2);
    $requete->execute();
    $result = $requete->fetchAll(PDO::FETCH_OBJ);
    return  $result;
}

function insertBon($numero,$user_validate,$user_id,$facture_id,$client_id,$site_id,$bdd)
{
    $dte = date('Y-m-d');
    $dte_h = date('Y-m-d H:i:s');
    $status='0';
    $requete = $bdd->prepare("INSERT INTO bons (numero,status,dte ,dte_h ,user_validate,user_id,client_id,facture_id,site_id)
                VALUES(:numero,:status,:dte,:dte_h,:user_validate,:user_id,:client_id,:facture_id,:site_id)");
    $requete->BindParam(':numero',$numero);
    $requete->BindParam(':status',$status);
    $requete->BindParam(':dte', $dte);
    $requete->BindParam(':dte_h',$dte_h);
    $requete->BindParam(':user_validate', $user_validate);
    $requete->BindParam(':user_id', $user_id);
    $requete->BindParam(':client_id',$client_id);
    $requete->BindParam(':facture_id',$facture_id);
    $requete->BindParam(':site_id', $site_id);
    $requete->execute();
    return $bdd->lastInsertId();
}

function insertLignesBon($produit_id,$qte,$prix,$accomp,$bon_id,$bdd)
{
    $dte = date('Y-m-d');
    $dte_h = date('Y-m-d H:i:s');
    $status='0';
    $user_id=$_SESSION['id_user'];
    $requete = $bdd->prepare("INSERT INTO lignesbons (produit_id,qte,prix,accomp,bon_id,user_id)
                VALUES(:produit_id,:qte,:prix,:accomp,:bon_id,:user_id)");
    $requete->BindParam(':produit_id',$produit_id);
    $requete->BindParam(':qte',$qte);
    $requete->BindParam(':prix',$prix);
    $requete->BindParam(':accomp',$accomp);
    $requete->BindParam(':bon_id',$bon_id);
    $requete->BindParam(':user_id',$user_id);
    $requete->execute();
}

function getListBcByFact($id,$bdd)
{
    $requete = $bdd->prepare("SELECT a.*,b.nom_client,b.designation,b.type,c.nom_user,c.prenom_user,d.num_fact
         FROM  bons AS a,t_client AS b, t_utilisateur AS c,t_facture AS d
        WHERE a.facture_id=d.id_fact
         AND a.client_id=b.id_client
         AND   a.user_id=c.id_user
         AND  a.facture_id=:facture_id
         ORDER BY a.id DESC");
    $requete->BindParam(':facture_id',$id);
    $requete->execute();
    return $requete->fetchAll(PDO::FETCH_OBJ);
}
function getDetailsBC($id,$plat_id,$bdd)
{
    $requete = $bdd->prepare("SELECT a.id,a.produit_id,a.qte,a.prix,a.accomp,a.user_id,a.bon_id,
    b.designation FROM lignesbons AS a,stk_produit AS b 
    WHERE a.produit_id=b.idprod  AND a.bon_id=:bon_id AND a.produit_id=:produit_id AND b.repas=1 AND a.psedo=0");
    $requete->BindParam(':bon_id',$id);
    $requete->BindParam(':produit_id',$plat_id);
    $requete->execute();
    return $requete->fetchAll(PDO::FETCH_OBJ);
}
function getLineBC($id,$bdd)
{
    $requete = $bdd->prepare("SELECT a.id,a.produit_id,SUM(a.qte) AS qte,a.prix,GROUP_CONCAT(a.accomp) AS accomp,a.user_id,a.bon_id,
    b.designation FROM lignesbons AS a,stk_produit AS b 
    WHERE a.produit_id=b.idprod  AND a.bon_id=:bon_id AND b.repas=1 AND a.psedo=0  GROUP BY a.produit_id");
    $requete->BindParam(':bon_id',$id);
    $requete->execute();
    return $requete->fetchAll(PDO::FETCH_OBJ);
}
function deleteLignesBon($id,$bdd)
{
    $psedo=1;
    $requete = $bdd->prepare("UPDATE lignesbons  SET psedo=:psedo WHERE id=:id");
    $requete->BindParam(':psedo',$psedo);
    $requete->BindParam(':id',$id);
    $requete->execute();
}

function getInfosBcById($id,$bdd)
{
    $requete = $bdd->prepare("SELECT a.*,b.num_fact,c.nom_user,c.prenom_user
    FROM bons AS a,t_facture AS b,t_utilisateur AS c
    WHERE a.facture_id=b.id_fact AND a.user_id=c.id_user AND a.id=:id");
    $requete->BindParam(':id',$id);
    $requete->execute();
    return $requete->fetch(PDO::FETCH_OBJ);
}

function countBonsPrepared($id,$bdd)
{
    $requete = $bdd->prepare("SELECT COUNT(*) AS n FROM bons WHERE facture_id=:id AND status=1");
    $requete->BindParam(':id',$id);
    $requete->execute();
    $res=$requete->fetch(PDO::FETCH_OBJ);
    return $res->n;
}

function getListBcByFactAll($bdd)
{
    $requete = $bdd->prepare("SELECT a.*,b.nom_client,b.designation,b.type,c.nom_user,c.prenom_user,d.num_fact
         FROM  bons AS a,t_client AS b, t_utilisateur AS c,t_facture AS d
        WHERE a.facture_id=d.id_fact
         AND a.client_id=b.id_client
         AND   a.user_id=c.id_user
         AND   a.status=0
         ORDER BY a.id ASC");
    $requete->execute();
    return $requete->fetchAll(PDO::FETCH_OBJ);
}
function getListBcByFactAll2($dte1,$dte2,$bdd)
{
    $requete = $bdd->prepare("SELECT a.*,b.nom_client,b.designation,b.type,c.nom_user,c.prenom_user,d.num_fact
         FROM  bons AS a,t_client AS b, t_utilisateur AS c,t_facture AS d
        WHERE a.facture_id=d.id_fact
         AND a.client_id=b.id_client
         AND   a.user_id=c.id_user
         AND   a.status=1
         AND a.dte BETWEEN :dte1 AND :dte2
         ORDER BY a.id ASC");
    $requete->BindParam(':dte1',$dte1);
    $requete->BindParam(':dte2',$dte2);
    $requete->execute();
    return $requete->fetchAll(PDO::FETCH_OBJ);
}
function getDetailsBonAll($id,$bdd)
{
    $requete = $bdd->prepare("SELECT a.*,b.nom_client,b.designation,b.type,c.nom_user,c.prenom_user,d.num_fact
         FROM  bons AS a,t_client AS b, t_utilisateur AS c,t_facture AS d
        WHERE a.facture_id=d.id_fact
         AND a.client_id=b.id_client
         AND   a.user_id=c.id_user
         AND   a.status=0
         ORDER BY a.id ASC");
    $requete->execute();
    return $requete->fetchAll(PDO::FETCH_OBJ);
}

function ReimprimerBonCuisine2($bon_id, $bdd)
{
    $tva_fact = 0;
    $tauxfct = 1;
    $remise_fact = 0;
    $_SESSION['dessert'] = 0;
    $_SESSION['entree'] = 0;
    $_SESSION['plats'] = 0;
    $_SESSION['panier'] = array();
    $_SESSION['panier']['id_article'] = array();
    $_SESSION['panier']['nom'] = array();
    $_SESSION['panier']['qte'] = array();
    $_SESSION['panier']['prix'] = array();
    $_SESSION['panier']['repas'] = array();
    $_SESSION['panier']['genre'] = array();
    $_SESSION['panier']['pa'] = array();
    $_SESSION['panier']['description'] = array();
    $_SESSION['panier']['id_client'] = 0;
    $_SESSION['panier']['remise'] = 0;
    $_SESSION['panier']['mont_tva'] = 0;
    $_SESSION['panier']['mont_ttc'] = 0;
    $_SESSION['panier']['mont_ttc_remise'] = 0;
    $_SESSION['panier']['verrouille'] = false;
    $_SESSION['etat_cmd'] =1;
    $requete = $bdd->prepare("SELECT SUM(a.qte) AS qte,a.prix,a.produit_id,b.designation,b.repas,GROUP_CONCAT(a.accomp) AS accomp,b.pa,ss.genre
    FROM lignesbons AS a, stk_produit AS b,stk_sous_famille AS ss
    WHERE a.produit_id=b.idprod AND b.famille_id=ss.id_s_fam 
    AND a.psedo=0
    AND a.bon_id=:bon_id
    GROUP BY a.produit_id");
        $requete->BindParam(':bon_id', $bon_id);
        $requete->execute();
        $reservation_l_attente = $requete->fetchAll(PDO::FETCH_OBJ);
        foreach ($reservation_l_attente as $r) {
            $qte = $r->qte;
            $prix = $r->prix;
            $idprod = $r->produit_id;
            $designation = $r->designation;

            $repas = $r->repas;
            $genre = $r->genre;
            $des_plt = $r->accomp;
            $pa = $r->pa;

            array_push($_SESSION['panier']['id_article'], $idprod);
            array_push($_SESSION['panier']['nom'], $designation);
            array_push($_SESSION['panier']['qte'], $qte);
            array_push($_SESSION['panier']['prix'], $prix);
            array_push($_SESSION['panier']['repas'], $repas);
            array_push($_SESSION['panier']['genre'], $genre);
            array_push($_SESSION['panier']['pa'], $pa);
            array_push($_SESSION['panier']['description'], $des_plt);
            if ($genre == 2) {
                $_SESSION['dessert'] = 1;
            } elseif ($genre == 1) {
                $_SESSION['entree'] = 1;
            } elseif ($genre == 0) {
                $_SESSION['plats'] = 1;
            }
        }
        $mont_ht = 0;
        $nb_articles = count($_SESSION['panier']['id_article']);
        for ($i = 0; $i < $nb_articles; $i++) {
            $mont_ht += $_SESSION['panier']['qte'][$i] * $_SESSION['panier']['prix'][$i];
        }
        $total1 = $mont_ht;
        $total = total($total1, $tva_fact, $remise_fact);
        //        $mont_tva=tva($total,$tva_fact,$remise_fact);
        $mont_tva=0;
        $mont_rmz = remise($total1, $tva_fact, $remise_fact);
        $mont_ht = ht($total, $tva_fact, $remise_fact);

        $ttc = ttc($mont_ht, $mont_tva, $mont_rmz);
        $ttc2 =  montant_equivalent_bdd('CDF', 'USD', $tauxfct, $ttc);
        $_SESSION['panier']['mont_tva'] = $mont_tva;
        $_SESSION['panier']['mont_ttc'] = $mont_ht - $mont_rmz;
        $_SESSION['panier']['mont_remise'] = $mont_rmz;
        $_SESSION['panier']['mont_ht'] = $mont_ht;
        $_SESSION['panier']['mont_ttc_remise'] = $ttc;
        $_SESSION['ttc2'] = $ttc2;
    
}


function ReimprimerBC3($bon_id, $bdd)
{
    $tva_fact = 0;
    $tauxfct = 1;
    $remise_fact = 0;
    $_SESSION['dessert'] = 0;
    $_SESSION['entree'] = 0;
    $_SESSION['plats'] = 0;
    $_SESSION['panier'] = array();
    $_SESSION['panier']['id_article'] = array();
    $_SESSION['panier']['nom'] = array();
    $_SESSION['panier']['qte'] = array();
    $_SESSION['panier']['prix'] = array();
    $_SESSION['panier']['repas'] = array();
    $_SESSION['panier']['genre'] = array();
    $_SESSION['panier']['description'] = array();
    $_SESSION['panier']['id_client'] = 0;
    $_SESSION['panier']['remise'] = 0;
    $_SESSION['panier']['mont_tva'] = 0;
    $_SESSION['panier']['mont_ttc'] = 0;
    $_SESSION['panier']['mont_ttc_remise'] = 0;
    $_SESSION['panier']['verrouille'] = false;
    $requete = $bdd->prepare("SELECT a.*,b.nom_client,b.designation,b.type,c.nom_user,c.prenom_user,d.num_fact,d.note_cmd
    FROM  bons AS a,t_client AS b, t_utilisateur AS c,t_facture AS d
   WHERE a.facture_id=d.id_fact
    AND a.client_id=b.id_client
    AND a.user_id=c.id_user
    AND a.id=:id");
    $requete->BindParam(':id', $bon_id);
    $requete->execute();
    $reservation_attente = $requete->fetchAll(PDO::FETCH_OBJ);
    foreach ($reservation_attente as $ra) {
        $id = $ra->id;
        $id_fact = $id;
        $date_edition = $ra->dte;
        $dte_h = $ra->dte_h;
        $numbon = $ra->numero;
        $num_fact = $ra->num_fact;
        $tbl = $ra->designation;
        $cl = $ra->nom_client;
        $typ = $ra->type;
        $nom_serveur = $ra->nom_user;
        $status = $ra->status;
        $lib_status = 'en attente';
        if (($typ == 'client') || ($typ == 'serveur')) {
            $cl_tbl = $cl;
        } else if ($typ == 'table') {
            $cl_tbl = $tbl;
        } else {
            $cl_tbl = 'Client occasionnel';
        }
        $cl = $ra->nom_client;
        $_SESSION['nom_user'] = $nom_serveur;
        $_SESSION['date_edition'] = $date_edition;
        $_SESSION['date_edition2'] = $dte_h;
        $_SESSION['num_commande'] = $num_fact;
        $_SESSION['nom_client'] = $cl_tbl;
        $_SESSION['NoteCmdCui'] = $ra->note_cmd;
        $requete = $bdd->prepare("SELECT SUM(a.qte) AS qte,a.prix,b.idprod,a.produit_id,b.designation,b.repas,GROUP_CONCAT(a.accomp) AS accomp,b.pa,ss.genre
        FROM lignesbons AS a, stk_produit AS b,stk_sous_famille AS ss
        WHERE a.produit_id=b.idprod AND b.famille_id=ss.id_s_fam 
        AND a.psedo=0
        AND a.bon_id=:bon_id
        GROUP BY a.produit_id");
        $requete->BindParam(':bon_id', $id_fact);
        $requete->execute();
        $reservation_l_attente = $requete->fetchAll(PDO::FETCH_OBJ);
        foreach ($reservation_l_attente as $r) {
            $qte = $r->qte;
            //$impr = $r->impr;
            /* if ($impr == 1) {
                if ($r->qte2 != 0) {
                    $qte = $r->qte2;
                }
            } */

            if (round($r->qte) == 0) {
                $qte = $r->qteoffert;
            }
            $prix = $r->prix;
            $idprod = $r->idprod;
            $designation = $r->designation;
            $description = $r->accomp;
            $repas = $r->repas;
            $genre = $r->genre;
            array_push($_SESSION['panier']['id_article'], $idprod);
            array_push($_SESSION['panier']['nom'], $designation);
            array_push($_SESSION['panier']['qte'], $qte);
            array_push($_SESSION['panier']['prix'], $prix);
            array_push($_SESSION['panier']['repas'], $repas);
            array_push($_SESSION['panier']['genre'], $genre);
            array_push($_SESSION['panier']['description'], $description);
            if ($genre == 2) {
                $_SESSION['dessert'] = 1;
            } elseif ($genre == 1) {
                $_SESSION['entree'] = 1;
            } elseif ($genre == 0) {
                $_SESSION['plats'] = 1;
            }
        }
        $mont_ht = 0;
        $nb_articles = count($_SESSION['panier']['id_article']);
        for ($i = 0; $i < $nb_articles; $i++) {
            $mont_ht += $_SESSION['panier']['qte'][$i] * $_SESSION['panier']['prix'][$i];
        }
        $total1 = $mont_ht;
        $total = total($total1, $tva_fact, $remise_fact);
        $mont_tva = tva($total, $tva_fact, $remise_fact);
        $mont_rmz = remise($total1, $tva_fact, $remise_fact);
        $mont_ht = ht($total, $tva_fact, $remise_fact);

        $ttc = ttc($mont_ht, $mont_tva, $mont_rmz);
        $ttc2 =  montant_equivalent_bdd('CDF', 'USD', $tauxfct, $ttc);
        $_SESSION['panier']['mont_tva'] = $mont_tva;
        $_SESSION['panier']['mont_ttc'] = $mont_ht - $mont_rmz;
        $_SESSION['panier']['mont_remise'] = $mont_rmz;
        $_SESSION['panier']['mont_ht'] = $mont_ht;
        $_SESSION['panier']['mont_ttc_remise'] = $ttc;
        $_SESSION['ttc2'] = $ttc2;
    }
}

function checkIsprepared($id,$bdd)
{
    $requete = $bdd->prepare("SELECT COUNT(*) AS n FROM bons WHERE id=:id AND status=1");
    $requete->BindParam(':id',$id);
    $requete->execute();
    $res=$requete->fetch(PDO::FETCH_OBJ);
    return $res->n;
}


function CreateAcountForCustomer($compte1, $compte2, $account, $nom_client, $site_id, $bdd)
{
    //RECHERCHE COMPTE CLIENT
    $nb = 0;
    $bool = 0;
    $requete = $bdd->prepare("SELECT COUNT(*) AS nb_lg FROM cptsouscomptes WHERE numero=:numero");
    $requete->BindParam(':numero', $account);
    $requete->execute();
    $operations = $requete->fetchAll(PDO::FETCH_OBJ);
    foreach ($operations as $op) :
        $nb = $op->nb_lg;
    endforeach;
    if ($nb > 0) $bool = 1;
    //RECHERCHE COMPTE CLIENT
    if ($bool == 0) {
        //CREATION COMPTE CLIENT
        $libelle_cpt = $nom_client;
        $numero = $account;
        $compte_id = '284';
        $psedo = 0;
        $modif = 0;
        $suffixe = $compte2;
        $requete = $bdd->prepare("INSERT INTO cptsouscomptes (libelle,numero,compte_id,psedo,modif,site_id,suffixe)
                                            VALUES(:libelle,:numero,:compte_id,:psedo,:modif,:site_id,:suffixe)");

        $requete->BindParam(':libelle', $libelle_cpt);
        $requete->BindParam(':numero', $numero);
        $requete->BindParam(':compte_id', $compte_id);
        $requete->BindParam(':psedo', $psedo);
        $requete->BindParam(':modif', $modif);
        $requete->BindParam(':site_id', $site_id);
        $requete->BindParam(':suffixe', $suffixe);
        $requete->execute();
        //CREATION COMPTE CLIENT

    }
    //SELECTION COMPTE
    $_SESSION['Customer_compte_ecriture'] = '4111';
    $_SESSION['Customer_long_compte'] = 4;
    $_SESSION['Customer_souscompte_id'] = 385;
    $_SESSION['Customer_categorie_id'] = 49;
    $_SESSION['Customer_compte_id'] = 284;
    $_SESSION['Customer_nom_client'] = '';
    $requete = $bdd->prepare("SELECT *,b.numero AS compte_ecriture,b.id AS souscompte_id FROM cptsouscomptes AS b,cptcomptes AS c,cptcategories AS d WHERE b.compte_id=c.id AND c.categorie_id=d.id AND b.numero=:numero AND b.psedo=0");
    $requete->BindParam(':numero', $account);
    $requete->execute();
    $result = $requete->fetchAll(PDO::FETCH_OBJ);
    foreach ($result as $r) {
        $_SESSION['Customer_compte_ecriture'] = $r->compte_ecriture;
        $_SESSION['Customer_long_compte'] = 4;
        $_SESSION['Customer_souscompte_id'] = $r->souscompte_id;
        $_SESSION['Customer_categorie_id'] = 49;
        $_SESSION['Customer_compte_id'] = 284;
        $_SESSION['Customer_nom_client'] = $nom_client;
    }
    //SELECTION COMPTE
}




function listOfPaiementsByUser($caissier,$id, $dte1, $dte2, $bdd)
{


    if($id!=0){
    //Retourne toutes les commandes du sous-resto
    if($caissier==0){
        $req = "SELECT re.id_regl,re.numero,re.dte,re.date_regl,re.id_user,pa.montantusd,pa.montantcdf,pa.rendu_usd,pa.rendu_cdf,
        pa.taux,mo.lib,us.nom_user,us.prenom_user,cl.nom_client,cl.designation,cl.type,fc.num_fact,fc.mode,mo.lib
        FROM t_reglement AS re,paiement AS pa,t_mode_reglement AS mo,t_utilisateur AS us,t_facture AS fc,t_client AS cl
            WHERE re.id_regl=pa.regl_id 
                AND  mo.id_mode_regl=pa.id_mode_regl 
                AND  re.id_user=us.id_user
                AND  re.id_fact=fc.id_fact
                AND  fc.id_client=cl.id_client
                AND fc.id_sousresto=:id
                AND fc.type='restaurant'
                AND pa.motif='restaurant'
                AND re.dte BETWEEN :dte1 AND :dte2
            ";
        $requete = $bdd->prepare($req);
        $requete->BindParam(':id', $id);
        $requete->BindParam(':dte1', $dte1);
        $requete->BindParam(':dte2', $dte2);
    }else{
        $req = "SELECT re.id_regl,re.numero,re.dte,re.date_regl,re.id_user,pa.montantusd,pa.montantcdf,pa.rendu_usd,pa.rendu_cdf,
        pa.taux,mo.lib,us.nom_user,us.prenom_user,cl.nom_client,cl.designation,cl.type,fc.num_fact,fc.mode,mo.lib
        FROM t_reglement AS re,paiement AS pa,t_mode_reglement AS mo,t_utilisateur AS us,t_facture AS fc,t_client AS cl
        WHERE re.id_regl=pa.regl_id 
        AND  mo.id_mode_regl=pa.id_mode_regl 
        AND  re.id_user=us.id_user
        AND  re.id_fact=fc.id_fact
        AND  fc.id_client=cl.id_client
        AND  re.id_user=:id_user
        AND fc.id_sousresto=:id
        AND fc.type='restaurant'
        AND pa.motif='restaurant'
        AND re.dte BETWEEN :dte1 AND :dte2
        ";
        $requete = $bdd->prepare($req);
        $requete->BindParam(':id', $id);
        $requete->BindParam(':dte1', $dte1);
        $requete->BindParam(':dte2', $dte2);
        $requete->BindParam(':id_user',$caissier);
    }
}else{
    if($caissier==0){
        $req = "SELECT re.id_regl,re.numero,re.dte,re.date_regl,re.id_user,pa.montantusd,pa.montantcdf,pa.rendu_usd,pa.rendu_cdf,
        pa.taux,mo.lib,us.nom_user,us.prenom_user,cl.nom_client,cl.designation,cl.type,fc.num_fact,fc.mode,mo.lib
        FROM t_reglement AS re,paiement AS pa,t_mode_reglement AS mo,t_utilisateur AS us,t_facture AS fc,t_client AS cl
            WHERE re.id_regl=pa.regl_id 
                AND  mo.id_mode_regl=pa.id_mode_regl 
                AND  re.id_user=us.id_user
                AND  re.id_fact=fc.id_fact
                AND  fc.id_client=cl.id_client
                AND fc.type='restaurant'
                AND pa.motif='restaurant'
                AND re.dte BETWEEN :dte1 AND :dte2
            ";
        $requete = $bdd->prepare($req);
        $requete->BindParam(':dte1', $dte1);
        $requete->BindParam(':dte2', $dte2);
    }else{
        $req = "SELECT re.id_regl,re.numero,re.dte,re.date_regl,re.id_user,pa.montantusd,pa.montantcdf,pa.rendu_usd,pa.rendu_cdf,
        pa.taux,mo.lib,us.nom_user,us.prenom_user,cl.nom_client,cl.designation,cl.type,fc.num_fact,fc.mode,mo.lib
        FROM t_reglement AS re,paiement AS pa,t_mode_reglement AS mo,t_utilisateur AS us,t_facture AS fc,t_client AS cl
        WHERE re.id_regl=pa.regl_id 
        AND  mo.id_mode_regl=pa.id_mode_regl 
        AND  re.id_user=us.id_user
        AND  re.id_fact=fc.id_fact
        AND  fc.id_client=cl.id_client
        AND  re.id_user=:id_user
        AND fc.type='restaurant'
        AND pa.motif='restaurant'
        AND re.dte BETWEEN :dte1 AND :dte2
        ";
        $requete = $bdd->prepare($req);
        $requete->BindParam(':dte1', $dte1);
        $requete->BindParam(':dte2', $dte2);
        $requete->BindParam(':id_user',$caissier);
    }

}
    $requete->execute();
    $result = $requete->fetchAll(PDO::FETCH_OBJ);
    return $result;
}
function getTotalPaymentsByModeUser($caissier_id,$id, $dte1, $dte2, $maffiche, $bdd)
{
    if($id!=0){
    //Retourne toutes les commandes du sous-resto
    if($caissier_id==0){

        if ($maffiche == 'USD') {
            $req = "SELECT mo.lib, SUM((pa.montantusd-pa.rendu_usd)+(pa.montantcdf-pa.rendu_cdf)/pa.taux) AS montpaye
                            FROM t_reglement AS re,paiement AS pa,t_mode_reglement AS mo,t_facture AS ft
                            WHERE re.id_regl=pa.regl_id 
                        AND  mo.id_mode_regl=pa.id_mode_regl 
                        AND  ft.id_fact=re.id_fact
                        AND  ft.type='restaurant'
                        AND pa.motif='restaurant'
                        AND mo.visible=1
                        AND pa.id_sousresto=:id
                        AND re.dte BETWEEN :dte1 AND :dte2
                        GROUP BY mo.id_mode_regl ORDER BY re.id_regl DESC";
        } else {
            $req = "SELECT mo.lib, SUM((pa.montantusd-pa.rendu_usd)*pa.taux+(pa.montantcdf-pa.rendu_cdf)) AS montpaye
                            FROM t_reglement AS re,paiement AS pa,t_mode_reglement AS mo, t_facture AS ft
                            WHERE re.id_regl=pa.regl_id 
                        AND  mo.id_mode_regl=pa.id_mode_regl 
                        AND  ft.id_fact=re.id_fact
                        AND  ft.type='restaurant'
                        AND pa.motif='restaurant'
                        AND mo.visible=1
                        AND pa.id_sousresto=:id
                        AND re.dte BETWEEN :dte1 AND :dte2
                        GROUP BY mo.id_mode_regl";
        }
        $requete = $bdd->prepare($req);
        $requete->BindParam(':id', $id);
        $requete->BindParam(':dte1', $dte1);
        $requete->BindParam(':dte2', $dte2);
    }else{
        if ($maffiche == 'USD') {
            $req = "SELECT mo.lib, SUM((pa.montantusd-pa.rendu_usd)+(pa.montantcdf-pa.rendu_cdf)/pa.taux) AS montpaye
                            FROM t_reglement AS re,paiement AS pa,t_mode_reglement AS mo,t_facture AS ft
                            WHERE re.id_regl=pa.regl_id 
                        AND  mo.id_mode_regl=pa.id_mode_regl 
                        AND  ft.id_fact=re.id_fact
                        AND  ft.type='restaurant'
                        AND pa.motif='restaurant'
                        AND mo.visible=1
                        AND pa.id_sousresto=:id
                        AND re.dte BETWEEN :dte1 AND :dte2
                        AND re.id_user=:id_user
                        GROUP BY mo.id_mode_regl ORDER BY re.id_regl DESC";
        } else {
            $req = "SELECT mo.lib, SUM((pa.montantusd-pa.rendu_usd)*pa.taux+(pa.montantcdf-pa.rendu_cdf)) AS montpaye
                            FROM t_reglement AS re,paiement AS pa,t_mode_reglement AS mo, t_facture AS ft
                            WHERE re.id_regl=pa.regl_id 
                        AND  mo.id_mode_regl=pa.id_mode_regl 
                        AND  ft.id_fact=re.id_fact
                        AND  ft.type='restaurant'
                        AND pa.motif='restaurant'
                        AND mo.visible=1
                        AND pa.id_sousresto=:id
                        AND re.dte BETWEEN :dte1 AND :dte2
                        AND re.id_user=:id_user
                        GROUP BY mo.id_mode_regl";
        }
        $requete = $bdd->prepare($req);
        $requete->BindParam(':id', $id);
        $requete->BindParam(':dte1', $dte1);
        $requete->BindParam(':dte2', $dte2);
        $requete->BindParam(':id_user',$caissier_id);
    }
}else{

    if($caissier_id==0){

        if ($maffiche == 'USD') {
            $req = "SELECT mo.lib, SUM((pa.montantusd-pa.rendu_usd)+(pa.montantcdf-pa.rendu_cdf)/pa.taux) AS montpaye
                            FROM t_reglement AS re,paiement AS pa,t_mode_reglement AS mo,t_facture AS ft
                            WHERE re.id_regl=pa.regl_id 
                        AND  mo.id_mode_regl=pa.id_mode_regl 
                        AND  ft.id_fact=re.id_fact
                        AND  ft.type='restaurant'
                        AND pa.motif='restaurant'
                        AND mo.visible=1
                        AND re.dte BETWEEN :dte1 AND :dte2
                        GROUP BY mo.id_mode_regl ORDER BY re.id_regl DESC";
        } else {
            $req = "SELECT mo.lib, SUM((pa.montantusd-pa.rendu_usd)*pa.taux+(pa.montantcdf-pa.rendu_cdf)) AS montpaye
                            FROM t_reglement AS re,paiement AS pa,t_mode_reglement AS mo, t_facture AS ft
                            WHERE re.id_regl=pa.regl_id 
                        AND  mo.id_mode_regl=pa.id_mode_regl 
                        AND  ft.id_fact=re.id_fact
                        AND  ft.type='restaurant'
                        AND pa.motif='restaurant'
                        AND mo.visible=1
                        AND re.dte BETWEEN :dte1 AND :dte2
                        GROUP BY mo.id_mode_regl";
        }
        $requete = $bdd->prepare($req);
        $requete->BindParam(':dte1', $dte1);
        $requete->BindParam(':dte2', $dte2);
    }else{
        if ($maffiche == 'USD') {
            $req = "SELECT mo.lib, SUM((pa.montantusd-pa.rendu_usd)+(pa.montantcdf-pa.rendu_cdf)/pa.taux) AS montpaye
                            FROM t_reglement AS re,paiement AS pa,t_mode_reglement AS mo,t_facture AS ft
                            WHERE re.id_regl=pa.regl_id 
                        AND  mo.id_mode_regl=pa.id_mode_regl 
                        AND  ft.id_fact=re.id_fact
                        AND  ft.type='restaurant'
                        AND pa.motif='restaurant'
                        AND mo.visible=1
                        AND re.dte BETWEEN :dte1 AND :dte2
                        AND re.id_user=:id_user
                        GROUP BY mo.id_mode_regl ORDER BY re.id_regl DESC";
        } else {
            $req = "SELECT mo.lib, SUM((pa.montantusd-pa.rendu_usd)*pa.taux+(pa.montantcdf-pa.rendu_cdf)) AS montpaye
                            FROM t_reglement AS re,paiement AS pa,t_mode_reglement AS mo, t_facture AS ft
                            WHERE re.id_regl=pa.regl_id 
                        AND  mo.id_mode_regl=pa.id_mode_regl 
                        AND  ft.id_fact=re.id_fact
                        AND  ft.type='restaurant'
                        AND pa.motif='restaurant'
                        AND mo.visible=1
                        AND re.dte BETWEEN :dte1 AND :dte2
                        AND re.id_user=:id_user
                        GROUP BY mo.id_mode_regl";
        }
        $requete = $bdd->prepare($req);
        $requete->BindParam(':dte1', $dte1);
        $requete->BindParam(':dte2', $dte2);
        $requete->BindParam(':id_user',$caissier_id);
    }
}
    $requete->execute();
    $result = $requete->fetchAll(PDO::FETCH_OBJ);
    return $result;
}



//La Compta
function EcritureCompta($dte, $dteaff, $dtetime, $libelle, $reference, $beneficiaire, $journal_id, $psedo, $exercice_id, $user_id, $site_id, $bdd)
{

    $requete = $bdd->prepare("INSERT INTO cptecritures (dte,dteaff,dtetime,libelle,reference,beneficiaire,journal_id,psedo,exercice_id,user_id,site_id)
        VALUES(:dte,:dteaff,:dtetime,:libelle,:reference,:beneficiaire,:journal_id,:psedo,:exercice_id,:user_id,:site_id)");
    $requete->BindParam(':dte', $dte);
    $requete->BindParam(':dteaff', $dteaff);
    $requete->BindParam(':dtetime', $dtetime);
    $requete->BindParam(':libelle', $libelle);
    $requete->BindParam(':reference', $reference);
    $requete->BindParam(':beneficiaire', $beneficiaire);
    $requete->BindParam(':journal_id', $journal_id);
    $requete->BindParam(':psedo', $psedo);
    $requete->BindParam(':exercice_id', $exercice_id);
    $requete->BindParam(':user_id', $user_id);
    $requete->BindParam(':site_id', $site_id);
    $requete->execute();
    $id = $bdd->lastInsertId();
    return $id;
}

function DetailsEcritureCompta($compte_id, $debit, $credit, $devise, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd)
{

    $requete = $bdd->prepare("INSERT INTO cptdetailsecritures (compte_id,debit,credit,devise,taux,ecriture_id,site_id,categorie_id,souscompte_id,compte_ecriture,long_compte)
        VALUES(:compte_id,:debit,:credit,:devise,:taux,:ecriture_id,:site_id,:categorie_id,:souscompte_id,:compte_ecriture,:long_compte)");
    $requete->BindParam(':compte_id', $compte_id);
    $requete->BindParam(':debit', $debit);
    $requete->BindParam(':credit', $credit);
    $requete->BindParam(':devise', $devise);
    $requete->BindParam(':taux', $tauxop);
    $requete->BindParam(':ecriture_id', $ecriture_id);
    $requete->BindParam(':site_id', $site_id);
    $requete->BindParam(':categorie_id', $categorie_id);
    $requete->BindParam(':souscompte_id', $souscompte_id);
    $requete->BindParam(':compte_ecriture', $compte_ecriture);
    $requete->BindParam(':long_compte', $long_compte);
    $requete->execute();
    $id = $bdd->lastInsertId();
    return $id;
}

function ExerciceEncours($site_id, $bdd)
{
    $requete = 'SELECT id AS id_exercice,lib,fin,debut,cloture
    FROM  cptexercice
    WHERE  etat=1 AND site_id=:site_id';
    $query = $bdd->prepare($requete);
    $query->BindParam(':site_id', $site_id);
    $query->execute();
    $r = $query->fetch(PDO::FETCH_OBJ);
    $_SESSION['exercice_id'] = $r->id_exercice;
    $_SESSION['exercice_lib'] = $r->lib;
    $_SESSION['exercice_debut'] = $r->debut;
    $_SESSION['exercice_fin'] = $r->fin;
    $_SESSION['exercice_clot'] = $r->cloture;
}

function INFOSFromAccountNumber($compte_num, $format, $bdd)
{
    $data = array();
    $data['id'] = array();
    $data['lib'] = array();
    $id = 0;
    $lib = 0;
    if ($format == 2) {
        $requete = 'SELECT id,libelle FROM cptcategories WHERE numero=:compte_num';
        $query = $bdd->prepare($requete);
        $query->BindParam(':compte_num', $compte_num);
        $query->execute();
        $result = $query->fetchAll(PDO::FETCH_OBJ);
        foreach ($result as $r) {
            $id = $r->id;
            $lib = $r->libelle;
        }
    } else if ($format == 3) {
        $requete = 'SELECT id,libelle FROM cptcomptes WHERE numero=:compte_num';
        $query = $bdd->prepare($requete);
        $query->BindParam(':compte_num', $compte_num);
        $query->execute();
        $result = $query->fetchAll(PDO::FETCH_OBJ);
        foreach ($result as $r) {
            $id = $r->id;
            $lib = $r->libelle;
        }
    } else if ($format == 4) {
        $requete = 'SELECT id,libelle FROM cptsouscomptes WHERE numero=:compte_num';
        $query = $bdd->prepare($requete);
        $query->BindParam(':compte_num', $compte_num);
        $query->execute();
        $result = $query->fetchAll(PDO::FETCH_OBJ);
        foreach ($result as $r) {
            $id = $r->id;
            $lib = $r->libelle;
        }
    }
    $data['id'] = $id;
    $data['lib'] = $lib;
    return $data;
}

function TRESORERIE($entree, $libelle, $beneficiaire, $date_bon, $date_heure_bon, $montantFC, $montantUSD, $cpte_num, $id_user, $longcompte, $detail_id_ecrit, $lib_monnaie, $site_id, $bdd)
{
    $requete = $bdd->prepare("INSERT INTO t_operation (type,libelle,beneficiaire,date_bon,date_heure_bon,montantFC,
       montantUSD,numBordereau,mode_operation,session_id,motif_id,user_id,hotel_id,format,detail_id_ecrit)
       VALUES(:type,:libelle,:beneficiaire,:date_bon,:date_heure_bon,:montantFC
       ,:montantUSD,:numBordereau,:mode_operation,:session_id,
       :cpte_id,:user_id,:hotel_id,:format,:detail_id_ecrit)");
    $session_id = 1;
    $type_caisse = "normal";
    $numBordereau = "";
    $requete->BindParam(':type', $entree);
    $requete->BindParam(':libelle', $libelle);
    $requete->BindParam(':beneficiaire', $beneficiaire);
    $requete->BindParam(':date_bon', $date_bon);
    $requete->BindParam(':date_heure_bon', $date_heure_bon);
    $requete->BindParam(':montantFC', $montantFC);
    $requete->BindParam(':montantUSD', $montantUSD);
    $requete->BindParam(':numBordereau', $numBordereau);
    $requete->BindParam(':mode_operation', $type_caisse);
    $requete->BindParam(':session_id', $session_id);
    $requete->BindParam(':cpte_id', $cpte_num);
    $requete->BindParam(':user_id', $id_user);
    $requete->BindParam(':hotel_id', $site_id);
    $requete->BindParam(':format', $longcompte);
    $requete->BindParam(':detail_id_ecrit', $detail_id_ecrit);
    $requete->execute();
    $id_operation = $bdd->lastInsertId();
    //  Modification de numBon dans la bdd
    if ($entree == 'entree') {
        $pref = 'BE/';
    } else {
        $pref = 'BS/';
    }

    $num_cmd = getnumerotation($site_id, $lib_monnaie, $bdd);
    $numBon = $pref . str_pad($num_cmd, 4, "0", STR_PAD_LEFT); //001;
    $requete = $bdd->prepare("UPDATE t_operation  SET numBon =:numBon,type =:type WHERE idoperation=:idoperation");
    $requete->BindParam(':numBon', $numBon);
    $requete->BindParam(':type', $entree);
    $requete->BindParam(':idoperation', $id_operation);
    $requete->execute();
    $num_cmd += 1;
    setnumerotation($site_id, $lib_monnaie, $num_cmd, $bdd);
}

function ConfLinkMod($module_id, $site_id, $bdd)
{
    $_SESSION['ConfLinkMod'] = array();
    $_SESSION['ConfLinkMod']['compte_ecriture '] = array();
    $_SESSION['ConfLinkMod']['long_compte'] = array();
    $_SESSION['ConfLinkMod']['souscompte_id'] = array();
    $_SESSION['ConfLinkMod']['categorie_id'] = array();
    $_SESSION['ConfLinkMod']['compte_id'] = array();
    $_SESSION['ConfLinkMod']['libelle'] = array();
    $_SESSION['ConfLinkMod']['code'] = array();
    $_SESSION['ConfLinkMod']['champ'] = array();
    $_SESSION['ConfLinkMod_lie'] = 0;
    $requete = $bdd->prepare("SELECT * FROM cpt_liaison_module WHERE module_id=:module_id AND site_id=:site_id");
    $requete->BindParam(':module_id', $module_id);
    $requete->BindParam(':site_id', $site_id);
    $requete->execute();
    $result = $requete->fetchAll(PDO::FETCH_OBJ);
    foreach ($result as $r) {
        $_SESSION['ConfLinkMod_lie'] = $code = $r->lie;
        $code = $r->code;

        if (!in_array($code, $_SESSION['ConfLinkMod']['code'])) {
            array_push($_SESSION['ConfLinkMod']['code'], $code);
            $_SESSION['ConfLinkMod']['compte_ecriture'][$code] = $r->compte_ecriture;
            $_SESSION['ConfLinkMod']['long_compte'][$code] = $r->long_compte;
            $_SESSION['ConfLinkMod']['souscompte_id'][$code] = $r->souscompte_id;
            $_SESSION['ConfLinkMod']['categorie_id'][$code] = $r->categorie_id;
            $_SESSION['ConfLinkMod']['compte_id'][$code] = $r->compte_id;
            $_SESSION['ConfLinkMod']['libelle'][$code] = $r->libelle;
            $_SESSION['ConfLinkMod']['champ'][$code] = $r->champ;
        }
    }
}

function AccountCustomerProcess($id_client, $type_client, $bdd)
{
    //Pour les clients qui n'ont pas des comptes ils sont considere occasionnel
    $_SESSION['Customer_compte_ecriture'] = '4111';
    $_SESSION['Customer_long_compte'] = 4;
    $_SESSION['Customer_souscompte_id'] = 385;
    $_SESSION['Customer_categorie_id'] = 49;
    $_SESSION['Customer_compte_id'] = 284;

    $requete = $bdd->prepare("SELECT *,b.numero AS compte_ecriture,b.id AS souscompte_id FROM t_client AS a,cptsouscomptes AS b,cptcomptes AS c,cptcategories AS d WHERE a.id_sous_compte=b.id AND b.compte_id=c.id AND c.categorie_id=d.id AND a.id_client=:id_client AND b.psedo=0");
    $requete->BindParam(':id_client', $id_client);
    $requete->execute();
    $result = $requete->fetchAll(PDO::FETCH_OBJ);
    foreach ($result as $r) {
        if ($type_client == "occasionnel") {

            $_SESSION['Customer_compte_ecriture'] = '4111';
            $_SESSION['Customer_long_compte'] = 4;
            $_SESSION['Customer_souscompte_id'] = 385;
            $_SESSION['Customer_categorie_id'] = 49;
            $_SESSION['Customer_compte_id'] = 284;
        } else {

            $_SESSION['Customer_compte_ecriture'] = $r->compte_ecriture;
            $_SESSION['Customer_long_compte'] = 4;
            $_SESSION['Customer_souscompte_id'] = $r->souscompte_id;
            $_SESSION['Customer_categorie_id'] = 49;
            $_SESSION['Customer_compte_id'] = 284;
        }
    }
}

function GetAccountCustomer($id_sous_compte, $bdd)
{

    $_SESSION['souscomptes_id'] = 0;
    $_SESSION['souscomptes_lib'] = '';
    $_SESSION['souscomptes_num'] = '';
    if ($id_sous_compte != Null) {
        $requete = 'SELECT id,libelle,numero
    FROM  cptsouscomptes
    WHERE  id=:id_sous_compte';
        $query = $bdd->prepare($requete);
        $query->BindParam(':id_sous_compte', $id_sous_compte);
        $query->execute();
        $r = $query->fetch(PDO::FETCH_OBJ);
        $_SESSION['souscomptes_id'] = $r->id;
        $_SESSION['souscomptes_lib'] = $r->libelle;
        $_SESSION['souscomptes_num'] = $r->numero;
    }
}

function COMPTA_VENTE_CASH_RESTO($type_rendu, $reference, $dte, $dtetime, $montantusd, $montantcdf, $montantsaisi, $ht, $tva, $ttc, $devise, $tauxop, $libelle, $beneficiaire, $site_id, $user_id, $bdd)
{
    ExerciceEncours($site_id, $bdd);
    $exercice_id = $_SESSION['exercice_id'];
    $journal_id = 2;
    $montantcdf2 = 0;
    $montantusd2 = 0;
    $dteaff = $dte;
    $psedo = 0;
    //CAISSE CDF OU USD
    if ($montantcdf > 0 && $montantusd > 0) {

        $devisecdf = 'CDF';
        $deviseusd = 'USD';
        $ttc_cdf = montant_equivalent_bdd($devise, $devisecdf, $tauxop, $ttc);
        $ttc_usd = montant_equivalent_bdd($devise, $deviseusd, $tauxop, $ttc);

        if ($montantcdf >= $ttc_cdf) {

            $restecdf = $montantcdf - $ttc_cdf;
            $montantcdf = $ttc_cdf;
            $resteusd = $montantusd;
            //Ecriture Monnaie locale
            $devise_op = 'CDF';
            $libelle = 'Restaurant : paiement vente cash en CDF';
            $ecriture_id = EcritureCompta($dte, $dteaff, $dtetime, $libelle, $reference, $beneficiaire, $journal_id, $psedo, $exercice_id, $user_id, $site_id, $bdd);
            //TVA FACTUREE SUR VENTE
            $montanttva = 0;
            if ($tva != 0) {
                $montanttva = ($montantcdf * $tva) / 100;
                $compte_ecriture = $_SESSION['ConfLinkMod']['compte_ecriture']['TVA'];
                $long_compte = $_SESSION['ConfLinkMod']['long_compte']['TVA'];
                $souscompte_id = $_SESSION['ConfLinkMod']['souscompte_id']['TVA'];
                $categorie_id = $_SESSION['ConfLinkMod']['categorie_id']['TVA'];
                $compte_id = $_SESSION['ConfLinkMod']['compte_id']['TVA'];
                $debit = 0;
                $credit = $montanttva;
                DetailsEcritureCompta($compte_id, $debit, $credit, $devise_op, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
                //GENERATION RAPPORT
                $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
                $libcompte = $data['lib'];
                $compte = $compte_ecriture . ' ' . $libcompte;
                $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
                       VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
                $requete->BindParam(':dte', $dte);
                $requete->BindParam(':ref', $reference);
                $requete->BindParam(':compte', $compte);
                $requete->BindParam(':description', $libelle);
                $requete->BindParam(':debit', $debit);
                $requete->BindParam(':credit', $credit);
                $requete->BindParam(':devise', $devise_op);
                $requete->BindParam(':journal_id', $journal_id);
                $requete->BindParam(':exercice_id', $exercice_id);
                $requete->BindParam(':site_id', $site_id);
                $requete->BindParam(':ecriture_id', $ecriture_id);
                $requete->execute();
            }
            //TVA FACTUREE SUR VENTE
            $compte_ecriture = $_SESSION['ConfLinkMod']['compte_ecriture']['TRESLOC'];
            $long_compte = $_SESSION['ConfLinkMod']['long_compte']['TRESLOC'];
            $souscompte_id = $_SESSION['ConfLinkMod']['souscompte_id']['TRESLOC'];
            $categorie_id = $_SESSION['ConfLinkMod']['categorie_id']['TRESLOC'];
            $compte_id = $_SESSION['ConfLinkMod']['compte_id']['TRESLOC'];
            $debit = $montantcdf;
            $credit = 0;
            $detail_id_ecrit = DetailsEcritureCompta($compte_id, $debit, $credit, $devise_op, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
            //tresorerie
            $entree = 'entree';
            $date_bon = $dte;
            $date_heure_bon = $dtetime;
            $montantFC = $montantcdf;
            $montantUSD = 0;
            $cpte_num = $compte_ecriture;
            $id_user = $user_id;
            $longcompte = 4;
            $datas = INFOSFromAccountNumber($cpte_num, $longcompte, $bdd);
            $lib_monnaie = 'entreecdf';
            TRESORERIE($entree, $libelle, $beneficiaire, $date_bon, $date_heure_bon, $montantFC, $montantUSD, $cpte_num, $id_user, $longcompte, $detail_id_ecrit, $lib_monnaie, $site_id, $bdd);
            //GENERATION RAPPORT
            $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
            $libcompte = $data['lib'];
            $compte = $compte_ecriture . ' ' . $libcompte;
            $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
                   VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
            $requete->BindParam(':dte', $dte);
            $requete->BindParam(':ref', $reference);
            $requete->BindParam(':compte', $compte);
            $requete->BindParam(':description', $libelle);
            $requete->BindParam(':debit', $debit);
            $requete->BindParam(':credit', $credit);
            $requete->BindParam(':devise', $devise_op);
            $requete->BindParam(':journal_id', $journal_id);
            $requete->BindParam(':exercice_id', $exercice_id);
            $requete->BindParam(':site_id', $site_id);
            $requete->BindParam(':ecriture_id', $ecriture_id);
            $requete->execute();
            $ht = $montantcdf - $montanttva;

            //VENTE MARCHANDISE OU VENTE PRODUIT FINI
            $compte_ecriture = $_SESSION['ConfLinkMod']['compte_ecriture']['PROSERV'];
            $long_compte = $_SESSION['ConfLinkMod']['long_compte']['PROSERV'];
            $souscompte_id = $_SESSION['ConfLinkMod']['souscompte_id']['PROSERV'];
            $categorie_id = $_SESSION['ConfLinkMod']['categorie_id']['PROSERV'];
            $compte_id = $_SESSION['ConfLinkMod']['compte_id']['PROSERV'];
            $debit = 0;
            $credit = $ht;
            DetailsEcritureCompta($compte_id, $debit, $credit, $devise_op, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
            //GENERATION RAPPORT
            $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
            $libcompte = $data['lib'];
            $compte = $compte_ecriture . ' ' . $libcompte;
            $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
                   VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
            $requete->BindParam(':dte', $dte);
            $requete->BindParam(':ref', $reference);
            $requete->BindParam(':compte', $compte);
            $requete->BindParam(':description', $libelle);
            $requete->BindParam(':debit', $debit);
            $requete->BindParam(':credit', $credit);
            $requete->BindParam(':devise', $devise_op);
            $requete->BindParam(':journal_id', $journal_id);
            $requete->BindParam(':exercice_id', $exercice_id);
            $requete->BindParam(':site_id', $site_id);
            $requete->BindParam(':ecriture_id', $ecriture_id);
            $requete->execute();
            //VENTE MARCHANDISE OU VENTE PRODUIT FINI

        } elseif ($montantusd >= $ttc_usd) {

            $resteusd = $montantusd - $ttc_usd;
            $montantusd = $ttc_usd;
            $restecdf = $montantcdf;
            //Ecriture Monnaie etrangere
            $libelle = 'Restaurant : paiement vente cash en USD';
            $ecriture_id = EcritureCompta($dte, $dteaff, $dtetime, $libelle, $reference, $beneficiaire, $journal_id, $psedo, $exercice_id, $user_id, $site_id, $bdd);
            $devise_op = 'USD';
            //TVA FACTUREE SUR VENTE
            $montanttva = 0;
            if ($tva != 0) {
                $montanttva = ($montantusd * $tva) / 100;
                $compte_ecriture = $_SESSION['ConfLinkMod']['compte_ecriture']['TVA'];
                $long_compte = $_SESSION['ConfLinkMod']['long_compte']['TVA'];
                $souscompte_id = $_SESSION['ConfLinkMod']['souscompte_id']['TVA'];
                $categorie_id = $_SESSION['ConfLinkMod']['categorie_id']['TVA'];
                $compte_id = $_SESSION['ConfLinkMod']['compte_id']['TVA'];
                $debit = 0;
                $credit = $montanttva;
                $libelledescrpt = '';
                $numdoc = '';
                DetailsEcritureCompta($compte_id, $debit, $credit, $devise_op, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
                //GENERATION RAPPORT
                $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
                $libcompte = $data['lib'];
                $compte = $compte_ecriture . ' ' . $libcompte;
                $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
                       VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
                $requete->BindParam(':dte', $dte);
                $requete->BindParam(':ref', $reference);
                $requete->BindParam(':compte', $compte);
                $requete->BindParam(':description', $libelle);
                $requete->BindParam(':debit', $debit);
                $requete->BindParam(':credit', $credit);
                $requete->BindParam(':devise', $devise_op);
                $requete->BindParam(':journal_id', $journal_id);
                $requete->BindParam(':exercice_id', $exercice_id);
                $requete->BindParam(':site_id', $site_id);
                $requete->BindParam(':ecriture_id', $ecriture_id);
                $requete->execute();
            }
            //TVA FACTUREE SUR VENTE
            $compte_ecriture = $_SESSION['ConfLinkMod']['compte_ecriture']['TRESETR'];
            $long_compte = $_SESSION['ConfLinkMod']['long_compte']['TRESETR'];
            $souscompte_id = $_SESSION['ConfLinkMod']['souscompte_id']['TRESETR'];
            $categorie_id = $_SESSION['ConfLinkMod']['categorie_id']['TRESETR'];
            $compte_id = $_SESSION['ConfLinkMod']['compte_id']['TRESETR'];
            $debit = $montantusd;
            $credit = 0;
            $detail_id_ecrit = DetailsEcritureCompta($compte_id, $debit, $credit, $devise_op, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
            //tresorerie
            $entree = 'entree';
            $date_bon = $dte;
            $date_heure_bon = $dtetime;
            $montantFC = 0;
            $montantUSD = $montantusd;
            $cpte_num = $compte_ecriture;
            $id_user = $user_id;
            $longcompte = 4;
            $datas = INFOSFromAccountNumber($cpte_num, $longcompte, $bdd);
            $lib_monnaie = 'entreeusd';
            TRESORERIE($entree, $libelle, $beneficiaire, $date_bon, $date_heure_bon, $montantFC, $montantUSD, $cpte_num, $id_user, $longcompte, $detail_id_ecrit, $lib_monnaie, $site_id, $bdd);
            //GENERATION RAPPORT
            $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
            $libcompte = $data['lib'];
            $compte = $compte_ecriture . ' ' . $libcompte;
            $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
                   VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
            $requete->BindParam(':dte', $dte);
            $requete->BindParam(':ref', $reference);
            $requete->BindParam(':compte', $compte);
            $requete->BindParam(':description', $libelle);
            $requete->BindParam(':debit', $debit);
            $requete->BindParam(':credit', $credit);
            $requete->BindParam(':devise', $devise_op);
            $requete->BindParam(':journal_id', $journal_id);
            $requete->BindParam(':exercice_id', $exercice_id);
            $requete->BindParam(':site_id', $site_id);
            $requete->BindParam(':ecriture_id', $ecriture_id);
            $requete->execute();
            $ht = $montantusd - $montanttva;
            //VENTE MARCHANDISE OU VENTE PRODUIT FINI
            $compte_ecriture = $_SESSION['ConfLinkMod']['compte_ecriture']['PROSERV'];
            $long_compte = $_SESSION['ConfLinkMod']['long_compte']['PROSERV'];
            $souscompte_id = $_SESSION['ConfLinkMod']['souscompte_id']['PROSERV'];
            $categorie_id = $_SESSION['ConfLinkMod']['categorie_id']['PROSERV'];
            $compte_id = $_SESSION['ConfLinkMod']['compte_id']['PROSERV'];
            $debit = 0;
            $credit = $ht;
            DetailsEcritureCompta($compte_id, $debit, $credit, $devise_op, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
            //GENERATION RAPPORT
            $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
            $libcompte = $data['lib'];
            $compte = $compte_ecriture . ' ' . $libcompte;
            $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
                   VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
            $requete->BindParam(':dte', $dte);
            $requete->BindParam(':ref', $reference);
            $requete->BindParam(':compte', $compte);
            $requete->BindParam(':description', $libelle);
            $requete->BindParam(':debit', $debit);
            $requete->BindParam(':credit', $credit);
            $requete->BindParam(':devise', $devise_op);
            $requete->BindParam(':journal_id', $journal_id);
            $requete->BindParam(':exercice_id', $exercice_id);
            $requete->BindParam(':site_id', $site_id);
            $requete->BindParam(':ecriture_id', $ecriture_id);
            $requete->execute();
            //VENTE MARCHANDISE OU VENTE PRODUIT FINI



        } elseif ($montantcdf < $ttc_cdf) {

            $restecdf = 0;
            $soldecdf = $ttc_cdf - $montantcdf;
            $soldeusd = montant_equivalent_bdd($devisecdf, $deviseusd, $tauxop, $soldecdf);
            $resteusd = $montantusd - $soldeusd;
            if ($montantusd >= $soldeusd) {
                $montantusd = $soldeusd;
            }
            //Ecriture Monnaie etrangere
            $libelle = 'Restaurant : paiement vente cash en CDF';
            $ecriture_id = EcritureCompta($dte, $dteaff, $dtetime, $libelle, $reference, $beneficiaire, $journal_id, $psedo, $exercice_id, $user_id, $site_id, $bdd);
            $devise_op = 'CDF';
            //TVA FACTUREE SUR VENTE
            $montanttva = 0;
            if ($tva != 0) {
                $montanttva = ($montantcdf * $tva) / 100;
                $compte_ecriture = $_SESSION['ConfLinkMod']['compte_ecriture']['TVA'];
                $long_compte = $_SESSION['ConfLinkMod']['long_compte']['TVA'];
                $souscompte_id = $_SESSION['ConfLinkMod']['souscompte_id']['TVA'];
                $categorie_id = $_SESSION['ConfLinkMod']['categorie_id']['TVA'];
                $compte_id = $_SESSION['ConfLinkMod']['compte_id']['TVA'];
                $debit = 0;
                $credit = $montanttva;

                DetailsEcritureCompta($compte_id, $debit, $credit, $devise_op, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
                //GENERATION RAPPORT
                $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
                $libcompte = $data['lib'];
                $compte = $compte_ecriture . ' ' . $libcompte;
                $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
                   VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
                $requete->BindParam(':dte', $dte);
                $requete->BindParam(':ref', $reference);
                $requete->BindParam(':compte', $compte);
                $requete->BindParam(':description', $libelle);
                $requete->BindParam(':debit', $debit);
                $requete->BindParam(':credit', $credit);
                $requete->BindParam(':devise', $devise_op);
                $requete->BindParam(':journal_id', $journal_id);
                $requete->BindParam(':exercice_id', $exercice_id);
                $requete->BindParam(':site_id', $site_id);
                $requete->BindParam(':ecriture_id', $ecriture_id);
                $requete->execute();
            }
            //TVA FACTUREE SUR VENTE
            $compte_ecriture = $_SESSION['ConfLinkMod']['compte_ecriture']['TRESLOC'];
            $long_compte = $_SESSION['ConfLinkMod']['long_compte']['TRESLOC'];
            $souscompte_id = $_SESSION['ConfLinkMod']['souscompte_id']['TRESLOC'];
            $categorie_id = $_SESSION['ConfLinkMod']['categorie_id']['TRESLOC'];
            $compte_id = $_SESSION['ConfLinkMod']['compte_id']['TRESLOC'];
            $debit = $montantcdf;
            $credit = 0;
            $detail_id_ecrit = DetailsEcritureCompta($compte_id, $debit, $credit, $devise_op, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
            //tresorerie
            $entree = 'entree';
            $date_bon = $dte;
            $date_heure_bon = $dtetime;
            $montantFC = $montantcdf;
            $montantUSD = 0;
            $cpte_num = $compte_ecriture;
            $id_user = $user_id;
            $longcompte = 4;
            $datas = INFOSFromAccountNumber($cpte_num, $longcompte, $bdd);
            $lib_monnaie = 'entreeusd';
            TRESORERIE($entree, $libelle, $beneficiaire, $date_bon, $date_heure_bon, $montantFC, $montantUSD, $cpte_num, $id_user, $longcompte, $detail_id_ecrit, $lib_monnaie, $site_id, $bdd);
            //GENERATION RAPPORT
            $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
            $libcompte = $data['lib'];
            $compte = $compte_ecriture . ' ' . $libcompte;
            $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
               VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
            $requete->BindParam(':dte', $dte);
            $requete->BindParam(':ref', $reference);
            $requete->BindParam(':compte', $compte);
            $requete->BindParam(':description', $libelle);
            $requete->BindParam(':debit', $debit);
            $requete->BindParam(':credit', $credit);
            $requete->BindParam(':devise', $devise_op);
            $requete->BindParam(':journal_id', $journal_id);
            $requete->BindParam(':exercice_id', $exercice_id);
            $requete->BindParam(':site_id', $site_id);
            $requete->BindParam(':ecriture_id', $ecriture_id);
            $requete->execute();
            $ht = $montantcdf - $montanttva;
            //VENTE MARCHANDISE OU VENTE PRODUIT FINI
            $compte_ecriture = $_SESSION['ConfLinkMod']['compte_ecriture']['PROSERV'];
            $long_compte = $_SESSION['ConfLinkMod']['long_compte']['PROSERV'];
            $souscompte_id = $_SESSION['ConfLinkMod']['souscompte_id']['PROSERV'];
            $categorie_id = $_SESSION['ConfLinkMod']['categorie_id']['PROSERV'];
            $compte_id = $_SESSION['ConfLinkMod']['compte_id']['PROSERV'];
            $debit = 0;
            $credit = $ht;
            $libelledescrpt = '';
            $numdoc = '';
            DetailsEcritureCompta($compte_id, $debit, $credit, $devise_op, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
            //GENERATION RAPPORT
            $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
            $libcompte = $data['lib'];
            $compte = $compte_ecriture . ' ' . $libcompte;
            $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
               VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
            $requete->BindParam(':dte', $dte);
            $requete->BindParam(':ref', $reference);
            $requete->BindParam(':compte', $compte);
            $requete->BindParam(':description', $libelle);
            $requete->BindParam(':debit', $debit);
            $requete->BindParam(':credit', $credit);
            $requete->BindParam(':devise', $devise_op);
            $requete->BindParam(':journal_id', $journal_id);
            $requete->BindParam(':exercice_id', $exercice_id);
            $requete->BindParam(':site_id', $site_id);
            $requete->BindParam(':ecriture_id', $ecriture_id);
            $requete->execute();
            //VENTE MARCHANDISE OU VENTE PRODUIT FINI
            //COMPLEMENT PAIEMENT USD
            $libelle = 'Restaurant : complement paiement en USD';
            $ecriture_id = EcritureCompta($dte, $dteaff, $dtetime, $libelle, $reference, $beneficiaire, $journal_id, $psedo, $exercice_id, $user_id, $site_id, $bdd);
            $montantusd2 = $montantusd;
            $deviseusd = 'USD';
            $montant_ttc = montant_equivalent_bdd($devise, $deviseusd, $tauxop, $ttc);
            if ($montantusd > $montant_ttc) {
                $montantusd = $montant_ttc;
            }
            $devise_op = 'USD';
            //TVA FACTUREE SUR VENTE
            $montanttva = 0;
            if ($tva != 0) {
                $montanttva = ($montantusd * $tva) / 100;
                $compte_ecriture = $_SESSION['ConfLinkMod']['compte_ecriture']['TVA'];
                $long_compte = $_SESSION['ConfLinkMod']['long_compte']['TVA'];
                $souscompte_id = $_SESSION['ConfLinkMod']['souscompte_id']['TVA'];
                $categorie_id = $_SESSION['ConfLinkMod']['categorie_id']['TVA'];
                $compte_id = $_SESSION['ConfLinkMod']['compte_id']['TVA'];
                $debit = 0;
                $credit = $montanttva;
                DetailsEcritureCompta($compte_id, $debit, $credit, $devise_op, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
                //GENERATION RAPPORT
                $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
                $libcompte = $data['lib'];
                $compte = $compte_ecriture . ' ' . $libcompte;
                $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
                VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
                $requete->BindParam(':dte', $dte);
                $requete->BindParam(':ref', $reference);
                $requete->BindParam(':compte', $compte);
                $requete->BindParam(':description', $libelle);
                $requete->BindParam(':debit', $debit);
                $requete->BindParam(':credit', $credit);
                $requete->BindParam(':devise', $devise_op);
                $requete->BindParam(':journal_id', $journal_id);
                $requete->BindParam(':exercice_id', $exercice_id);
                $requete->BindParam(':site_id', $site_id);
                $requete->BindParam(':ecriture_id', $ecriture_id);
                $requete->execute();
            }
            //TVA FACTUREE SUR VENTE
            $compte_ecriture = $_SESSION['ConfLinkMod']['compte_ecriture']['TRESETR'];
            $long_compte = $_SESSION['ConfLinkMod']['long_compte']['TRESETR'];
            $souscompte_id = $_SESSION['ConfLinkMod']['souscompte_id']['TRESETR'];
            $categorie_id = $_SESSION['ConfLinkMod']['categorie_id']['TRESETR'];
            $compte_id = $_SESSION['ConfLinkMod']['compte_id']['TRESETR'];
            $debit = $montantusd;
            $credit = 0;
            $detail_id_ecrit = DetailsEcritureCompta($compte_id, $debit, $credit, $devise_op, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
            //tresorerie
            $entree = 'entree';
            $date_bon = $dte;
            $date_heure_bon = $dtetime;
            $montantFC = 0;
            $montantUSD = $montantusd;
            $cpte_num = $compte_ecriture;
            $id_user = $user_id;
            $longcompte = 4;
            $datas = INFOSFromAccountNumber($cpte_num, $longcompte, $bdd);
            $lib_monnaie = 'entreeusd';
            TRESORERIE($entree, $libelle, $beneficiaire, $date_bon, $date_heure_bon, $montantFC, $montantUSD, $cpte_num, $id_user, $longcompte, $detail_id_ecrit, $lib_monnaie, $site_id, $bdd);
            //GENERATION RAPPORT
            $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
            $libcompte = $data['lib'];
            $compte = $compte_ecriture . ' ' . $libcompte;
            $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
            VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
            $requete->BindParam(':dte', $dte);
            $requete->BindParam(':ref', $reference);
            $requete->BindParam(':compte', $compte);
            $requete->BindParam(':description', $libelle);
            $requete->BindParam(':debit', $debit);
            $requete->BindParam(':credit', $credit);
            $requete->BindParam(':devise', $devise_op);
            $requete->BindParam(':journal_id', $journal_id);
            $requete->BindParam(':exercice_id', $exercice_id);
            $requete->BindParam(':site_id', $site_id);
            $requete->BindParam(':ecriture_id', $ecriture_id);
            $requete->execute();
            $ht = $montantusd - $montanttva;

            //VENTE MARCHANDISE OU VENTE PRODUIT FINI
            $compte_ecriture = $_SESSION['ConfLinkMod']['compte_ecriture']['PROSERV'];
            $long_compte = $_SESSION['ConfLinkMod']['long_compte']['PROSERV'];
            $souscompte_id = $_SESSION['ConfLinkMod']['souscompte_id']['PROSERV'];
            $categorie_id = $_SESSION['ConfLinkMod']['categorie_id']['PROSERV'];
            $compte_id = $_SESSION['ConfLinkMod']['compte_id']['PROSERV'];
            $debit = 0;
            $credit = $ht;
            DetailsEcritureCompta($compte_id, $debit, $credit, $devise_op, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
            //GENERATION RAPPORT
            $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
            $libcompte = $data['lib'];
            $compte = $compte_ecriture . ' ' . $libcompte;
            $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
             VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
            $requete->BindParam(':dte', $dte);
            $requete->BindParam(':ref', $reference);
            $requete->BindParam(':compte', $compte);
            $requete->BindParam(':description', $libelle);
            $requete->BindParam(':debit', $debit);
            $requete->BindParam(':credit', $credit);
            $requete->BindParam(':devise', $devise_op);
            $requete->BindParam(':journal_id', $journal_id);
            $requete->BindParam(':exercice_id', $exercice_id);
            $requete->BindParam(':site_id', $site_id);
            $requete->BindParam(':ecriture_id', $ecriture_id);
            $requete->execute();
            //VENTE MARCHANDISE OU VENTE PRODUIT FINI
        }
    } elseif ($montantcdf > 0) {
        $libelle = 'Restaurant : paiement vente cash en CDF';
        $ecriture_id = EcritureCompta($dte, $dteaff, $dtetime, $libelle, $reference, $beneficiaire, $journal_id, $psedo, $exercice_id, $user_id, $site_id, $bdd);
        $devisecdf = 'CDF';
        $montant_ttc = montant_equivalent_bdd($devise, $devisecdf, $tauxop, $ttc);
        if ($montantcdf > $montant_ttc) {
            $montantcdf = $montant_ttc;
        }
        $devise_op = 'CDF';
        //TVA FACTUREE SUR VENTE
        $montanttva = 0;
        if ($tva != 0) {
            $montanttva = ($montantcdf * $tva) / 100;
            $compte_ecriture = $_SESSION['ConfLinkMod']['compte_ecriture']['TVA'];
            $long_compte = $_SESSION['ConfLinkMod']['long_compte']['TVA'];
            $souscompte_id = $_SESSION['ConfLinkMod']['souscompte_id']['TVA'];
            $categorie_id = $_SESSION['ConfLinkMod']['categorie_id']['TVA'];
            $compte_id = $_SESSION['ConfLinkMod']['compte_id']['TVA'];
            $debit = 0;
            $credit = $montanttva;
            DetailsEcritureCompta($compte_id, $debit, $credit, $devise_op, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
            //GENERATION RAPPORT
            $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
            $libcompte = $data['lib'];
            $compte = $compte_ecriture . ' ' . $libcompte;
            $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
            VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
            $requete->BindParam(':dte', $dte);
            $requete->BindParam(':ref', $reference);
            $requete->BindParam(':compte', $compte);
            $requete->BindParam(':description', $libelle);
            $requete->BindParam(':debit', $debit);
            $requete->BindParam(':credit', $credit);
            $requete->BindParam(':devise', $devise_op);
            $requete->BindParam(':journal_id', $journal_id);
            $requete->BindParam(':exercice_id', $exercice_id);
            $requete->BindParam(':site_id', $site_id);
            $requete->BindParam(':ecriture_id', $ecriture_id);
            $requete->execute();
        }
        //TVA FACTUREE SUR VENTE
        $compte_ecriture = $_SESSION['ConfLinkMod']['compte_ecriture']['TRESLOC'];
        $long_compte = $_SESSION['ConfLinkMod']['long_compte']['TRESLOC'];
        $souscompte_id = $_SESSION['ConfLinkMod']['souscompte_id']['TRESLOC'];
        $categorie_id = $_SESSION['ConfLinkMod']['categorie_id']['TRESLOC'];
        $compte_id = $_SESSION['ConfLinkMod']['compte_id']['TRESLOC'];
        $debit = $montantcdf;
        $credit = 0;
        $detail_id_ecrit = DetailsEcritureCompta($compte_id, $debit, $credit, $devise_op, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
        //tresorerie
        $entree = 'entree';
        $date_bon = $dte;
        $date_heure_bon = $dtetime;
        $montantFC = $montantcdf;
        $montantUSD = 0;
        $cpte_num = $compte_ecriture;
        $id_user = $user_id;
        $longcompte = 4;
        $datas = INFOSFromAccountNumber($cpte_num, $longcompte, $bdd);
        $lib_monnaie = 'entreecdf';
        TRESORERIE($entree, $libelle, $beneficiaire, $date_bon, $date_heure_bon, $montantFC, $montantUSD, $cpte_num, $id_user, $longcompte, $detail_id_ecrit, $lib_monnaie, $site_id, $bdd);
        //GENERATION RAPPORT
        $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
        $libcompte = $data['lib'];
        $compte = $compte_ecriture . ' ' . $libcompte;
        $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
        VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
        $requete->BindParam(':dte', $dte);
        $requete->BindParam(':ref', $reference);
        $requete->BindParam(':compte', $compte);
        $requete->BindParam(':description', $libelle);
        $requete->BindParam(':debit', $debit);
        $requete->BindParam(':credit', $credit);
        $requete->BindParam(':devise', $devise_op);
        $requete->BindParam(':journal_id', $journal_id);
        $requete->BindParam(':exercice_id', $exercice_id);
        $requete->BindParam(':site_id', $site_id);
        $requete->BindParam(':ecriture_id', $ecriture_id);
        $requete->execute();
        $ht = $montantcdf - $montanttva;

        //VENTE MARCHANDISE OU VENTE PRODUIT FINI
        $compte_ecriture = $_SESSION['ConfLinkMod']['compte_ecriture']['PROSERV'];
        $long_compte = $_SESSION['ConfLinkMod']['long_compte']['PROSERV'];
        $souscompte_id = $_SESSION['ConfLinkMod']['souscompte_id']['PROSERV'];
        $categorie_id = $_SESSION['ConfLinkMod']['categorie_id']['PROSERV'];
        $compte_id = $_SESSION['ConfLinkMod']['compte_id']['PROSERV'];
        $debit = 0;
        $credit = $ht;
        DetailsEcritureCompta($compte_id, $debit, $credit, $devise_op, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
        //GENERATION RAPPORT
        $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
        $libcompte = $data['lib'];
        $compte = $compte_ecriture . ' ' . $libcompte;
        $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
        VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
        $requete->BindParam(':dte', $dte);
        $requete->BindParam(':ref', $reference);
        $requete->BindParam(':compte', $compte);
        $requete->BindParam(':description', $libelle);
        $requete->BindParam(':debit', $debit);
        $requete->BindParam(':credit', $credit);
        $requete->BindParam(':devise', $devise_op);
        $requete->BindParam(':journal_id', $journal_id);
        $requete->BindParam(':exercice_id', $exercice_id);
        $requete->BindParam(':site_id', $site_id);
        $requete->BindParam(':ecriture_id', $ecriture_id);
        $requete->execute();
        //VENTE MARCHANDISE OU VENTE PRODUIT FINI
    } elseif ($montantusd > 0) {
        $libelle = 'Restaurant : paiement vente cash en USD';
        $ecriture_id = EcritureCompta($dte, $dteaff, $dtetime, $libelle, $reference, $beneficiaire, $journal_id, $psedo, $exercice_id, $user_id, $site_id, $bdd);
        $deviseusd = 'USD';
        $montant_ttc = montant_equivalent_bdd($devise, $deviseusd, $tauxop, $ttc);
        if ($montantusd > $ttc) {
            $montantusd = $montant_ttc;
        }
        $devise_op = 'USD';
        //TVA FACTUREE SUR VENTE
        $montanttva = 0;
        if ($tva != 0) {
            $montanttva = ($montantusd * $tva) / 100;
            $compte_ecriture = $_SESSION['ConfLinkMod']['compte_ecriture']['TVA'];
            $long_compte = $_SESSION['ConfLinkMod']['long_compte']['TVA'];
            $souscompte_id = $_SESSION['ConfLinkMod']['souscompte_id']['TVA'];
            $categorie_id = $_SESSION['ConfLinkMod']['categorie_id']['TVA'];
            $compte_id = $_SESSION['ConfLinkMod']['compte_id']['TVA'];
            $debit = 0;
            $credit = $montanttva;
            DetailsEcritureCompta($compte_id, $debit, $credit, $devise_op, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
            //GENERATION RAPPORT
            $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
            $libcompte = $data['lib'];
            $compte = $compte_ecriture . ' ' . $libcompte;
            $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
            VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
            $requete->BindParam(':dte', $dte);
            $requete->BindParam(':ref', $reference);
            $requete->BindParam(':compte', $compte);
            $requete->BindParam(':description', $libelle);
            $requete->BindParam(':debit', $debit);
            $requete->BindParam(':credit', $credit);
            $requete->BindParam(':devise', $devise_op);
            $requete->BindParam(':journal_id', $journal_id);
            $requete->BindParam(':exercice_id', $exercice_id);
            $requete->BindParam(':site_id', $site_id);
            $requete->BindParam(':ecriture_id', $ecriture_id);
            $requete->execute();
        }
        //TVA FACTUREE SUR VENTE
        $compte_ecriture = $_SESSION['ConfLinkMod']['compte_ecriture']['TRESETR'];
        $long_compte = $_SESSION['ConfLinkMod']['long_compte']['TRESETR'];
        $souscompte_id = $_SESSION['ConfLinkMod']['souscompte_id']['TRESETR'];
        $categorie_id = $_SESSION['ConfLinkMod']['categorie_id']['TRESETR'];
        $compte_id = $_SESSION['ConfLinkMod']['compte_id']['TRESETR'];
        $debit = $montantusd;
        $credit = 0;
        $detail_id_ecrit = DetailsEcritureCompta($compte_id, $debit, $credit, $devise_op, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
        //tresorerie
        $entree = 'entree';
        $date_bon = $dte;
        $date_heure_bon = $dtetime;
        $montantFC = 0;
        $montantUSD = $montantusd;
        $cpte_num = $compte_ecriture;
        $id_user = $user_id;
        $longcompte = 4;
        $datas = INFOSFromAccountNumber($cpte_num, $longcompte, $bdd);
        $lib_monnaie = 'entreeusd';
        TRESORERIE($entree, $libelle, $beneficiaire, $date_bon, $date_heure_bon, $montantFC, $montantUSD, $cpte_num, $id_user, $longcompte, $detail_id_ecrit, $lib_monnaie, $site_id, $bdd);
        //GENERATION RAPPORT
        $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
        $libcompte = $data['lib'];
        $compte = $compte_ecriture . ' ' . $libcompte;
        $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
        VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
        $requete->BindParam(':dte', $dte);
        $requete->BindParam(':ref', $reference);
        $requete->BindParam(':compte', $compte);
        $requete->BindParam(':description', $libelle);
        $requete->BindParam(':debit', $debit);
        $requete->BindParam(':credit', $credit);
        $requete->BindParam(':devise', $devise_op);
        $requete->BindParam(':journal_id', $journal_id);
        $requete->BindParam(':exercice_id', $exercice_id);
        $requete->BindParam(':site_id', $site_id);
        $requete->BindParam(':ecriture_id', $ecriture_id);
        $requete->execute();
        $ht = $montantusd - $montanttva;
        //VENTE MARCHANDISE OU VENTE PRODUIT FINI
        $compte_ecriture = $_SESSION['ConfLinkMod']['compte_ecriture']['PROSERV'];
        $long_compte = $_SESSION['ConfLinkMod']['long_compte']['PROSERV'];
        $souscompte_id = $_SESSION['ConfLinkMod']['souscompte_id']['PROSERV'];
        $categorie_id = $_SESSION['ConfLinkMod']['categorie_id']['PROSERV'];
        $compte_id = $_SESSION['ConfLinkMod']['compte_id']['PROSERV'];
        $debit = 0;
        $credit = $ht;
        DetailsEcritureCompta($compte_id, $debit, $credit, $devise_op, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
        //GENERATION RAPPORT
        $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
        $libcompte = $data['lib'];
        $compte = $compte_ecriture . ' ' . $libcompte;
        $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
        VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
        $requete->BindParam(':dte', $dte);
        $requete->BindParam(':ref', $reference);
        $requete->BindParam(':compte', $compte);
        $requete->BindParam(':description', $libelle);
        $requete->BindParam(':debit', $debit);
        $requete->BindParam(':credit', $credit);
        $requete->BindParam(':devise', $devise_op);
        $requete->BindParam(':journal_id', $journal_id);
        $requete->BindParam(':exercice_id', $exercice_id);
        $requete->BindParam(':site_id', $site_id);
        $requete->BindParam(':ecriture_id', $ecriture_id);
        $requete->execute();
        //VENTE MARCHANDISE OU VENTE PRODUIT FINI

    }
}



function COMPTA_VENTE_CREDIT_RESTO($type_rendu, $reference, $dte, $dtetime, $montantusd, $montantcdf, $montantsaisi, $ht, $tva, $ttc, $devise, $tauxop, $libelle, $beneficiaire, $site_id, $user_id, $bdd)
{
    ExerciceEncours($site_id, $bdd);
    $exercice_id = $_SESSION['exercice_id'];
    $journal_id = 2;
    $montantcdf2 = 0;
    $montantusd2 = 0;
    $dteaff = $dte;
    $psedo = 0;
    $libelle = 'Restaurant : Vente à credit';
    $ecriture_id = EcritureCompta($dte, $dteaff, $dtetime, $libelle, $reference, $beneficiaire, $journal_id, $psedo, $exercice_id, $user_id, $site_id, $bdd);
    //VENTE MARCHANDISE OU VENTE PRODUIT FINI
    $compte_ecriture = $_SESSION['ConfLinkMod']['compte_ecriture']['PROSERV'];
    $long_compte = $_SESSION['ConfLinkMod']['long_compte']['PROSERV'];
    $souscompte_id = $_SESSION['ConfLinkMod']['souscompte_id']['PROSERV'];
    $categorie_id = $_SESSION['ConfLinkMod']['categorie_id']['PROSERV'];
    $compte_id = $_SESSION['ConfLinkMod']['compte_id']['PROSERV'];
    $debit = 0;
    $credit = $ht;
    DetailsEcritureCompta($compte_id, $debit, $credit, $devise, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
    //GENERATION RAPPORT
    $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
    $libcompte = $data['lib'];
    $compte = $compte_ecriture . ' ' . $libcompte;
    $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
       VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
    $requete->BindParam(':dte', $dte);
    $requete->BindParam(':ref', $reference);
    $requete->BindParam(':compte', $compte);
    $requete->BindParam(':description', $libelle);
    $requete->BindParam(':debit', $debit);
    $requete->BindParam(':credit', $credit);
    $requete->BindParam(':devise', $devise);
    $requete->BindParam(':journal_id', $journal_id);
    $requete->BindParam(':exercice_id', $exercice_id);
    $requete->BindParam(':site_id', $site_id);
    $requete->BindParam(':ecriture_id', $ecriture_id);
    $requete->execute();
    //VENTE MARCHANDISE OU VENTE PRODUIT FINI
    //TVA FACTUREE SUR 
    if ($tva != 0) {
        $montanttva = ($ttc * $tva) / 100;
        $compte_ecriture = $_SESSION['ConfLinkMod']['compte_ecriture']['TVA'];
        $long_compte = $_SESSION['ConfLinkMod']['long_compte']['TVA'];
        $souscompte_id = $_SESSION['ConfLinkMod']['souscompte_id']['TVA'];
        $categorie_id = $_SESSION['ConfLinkMod']['categorie_id']['TVA'];
        $compte_id = $_SESSION['ConfLinkMod']['compte_id']['TVA'];
        $debit = 0;
        $credit = $montanttva;
        DetailsEcritureCompta($compte_id, $debit, $credit, $devise, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
        //GENERATION RAPPORT
        $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
        $libcompte = $data['lib'];
        $compte = $compte_ecriture . ' ' . $libcompte;
        $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
           VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
        $requete->BindParam(':dte', $dte);
        $requete->BindParam(':ref', $reference);
        $requete->BindParam(':compte', $compte);
        $requete->BindParam(':description', $libelle);
        $requete->BindParam(':debit', $debit);
        $requete->BindParam(':credit', $credit);
        $requete->BindParam(':devise', $devise);
        $requete->BindParam(':journal_id', $journal_id);
        $requete->BindParam(':exercice_id', $exercice_id);
        $requete->BindParam(':site_id', $site_id);
        $requete->BindParam(':ecriture_id', $ecriture_id);
        $requete->execute();
    }
    //TVA FACTUREE SUR VENTE
    //CLIENT
    $compte_ecriture = $_SESSION['Customer_compte_ecriture'];
    $long_compte = $_SESSION['Customer_long_compte'];
    $souscompte_id = $_SESSION['Customer_souscompte_id'];
    $categorie_id = $_SESSION['Customer_categorie_id'];
    $compte_id = $_SESSION['Customer_compte_id'];
    $debit = $ttc;
    $credit = 0;
    DetailsEcritureCompta($compte_id, $debit, $credit, $devise, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
    //GENERATION RAPPORT
    $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
    $libcompte = $data['lib'];
    $compte = $compte_ecriture . ' ' . $libcompte;
    $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
       VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
    $requete->BindParam(':dte', $dte);
    $requete->BindParam(':ref', $reference);
    $requete->BindParam(':compte', $compte);
    $requete->BindParam(':description', $libelle);
    $requete->BindParam(':debit', $debit);
    $requete->BindParam(':credit', $credit);
    $requete->BindParam(':devise', $devise);
    $requete->BindParam(':journal_id', $journal_id);
    $requete->BindParam(':exercice_id', $exercice_id);
    $requete->BindParam(':site_id', $site_id);
    $requete->BindParam(':ecriture_id', $ecriture_id);
    $requete->execute();
    //CLIENT
}

function COMPTA_PAIE_RESTO($reference, $montantusd, $montantcdf, $montantsaisi, $devise, $tauxop, $libelle, $beneficiaire, $site_id, $user_id, $bdd, $ttc)
{

    //CAISSE CDF OU USD
    $deviseusd = 'USD';
    $ttc_usd = montant_equivalent_bdd($devise, $deviseusd, $tauxop, $ttc);
    $devisecdf = 'CDF';
    $ttc_cdf = montant_equivalent_bdd($devise, $devisecdf, $tauxop, $ttc);

    if ($montantusd > 0 && $montantcdf > 0) {
        if ($montantusd >= $ttc_usd) {
            $resteusd = $montantusd - $ttc_usd;
            $montantusd = $ttc_usd;
            ExerciceEncours($site_id, $bdd);
            $exercice_id = $_SESSION['exercice_id'];
            $journal_id = 3;
            $dte = date('Y-m-d');
            $dteaff = $dte;
            $dtetime = date('Y-m-d H:i:s');
            $psedo = 0;
            $libelle = "Restaurant : Paiement en USD";
            $ecriture_id = EcritureCompta($dte, $dteaff, $dtetime, $libelle, $reference, $beneficiaire, $journal_id, $psedo, $exercice_id, $user_id, $site_id, $bdd);
            $deviseusd = "USD";
            $compte_ecriture = $_SESSION['ConfLinkMod']['compte_ecriture']['TRESETR'];
            $long_compte = $_SESSION['ConfLinkMod']['long_compte']['TRESETR'];
            $souscompte_id = $_SESSION['ConfLinkMod']['souscompte_id']['TRESETR'];
            $categorie_id = $_SESSION['ConfLinkMod']['categorie_id']['TRESETR'];
            $compte_id = $_SESSION['ConfLinkMod']['compte_id']['TRESETR'];
            $debit = $montantusd;
            $credit = 0;
            $libelledescrpt = '';
            $numdoc = '';
            $detail_id_ecrit = DetailsEcritureCompta($compte_id, $debit, $credit, $deviseusd, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
            //tresorerie
            $entree = 'entree';
            $date_bon = $dte;
            $date_heure_bon = $dtetime;
            $montantFC = 0;
            $montantUSD = $montantusd;
            $cpte_num = $compte_ecriture;
            $id_user = $user_id;
            $longcompte = 4;
            $datas = INFOSFromAccountNumber($cpte_num, $longcompte, $bdd);
            $lib_monnaie = 'entreeusd';
            TRESORERIE($entree, $libelle, $beneficiaire, $date_bon, $date_heure_bon, $montantFC, $montantUSD, $cpte_num, $id_user, $longcompte, $detail_id_ecrit, $lib_monnaie, $site_id, $bdd);

            //GENERATION RAPPORT
            $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
            $libcompte = $data['lib'];
            $compte = $compte_ecriture . ' ' . $libcompte;
            $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
               VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
            $requete->BindParam(':dte', $dte);
            $requete->BindParam(':ref', $reference);
            $requete->BindParam(':compte', $compte);
            $requete->BindParam(':description', $libelle);
            $requete->BindParam(':debit', $debit);
            $requete->BindParam(':credit', $credit);
            $requete->BindParam(':devise', $deviseusd);
            $requete->BindParam(':journal_id', $journal_id);
            $requete->BindParam(':exercice_id', $exercice_id);
            $requete->BindParam(':site_id', $site_id);
            $requete->BindParam(':ecriture_id', $ecriture_id);
            $requete->execute();
            //COMPTE CLIENT
            $compte_ecriture = $_SESSION['Customer_compte_ecriture'];
            $long_compte = $_SESSION['Customer_long_compte'];
            $souscompte_id = $_SESSION['Customer_souscompte_id'];
            $categorie_id = $_SESSION['Customer_categorie_id'];
            $compte_id = $_SESSION['Customer_compte_id'];
            $debit = 0;
            $credit = $montantusd;
            $libelledescrpt = '';
            $numdoc = '';
            DetailsEcritureCompta($compte_id, $debit, $credit, $deviseusd, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
            //GENERATION RAPPORT
            $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
            $libcompte = $data['lib'];
            $compte = $compte_ecriture . ' ' . $libcompte;
            $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
               VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
            $requete->BindParam(':dte', $dte);
            $requete->BindParam(':ref', $reference);
            $requete->BindParam(':compte', $compte);
            $requete->BindParam(':description', $libelle);
            $requete->BindParam(':debit', $debit);
            $requete->BindParam(':credit', $credit);
            $requete->BindParam(':devise', $deviseusd);
            $requete->BindParam(':journal_id', $journal_id);
            $requete->BindParam(':exercice_id', $exercice_id);
            $requete->BindParam(':site_id', $site_id);
            $requete->BindParam(':ecriture_id', $ecriture_id);
            $requete->execute();
            //COMPTE CLIENT  

        } elseif ($montantcdf >= $ttc_cdf) {
            $restecdf = $montantcdf - $ttc_cdf;
            $montantcdf = $ttc_cdf;
            ExerciceEncours($site_id, $bdd);
            $exercice_id = $_SESSION['exercice_id'];
            $journal_id = 3;
            $dte = date('Y-m-d');
            $dteaff = $dte;
            $dtetime = date('Y-m-d H:i:s');
            $psedo = 0;
            $ecriture_id = EcritureCompta($dte, $dteaff, $dtetime, $libelle, $reference, $beneficiaire, $journal_id, $psedo, $exercice_id, $user_id, $site_id, $bdd);
            $devisecdf = 'CDF';
            $compte_ecriture = $_SESSION['ConfLinkMod']['compte_ecriture']['TRESLOC'];
            $long_compte = $_SESSION['ConfLinkMod']['long_compte']['TRESLOC'];
            $souscompte_id = $_SESSION['ConfLinkMod']['souscompte_id']['TRESLOC'];
            $categorie_id = $_SESSION['ConfLinkMod']['categorie_id']['TRESLOC'];
            $compte_id = $_SESSION['ConfLinkMod']['compte_id']['TRESLOC'];
            $debit = $montantcdf;
            $credit = 0;
            $detail_id_ecrit = DetailsEcritureCompta($compte_id, $debit, $credit, $devisecdf, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
            //tresorerie
            $entree = 'entree';
            $date_bon = $dte;
            $date_heure_bon = $dtetime;
            $montantFC = $montantcdf;
            $montantUSD = 0;
            $cpte_num = $compte_ecriture;
            $id_user = $user_id;
            $longcompte = 4;
            $datas = INFOSFromAccountNumber($cpte_num, $longcompte, $bdd);
            $lib_monnaie = 'entreecdf';
            TRESORERIE($entree, $libelle, $beneficiaire, $date_bon, $date_heure_bon, $montantFC, $montantUSD, $cpte_num, $id_user, $longcompte, $detail_id_ecrit, $lib_monnaie, $site_id, $bdd);
            //GENERATION RAPPORT
            $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
            $libcompte = $data['lib'];
            $compte = $compte_ecriture . ' ' . $libcompte;
            $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
               VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
            $requete->BindParam(':dte', $dte);
            $requete->BindParam(':ref', $reference);
            $requete->BindParam(':compte', $compte);
            $requete->BindParam(':description', $libelle);
            $requete->BindParam(':debit', $debit);
            $requete->BindParam(':credit', $credit);
            $requete->BindParam(':devise', $devisecdf);
            $requete->BindParam(':journal_id', $journal_id);
            $requete->BindParam(':exercice_id', $exercice_id);
            $requete->BindParam(':site_id', $site_id);
            $requete->BindParam(':ecriture_id', $ecriture_id);
            $requete->execute();
            //COMPTE CLIENT
            $compte_ecriture = $_SESSION['Customer_compte_ecriture'];
            $long_compte = $_SESSION['Customer_long_compte'];
            $souscompte_id = $_SESSION['Customer_souscompte_id'];
            $categorie_id = $_SESSION['Customer_categorie_id'];
            $compte_id = $_SESSION['Customer_compte_id'];
            $debit = 0;
            $credit = $montantcdf;
            DetailsEcritureCompta($compte_id, $debit, $credit, $devisecdf, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
            //GENERATION RAPPORT
            $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
            $libcompte = $data['lib'];
            $compte = $compte_ecriture . ' ' . $libcompte;
            $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
               VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
            $requete->BindParam(':dte', $dte);
            $requete->BindParam(':ref', $reference);
            $requete->BindParam(':compte', $compte);
            $requete->BindParam(':description', $libelle);
            $requete->BindParam(':debit', $debit);
            $requete->BindParam(':credit', $credit);
            $requete->BindParam(':devise', $devisecdf);
            $requete->BindParam(':journal_id', $journal_id);
            $requete->BindParam(':exercice_id', $exercice_id);
            $requete->BindParam(':site_id', $site_id);
            $requete->BindParam(':ecriture_id', $ecriture_id);
            $requete->execute();
            //COMPTE CLIENT   
        } elseif ($montantusd < $ttc_usd) {
            $devisecdf = 'CDF';
            $deviseusd = 'USD';
            $resteusd = 0;
            $soldeusd = $ttc_usd - $montantusd;
            $soldecdf = montant_equivalent_bdd($deviseusd, $devisecdf, $tauxop, $soldeusd);
            $restecdf = $montantcdf - $soldecdf;
            $montantcdf = $soldecdf;
            //paiement en usd
            ExerciceEncours($site_id, $bdd);
            $exercice_id = $_SESSION['exercice_id'];
            $journal_id = 3;
            $dte = date('Y-m-d');
            $dteaff = $dte;
            $dtetime = date('Y-m-d H:i:s');
            $psedo = 0;
            $libelle = "Restaurant : Paiement en USD";
            $ecriture_id = EcritureCompta($dte, $dteaff, $dtetime, $libelle, $reference, $beneficiaire, $journal_id, $psedo, $exercice_id, $user_id, $site_id, $bdd);
            $deviseusd = "USD";
            $compte_ecriture = $_SESSION['ConfLinkMod']['compte_ecriture']['TRESETR'];
            $long_compte = $_SESSION['ConfLinkMod']['long_compte']['TRESETR'];
            $souscompte_id = $_SESSION['ConfLinkMod']['souscompte_id']['TRESETR'];
            $categorie_id = $_SESSION['ConfLinkMod']['categorie_id']['TRESETR'];
            $compte_id = $_SESSION['ConfLinkMod']['compte_id']['TRESETR'];
            $debit = $montantusd;
            $credit = 0;
            $libelledescrpt = '';
            $numdoc = '';
            $detail_id_ecrit = DetailsEcritureCompta($compte_id, $debit, $credit, $deviseusd, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
            //tresorerie
            $entree = 'entree';
            $date_bon = $dte;
            $date_heure_bon = $dtetime;
            $montantFC = 0;
            $montantUSD = $montantusd;
            $cpte_num = $compte_ecriture;
            $id_user = $user_id;
            $longcompte = 4;
            $datas = INFOSFromAccountNumber($cpte_num, $longcompte, $bdd);
            $lib_monnaie = 'entreeusd';
            TRESORERIE($entree, $libelle, $beneficiaire, $date_bon, $date_heure_bon, $montantFC, $montantUSD, $cpte_num, $id_user, $longcompte, $detail_id_ecrit, $lib_monnaie, $site_id, $bdd);

            //GENERATION RAPPORT
            $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
            $libcompte = $data['lib'];
            $compte = $compte_ecriture . ' ' . $libcompte;
            $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
            VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
            $requete->BindParam(':dte', $dte);
            $requete->BindParam(':ref', $reference);
            $requete->BindParam(':compte', $compte);
            $requete->BindParam(':description', $libelle);
            $requete->BindParam(':debit', $debit);
            $requete->BindParam(':credit', $credit);
            $requete->BindParam(':devise', $deviseusd);
            $requete->BindParam(':journal_id', $journal_id);
            $requete->BindParam(':exercice_id', $exercice_id);
            $requete->BindParam(':site_id', $site_id);
            $requete->BindParam(':ecriture_id', $ecriture_id);
            $requete->execute();
            //COMPTE CLIENT
            $compte_ecriture = $_SESSION['Customer_compte_ecriture'];
            $long_compte = $_SESSION['Customer_long_compte'];
            $souscompte_id = $_SESSION['Customer_souscompte_id'];
            $categorie_id = $_SESSION['Customer_categorie_id'];
            $compte_id = $_SESSION['Customer_compte_id'];
            $debit = 0;
            $credit = $montantusd;
            $libelledescrpt = '';
            $numdoc = '';
            DetailsEcritureCompta($compte_id, $debit, $credit, $deviseusd, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
            //GENERATION RAPPORT
            $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
            $libcompte = $data['lib'];
            $compte = $compte_ecriture . ' ' . $libcompte;
            $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
            VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
            $requete->BindParam(':dte', $dte);
            $requete->BindParam(':ref', $reference);
            $requete->BindParam(':compte', $compte);
            $requete->BindParam(':description', $libelle);
            $requete->BindParam(':debit', $debit);
            $requete->BindParam(':credit', $credit);
            $requete->BindParam(':devise', $deviseusd);
            $requete->BindParam(':journal_id', $journal_id);
            $requete->BindParam(':exercice_id', $exercice_id);
            $requete->BindParam(':site_id', $site_id);
            $requete->BindParam(':ecriture_id', $ecriture_id);
            $requete->execute();
            //COMPTE CLIENT  
            //paiement en usd

            //paiement en cdf
            ExerciceEncours($site_id, $bdd);
            $exercice_id = $_SESSION['exercice_id'];
            $journal_id = 3;
            $dte = date('Y-m-d');
            $dteaff = $dte;
            $dtetime = date('Y-m-d H:i:s');
            $psedo = 0;
            $libelle = "Restaurant : Paiement en CDF";
            $ecriture_id = EcritureCompta($dte, $dteaff, $dtetime, $libelle, $reference, $beneficiaire, $journal_id, $psedo, $exercice_id, $user_id, $site_id, $bdd);
            $devisecdf = 'CDF';
            $compte_ecriture = $_SESSION['ConfLinkMod']['compte_ecriture']['TRESLOC'];
            $long_compte = $_SESSION['ConfLinkMod']['long_compte']['TRESLOC'];
            $souscompte_id = $_SESSION['ConfLinkMod']['souscompte_id']['TRESLOC'];
            $categorie_id = $_SESSION['ConfLinkMod']['categorie_id']['TRESLOC'];
            $compte_id = $_SESSION['ConfLinkMod']['compte_id']['TRESLOC'];
            $debit = $montantcdf;
            $credit = 0;
            $detail_id_ecrit = DetailsEcritureCompta($compte_id, $debit, $credit, $devisecdf, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
            //tresorerie
            $entree = 'entree';
            $date_bon = $dte;
            $date_heure_bon = $dtetime;
            $montantFC = $montantcdf;
            $montantUSD = 0;
            $cpte_num = $compte_ecriture;
            $id_user = $user_id;
            $longcompte = 4;
            $datas = INFOSFromAccountNumber($cpte_num, $longcompte, $bdd);
            $lib_monnaie = 'entreecdf';
            TRESORERIE($entree, $libelle, $beneficiaire, $date_bon, $date_heure_bon, $montantFC, $montantUSD, $cpte_num, $id_user, $longcompte, $detail_id_ecrit, $lib_monnaie, $site_id, $bdd);
            //GENERATION RAPPORT
            $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
            $libcompte = $data['lib'];
            $compte = $compte_ecriture . ' ' . $libcompte;
            $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
           VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
            $requete->BindParam(':dte', $dte);
            $requete->BindParam(':ref', $reference);
            $requete->BindParam(':compte', $compte);
            $requete->BindParam(':description', $libelle);
            $requete->BindParam(':debit', $debit);
            $requete->BindParam(':credit', $credit);
            $requete->BindParam(':devise', $devisecdf);
            $requete->BindParam(':journal_id', $journal_id);
            $requete->BindParam(':exercice_id', $exercice_id);
            $requete->BindParam(':site_id', $site_id);
            $requete->BindParam(':ecriture_id', $ecriture_id);
            $requete->execute();
            //COMPTE CLIENT
            $compte_ecriture = $_SESSION['Customer_compte_ecriture'];
            $long_compte = $_SESSION['Customer_long_compte'];
            $souscompte_id = $_SESSION['Customer_souscompte_id'];
            $categorie_id = $_SESSION['Customer_categorie_id'];
            $compte_id = $_SESSION['Customer_compte_id'];
            $debit = 0;
            $credit = $montantcdf;
            DetailsEcritureCompta($compte_id, $debit, $credit, $devisecdf, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
            //GENERATION RAPPORT
            $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
            $libcompte = $data['lib'];
            $compte = $compte_ecriture . ' ' . $libcompte;
            $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
           VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
            $requete->BindParam(':dte', $dte);
            $requete->BindParam(':ref', $reference);
            $requete->BindParam(':compte', $compte);
            $requete->BindParam(':description', $libelle);
            $requete->BindParam(':debit', $debit);
            $requete->BindParam(':credit', $credit);
            $requete->BindParam(':devise', $devisecdf);
            $requete->BindParam(':journal_id', $journal_id);
            $requete->BindParam(':exercice_id', $exercice_id);
            $requete->BindParam(':site_id', $site_id);
            $requete->BindParam(':ecriture_id', $ecriture_id);
            $requete->execute();
            //COMPTE CLIENT   
            //paiement en cdf

        }
    } elseif ($montantcdf > 0) {
        $restecdf = 0;
        if ($montantcdf > $ttc_cdf) {
            $restecdf = $montantcdf - $ttc_cdf;
            $montantcdf = $ttc_cdf;
        }

        ExerciceEncours($site_id, $bdd);
        $exercice_id = $_SESSION['exercice_id'];
        $journal_id = 3;
        $dte = date('Y-m-d');
        $dteaff = $dte;
        $dtetime = date('Y-m-d H:i:s');
        $psedo = 0;
        $libelle = "Restaurant : Paiement en CDF";
        $ecriture_id = EcritureCompta($dte, $dteaff, $dtetime, $libelle, $reference, $beneficiaire, $journal_id, $psedo, $exercice_id, $user_id, $site_id, $bdd);
        $devisecdf = 'CDF';
        $compte_ecriture = $_SESSION['ConfLinkMod']['compte_ecriture']['TRESLOC'];
        $long_compte = $_SESSION['ConfLinkMod']['long_compte']['TRESLOC'];
        $souscompte_id = $_SESSION['ConfLinkMod']['souscompte_id']['TRESLOC'];
        $categorie_id = $_SESSION['ConfLinkMod']['categorie_id']['TRESLOC'];
        $compte_id = $_SESSION['ConfLinkMod']['compte_id']['TRESLOC'];
        $debit = $montantcdf;
        $credit = 0;
        $libelledescrpt = '';
        $numdoc = '';
        $detail_id_ecrit = DetailsEcritureCompta($compte_id, $debit, $credit, $devisecdf, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
        //tresorerie
        $entree = 'entree';
        $date_bon = $dte;
        $date_heure_bon = $dtetime;
        $montantFC = $montantcdf;
        $montantUSD = 0;
        $cpte_num = $compte_ecriture;
        $id_user = $user_id;
        $longcompte = 4;
        $datas = INFOSFromAccountNumber($cpte_num, $longcompte, $bdd);
        $lib_monnaie = 'entreecdf';
        TRESORERIE($entree, $libelle, $beneficiaire, $date_bon, $date_heure_bon, $montantFC, $montantUSD, $cpte_num, $id_user, $longcompte, $detail_id_ecrit, $lib_monnaie, $site_id, $bdd);
        //GENERATION RAPPORT
        $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
        $libcompte = $data['lib'];
        $compte = $compte_ecriture . ' ' . $libcompte;
        $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
       VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
        $requete->BindParam(':dte', $dte);
        $requete->BindParam(':ref', $reference);
        $requete->BindParam(':compte', $compte);
        $requete->BindParam(':description', $libelle);
        $requete->BindParam(':debit', $debit);
        $requete->BindParam(':credit', $credit);
        $requete->BindParam(':devise', $devisecdf);
        $requete->BindParam(':journal_id', $journal_id);
        $requete->BindParam(':exercice_id', $exercice_id);
        $requete->BindParam(':site_id', $site_id);
        $requete->BindParam(':ecriture_id', $ecriture_id);
        $requete->execute();
        //COMPTE CLIENT
        $compte_ecriture = $_SESSION['Customer_compte_ecriture'];
        $long_compte = $_SESSION['Customer_long_compte'];
        $souscompte_id = $_SESSION['Customer_souscompte_id'];
        $categorie_id = $_SESSION['Customer_categorie_id'];
        $compte_id = $_SESSION['Customer_compte_id'];
        $debit = 0;
        $credit = $montantcdf;
        DetailsEcritureCompta($compte_id, $debit, $credit, $devisecdf, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
        //GENERATION RAPPORT
        $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
        $libcompte = $data['lib'];
        $compte = $compte_ecriture . ' ' . $libcompte;
        $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
       VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
        $requete->BindParam(':dte', $dte);
        $requete->BindParam(':ref', $reference);
        $requete->BindParam(':compte', $compte);
        $requete->BindParam(':description', $libelle);
        $requete->BindParam(':debit', $debit);
        $requete->BindParam(':credit', $credit);
        $requete->BindParam(':devise', $devisecdf);
        $requete->BindParam(':journal_id', $journal_id);
        $requete->BindParam(':exercice_id', $exercice_id);
        $requete->BindParam(':site_id', $site_id);
        $requete->BindParam(':ecriture_id', $ecriture_id);
        $requete->execute();
        //COMPTE CLIENT   

    } elseif ($montantusd > 0) {
        $resteusd = 0;
        if ($montantusd > $ttc_usd) {
            $resteusd = $montantusd - $ttc_usd;
            $montantusd = $ttc_usd;
        }
        ExerciceEncours($site_id, $bdd);
        $exercice_id = $_SESSION['exercice_id'];
        $journal_id = 3;
        $dte = date('Y-m-d');
        $dteaff = $dte;
        $dtetime = date('Y-m-d H:i:s');
        $psedo = 0;
        $libelle = "Restaurant : Paiement en USD";
        $ecriture_id = EcritureCompta($dte, $dteaff, $dtetime, $libelle, $reference, $beneficiaire, $journal_id, $psedo, $exercice_id, $user_id, $site_id, $bdd);
        $deviseusd = "USD";
        $compte_ecriture = $_SESSION['ConfLinkMod']['compte_ecriture']['TRESETR'];
        $long_compte = $_SESSION['ConfLinkMod']['long_compte']['TRESETR'];
        $souscompte_id = $_SESSION['ConfLinkMod']['souscompte_id']['TRESETR'];
        $categorie_id = $_SESSION['ConfLinkMod']['categorie_id']['TRESETR'];
        $compte_id = $_SESSION['ConfLinkMod']['compte_id']['TRESETR'];
        $debit = $montantusd;
        $credit = 0;
        $libelledescrpt = '';
        $numdoc = '';
        $detail_id_ecrit = DetailsEcritureCompta($compte_id, $debit, $credit, $deviseusd, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
        //tresorerie
        $entree = 'entree';
        $date_bon = $dte;
        $date_heure_bon = $dtetime;
        $montantFC = 0;
        $montantUSD = $montantusd;
        $cpte_num = $compte_ecriture;
        $id_user = $user_id;
        $longcompte = 4;
        $datas = INFOSFromAccountNumber($cpte_num, $longcompte, $bdd);
        $lib_monnaie = 'entreeusd';
        TRESORERIE($entree, $libelle, $beneficiaire, $date_bon, $date_heure_bon, $montantFC, $montantUSD, $cpte_num, $id_user, $longcompte, $detail_id_ecrit, $lib_monnaie, $site_id, $bdd);

        //GENERATION RAPPORT
        $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
        $libcompte = $data['lib'];
        $compte = $compte_ecriture . ' ' . $libcompte;
        $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
       VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
        $requete->BindParam(':dte', $dte);
        $requete->BindParam(':ref', $reference);
        $requete->BindParam(':compte', $compte);
        $requete->BindParam(':description', $libelle);
        $requete->BindParam(':debit', $debit);
        $requete->BindParam(':credit', $credit);
        $requete->BindParam(':devise', $deviseusd);
        $requete->BindParam(':journal_id', $journal_id);
        $requete->BindParam(':exercice_id', $exercice_id);
        $requete->BindParam(':site_id', $site_id);
        $requete->BindParam(':ecriture_id', $ecriture_id);
        $requete->execute();
        //COMPTE CLIENT
        $compte_ecriture = $_SESSION['Customer_compte_ecriture'];
        $long_compte = $_SESSION['Customer_long_compte'];
        $souscompte_id = $_SESSION['Customer_souscompte_id'];
        $categorie_id = $_SESSION['Customer_categorie_id'];
        $compte_id = $_SESSION['Customer_compte_id'];
        $debit = 0;
        $credit = $montantusd;
        $libelledescrpt = '';
        $numdoc = '';
        DetailsEcritureCompta($compte_id, $debit, $credit, $deviseusd, $tauxop, $ecriture_id, $site_id, $categorie_id, $souscompte_id, $compte_ecriture, $long_compte, $bdd);
        //GENERATION RAPPORT
        $data = INFOSFromAccountNumber($compte_ecriture, $long_compte, $bdd);
        $libcompte = $data['lib'];
        $compte = $compte_ecriture . ' ' . $libcompte;
        $requete = $bdd->prepare("INSERT INTO cptrapportjournal (dte,ref,compte,description,debit,credit,devise,journal_id,exercice_id,site_id,ecriture_id)
       VALUES(:dte,:ref,:compte,:description,:debit,:credit,:devise,:journal_id,:exercice_id,:site_id,:ecriture_id)");
        $requete->BindParam(':dte', $dte);
        $requete->BindParam(':ref', $reference);
        $requete->BindParam(':compte', $compte);
        $requete->BindParam(':description', $libelle);
        $requete->BindParam(':debit', $debit);
        $requete->BindParam(':credit', $credit);
        $requete->BindParam(':devise', $deviseusd);
        $requete->BindParam(':journal_id', $journal_id);
        $requete->BindParam(':exercice_id', $exercice_id);
        $requete->BindParam(':site_id', $site_id);
        $requete->BindParam(':ecriture_id', $ecriture_id);
        $requete->execute();
        //COMPTE CLIENT 
    }
    //CAISSE CDF OU USD

}


//La Compta


function countProdCompose($plat_id,$bdd)
{
    //$plat_id=8;
    $req = "SELECT COUNT(*) AS nbr FROM t_ingredient AS a
            WHERE a.plat_id=:plat_id";
    $requete = $bdd->prepare($req);
    $requete->BindParam(':plat_id', $plat_id);
    $requete->execute();
    $result = $requete->fetch(PDO::FETCH_OBJ);
    return $result->nbr;
}


function GetIdDepot($id_sousresto, $bdd)
{
    $depot_id =0;
    $requete = $bdd->prepare("SELECT * FROM t_sousresto WHERE id_sousresto=:id_sousresto");
    $requete->BindParam(':id_sousresto', $id_sousresto);
    $requete->execute();
    $result = $requete->fetchAll(PDO::FETCH_OBJ);
    foreach ($result as $r) {
        $depot_id = $r->depot_id;
    }
    return $depot_id;
}
function GetLibPos($id_sousresto, $bdd)
{
    $LibPos =0;
    $requete = $bdd->prepare("SELECT * FROM t_sousresto WHERE id_sousresto=:id_sousresto");
    $requete->BindParam(':id_sousresto', $id_sousresto);
    $requete->execute();
    $result = $requete->fetchAll(PDO::FETCH_OBJ);
    foreach ($result as $r) {
        $LibPos = $r->libelle;
    }
    return $LibPos;
}


function AfficherParMonnaieVente($monnaie, $montant)
{
    $montant_conv=  montant_equivalent_bdd(getsymbole_devise(),$_SESSION['monnaie_vente_site'],$_SESSION['taux_vente_site'],$montant);

    return afficheMontant2($_SESSION['monnaie_vente_site'],$montant_conv);
}